# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.containerinstance import ContainerInstanceManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerinstance
# USAGE
    python container_groups_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerInstanceManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.container_groups.begin_create_or_update(
        resource_group_name="demo",
        container_group_name="demo1",
        container_group={
            "identity": {
                "type": "SystemAssigned, UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity-name": {}
                },
            },
            "location": "west us",
            "properties": {
                "containers": [
                    {
                        "name": "demo1",
                        "properties": {
                            "command": [],
                            "environmentVariables": [],
                            "image": "nginx",
                            "ports": [{"port": 80}],
                            "resources": {"requests": {"cpu": 1, "gpu": {"count": 1, "sku": "K80"}, "memoryInGB": 1.5}},
                            "volumeMounts": [
                                {"mountPath": "/mnt/volume1", "name": "volume1", "readOnly": False},
                                {"mountPath": "/mnt/volume2", "name": "volume2", "readOnly": False},
                                {"mountPath": "/mnt/volume3", "name": "volume3", "readOnly": True},
                            ],
                        },
                    }
                ],
                "diagnostics": {
                    "logAnalytics": {
                        "logType": "ContainerInsights",
                        "metadata": {"test-key": "test-metadata-value"},
                        "workspaceId": "workspaceid",
                        "workspaceKey": "workspaceKey",
                        "workspaceResourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/rg/providers/microsoft.operationalinsights/workspaces/workspace",
                    }
                },
                "dnsConfig": {
                    "nameServers": ["1.1.1.1"],
                    "options": "ndots:2",
                    "searchDomains": "cluster.local svc.cluster.local",
                },
                "imageRegistryCredentials": [],
                "ipAddress": {
                    "autoGeneratedDomainNameLabelScope": "Unsecure",
                    "dnsNameLabel": "dnsnamelabel1",
                    "ports": [{"port": 80, "protocol": "TCP"}],
                    "type": "Public",
                },
                "osType": "Linux",
                "subnetIds": [
                    {
                        "id": "[resourceId('Microsoft.Network/virtualNetworks/subnets', parameters('vnetName'), parameters('subnetName'))]"
                    }
                ],
                "volumes": [
                    {
                        "azureFile": {
                            "shareName": "shareName",
                            "storageAccountKey": "accountKey",
                            "storageAccountName": "accountName",
                        },
                        "name": "volume1",
                    },
                    {"emptyDir": {}, "name": "volume2"},
                    {
                        "name": "volume3",
                        "secret": {"secretKey1": "SecretValue1InBase64", "secretKey2": "SecretValue2InBase64"},
                    },
                ],
            },
        },
    ).result()
    print(response)


# x-ms-original-file: specification/containerinstance/resource-manager/Microsoft.ContainerInstance/preview/2022-10-01-preview/examples/ContainerGroupsCreateOrUpdate.json
if __name__ == "__main__":
    main()
