# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExtractedPage(Model):
    """Extraction information of a single page in a
    with a document.

    :param number: Page number.
    :type number: int
    :param height: Height of the page (in pixels).
    :type height: int
    :param width: Width of the page (in pixels).
    :type width: int
    :param cluster_id: Cluster identifier.
    :type cluster_id: int
    :param key_value_pairs: List of Key-Value pairs extracted from the page.
    :type key_value_pairs:
     list[~azure.cognitiveservices.formrecognizer.models.ExtractedKeyValuePair]
    :param tables: List of Tables and their information extracted from the
     page.
    :type tables:
     list[~azure.cognitiveservices.formrecognizer.models.ExtractedTable]
    """

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
        'width': {'key': 'width', 'type': 'int'},
        'cluster_id': {'key': 'clusterId', 'type': 'int'},
        'key_value_pairs': {'key': 'keyValuePairs', 'type': '[ExtractedKeyValuePair]'},
        'tables': {'key': 'tables', 'type': '[ExtractedTable]'},
    }

    def __init__(self, *, number: int=None, height: int=None, width: int=None, cluster_id: int=None, key_value_pairs=None, tables=None, **kwargs) -> None:
        super(ExtractedPage, self).__init__(**kwargs)
        self.number = number
        self.height = height
        self.width = width
        self.cluster_id = cluster_id
        self.key_value_pairs = key_value_pairs
        self.tables = tables
