# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessRights(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MANAGE = "Manage"
    SEND = "Send"
    LISTEN = "Listen"

class EntityStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enumerates the possible values for the status of the Event Hub.
    """

    ACTIVE = "Active"
    DISABLED = "Disabled"
    RESTORING = "Restoring"
    SEND_DISABLED = "SendDisabled"
    RECEIVE_DISABLED = "ReceiveDisabled"
    CREATING = "Creating"
    DELETING = "Deleting"
    RENAMING = "Renaming"
    UNKNOWN = "Unknown"

class NamespaceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of the Namespace.
    """

    UNKNOWN = "Unknown"
    CREATING = "Creating"
    CREATED = "Created"
    ACTIVATING = "Activating"
    ENABLING = "Enabling"
    ACTIVE = "Active"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    SOFT_DELETING = "SoftDeleting"
    SOFT_DELETED = "SoftDeleted"
    REMOVING = "Removing"
    REMOVED = "Removed"
    FAILED = "Failed"

class Policykey(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Key that needs to be regenerated.
    """

    PRIMARY_KEY = "PrimaryKey"
    SECONDARY_KEY = "SecondaryKey"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of this SKU.
    """

    BASIC = "Basic"
    STANDARD = "Standard"

class SkuTier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The billing tier of this particular SKU.
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class UnavailableReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the reason for the unavailability of the service.
    """

    NONE = "None"
    INVALID_NAME = "InvalidName"
    SUBSCRIPTION_IS_DISABLED = "SubscriptionIsDisabled"
    NAME_IN_USE = "NameInUse"
    NAME_IN_LOCKDOWN = "NameInLockdown"
    TOO_MANY_NAMESPACE_IN_CURRENT_SUBSCRIPTION = "TooManyNamespaceInCurrentSubscription"
