# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SkypeChannelProperties(Model):
    """The parameters to provide for the Microsoft Teams channel.

    All required parameters must be populated in order to send to Azure.

    :param enable_messaging: Enable messaging for Skype channel
    :type enable_messaging: bool
    :param enable_media_cards: Enable media cards for Skype channel
    :type enable_media_cards: bool
    :param enable_video: Enable video for Skype channel
    :type enable_video: bool
    :param enable_calling: Enable calling for Skype channel
    :type enable_calling: bool
    :param enable_screen_sharing: Enable screen sharing for Skype channel
    :type enable_screen_sharing: bool
    :param enable_groups: Enable groups for Skype channel
    :type enable_groups: bool
    :param groups_mode: Group mode for Skype channel
    :type groups_mode: str
    :param calling_web_hook: Calling web hook for Skype channel
    :type calling_web_hook: str
    :param is_enabled: Required. Whether this channel is enabled for the bot
    :type is_enabled: bool
    """

    _validation = {
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'enable_messaging': {'key': 'enableMessaging', 'type': 'bool'},
        'enable_media_cards': {'key': 'enableMediaCards', 'type': 'bool'},
        'enable_video': {'key': 'enableVideo', 'type': 'bool'},
        'enable_calling': {'key': 'enableCalling', 'type': 'bool'},
        'enable_screen_sharing': {'key': 'enableScreenSharing', 'type': 'bool'},
        'enable_groups': {'key': 'enableGroups', 'type': 'bool'},
        'groups_mode': {'key': 'groupsMode', 'type': 'str'},
        'calling_web_hook': {'key': 'callingWebHook', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SkypeChannelProperties, self).__init__(**kwargs)
        self.enable_messaging = kwargs.get('enable_messaging', None)
        self.enable_media_cards = kwargs.get('enable_media_cards', None)
        self.enable_video = kwargs.get('enable_video', None)
        self.enable_calling = kwargs.get('enable_calling', None)
        self.enable_screen_sharing = kwargs.get('enable_screen_sharing', None)
        self.enable_groups = kwargs.get('enable_groups', None)
        self.groups_mode = kwargs.get('groups_mode', None)
        self.calling_web_hook = kwargs.get('calling_web_hook', None)
        self.is_enabled = kwargs.get('is_enabled', None)
