# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.bots_operations import BotsOperations
from .operations.channels_operations import ChannelsOperations
from .operations.operations import Operations
from .operations.bot_connection_operations import BotConnectionOperations
from .operations.enterprise_channels_operations import EnterpriseChannelsOperations
from . import models


class AzureBotServiceConfiguration(AzureConfiguration):
    """Configuration for AzureBotService
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Azure Subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(AzureBotServiceConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-botservice/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class AzureBotService(SDKClient):
    """Azure Bot Service is a platform for creating smart conversational agents.

    :ivar config: Configuration for client.
    :vartype config: AzureBotServiceConfiguration

    :ivar bots: Bots operations
    :vartype bots: azure.mgmt.botservice.operations.BotsOperations
    :ivar channels: Channels operations
    :vartype channels: azure.mgmt.botservice.operations.ChannelsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.botservice.operations.Operations
    :ivar bot_connection: BotConnection operations
    :vartype bot_connection: azure.mgmt.botservice.operations.BotConnectionOperations
    :ivar enterprise_channels: EnterpriseChannels operations
    :vartype enterprise_channels: azure.mgmt.botservice.operations.EnterpriseChannelsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Azure Subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AzureBotServiceConfiguration(credentials, subscription_id, base_url)
        super(AzureBotService, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-07-12'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.bots = BotsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.channels = ChannelsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.bot_connection = BotConnectionOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.enterprise_channels = EnterpriseChannelsOperations(
            self._client, self.config, self._serialize, self._deserialize)
