/*
 * Copyright (C) 2008  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#ifndef NETAVAILABILITY_H
#define NETAVAILABILITY_H

#include "irisnetglobal.h"

namespace XMPP {
class NetAvailability : public QObject {
    Q_OBJECT

public:
    NetAvailability(QObject *parent = nullptr);
    ~NetAvailability();

    bool isAvailable() const;

signals:
    void changed(bool available);

private:
    class Private;
    friend class Private;
    Private *d;
};
} // namespace XMPP

#endif // NETAVAILABILITY_H
