/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.TimeArrow;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TimeConstraint {
    private final TimeTick tick1;
    private final TimeTick tick2;
    private final Display label;
    private final ISkinParam skinParam;

    public TimeConstraint(TimeTick tick1, TimeTick tick2, String label, ISkinParam skinParam) {
        this.tick1 = Objects.requireNonNull(tick1);
        this.tick2 = Objects.requireNonNull(tick2);
        this.label = Display.getWithNewlines(label);
        this.skinParam = skinParam;
    }

    public final TimeTick getTick1() {
        return this.tick1;
    }

    public final TimeTick getTick2() {
        return this.tick2;
    }

    public final Display getLabel() {
        return this.label;
    }

    private TextBlock getTextBlock(Display display) {
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(14);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLUE, false);
    }

    public void drawU(UGraphic ug, TimingRuler ruler) {
        ug = ug.apply(HColorUtils.RED).apply(HColorUtils.RED.bg());
        double x1 = ruler.getPosInPixel(this.tick1);
        double x2 = ruler.getPosInPixel(this.tick2);
        ug = ug.apply(UTranslate.dx(x1));
        ug.draw(ULine.hline(x2 - x1));
        ug.draw(this.getPolygon(-1.5707963267948966, new Point2D.Double(0.0, 0.0)));
        ug.draw(this.getPolygon(1.5707963267948966, new Point2D.Double(x2 - x1, 0.0)));
        TextBlock text = this.getTextBlock(this.label);
        Dimension2D dimText = text.calculateDimension(ug.getStringBounder());
        double x = (x2 - x1 - dimText.getWidth()) / 2.0;
        text.drawU(ug.apply(new UTranslate(x, -this.getConstraintHeight(ug.getStringBounder()))));
    }

    public double getConstraintHeight(StringBounder stringBounder) {
        TextBlock text = this.getTextBlock(this.label);
        Dimension2D dimText = text.calculateDimension(stringBounder);
        return dimText.getHeight() + TimeConstraint.getTopMargin();
    }

    public static double getTopMargin() {
        return 5.0;
    }

    private UPolygon getPolygon(double angle, Point2D end) {
        double delta = 0.3490658503988659;
        Point2D pt1 = TimeArrow.onCircle(end, angle + 0.3490658503988659);
        Point2D pt2 = TimeArrow.onCircle(end, angle - 0.3490658503988659);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(pt1.getX(), pt1.getY());
        polygon.addPoint(pt2.getX(), pt2.getY());
        polygon.addPoint(end.getX(), end.getY());
        return polygon;
    }

    public static double getHeightForConstraints(StringBounder stringBounder, List<TimeConstraint> constraints) {
        if (constraints.size() == 0) {
            return 0.0;
        }
        double result = 0.0;
        for (TimeConstraint constraint : constraints) {
            result = Math.max(result, constraint.getConstraintHeight(stringBounder));
        }
        return result;
    }
}

