/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementLine;
import net.sourceforge.plantuml.salt.factory.ElementFactory;

public class ElementFactoryLine
implements ElementFactory {
    private final DataSource dataSource;

    public ElementFactoryLine(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        Terminated next = (Terminated)this.dataSource.next();
        String text = (String)next.getElement();
        return new Terminated<Element>(new ElementLine(text.charAt(0)), next.getTerminator());
    }

    @Override
    public boolean ready() {
        String text = this.dataSource.peek(0).getElement();
        if (this.isLine(text, '-')) {
            return true;
        }
        if (this.isLine(text, '=')) {
            return true;
        }
        if (this.isLine(text, '~')) {
            return true;
        }
        return this.isLine(text, '.');
    }

    private boolean isLine(String text, char c) {
        String s = "" + c + c;
        return text.startsWith(s) && text.endsWith(s);
    }
}

