/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.AFile;
import net.sourceforge.plantuml.AParentFolder;
import net.sourceforge.plantuml.AParentFolderRegular;
import net.sourceforge.plantuml.security.SFile;

public class AFileRegular
implements AFile {
    private final SFile file;

    public String toString() {
        return "AFileRegular::" + this.file.getAbsolutePath();
    }

    public AFileRegular(SFile file) {
        this.file = file;
    }

    @Override
    public InputStream openFile() {
        return this.file.openFile();
    }

    @Override
    public boolean isOk() {
        return this.file.exists() && !this.file.isDirectory();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AFileRegular)) {
            return false;
        }
        return this.file.equals(((AFileRegular)obj).file);
    }

    @Override
    public AParentFolder getParentFile() {
        return new AParentFolderRegular(this.file.getParentFile());
    }

    @Override
    public SFile getUnderlyingFile() {
        return this.file;
    }

    @Override
    public SFile getSystemFolder() throws IOException {
        return this.file.getParentFile().getCanonicalFile();
    }
}

