/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.StringTokenizer;
import jcckit.util.ConfigParameters;
import jcckit.util.TicLabelFormat;

public class TicLabelMap
implements TicLabelFormat {
    public static final String MAP_KEY = "map";
    private final MapItem[] _map;

    public TicLabelMap(ConfigParameters config) {
        StringTokenizer tokenizer = new StringTokenizer(config.get(MAP_KEY), ";");
        this._map = new MapItem[tokenizer.countTokens()];
        for (int i = 0; i < this._map.length; ++i) {
            String item = tokenizer.nextToken();
            try {
                this._map[i] = new MapItem(item.trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Item '" + item + "' of " + config.getFullKey(MAP_KEY) + " has an invalid number.");
            }
        }
    }

    @Override
    public String form(double ticValue) {
        String result = "?";
        for (int i = 0; i < this._map.length; ++i) {
            if (!this._map[i].isInside(ticValue)) continue;
            result = this._map[i].label;
            break;
        }
        return result;
    }

    private static class MapItem {
        private double _min = Double.MIN_VALUE;
        private double _max = Double.MAX_VALUE;
        private final String label;

        public MapItem(String item) {
            int index = item.indexOf(61);
            if (index < 0) {
                this.label = item;
            } else {
                this.label = item.substring(index + 1).trim();
                if ((index = (item = item.substring(0, index).trim()).indexOf(58)) < 0) {
                    this._min = new Double(item);
                    this._max = this._min == 0.0 ? Double.MIN_VALUE : this._min * 1.000001;
                    this._min *= 0.999999;
                    if (this._min > this._max) {
                        double z = this._min;
                        this._min = this._max;
                        this._max = z;
                    }
                } else {
                    this._min = new Double(item.substring(0, index));
                    this._max = new Double(item.substring(index + 1));
                }
            }
        }

        public boolean isInside(double value) {
            return value >= this._min && value < this._max;
        }
    }
}

