# Plover

> Bringing stenography to everyone.

[![CI badge]][CI link]

| [Homepage][] | [Releases][] | [Wiki][] | [Blog][] | [Google Group][] | [Discord Chat][] |
|--------------|--------------|----------|----------|------------------|------------------|

-   [About](#about)
-   [Installation](#installation)
-   [Getting help](#getting-help)
-   [Contributing](#contributing)
-   [Donations](#donations)
-   [Programming](#programming)
-   [Writing, Art, UX, and Web Design](#writing-art-ux-and-web-design)
-   [Development Environment and Building](#development-environment-and-building)

## About

Plover (rhymes with "lover") is a desktop application that allows anyone
to use stenography to write on their computer, up to speeds of 200WPM
and beyond.

Plover is part of the [Open Steno Project][]. The Open Steno Project's
goal is to provide everything you need to learn machine shorthand on
your own, from free software, to cheap hardware, to learning resources.

Plover is GPLv2+ as of version 3.1.0. See the [license][] for details.

## Installation

Plover runs on Windows, Linux, and Mac.

View the [installation guide][] which covers downloading, installation,
and initial configuration.

## Getting help

Having trouble with Plover?

The Wiki has several pages to help you:

-   [Installation Guide][]
-   [Beginner's Guide][]
-   [Supported Hardware][]
-   [Troubleshooting Common Issues][]

If you are still having trouble, have found a bug, or would like to
request a new feature, please [search for or create an issue][issues].
When making a new issue, fill out the form as best you can so that we
can help you quickly.

If you are looking for more general support (i.e. you don't have a
specific issue), consider joining the community. We are active on the
[Discord Chat][], a live chatroom service; and on the [Google Group][],
a more traditional mailing list.

## Contributing

The Open Steno Project is always growing, and could use your help!

### Donations

Plover is developed by volunteers. Donations to Open Steno help fund new
projects as well as any maintenance costs with publishing Plover.

[Donate here][Donate], donations of any size are very appreciated!

### Programming

Plover is a cross-platform desktop application written in Python. To
contribute to Plover, see [contributing][].

If Python isn't your thing, there are other steno-related projects,
including [StenoJig][] (JavaScript) and [StenoTray][] (Java).

### Writing, Art, UX, and Web Design

-   The [Plover Wiki][Wiki] discusses Plover and Open Steno in
    general. Edits to the Wiki and new page ideas are welcome.
-   Graphic art for Plover and stenography in general is always
    appreciated. The app's icons are worked on at [morinted/plover\_icons][].
    You may consider reimagining or reposing [Plover's mascot, Dolores][Mascot].
-   UX improvement suggestions are welcome. Plover runs on Windows, Mac,
    and Linux, and should be powerful but out of the way, which poses
    some interesting challenges. Please drop in to the Discord server to
    brainstorm with users and the developers.
-   Open Steno has websites that accept contributions, including the
    [Open Steno Project Homepage][Open Steno Project] ([source][Open
    Steno Project Homepage Source]) and [Plover's Homepage][Homepage]
    ([source][Homepage Source]).

## Development Environment and Building

Plover is cross-platform and has separate build instructions for each
platform.

Please follow through for your system:

-   [Windows][Windows README]
-   [Linux][Linux README]
-   [Mac][macOS README]

  [Beginner's Guide]: https://github.com/openstenoproject/plover/wiki/Beginner's-Guide:-Get-Started-with-Plover
  [Blog]: http://plover.stenoknight.com
  [Contributing]: https://github.com/openstenoproject/plover/blob/master/CONTRIBUTING.md
  [Discord Chat]: https://discord.gg/0lQde43a6dGmAMp2
  [Donate]: http://www.openstenoproject.org/donate
  [Google Group]: https://groups.google.com/forum/#!forum/ploversteno
  [Homepage Source]: https://github.com/openstenoproject/plover/tree/gh-pages
  [Homepage]: http://opensteno.org/plover
  [Issues]: https://github.com/openstenoproject/plover/issues?q=is:issue
  [License]: https://github.com/openstenoproject/plover/blob/master/LICENSE.txt
  [Open Steno Project Homepage Source]: https://github.com/openstenoproject/openstenoproject.github.io
  [Open Steno Project]: http://opensteno.org
  [Mascot]: http://plover.stenoknight.com/2010/10/new-logo.html
  [Releases]: https://github.com/openstenoproject/plover/releases
  [StenoJig]: https://github.com/JoshuaGrams/steno-jig
  [StenoTray]: https://github.com/SmackleFunky/StenoTray
  [Supported Hardware]: https://github.com/openstenoproject/plover/wiki/Supported-Hardware
  [Troubleshooting Common Issues]: https://github.com/openstenoproject/plover/wiki/Troubleshooting:-Common-Issues
  [Wiki]: https://github.com/openstenoproject/plover/wiki
  [installation guide]: https://github.com/openstenoproject/plover/wiki/Installation-Guide
  [morinted/plover\_icons]: https://github.com/morinted/plover_icons

  [Windows README]: https://github.com/openstenoproject/plover/blob/master/windows/README.md
  [Linux README]: https://github.com/openstenoproject/plover/blob/master/linux/README.md
  [macOS README]: https://github.com/openstenoproject/plover/blob/master/osx/README.md

  [CI Badge]: https://github.com/openstenoproject/plover/actions/workflows/ci.yml/badge.svg?branch=master
  [CI Link]: https://github.com/openstenoproject/plover/actions/workflows/ci.yml?query=branch%3Amaster
