package org.codehaus.plexus.container.initialization;

/*
 * Copyright 2001-2006 Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.codehaus.plexus.configuration.source.ConfigurationSource;
import org.codehaus.plexus.configuration.source.ContainerConfigurationSource;

/**
 * @author Jason van Zyl
 * @author cstamas
 */
public class InitializeContainerConfigurationSourcePhase
    extends AbstractCoreComponentInitializationPhase
{
    public void initializeCoreComponent( ContainerInitializationContext context )
        throws ContainerInitializationException
    {
        ConfigurationSource configurationSource = context.getContainer().getConfigurationSource();

        // ----------------------------------------------------------------------
        // The configurationSource may have been set programmatically so we need
        // to check. If it hasn't then we will add the default container config source.
        // ----------------------------------------------------------------------

        if ( configurationSource == null )
        {
            // adding default source for container to enable lookups
            context.getContainer().setConfigurationSource( new ContainerConfigurationSource() );
        }
    }
}
