#!/bin/sh

set -e
. ./testsuite/common.sh

TMP_FILE=$(mktemp)
expect_equal \
"bin/phpabtpl --require proj1/pack1 --suggest proj2/pack2 --require-file ${TMP_FILE}" \
"<?php

// Require
require_once '/usr/share/php/Proj1/Pack1/autoload.php';

// Suggest
if (stream_resolve_include_path('/usr/share/php/Proj2/Pack2/autoload.php')) { include_once '/usr/share/php/Proj2/Pack2/autoload.php'; }

// @codingStandardsIgnoreFile
// @codeCoverageIgnoreStart
// this is an autogenerated file - do not edit
spl_autoload_register(
    function(\$class) {
        static \$classes = null;
        if (\$classes === null) {
            \$classes = array(
                ___CLASSLIST___
            );
        }
        \$cn = strtolower(\$class);
        if (isset(\$classes[\$cn])) {
            require ___BASEDIR___\$classes[\$cn];
        }
    },
    ___EXCEPTION___,
    ___PREPEND___
);
// @codeCoverageIgnoreEnd

// Files
require_once realpath('${TMP_FILE}');"
