<?xml version="1.0" encoding="UTF-8"?>
<feed xmlns="http://www.w3.org/2005/Atom">
	<title type="text">Russell Beattie’s Weblog</title>
	<subtitle type="text">...because I can't shut up.</subtitle>
	<updated>2008-07-20T12:16:55-07:00</updated>
	<id>http://www.russellbeattie.com/blog/atom</id>
	<author>
		<name>Russell Beattie</name>
		<email>russ@russellbeattie.com</email>
	</author>
	<logo>http://www.russellbeattie.com/images/russellbeattie_sm.jpg</logo>
	<entry>
		<title type="html"><![CDATA[iPhone Reconciliation]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/iphone-reconciliation" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/iphone-reconciliation</id>
		<updated>2008-07-20T12:16:55-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/iphone.png" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;It's amusing to see a bunch of people in the tech community having trouble reconciling their love for the iPhone vs. how closed and proprietary it is. It's a real conundrum... The iPhone 3G is the best mobile phone there is, bar none, in both functionality and usability. It's also relatively inexpensive, widely marketed, and easy to get down at your local mall so tons of your friends and family have one as well. And there's nothing else like it on the market now, or in the forseeable future.&lt;/p&gt;
&lt;p&gt;However, from a technology perspective, it's about as closed as they come. And this has caused some real consternation in the tech community. They're trying to work through the issue it seems, but haven't really quite gotten it straight in their minds yet.&lt;/p&gt;
&lt;p&gt;First there's Gina Trapani writing about how you should &lt;a href="http://lifehacker.com/398658/why-youre-better-off-avoiding-the-iphone"&gt;avoid the iPhone&lt;/a&gt;, despite the fact that she doesn't actually follow this advice. She lays out the very real problems that the iPhone has from a Free Software and DRM perspective, but in the end simply covers up the Apple logo in a "minor rebellion" and keeps using it.&lt;/p&gt;
&lt;p&gt;Then there's Tim Bray, writing about his &lt;a href="http://www.tbray.org/ongoing/When/200x/2008/07/18/Mobile-Net-Gloom"&gt;Mobility Blues&lt;/a&gt;, because Java development on most phones sucks, Android is nonexistent, and developing for the iPhone despite how nice it is, is akin to being a sharecropper. He doesn't actually address development for Blackberry, Symbian or Windows mobile devices because really, the entire post is summed up as, "God, the iPhone rocks, I wish it were open, or at least had a decent JDK from Sun." :-)&lt;/p&gt;
&lt;p&gt;Then there's Tim O'Reilly - who's been a huge iPhone booster despite the fact that his company was essentially built supporting open source - &lt;a href="http://radar.oreilly.com/2008/07/iphone-rants-and-raves.html"&gt;wondering about&lt;/a&gt; "devices and services that people love so much that they even love to hate them." I don't think anyone loves to hate the iPhone (except competitors obviously), it's that *they hate that they love it*. There's a difference.&lt;/p&gt;
&lt;p&gt;One of the amusing things in O'Reilly's post was at the end where he wrote that Jeff Weiner asked him to "write something that explains why the iPhone is such a paradigm-shifting device," which he agreed he should do. It's sort of another attempt to reconcile the love/hate relationship with the device: "I have to love it! It's 10x better than anything else before it!" But is that true? I don't think so.&lt;/p&gt;
&lt;p&gt;I really don't see any paradigm shift beyond the normal Apple integration and marketing magic. Anyone who's used smartphones for the past few years knows that the iPhone doesn't do anything that another comparable device like a Nokia N95 does - it just integrated them better. There are some innovations like the multi-touch screen, but in general the iPhone succeeds because the whole ends up being more than the sum of it's parts. It's not like it's 10x better than anything else, however. It all depends on your perspective and what you use your phone for. Ask a heavy Blackberry user if they prefer an iPhone's email client, for example, or a Nokia user chatting for free using integrated VoIP if they'd like to give it up, or ask a heavy Danger HipTop users if they want to give up their 24/7 IM connections and I doubt you'd get many takers. That said, ask any Motorola RAZR user what they prefer and there's no contest, so it really just depends on where you're coming from.&lt;/p&gt;
&lt;p&gt;I've loved the iPhone since the moment I started using it (check the archives, baby), and have only gained more respect for it as time goes on. But as a developer and business person I've always been wary of it, and maybe a little annoyed that so much attention was lavished on it to the detriment of other more open platforms. I take the long view, however. The iPhone will never gain a monopoly like Windows - there's just too much competition in the market. Competitors from all sides - from the Intel backed MID devices to the Nokia backed mobile devices to the Linux backed open devices - will eventually catch up in terms of features and functionality. So therefore it's just a matter of time before there are more open alternatives that don't require any sort of sacrifice to use. Just like I use a Sony Vaio laptop with Ubuntu on it instead of a MacBook, with little to no loss of features and a much expanded universe of possibilities, eventually we'll see the same in the mobile market. Until then, I happily have an iPhone in my pocket and not worry about it.&lt;/p&gt;
&lt;p&gt;That doesn't mean I'm content - every time I pull it out of my pocket I almost let out an audible sigh. My biggest regret so far as a professional in the mobile space is that I had nothing to do with that device, actually. I wish I had something to do with it because it's so nice, and has brought smartphones to the masses in a way that no one else could. It would have been nice to have been part of that effort.&lt;/p&gt;
&lt;p&gt;I could actually see &lt;a href="http://www.russellbeattie.com/notebook/1008182.html"&gt;what Jobs was going to do&lt;/a&gt; years ago. Here's what I wrote back in 2004:&lt;/p&gt;
&lt;blockquote&gt;
&lt;p&gt;&lt;em&gt;Steve Jobs has a mobile phone. I'm not sure which mobile phone it is, but he's definltely got one. And he hates it. He curses at it every day. He hates it like he hated the original IBM PC. He hates how hard it is to add contacts and make calls and he cringes at the web experience and the Java games, if he's even bothered to try them. He holds it in his hand during long trips and admires some things about it, but knows *he could do it better.* He knows that if Apple decided to make a mobile phone, it would be the most intuitive and elegant mobile phone in the world. And he wants that phone.&lt;/em&gt;&lt;/p&gt;
&lt;/blockquote&gt;
&lt;p&gt;And he got it. But that's the thing: It's Steve Job's phone, and you shouldn't forget it. You can use it, you can love it, you can praise it, buy apps for it and let your kids play with it. You can do everything you want, but just remember, it's not yours and never will be.&lt;/p&gt;
&lt;p&gt;If you're in technology, this is the thing to understand and once you accept this, it's pretty easy to enjoy how nice the iPhone is. Like leasing a BMW or something. It's not yours, but it doesn't make driving it any less enjoyable.&lt;/p&gt;
&lt;p&gt;:-)&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=eH5zZp"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=eH5zZp" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[The missing iPhone apps]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/the-missing-iphone-apps" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/the-missing-iphone-apps</id>
		<updated>2008-07-17T22:35:51-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/appstore.jpg" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;So I got the new iPhone 3G, and have upgraded my old one to the 2.0 firmware, and have been pretty impressed with some of the innovative applications that are available online. I was thinking about this to myself while keeping my 6yo son occupied today at a restaurant with a free Pong-clone that I looked up and downloaded while we were sitting there. It's simple and fun, though he discovered soon enough that tilting the phone towards your opponent makes the ball go that much faster, and soon I was afraid we were going to snap it in half trying to tilt in the opposite sides direction.&lt;/p&gt;
&lt;p&gt;That said, there's a lot of apps that are just plain missing from the app store - most of them which have been available on much less capable mobile phones for years now. Considering some of the crap that's in the catalog, I wonder if there's just a vacuum of Mac-toting Objective C developers, or if Apple is actively keeping these apps out of the AppStore?&lt;/p&gt;
&lt;p&gt;Some stuff that's missing is just plain geeky, I admit. The first things I want to see are an IRC client, Jabber client, an SSH terminal and a Remote Desktop or &lt;strike&gt;VNC client&lt;/strike&gt; [Update: There is a VNC client already! :-)]. Yes, I'm a geek - but so are the people who usually write these sorts of apps, which makes me think there's not really a dearth of these types of apps, but that Apple is only allowing "commercial" types of programs in the App store.&lt;/p&gt;
&lt;p&gt;Beyond this stuff, I'd love to see a real VoIP client (Skype, or SIP) - all the advanced Nokia phones have this stuff integrated into them already - so it can't be carrier pressure or anything unless they're being overly cautious. I'd also love to have a camcorder app, or at least a decent camera app that doesn't lack features like the integrated one does (timer, digital zoom, etc.). And what about an Opera or Mozilla browser, maybe with integrated Flash? There doesn't seem to be any real technical reason for them not to be there.&lt;/p&gt;
&lt;p&gt;Those are sort of "nice to have's", but an example of an important and popular app that's missing is MobiTV. Live streaming TV has been a staple on American mobile phones since I got my Nokia 6620 EDGE phone years ago. Not being able to have the option to watch live TV on HSUPA 3G networks is a almost a crime. I can't imagine that MobiTV ignored this platform outright, can you? And YouTube and Pandora already do video and/or streaming. Something else must be going on.&lt;/p&gt;
&lt;p&gt;Thinking about it I realized the AppStore doesn't have any apps with a subscription model. They're all apps that are buy-once, use forever. Until I realized this, I had simply mentally compared the Apple AppStore to the Qualcomm Brew deck that's been on CDMA phones for years, but now I realize that in fact, it's actually much less capable. (Sorry Apple fans, they are neither the innovator here, nor apparently the most full-featured either.)&lt;/p&gt;
&lt;p&gt;The comparison is actually quite accurate in general though. I still think it's shitty that I have to go through the iTunes interface to install apps at all - this is just like how Brew phones work as well. Why can't I just load up an app from any URL? Apps should be thought of as music, and just like I can "sideload" my iPhone with MP3s from my CDs, I should be able to load up apps from independent sites as well. This is exactly like the Qualcomm model. But you know, I remember being at one of the first MobileMondays in San Francisco years ago and Rocket Mobile was presenting, and Marc Canter sitting in the back having an absolute coronary hearing about all the limitations of the Brew app platform and being absolutely aghast that any developer would want to play that game, regardless of the revenue model. It seems however, that he's among the few, and Apple especially seems to able get away with this crud without so-much as a negative peep from the blogging or developer community. Hey, if you don't like it, don't develop for it, right? Sure, that's fine, I honestly just can't believe there's so many developers who decided to accept it.&lt;/p&gt;
&lt;p&gt;The sad part about it is most of the stuff I'm missing were available &lt;a href="http://www.russellbeattie.com/notebook/1005581.html"&gt;on my Nokia 6600 in 2003&lt;/a&gt;. So if that's the case, why do I use an iPhone? Because it's the best damn mobile phone on the freakin' planet, with the biggest screen and nicest UI - that doesn't mean I need to eat Apple's shit and like it though.&lt;/p&gt;
&lt;p&gt;All that said, I do have to say that there's apps for the iPhone that I *haven't* seen on any of the other smartphones out there even with years head start, so there's definitely a thriving and innovative community supporting the iPhone, and for that I'm happy and look forward to seeing what comes next. But just imagine how much *more* innovation we would see if these developers were actually using an open platform instead?&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=RVFPG5"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=RVFPG5" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Roomatic]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/roomatic" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/roomatic</id>
		<updated>2008-07-16T19:50:27-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/roomatic.png" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;I decided to whip up an experiment called &lt;a href="http://roomatic.com"&gt;Roomatic&lt;/a&gt; to test out some ideas I had to give Twitter some more forum-like community functionality like I've been posting about lately. The end result ended up being a way of using Twitter like how you would use IRC, with the channels based on #hashtags that are included in messages and presented in a standard chatroom interface.&lt;/p&gt;
&lt;p&gt;At first I was aiming towards making a sort of Twitter-based clone of FriendFeed's comment functionality (which I may still try to do) so you'll see that Roomatic's rooms don't just have to be hashtags, but also "hashurls" (I just made that up, can you tell?). In other words, you can pre-pend a URL with a hashmark like this: #&lt;a href="http://tinyurl.com/3c9ljq"&gt;http://tinyurl.com/3c9ljq&lt;/a&gt;, and it becomes a room based on that URL. (Try it to see what I'm talking about).&lt;/p&gt;
&lt;p&gt;That was the base of the functionality I wanted to use to enable comments, but then as I started messing with the Twitter and Summize APIs, I realized I could make it a bit more "live" using the JSON API. It ended up working out really well and enabled me to make a service out-of-the-box so that I didn't have to have users add Roomatic as a friend to use it (like you do with &lt;a href="http://hashtags.org"&gt;hashtags.org&lt;/a&gt;), nor did I have to store any user data. The Twitter POST just gets passed through to the server, and the rest comes directly from the JSON query. The result is the same sort of functionality I was looking for, but with minimal resources needed on my server.&lt;/p&gt;
&lt;p&gt;I'm *so* glad that Twitter bought Summize, as even though they encouraged people building stuff on their API, I was worried about hammering at their servers too much. Each page will poll the JSON Search API once every 3 seconds for updates - and even though you can set it so that it only asks for updates since a specific tweet ID (which I did), it still seemed like a lot to do to some third party. Twitter, however, is supposed to handle it. :-)&lt;/p&gt;
&lt;p&gt;This isn't much different than the functionality that Summize/Twitter Search already has, truth be told, but I wanted to see how it would "feel" with a slightly tweaked UI and updates that are shown immediately. I'm not particularly adept at Javascript or JQuery, so it's a bit crufty at the moment, but it gets the general idea across. (If you know ways of improving the way the Javascript works, *please* feel free to ping me).&lt;/p&gt;
&lt;p&gt;Anyways, because only the original room requests and posts go through the server and the rest is done via JSON, it's actually quite light to host, so I thought it would be fun to throw the site out there, even in its crufty state. Try it out and tell me what you think.&lt;/p&gt;
&lt;p&gt;Oh, and I'll be in #&lt;a href="http://roomatic.com/roomatic"&gt;roomatic&lt;/a&gt; if you want to chat.&lt;/p&gt;
&lt;p&gt;:-)&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;
&lt;p&gt;Update: Tweaked the site a bit so that #hashtags aren't the default, just the room word itself. Hashtags can still be used to narrow the results with a %23 added to the room name.&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=YEJbeS"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=YEJbeS" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[I need a job!]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/i-need-a-job" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/i-need-a-job</id>
		<updated>2008-07-08T11:38:25-07:00</updated>
		<content type="html">&lt;p&gt;Ahh, so it's that time again, when I post about needing to find a job - only this time I really mean it. :-) I've spent the past couple months decompressing after the failure of Mowser, and now looking at my bank account, it's time to get serious about moving on. Happily I can say that I'm rested, semi-tanned, and completely bored out of my mind, so finding a nice place to do some cool stuff sounds very appealing to me at the moment.&lt;/p&gt;
&lt;p&gt;If you have a job that you think I might be good for, please email me at russ@russellbeattie.com, or call me at +1 415 606 5345.&lt;/p&gt;
&lt;p&gt;My &lt;a href="http://www.russellbeattie.com/resume.html"&gt;resume is here&lt;/a&gt;. The question you might be asking after seeing it is what exactly is it that I do? Well, that's a good question. I'm not a heads-down programmer any more, nor do I have real experience in product or project management, and though I did start my own company, it died... So that leaves me with hand waving, I guess. Do you need a good hand-waver (consultant, strategist, analyst)? If so, I'm your man!&lt;/p&gt;
&lt;p&gt;Actually, I swore that if I failed at Mowser, I was going to shift gears and do something else like write for a living, or maybe be a full-time analyst (I did apply to Forrester last week, but they haven't responded yet). That said, the salary you can make in a technology company is still better than what you get as a writer, so it'd be sort of silly to just jump ship if I can still get a decent gig at one of the web companies or startups around. It's going to be a tough haul, though... I've had some phone interviews already with people just looking for low-level PHP contractors and they didn't go well, and since I don't think anyone in the mobile-web business wants to talk to me any more (for obvious reasons, as I think they're doomed) I really have limited options. If you know of something, definitely send it my way!&lt;/p&gt;
&lt;p&gt;Thanks!&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=NakXXO"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=NakXXO" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Trending Topics]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/trending-topics" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/trending-topics</id>
		<updated>2008-07-08T09:32:27-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/summizetopics.png" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;The news broke last night that Twitter is going to buy &lt;a href="http://www.summize.com"&gt;Summize&lt;/a&gt;, which I think is fantastic because it's such a great service which really adds a ton of value to Twitter. Om, in his jetlagged state, &lt;a href="http://gigaom.com/2008/07/07/summize-twitter-deal"&gt;wrote about why it's important here&lt;/a&gt;: the idea is that analysis of conversations is good for contextual advertising, etc. "We monitor collective attitudes being expressed right now on the web".&lt;/p&gt;
&lt;p&gt;That's great that Summize thinks of itself that way, as I've personally thought that's been the best part of the service - and something I've used daily for the past couple weeks. The "Trending Topics" link section on their front page is really, really cool - much moreso than the search stuff. (I wish in fact there was a feed of just those links so you could see topics as they bubble up to the list. I'd also love to see them expanded on as well - a bigger top 100 list per day for example.)&lt;/p&gt;
&lt;p&gt;The reason I think they're so cool is that you get to take the pulse of a thousand conversations from a million people or so and find out what they're interested in at any given moment. This is pretty great for someone like myself that tends not to be aware of popular issues outside my little tech bubble I live in. For example, lately I've learned that the Bachelorette was coming to the end and seemed to be something lots of people were interested in. (I had zero idea the show even existed). Also, I've seen movie reviews pretty consistently, and news topics as they pop up. Right now, because of the population of Twitter is left-leaning alpha-geeks and power users, the topics tend to be on that side of things with "Obama" being a semi-permanent member of the list, as well as navel-gazing type links - "Oooh, boy! Another AIR client for Twitter!" - and technology stuff like this morning's Drobo 2.0 announcement. But as the user base expands, the topics should get much more broad, and it'll be interesting to see what they are.&lt;/p&gt;
&lt;p&gt;It's like those year-end zeitgeist reports that Google and Yahoo! do where they list the most important search terms of the year, but live and constantly updated. And more importantly, I don't just see that people are searching "about" something, but I get to see their opinion on it as well. Do they like the thing they're mentioning, or do they hate it? That's a key differentiator from a "popular search terms" list we've seen up til now.&lt;/p&gt;
&lt;p&gt;I think if Twitter doesn't end up buying Summize, or even if they do that they should re-focus a lot of their effort in this area as this stuff is valuable to a ton of other services out there. (This was no doubt Summize's original business plan...). I just have that gut feeling of its inherent value, and it seems huge to me. Imagine a "topic engine" that did nothing but scour the latest blog posts, tweets, forum posts, etc. and created live topic lists for tons of areas? Like Nielson on steroids. It seems to me it'd be a really valuable position to be in: "Why is that important? Oh, Summize said it was."&lt;/p&gt;
&lt;p&gt;All that said, it seems like something that Google or Yahoo! could do in a heartbeat since they're already spidering so much content out there. I wonder if we'll see something from them sometime soon now that it's been pointed out?&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=TBMnwy"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=TBMnwy" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Playing with Seesmic]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/playing-with-seesmic" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/playing-with-seesmic</id>
		<updated>2008-07-08T00:55:27-07:00</updated>
		<content type="html">&lt;p&gt;&lt;span style="padding:0px; margin:0px; display:block"&gt;&lt;object width="435" height="355"&gt;&lt;param name="movie" value="http://seesmic.com/embeds/wrapper.swf" /&gt;
&lt;param name="bgcolor" value="#666666" /&gt;
&lt;param name="allowFullScreen" value="true" /&gt;
&lt;param name="allowScriptAccess" value="always" /&gt;
&lt;param name="flashVars" value="video=AjbBrGxzNa&amp;amp;version=threadedplayer" /&gt;
&lt;embed src="http://seesmic.com/embeds/wrapper.swf" type="application/x-shockwave-flash" flashvars="video=AjbBrGxzNa&amp;amp;version=threadedplayer" allowfullscreen="true" bgcolor="#666666" allowscriptaccess="always" width="435" height="355" /&gt;&lt;/object&gt;&lt;/span&gt;&lt;span style="display:block; width:435px; margin:0px; padding:0px;background:url(http://seesmic.com/images/seesmichtml.gif) left top repeat-x"&gt;&lt;a href="http://seesmic.com" target="_blank"&gt;&lt;img width="100%" height="29" style="border:none" src="http://seesmic.com/images/spacer.gif" border="0" alt="[image]" /&gt;&lt;/a&gt;&lt;/span&gt;&lt;/p&gt;
&lt;p&gt;Just trying out the new Adobe Flash 10 for Linux support for v4l2... yay!&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=IksNAp"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=IksNAp" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Grokking FriendFeed]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/grokking-friendfeed" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/grokking-friendfeed</id>
		<updated>2008-07-06T11:04:45-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/friendfeed.png" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;Even though I signed up for it months ago, it took me until just last night and today to figure out WTF was going on at FriendFeed. I'd see raves about it pop up on TechMeme, I'd go try it, not have any clue what the use of it was, and then forget about it again. It seemed like chaos and noise to me and no better than my current news reader.&lt;/p&gt;
&lt;p&gt;So last night I went through and started cleaning everything up - I got rid of all my feeds first, and just added in my blog, Twitter and Disqus. Then I deleted all my friends, and went through and added a few back in by hand. That seemed to clean things up quite a bit, and this morning I confirmed FriendFeed was much more useful.&lt;/p&gt;
&lt;p&gt;This is really the fault of FriendFeed's signup design because of its emphasis on adding your Facebook friends. When you sign up to the the service, it asks if you want to import from Facebook - and then automatically adds a bunch of those users who are already signed up if it finds matches, auto subscribing you to their set of feeds and vice versa. That just added tons and tons of feeds right away. Combine that with the "feature" of seeing 'friend of friends' feeds and the fact that you can sign up to the service like I did, add in a bunch of links, and then never return to it again, is just a recipe for noise.&lt;/p&gt;
&lt;p&gt;So now that I cleaned everything up, I'm grokking what's going on quite a bit more, and there's a few things that are going on that are interesting - and not just another mashup of feeds. There are (at least) three distinct parts to the system that I finally have figured out.&lt;/p&gt;
&lt;p&gt;The first part of the service should almost be called "Friend's Feeds" (possessive and plural) as the idea is that you and your contacts can add in all the feeds from their various services they use regularly and they will appear on your home page as an "activity stream". Each user's profile page is also sort of a summary of their online activity as well which if you think about it is incredibly useful. Rather than having to create a feed which splices in all the various services, FriendFeed does it for you and creates a nice web-viewable page for people you know (private or public, your choice) and also creates a "feed of feeds" as well. Though I've had readers of this blog complain when I spliced in various other feeds like my del.icio.us links or my Twitter posts, it's still a great reflection of what I want to share online - so it's very cool.&lt;/p&gt;
&lt;p&gt;Side note: One has to wonder if FeedBurner - who had a limited feed splicing in their service from years ago - will get into the act and offer a more complete service that competes on this level? I already use FeedBurner to offload the robot activity from my blog's feed, it's tempting to also offer my FriendFeed spliced feed as well. Reversing this, I wonder if FriendFeed will ever provide the stats of FeedBurner or the ability to map domains?&lt;/p&gt;
&lt;p&gt;The second part of FriendFeed is the direct posting/sharing feature. You can share links and tweet-like posts directly on FriendFeed, bypassing the other systems you may use. This is sort of brilliant. Once users start using FriendFeed and get others to subscribe to it, they'll star to wonder, "Why post this link on del.icio.us or use Twitter to post a random thought, when I can just share it straight to FriendFeed instead?" Though at first, you might not have enough friends who know about your FriendFeed stream, so you might be afraid of posting something that no one else sees - as more of your friends start using it (or are aware of it), there's a tipping point where it becomes&lt;/p&gt;
&lt;p&gt;Finally, the last part is the comments/forum features which have been layered on top of all the items that have been posted to the service. Each item - whether it's a Flickr photo that's been imported via your Flickr feed, or a post you wrote directly in FriendFeed using the "Share Something" button - is the basis of a public conversation where other FriendFeed users can add their thoughts by adding a comment. Additionally, you can choose to share an item or a feed directly into a FriendFeed Room, where the comments on those items are seen by everyone in that room, whether they subscribe to the original item's feed or not.&lt;/p&gt;
&lt;p&gt;Had I understood how much FriendFeed acts like a forum last night, I would have added to my &lt;a href="http://www.russellbeattie.com/blog/my-fascination-with-web-forums"&gt;mongo-post&lt;/a&gt; about the subject. The fact that I discovered after I had already posted about how compelling forums are, and how FriendFeed is gaining traction quickly only goes to reinforce the point of my post I think.&lt;/p&gt;
&lt;p&gt;There's actually a huge similarity in how 4Chan works, and how FriendFeed works which unless you're obsessed with the subject you may not notice. When a user comments on an item in FriendFeed, it "bumps" the feed back to the top of your activity stream. This is very similar to how many forums - especially the anonymous ones - work as well. It serves to help continually push the topic and encourage users to respond to each other, as the discussion keeps coming to the top until it loses steam.&lt;/p&gt;
&lt;p&gt;So FriendFeed does some really interesting things, and some more that I haven't paid much attention to yet (the Digg-like "joe liked this" rankings for example), but honestly, it's a total *mess*. It's sort of the anti-Twitter in terms of usability and focus. It's so completely geared towards the power user and uber-geeek its not funny - though with a name like FriendFeed, it's not surprising, most people still have no idea what the hell a 'feed' is. But even for the most jaded Web 2.0 super user, the service's multitude of entry points (feeds, sharing, comments) makes it so easy to devolve from a useful service into pure noise, as I personally can attest to.&lt;/p&gt;
&lt;p&gt;FriendFeed needs a serious cleanup, IMHO. Some problems:&lt;/p&gt;
&lt;p&gt;* Their tab metaphor is all screwed up - some things get new tabs, others are in sub-tabs/links. Tabs pop up and then disappear. It's just horrible.&lt;/p&gt;
&lt;p&gt;* Your account settings are accessed by a link up in the corner, and has some functionality you'd expect in the friend settings tab, which is hidden off on the right.&lt;/p&gt;
&lt;p&gt;* The Facebook integration is just a bad way to start off (like I said above) - I don't subscribe to everyone in my Facebook's feeds for a reason.&lt;/p&gt;
&lt;p&gt;* Showing me friend-of-friends by default is just dumb, and the setting to turn it off is really hard to find and should be in a global settings page.&lt;/p&gt;
&lt;p&gt;* There's no way to filter which feeds of my friends I see. Just because someone's added in 30 different sources, doesn't mean I need to see them all. Why is it all or nothing?&lt;/p&gt;
&lt;p&gt;* There's no list of Rooms... which I think is weird and probably just an oversight for now.&lt;/p&gt;
&lt;p&gt;* Profile pages have everything except the most basic info! It needs a blurb and a "main link" as well. Some people have added me, and it's hard to figure out which of their many feeds is best to learn about who they are.&lt;/p&gt;
&lt;p&gt;* Is FriendFeed mainly an activity stream, a microblog system, or a forum? They don't have to cut features, but they need to choose a focus.&lt;/p&gt;
&lt;p&gt;Okay, so that's all my thoughts for now. Feel free to &lt;a href="http://friendfeed.com/russellbeattie"&gt;add russellbeattie&lt;/a&gt; to your FriendFeed friends or subscribe to my &lt;a href="http://friendfeed.com/russellbeattie?format=atom"&gt;feed-of-feeds&lt;/a&gt;, which only has a few services right now, but will probably expand as I use the service more.&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;
&lt;p&gt;&lt;script type="text/javascript" src="http://friendfeed.com/embed/widget/russellbeattie"&gt;
&lt;/script&gt;&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=GtDrSt"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=GtDrSt" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[My fascination with web forums]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/my-fascination-with-web-forums" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/my-fascination-with-web-forums</id>
		<updated>2008-07-06T00:14:11-07:00</updated>
		<content type="html">&lt;p&gt;&lt;a href='http://grapher.compete.com/deviantart.com+twitter.com+ubuntuforums.org?metric=uv'&gt;&lt;img src='http://grapher.compete.com/deviantart.com+twitter.com+ubuntuforums.org_uv.png' alt="[image]" /&gt;&lt;/a&gt;&lt;/p&gt;
&lt;p&gt;Think about the last time you were trying to find an answer for something online - where did you eventually find the solution? It may depend on what you were looking for, but for me the answer is invariably contained in a web forum somewhere online. Blogs will many times have information about what I'm looking for, but almost always there's a forum thread or two out there that has as much or more info about whatever it is I'm looking for. Forums are as old as the Internet itself (newsnet, bulletin boards, AOL boards, etc.), and yet they're still fascinating to me.&lt;/p&gt;
&lt;p&gt;They're so useful, varied and popular and yet they're also so broken in many ways. I really don't think enough effort has been dedicated to "figuring out" why they work, and what can be done to improve on the standard formula. Forums have a pretty common structure - you have a main page where you see "categories" of things to leave messages about, then within those category pages are "threads" or "discussions" which show the first message in the the thread, and the number of replies to it. Clicking on the thread leads to a list of messages about that subject.&lt;/p&gt;
&lt;p&gt;This tried and true model serves some of the &lt;a href="http://www.big-boards.com/"&gt;biggest websites&lt;/a&gt; out there. They're not big as say, Yahoo! or AOL, but they collectively have millions of members who produce millions of posts every day. The amount of knowledge and effort going into those sites is incredible - but they seem almost completely under the radar of entrepreneurs or investors because they are so common.&lt;/p&gt;
&lt;p&gt;Yet look at the graph I included above from Compete.com - there's so much interest in Twitter and yet it only just recently passed GaiaOnline in terms of users, and hasn't caught up yet with the image forum DeviantArt. Sure, Twitter's growth is fantastic and viral, but look at those other sites, chugging along with millions of members and posts, and there's dozens more just like those out there.&lt;/p&gt;
&lt;p&gt;This is what I've been obsessing about lately. I've actually written about forums before, but I'm looking at them with fresh eyes and noticing how interesting they are, and yet how little they've been modernized. I have the sensation there's a huge opportunity here waiting to be taken advantage of.&lt;/p&gt;
&lt;p&gt;If you step up a few levels, it's easy to think of *everything* as a forum of one sort or another, yeah? Social Networking contain forums, profile pages with "wall" posts are like personal forums, Yahoo! and Google groups are forums, blogs with comments are forums, company feedback pages are forums, etc. etc. But I'm thinking of the topic-based, shared-experience forums rather than these smaller discussion pages.&lt;/p&gt;
&lt;p&gt;I think that may be what attracts me to forums so much. I always go back to my experience with Facebook most of my interactions using the system are one-on-one. I approve new friends, I get a few messages, I leave and read Wall posts - everything is done in the context of one person talking to another, though in the view of the public. I've gone hunting around for interesting forums or groups in Facebook with real content and there doesn't seem to be much there. It's a person-centric social structure, not an object-centered one like most of the forums. You go to the massive IGN forums to talk about games, GaiaOnline to talk about Anime and you go to DeviantArt to share interesting images. These are things I can understand and relate to - it's the difference between going to a party, and going to a meetup or event. I rarely do either, but I much prefer meetings with a purpose, just like I much prefer forums.&lt;/p&gt;
&lt;p&gt;The genres of forums are interesting as well to me. I've been fascinated with Japan's &lt;a href="http://en.wikipedia.org/wiki/2ch"&gt;2ch&lt;/a&gt; "image board" forum for years now, and recently explored the English-language equivalent at &lt;a href="http://4chan.org"&gt;4chan.org&lt;/a&gt;. Both are anonymous forums (which I initially &lt;a href="http://www.russellbeattie.com/notebook/1008640.html"&gt;wrote about years ago&lt;/a&gt;), neither requiring users to log in, with most posts being written by "Anonymous". Both are also incredibly influential - 2ch much moreso in Japan, but 4Chan is the source of many of the Internet memes we've seen over the past couple years (Rickrolling, etc.). According to Wikipedia, 4Chan's /b/ "random" topic has wracked up an incredible 70MM posts in its 4 years.&lt;/p&gt;
&lt;p&gt;Well, most of that is probably the absolute worst trash you can imagine. Even if you've seen it all, hanging out on 4chan for a bit will scar your retinas and challenge your faith in the good of humankind. That said it's the ultimate expression of free speech, and hey, also pretty amusing at times. :-) Putting aside moral and ethical questions for a moment (the racism, sexism and homophobia on /b/ is pretty disconcerting...) I'm just thinking of the numbers. The volume of posts is such that you don't actually have to ever use the "next page" links, simply refresh the topic pages, and posts will bump up over and over again. There's obviously something about this type of forum which is incredibly compelling.&lt;/p&gt;
&lt;p&gt;Well, all forums actually. People post and post and post to them. Think 4Chan's number of posts is huge? According to Big-Boards, GaiaOnline has over 1.3 BILLION posts! They're obviously the exception (and are such a force, they're launching their own MMRPG based on their forums, which is crazy), but IGN has 181MM posts in its site, Nexopia has 160MM.&lt;/p&gt;
&lt;p&gt;This is what excites me, because it seems for all their size and popularity, most of the popular boards use off the shelf software to do most of their work. And maybe that's fine since the compelling part of the forums ostensibly aren't the features of the site itself, but the topic it's covering. Companies are already taking advantage of the fact that there's little need to innovate - Ning, for example, is essentially just a forum site. Browsing the most popular or featured "networks", their basic forum component is always the core element - with the other features like extensive profiles and friends being secondary. &lt;a href="http://www.lefora.com/"&gt;Lefora&lt;/a&gt; is focusing just on the forum itself, not even bothering with the social stuff. This makes sense, since it seems that once you've created a forum around a topic, traffic and posts seem to follow regardless of additional features.&lt;/p&gt;
&lt;p&gt;But what's to say that by changing some of what's considered standard in forums, there wouldn't be something that's even more compelling?&lt;/p&gt;
&lt;p&gt;A few years ago I was doing some thought experiments around this topic when tagging was all the rage and ended up with what I called a "hyper forum" (I &lt;a href="http://www.russellbeattie.com/notebook/1008301.html"&gt;wrote about it here&lt;/a&gt;.). The idea was to add tags to each post in a normal forum, so you could then follow posts in various dimensions - by date, by thread and by tags. It didn't work out very well as it was incredibly confusing, but it was an interesting experiment.&lt;/p&gt;
&lt;p&gt;Going in the opposite direction of adding to forums, how about simplifying instead. For example, is there really a need for both topics and threads? Is there a better way for non-registered users to discover topics (say by word frequency or page-view popularity)? Is there a better way for users to keep track of posts and replies? Essentially what I'm thinking of is a microblog version of a forum - simplified and streamlined.&lt;/p&gt;
&lt;p&gt;One of the things I'm obsessed with is "user friction", which is why I love anonymous forums so much. For example, there's zero friction involved in participating in a 4Chan thread. You don't have to register, and the upload field is part of the main form. You just write what you want, add a file and you've instantly added content to the forum. But the site just looks like hell and takes ages to understand what's going on.&lt;/p&gt;
&lt;p&gt;The problem however, with all forums especially ones you can post anonymously to is spam and/or illegal activies and content. Years ago I remember wondering why Yahoo! didn't do more to emphasize their message boards or chat rooms. Those are the ones that used to be part of Yahoo! Messenger or linked at the bottom of news posts. &lt;a href="http://habitatchronicles.com/"&gt;Randy Farmer&lt;/a&gt; - who's been doing &lt;a href="http://www.fudco.com/chip/lessons.html"&gt;virtual community stuff&lt;/a&gt; longer than I've been using a computer mouse regularly - sat me down and explained how the more anonymous a community is, the more work it takes to maintain and the less value it has to users and ultimately to advertisers. The message boards were filled to the brim with spam and the chat rooms were filled with nothing but crude behavior and high probability of "grooming". Since human moderation was expensive, and ultimately impossible, Yahoo! eventually got rid of that stuff as it was just too taxing and/or dangerous to maintain.&lt;/p&gt;
&lt;p&gt;Again, this goes back to why Twitter is so interesting. The whitelist system cleans up so much of that stuff it's incredible (as &lt;a href="http://www.russellbeattie.com/blog/nearly-a-million-users-and-no-spam-or-trolls"&gt;I wrote about here&lt;/a&gt;), thus also making it quite valuable. Sure, you might get requests to be be friends with 100 bots a day, but if you don't add them, you don't see their crap in your messages. The question is, how can you duplicate this inherent value in a forum?&lt;/p&gt;
&lt;p&gt;I've got some ideas, which is why I was excited to play with the Laconi.ca codebase a bit a couple days ago at my catchall domain &lt;a href="http://foozik.com"&gt;Foozik&lt;/a&gt;. The first thing I did was bump up the maximum length of a post to 280 characters, and add in automatic embedding of image and YouTube links. It's not a forum, but it's at least a bit more in line with some of my thoughts for features that I think would be interesting to have. I'll most likely start in on the code again from scratch though, as I want it to be unique, but it's good to test out ideas.&lt;/p&gt;
&lt;p&gt;I envision this sort of combination of Tumblr, Twitter and 4Chan in my head - where it's super easy to start posting various content types, and easy to keep track of a thread and replies, but with much less baggage of a traditional forum with their tables and links and weird avatars and sigs cluttering the interface. The questions is how to keep the quality up and spam out, and that I'm not sure about just yet... but I feel like I'm close.&lt;/p&gt;
&lt;p&gt;Maybe just a couple more years, and I'll have figured it out. :-)&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=KgMRKU"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=KgMRKU" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Let the microblogs bloom]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/let-the-microblogs-bloom" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/let-the-microblogs-bloom</id>
		<updated>2008-07-03T12:35:05-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/twitter-whale.png" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;I was just about to embark on a post yesterday about my latest obsession which is web-based forums (actually, it's a return of an old obsession) when &lt;a href="http://identi.ca"&gt;identi.ca&lt;/a&gt; launched with their open source PHP-based Twitter clone, so I just had to try it out. I threw it up on foozik.com if you want to see. It took me a while to get the dependencies working, but it seems pretty cool.&lt;/p&gt;
&lt;p&gt;It's a great effort, looks good, and promoted in all the right ways. Evan (the guy behind identi.ca and the &lt;a href="http://laconi.ca"&gt;laconi.ca&lt;/a&gt; code base) did a great job creating a nice little project with some cool features like OpenID, Jabber support and the beginnings of a federation system.&lt;/p&gt;
&lt;p&gt;Looking at the code, however, it's doomed.&lt;/p&gt;
&lt;p&gt;The core architecture just isn't made to scale, and a day after it launched identi.ca already seems to be paying the price, even after adding a bunch more servers. Here's the the problem in a few lines of code:&lt;/p&gt;
&lt;pre&gt;
&lt;code&gt;
$notice = DB_DataObject::factory('notice');

# XXX: chokety and bad

$notice-&amp;gt;whereAdd('EXISTS (SELECT subscribed from subscription where subscriber = '.$profile-&amp;gt;id.' and subscribed = notice.profile_id)', 'OR');

$notice-&amp;gt;whereAdd('profile_id = ' . $profile-&amp;gt;id, 'OR');

$notice-&amp;gt;orderBy('created DESC');
&lt;/code&gt;
&lt;/pre&gt;
&lt;p&gt;Even the comments express this is "chokety and bad". Ignoring the use of the PEAR::DB data object stuff (that's adding abstractions on top of your database that you can't afford to have) this code shows that the design of the system is fundamentally flawed. The core problem is the query itself - it's expensive as hell: "Get all the notices (messages) where I am subscribed to the publisher." Oh, man. As the database grows, the indexes will have to get huge, and as there's more subscribers and more subscriptions between subscribers, it's going to be impossible for that query to keep up.&lt;/p&gt;
&lt;p&gt;The lesson from Twitter is that microblogs aren't Content Management Systems at all, but are instead Messaging systems, and have to be architected as such. SMTP or EDI are our models here, not publishing or blogs.&lt;/p&gt;
&lt;p&gt;Here's how a microblog system has to work to scale: All the messages created by users have to go into a Queue when they're created, and an external process then has to go through one by one and figure out which messages go into which subscriber's message list. As the system grows and more messages are created, the messages may arrive in your "inbox" slower, but they will still arrive. This type of system can be easily broken up into dedicated servers and multiple processes can handle different parts of the read/write process, and the individual user message lists can be more easily cached - as once a page is created that contains messages, it doesn't change.&lt;/p&gt;
&lt;p&gt;If you don't set it up like this? Well, you're seeing what happens at Twitter and identi.ca now. As the number of users scale up, and the number of messages increase, the load quickly overwhelms any relational database until it'll become impossible to keep up. Structuring microblog systems essentially like self-contained web-mail is the key. Just think about it - Hotmail survived and scaled after it launched in the 1990s when 512MB of RAM was considered a lot and 10GB hard drives were "big". It's not about *power* or throwing more/bigger hardware at the problem, it's about architecture.&lt;/p&gt;
&lt;p&gt;Another example: Lots of web forums out there get millions of new posts a day by tons of users (GaiaOnline.com had 5MM posts last week, for example), but they scale just fine because the format of forums have been designed to scale. These sites work because they simplify queries, facilitate caching, and not guaranteeing instant updates. Simplification and caching are to me the fundamental aspects of web scaling. This is the way it's been for a decade now... Want to survive a Slashdotting, for example? Get your DB out of there and export your pages as .html static files. These same principles can be applied even to a microblog/messaging system as well.&lt;/p&gt;
&lt;p&gt;Once this is widely accepted (and I'm sure there are many that would argue with me), the thing that will separate these types of services won't be whether they stay up (ala Twitter), but how fast your subscription messages are updated. Some services might be smaller or offer more features but not update as quickly whereas others will pride themselves on being as close to real-time as possible. The key is that it's all about messaging, not publishing. (Oh, and this also facilitates federation as well, but that's another topic).&lt;/p&gt;
&lt;p&gt;This said, all is not lost for the Laconi.ca code. The good thing is that it's open source, and not only that, but using the GNU Affero license, which means any changes made on anyone's server needs to be released back as well. Hopefully now that there's a code base to start from, some others (like myself) who are too lazy to start from scratch can get in there and start tweaking and shaping the code into something that will fundamentally scale better.&lt;/p&gt;
&lt;p&gt;I envision lots of microblog services out there, actually. Even though services do have a network effect going for them (the reason Twitter has survived for so long), the idea of smaller microblog services is very appealing. One comment on Identi.ca yesterday spelled out it's usefulness perfectly - a person wanted a version she could use in her classroom as a way for students to ask questions. Very cool - yes you could use a live chat room or a simple forum or e-group, but bringing the subscription model into it would add a very interesting dynamic that I think better reflects how people really interact. That's just one example, but I think there's even more out there.&lt;/p&gt;
&lt;p&gt;Just my thoughts for now. I'm going to write more about web forums in a bit.&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=56XT41"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=56XT41" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[My first gedit plugin]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/my-first-gedit-plugin" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/my-first-gedit-plugin</id>
		<updated>2008-06-30T11:24:57-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/gedit.png" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;I was looking at the various &lt;a href="http://live.gnome.org/Gedit/Plugins"&gt;gedit plugins&lt;/a&gt; yesterday, and decided I wanted to write my own. I actually really like gedit as a text editor - it's lightweight and with the plugins provides nearly as much functionality as UltraEdit or Textmate. It's actually amusing that the default text editor in Gnome is as powerful as it is - coming from Windows, you're used to Notepad being a piece of junk and having to find other apps to do any real work. This can be a bit of an issue, as if I've turned on line numbers and highlighting, and then open up a random text file for a README or something, the use cases sort of overlap (not that it bothers me that much).&lt;/p&gt;
&lt;p&gt;Anyways, I decided to create a *really simple* plugin for inserting a timestamp - I use text documents to record ideas and todos, and I always put in a timestamp before I start writing. There's already a plugin that's included called "Insert Date" but by default it pops up a dialog to ask you for a format each time. It wasn't until *AFTER* I wrote a simple plugin to do the same thing that I noticed that you can just go into "configure plugin" and choose the default format. I'm glad I didn't notice though, since that allowed me to learn how plugins work and create a sort of "canonical" plugin that I can expand on later.&lt;/p&gt;
&lt;p&gt;If you follow the &lt;a href="http://live.gnome.org/Gedit/PythonPluginHowTo"&gt;gedit plugin how-to instructions&lt;/a&gt;, you can see that the document writers broke the cardinal rule of beginning how-tos by including crap you don't need at first. By looking at some other plugins and stripping away the excess, I got down to a super-simple plugin that simply adds a menu, then does something to the document (in this case adding a timestamp). SIMPLE!&lt;/p&gt;
&lt;p&gt;I'll just link to the two files needed to run the plugin: &lt;a href="http://www.russellbeattie.com/download/inserttimestamp.gedit-plugin"&gt;inserttimestamp.gedit-plugin&lt;/a&gt; and &lt;a href="http://www.russellbeattie.com/download/inserttimestamp.py"&gt;inserttimestamp.py&lt;/a&gt; . (If you want to try them, just put them in ~/.gnome2/gedit/plugins). You can see that it's cut down to just about the bare-minimum. I wish I understood a bit more about the menu stuff - you have to use the GTK API for that, and it uses some default params that I don't understand exactly for where to place the menu. But the code itself doesn't have much more than it needs to work. This is actually useful to me as a reference so that in the future if I find myself needing some sort of automation - it'll be easy to use that as a template to whip up something more complex quickly.&lt;/p&gt;
&lt;p&gt;Actually at first what I wanted to write a plugin that would put the word-wrap option in menu, instead of in the preferences like they are now. Sadly it looks like the Python wrapper to access that API isn't available (or at least I couldn't find it). If you know more than me, please educate me: Here's the &lt;a href="http://september.jicksta.com/gedit-2.15.3-docs/reference/html/ch01.html"&gt;C API for gedit&lt;/a&gt;, and you can see there's a "gedit-prefs-manager" module (I think that's what it's called, it's not a Class), but there is no equivalent if you do a "dir(gedit)" from gedit Python console - the 'utils' is there, and the encoding stuff, but not the pref-manager. Maybe I'm missing how to get to that stuff, but I haven't found it yet after some searching.&lt;/p&gt;
&lt;p&gt;Speaking of the Python console, it's pretty interesting if you haven't played with it yet. Turn it on in the Plugins preferences, and then display the bottom pane in the View menu and it's there, and by default it's imported the gedit module and "window" has already been populated with the current window. I've done app automation stuff before using Visual Basic and COM, but having the console actually in the app I'm controlling is quite cool. (And it's Python, not Lua like what Scite uses, which is nice in many ways.)&lt;/p&gt;
&lt;p&gt;Try this, open the console, and do the following...&lt;/p&gt;
&lt;pre&gt;
&lt;code&gt;
You can access the main window through 'window' :
&amp;lt;gedit.Window object at 0xb65fe694 (GeditWindow at 0x8141000)&amp;gt;
&amp;gt;&amp;gt;&amp;gt; doc  = window.get_active_document()
&amp;gt;&amp;gt;&amp;gt; doc.insert_at_cursor("hello world")
&amp;gt;&amp;gt;&amp;gt; view = window.get_active_view()
&amp;gt;&amp;gt;&amp;gt; view.select_all()
&amp;gt;&amp;gt;&amp;gt; view.copy_clipboard()
&amp;gt;&amp;gt;&amp;gt; view.paste_clipboard()
&amp;gt;&amp;gt;&amp;gt; view.paste_clipboard()
&lt;/code&gt;
&lt;/pre&gt;
&lt;p&gt;You get the idea, it's basic document automation - but it's nicely done. Do a dir() on App, Window or Document to get an idea on the various things you can do with the API - it seems pretty clear. Though honestly, I wish there was more documentation than just the C API I've found, it's pretty easy to put the pieces together.&lt;/p&gt;
&lt;p&gt;:-)&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=pYgYHh"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=pYgYHh" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Adult thoughts while watching WALL-E]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/adult-thoughts-while-watching-wall-e" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/adult-thoughts-while-watching-wall-e</id>
		<updated>2008-06-28T13:43:21-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/wall-e-poster1-big.jpg" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;The munchkin and I went to go see the matinee of WALL-E yesterday and it was pretty great! Definitely recommended for the whole family. If you haven't seen it, though, you probably don't want to read the rest of this post as I don't want to give any spoilers or take away from the innocent wonder of seeing the movie for the first time.&lt;/p&gt;
&lt;p&gt;...&lt;/p&gt;
&lt;p&gt;We good? Okay. The problem is that even though most of the Pixar movies have some sort of cognitive dissonance or generally creepy subtext if you think about them too much (The toys are *watching* us? Where the hell did the people go in Cars? Did they take over?) I think that WALL-E is particularly full of, um, "issues".&lt;/p&gt;
&lt;p&gt;First I should say the movie was great - it's a love story at the core and it works really well. EVE seemed to have the personality of a strong, serious woman with a mission (more on this in a bit) and WALL-E may be a love sick moron, he's not generally a fool and is quite a bit mischievous as well.&lt;/p&gt;
&lt;p&gt;The lack of dialog was only apparent at one point when I realized an entire theater full of people was dead silent watching the movie and it wasn't during some sort of emotional scene - they were just all intent on watching what was happening. It was akin to seeing a live play, when you step out of the moment for a minute to realize there's a ton of people there, in the dark, silently watching.&lt;/p&gt;
&lt;p&gt;Anyways, after seeing the movie and replaying it my head a bit (especially since my son and I were playing the video game afterwards), lots of things occurred to me about the movie that just didn't fit quite right. Here's some thoughts on the movie from an adult point of view, in no specific order.&lt;/p&gt;
&lt;p&gt;* When WALL-E is going about his work and he starts to break down a bit (his tread is wearing out) it's quite disturbing how casually he grave-robs a fellow WALL-E unit who has since stopped working for spare parts. It sort of makes you wonder *how* exactly little ol' WALL-E became the last surviving bot in the first place... As resources started to dry up, what sort of ruthless deeds did WALL-E do to keep functioning?&lt;/p&gt;
&lt;p&gt;* The choice of Hello Dolly music is insanely odd, but will definitely trigger nostalgia for my parents. I saw it quite a few times when I was a kid, but I haven't seen the whole thing in easily 20 years. I wonder if there's someone in Pixar who actually just loves this movie, or if it was some sort of attempt to create a multi-generational family movie for all? Given the history of Disney, I'll assume the latter.&lt;/p&gt;
&lt;p&gt;* In fact, a movie from the Disney Corporation expounding on the evils of consumerism? My mind just can't absorb the self-referential hypocrisy there.&lt;/p&gt;
&lt;p&gt;* I don't get the double entendre meant by Buy N Large. There's the phrase "by and large" which means "in general" (more on the &lt;a href="http://www.worldwidewords.org/qa/qa-bya1.htm"&gt;history of the phrase here&lt;/a&gt;), and I guess if you "keep buying, you will enlarge", but beyond that I don't see the link really. Maybe "buy in large quantities" a la Cosco or something? I just don't see how the joke works because the original meaning doesn't have anything to do with the second in some ironic way...&lt;/p&gt;
&lt;p&gt;* I'm not Fred Willard's biggest fan - I think they should have just kept that stuff with him animated, but I guess it goes along with Hello Dolly in linking the past Earth with the dystopian future... Still, I think he's a jackass and not particularly funny.&lt;/p&gt;
&lt;p&gt;* Okay, guys at Pixar, we get it. Steve jobs founded your company and Apple and so you like Apple products. We noticed the iPod, and the various Mac sound effects and even how the bad guy of the movie is the voice of MacInTalk. Hahaha. You guys are hip. However, when EVE reboots with the fucking Mac chime it pulled me out of the moment in a bad, cranky way, so could you please cut the shit from now on?&lt;/p&gt;
&lt;p&gt;* Oh, yeah... and CALARTS FUCKIN' RULEZ DOOODZ! TOTALLY! A113! ROCK ON! YAH! A113! SO COOL!&lt;/p&gt;
&lt;p&gt;About the plot... There's lots of little things which are odd. For example, at one point in the movie, WALL-E pushes EVE out of his little house to the roof when she shuts down waiting for the mother ship to pick her up... but then he does crazy stuff like standing there in a lightning storm with an umbrella over him to protect her. Why didn't he just push her back inside? But that's sort of nit picky stuff. The things that really bug me is what happens when they get on spaceship Axiom. There the whole premise of the movie starts to take a left turn from reality. All the future peoples are floating around like blobs, unable to walk, doing nothing but shopping, consuming everything in cups. There are LOTS AND LOTS of questions here:&lt;/p&gt;
&lt;p&gt;* In a closed system like the one on the Axiom, how the hell is there *any* economy at all in which to consume to excess? All the robots do everything, there's no need to work, there didn't appear to be any rich or poor folk, and even the captain was a benevolent dictator of sorts who seemed to have the unquestioned loyalty of his people. What's there to consume and who cares if you do it anyways, as there's plenty to go around?&lt;/p&gt;
&lt;p&gt;* The captain is suprised to see a *plant*... What the hell have they been eating all this time? What's in those 7-Eleven Big Gulp cups anyways, Soylent Green?!?&lt;/p&gt;
&lt;p&gt;* At one point in the movie a woman and a man touch hands briefly and are genuinely surprised at the physical interaction. Umm... Obviously the must be reproducing completely artificially, which means there's a whole class of robots that we didn't have the, um, pleasure of actually seeing.&lt;/p&gt;
&lt;p&gt;* Continuing that thought... I noticed babies and toddlers, and full grown blob-like adults, but no kids and no older people. How does that work exactly? Is it like that movie where they kill everyone older than 30? Where are the 11 year olds?&lt;/p&gt;
&lt;p&gt;* The movie's anti-consumerism message is simply "buy too much and you become blobs". It's a bit weird. My kid didn't learn anything from the message as there didn't seem to be any downside to it beyond not really walking much. In fact, to those of us in the theater, who just paid $10 a ticket and another $20 per person for over-sized sodas and popcorn, sitting in our big easy chairs, stuffing our faces and sucking on straws, watching a movie in the middle of a gorgeous summer afternoon? It didn't seem particularly far from normal. Or is that the joke and it's on us? What? We're supposed to be out gardening and tending to the forests instead? Pixar can blow me.&lt;/p&gt;
&lt;p&gt;* I do love how Hollywood (and Pixar is included there) just can't seem to keep from collapsing strong role models into gender specific stereotypes in order to create tension in the plot. Near the end of the movie, WALL-E has been damaged and is essentially dying, when he seemingly selflessly gives the plant to EVE so that she can continue her Directive and bring humanity back to Earth. Despite having struggled thus far to complete her life's work and do her duty, she tosses the plant aside carelessly signifying that all she cares about now is WALL-E. (See that little girls? The lesson here is to sacrifice all for your Man. Get it?) But WALL-E in his half-dead state insists, goes over and picks up the plant, and gives it back to EVE, which at first seems like an incredibly selfless sacrifice on his part, but soon you realize he's actually saying, "No you stupid bitch, Earth is where all my replacement parts are - we need to plant to get the ship there to fix me." Ahh... We see a little more of how WALL-E was the last remaining robot and how underneath that hard polished exterior and blasters, EVE is really just like all women are - subservient and unable to think clearly during a crisis. Thanks for clarifying that Pixar!&lt;/p&gt;
&lt;p&gt;* At the end of the movie, we see the all the people in the ship wander out into the desolate wasteland of Earth, ready to start again now that the world is, um, slightly less toxic than it was before. The robots (we see during the credits) are there to help, which is good, because I don't know about you, but I'd pretty much starve if I had to farm for myself. Hopefully the ship has some seeds on it to get started... and bees and other bugs to help pollinate the plants... and well, animals, birds, etc. Oh, and sticking a plant into some dry ground and drowning it in water isn't going to produce much in the way of actual food (despite what the captain may think, and also wasn't that plant just floating in sub-zero space?) Also no worries about those frequent dust storms...&lt;/p&gt;
&lt;p&gt;* And where the hell are the *other* ships out there? There's like a couple hundred people on the Axiom at best? They better start procreating like crazy if they want to repopulate the world. Well, that and figuring out how to re-evolve all that "bone-loss" they've genetically lost. Also, didn't they seem awfully happy to go from their lives of leisure and happy interaction with their friends (via their holographic view screens) to one of hard labor, disease and suffering. But that's just me.&lt;/p&gt;
&lt;p&gt;* One last thought is that they didn't actually get rid of Buy N Large at the end, the purported evil corporation which helped pollute the world by its promotion of excess consumerism. Presumably, it'll just take over where it left off soon enough, so really, the world is still doomed.&lt;/p&gt;
&lt;p&gt;Ok, I'll stop there. I'm sure more will pop up as I think about it. The movie was still quite entertaining though, you definitely want to go see it, as it's very fun.&lt;/p&gt;
&lt;p&gt;:-)&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=V4XvLG"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=V4XvLG" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Ubuntu Rising]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/ubuntu-rising" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/ubuntu-rising</id>
		<updated>2008-06-26T14:05:07-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/ubuntumid.jpg" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;Every day I'm amazed at how good Ubuntu is, and how fast it's been improving. I've been a full time Linux user since January of last year, and in 18 months, I've just been amazed at how *happy* I am using it and how I get *more* happy as time goes on. I'm thinking about this again as I just moved computers from a desktop to a Sony Vaio laptop, and Ubuntu's latest works incredibly well on it. Advanced GUI, sound, WiFi, power management (including suspend/resume) and more all work as you'd expect it to without *any* manual file configuration. And the install process took less than 20 minutes from start to finish. I couldn't be happier.&lt;/p&gt;
&lt;p&gt;There's still a few issues, but nothing so frustrating that I'm any less ecstatic with my setup. As a Linux user, I sort of expect them and compared to years past they're trivial. For example, the built-in sound speakers don't shut off when you plug in external speakers or headphones right now. Not great but I'm sure I'll find out what the issue is with some searching. Also, the external monitor port doesn't recognize the correct resolution out of the box - I've seen online that I'll have to manually tweak the xorg.conf file, but I haven't done it yet either. Other than that, I haven't had a single issue, and I know that these issues could "fix themselves" as well, as Ubuntu continues to develop and my weekly updates bring fixes and upgrades.&lt;/p&gt;
&lt;p&gt;Honestly, the setup was so fast and easy, I would have spent *much* more time cleaning all the crapware off the pre-installed Vista setup, as well as searching for anti-virus stuff, etc. It's such an incredible stroke of luck that Windows Vista is so bad and that its launch coincided perfectly with Ubuntu becoming a truly viable alternative to Windows or OSX.&lt;/p&gt;
&lt;p&gt;What really excites me is the latest trend towards Linux based small computers like the Asus EEE PC, or all those Mobile Internet Devices that are coming down the pipe. Ubuntu recently released a &lt;a href="http://www.ubuntu.com/products/mobile"&gt;MID version&lt;/a&gt; and it looks fantastic. Not only is Ubuntu a fantastic OS, with great software available for it (including Wine 1.0, which also runs a bunch of Windows apps without problems), but when manufacturers start incorporating Ubuntu in the development process, there won't be *any* hardware issues - even the little ones that I have now.&lt;/p&gt;
&lt;p&gt;This is just so exciting. I just really like Unix as a computing platform - it's just so much better organized and functional than Windows. The daily pain of using Windows just doesn't exist... questions like "why isn't this connecting" or "why is this running so slowly" are quickly answered and more easily fixed. And with Ubuntu's Debian roots, it means that it's easily updated as well (and doesn't cost $120 every year or so to upgrade like OSX). Much of the technology, actually, has been out there for years and Ubuntu has simply done a fantastic job of organizing it all into a thoroughly enjoyable system to use.&lt;/p&gt;
&lt;p&gt;Again, the MID stuff is what gets me really jazzed. Using the Nokia 770 and N800 has really shown me how useful a dedicated Internet device can be. Combining Web, Email and IM among other apps like eBook readers and casual games in a portable and usable package is incredibly compelling and useful. Adding in the power of Ubuntu (no offense to the Maemo folks, whom I love and respect) is just going to make those devices even that much more lustworthy.&lt;/p&gt;
&lt;p&gt;It's a great time to be a Ubuntu user!&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=Uarknz"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=Uarknz" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Where are the electric cars?]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/where-are-the-electric-cars" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/where-are-the-electric-cars</id>
		<updated>2008-06-26T10:35:06-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/zenn_b.jpg" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;I know that GM killed their electric car in 2003, and just the thought of how insanely stupid and shortsighted they were makes me want to kill, but where are the rest of the electric cars? I heard a report on the radio yesterday about the progress on the Volt and the plug-in Prius next year, and about how cool it is to ride in a Tesla, but it seems crazy that we can't go down to a dealer right now and take a look at more options than that.&lt;/p&gt;
&lt;p&gt;Just recently I read about a store here in the Valley called &lt;a href="http://www.greenrides.com/"&gt;Green Rides&lt;/a&gt; that sold electric vehicles and thought about how cool that was. There's a car they sell called the &lt;a href="http://www.greenrides.com/neighborhood_rides_zenn.html"&gt;Zenn&lt;/a&gt; which looks incredibly cool... until you check out the stats. 25MPH max, and a 30 mile range. Are you kidding me? I don't understand why they're so limited - it's rated as if it was a golf cart because supposedly they have less safety stuff in them. You know, I can think of plenty of cars on the road that don't have a lot to them in terms of safety - or weight even - the Geo Metro back in the day got what, like 50 mpg? It was like a tin can on wheels, why can't they just take that design and throw some batteries in the back and get a decent electric car?&lt;/p&gt;
&lt;p&gt;I know it all goes back to battery power, but if GM was solving this stuff almost 10 years ago with the EV1, surely the technology must be a bit more standard nowadays, no? I hope now that gas prices are so insane (and honestly, I hope they stay there as economic incentive to produce more electric vehicles) that companies will get it together and start putting more resources into this stuff. I keep reading every day about this company or that developing this or that car... but until I can go down to the local dealer and test drive them myself, they're just not real.&lt;/p&gt;
&lt;p&gt;You can go online and check out &lt;a href="http://www.evconvert.com/resources"&gt;some fascinating mods&lt;/a&gt;. I love the idea of getting an old BMG, Beetle or Karmann Ghia and throwing a pile of batteries in the back and an electric motor in the front and getting a retro electric vehicle to use. But according to Wikipedia, &lt;a href="http://en.wikipedia.org/wiki/Electric_vehicle_conversion#California_.28US.29_conversion_registration_and_taxation"&gt;California makes it hard&lt;/a&gt; for those modded vehicles to get back on the road. Bleh.&lt;/p&gt;
&lt;p&gt;All this said, would I sell my somewhat gas-guzzling Saturn VUE (front wheel drive, stick, 23mpg) to get an electric version of a Geo Metro? Probably not this minute... but I'd love to have the option.&lt;/p&gt;
&lt;p&gt;:-)&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=L2oNnV"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=L2oNnV" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[Do Mobile OS Platforms Matter? ]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/do-mobile-os-platforms-matter" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/do-mobile-os-platforms-matter</id>
		<updated>2008-06-24T15:18:43-07:00</updated>
		<content type="html">&lt;p&gt;&lt;img src="http://www.russellbeattie.com/blog/media/mobileos.png" alt="[image]" /&gt;&lt;/p&gt;
&lt;p&gt;The big news today is that Nokia is spending nearly half a billion dollars for the rest of Symbian and will turn it into a non-profit organization and open OS. It's got everyone buzzing about how this is an attempt on Nokia's part to "take on" Android (because Vendor Wars always makes good copy), but I think that's a far too simplistic explanation.&lt;/p&gt;
&lt;p&gt;Backing up for a second, let's examine what the Symbian OS is, and who it targets. This really depends on who you are. Are you a manufacturer who needs to use the OS to make a device work with all the various pieces of hardware involved, or are you a "third party" who wants to create or use applications which run on the device?&lt;/p&gt;
&lt;p&gt;Symbian, the company, has always been much more focused on the former as the OEMs have been the ones paying the fees that kept the company going. The promise was simple - here's a platform which makes your most advanced phones work with little investment. Think about all the technologies in a modern mobile phone - from the various wireless standards like UMTS and Bluetooth, to GPS and even media processing capabilities for video and sound. A mobile OS has to make all that stuff work. It goes beyond just the development work, it also has to do with license fees, etc. If your mobile phone plays back MP3 files, someone had to have paid the Fraunhofer Institute their blood money, or else. For $7 a phone, OEMs could forget about that stuff and just worry about making a cool gadget.&lt;/p&gt;
&lt;p&gt;Even that price is expensive though, and manufacturers have always had options about how they get an OS for their phones. They could create some RTOS in house, they could license from any number of white-label OS providers, buy it as a complete hardware/software stack from someone like Qualcomm, or work with Microsoft or Symbian, etc. But now with today's announcement it means OEMs can get something for free that they used to have to pay for. Great! In theory, the Symbian OS is the most robust of the mobile phone OSes out there, and therefore now that it's free, manufacturers will start pumping out Symbian based devices like crazy. Game, set, match for the Symbian OS, right? The company may have essentially been a failure (it's dreams at one point were to take on Microsoft, remember), but the OS as a platform will live on and thrive, and those manufacturers who use that platform will benefit from the shared work, and larger user base as well.&lt;/p&gt;
&lt;p&gt;Because application developers tend to target the OS platform with the biggest marketshare, this means that today's announcement is a huge deal for mobile application developers and users, right? Wrong, and that's the point of this post. For everyone besides OEMs which can use the new freed Symbian OS to power their devices, to everyone else it doesn't mean very much.&lt;/p&gt;
&lt;p&gt;In my mind, there are different types of OS platforms, created for one of several reasons, broadly separated into monetization, control or shared workload. Monetization - as shown by Microsoft - is that if you control a platform that becomes popular, you can charge money for it indefinitely as it's the basis for many other people's work. Control is what Apple and Blackberry do, where they don't license the platform, but use it to ensure they control everything about what happens on their platform and devices. Shared workload is what the Linux folk are about, where even though they lose control and get no fees, they still derive benefits from not having to do everything themselves, and the platform improves and is used more broadly as well with less investment on their part.&lt;/p&gt;
&lt;p&gt;Symbian it seems has attempted to do all of this, first being an licensable platform attempting to be broadly used and monetize based on eventual dominance. Then Nokia wanted to have more control so they created the Series 60 GUI (and others) as a differentiator on top of Symbian, while UIQ was used by others. Then Nokia bought most of Symbian, and tried to license the GUI as well. Now essentially they're giving up on the two former options and are moving to the open model completely in an attempt to both share the work, and to increase adoption of the platform as a whole in face of competition from Microsoft, Apple and Google.&lt;/p&gt;
&lt;p&gt;Now, in the PC world, having a platform - whether it's an OS platform like Windows, or an application platform like Oracle or Excel - means that others can develop on and expand the functionality of that particular platform. The more third parties expand that functionality, the greater value the underlying platform has, and the more the owner of the platform can monetize it. Developers won't target a platform with a low user base, which is why broad adoption is so important - so for many platforms giving away the razor in an attempt to make money on the blades is still the general strategy. Pretty simple. And once the cycle of platform, developers and applications is set up, it's incredibly hard to break it.&lt;/p&gt;
&lt;p&gt;Except it won't work that way for Mobile OS platforms. Let me explain why:&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;No killer apps&lt;/strong&gt; - Smartphones and other mobile platforms like Palm or Windows CE have been around for a decade now, and there's yet to be a killer app for them. A killer app is what makes a platform take off. No killer app? No dominant platform. What's the chances that there will suddenly be an application in today's heterogeneous and interconnected computing environment that *only* runs on one mobile platform and no others? Little to none, really.&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;No app variation&lt;/strong&gt; - Oh, there might be thousands of mobile apps out there, but essentially they boil down to a few groups of applications - utility, communication, games, etc. which are pretty much the same regardless of platform. Go to Handango and see a bazillion versions of a calculator and get the idea. (As an aside, I predict when the iPhone AppStore launches in a couple weeks, there will be a lot of disappointment in terms of the quality and quantity of the apps offered).&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;No one buys apps anyways&lt;/strong&gt; - Most users of mobile devices are quite happy to use the included apps that are installed from the outset. Most don't even know you can get more apps, and even then the data has shown there's a buying spree for about 2 weeks to a month after a user gets a new phone where they buy shit for it (apps, ringtones, wallpapers) and then they don't bother any more. All the mobile platforms are thus fighting against normal user patterns, and over a piece of the pie that is significantly smaller than the total number of mobile users.&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;No one cares about which OS&lt;/strong&gt; - Ever notice that Qik, the video streaming startup that just raised a round recently - is powered exclusively by Symbian devices? Nope? Yeah, no one else does either. In fact, the only time you see it mentioned is when they're promising on a stack of bibles they'll have WinMo and iPhone versions out soon, really. The exception being Apple (as always), the rest of the world really aren't zealots about this stuff.&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;Anything a Native app can do, Java can do too&lt;/strong&gt; - You could argue that Java is a platform in an of itself, and if so, maybe it has won and the rest of the platforms are simply variations of GUI and low-level plumbing. Mostly though, what it means is that applications are portable, and developers will port if there's a demand for it, or they'll develop using a technology that's made to run on multiple platforms from the outset.&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;The Wii lesson&lt;/strong&gt; - The Nintendo Wii dominates the video game market with its family-friendly vibe and innovative controls, but the other consoles are also doing fine, thankyouverymuch. We've entered an era of multiple platforms and most people understand this. Companies in the video game market that want to sell to the broadest number of consumers target multiple consoles, and mobile developers will be no different.&lt;/p&gt;
&lt;p&gt;Even saying all this, I still think that Symbian has a long struggle ahead of it no matter what. Eventually the fact that Symbian is not Windows, Linux or OSX is going to start really affecting the productivity of the developers targeting that OS. OEMs will have to maintain more code which they're less familiar with, and application developers will have to learn and keep current with a niche OS which only matters to a portion of their user base. Symbian has had 10 years to gain some sort of traction, and has only done so by the consistent, and almost irrational, support of Nokia.&lt;/p&gt;
&lt;p&gt;It's a huge gamble by Nokia to continue supporting this OS, rather than moving wholesale to a different platform - both the $400MM they're putting down now, and the money they're going to spending in the future to maintain the OS. Just think of how far that $400MM would have sped them along had they chosen to move to something like Linux instead. That said, Nokia still has the dominance in the mobile phone industry to push it in a certain direction. I do think it really will be a matter of if and when other manufacturers embrace Symbian as to its future.&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=M3yTNP"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=M3yTNP" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
	<entry>
		<title type="html"><![CDATA[mOlympics Redux]]></title>
		<link rel="alternate" type="text/html" href="http://www.russellbeattie.com/blog/molympics-redux" />
		<author>
			<name>Russell Beattie</name>
			<email>russ@russellbeattie.com</email>
		</author>
		<id>http://www.russellbeattie.com/blog/molympics-redux</id>
		<updated>2008-06-23T11:18:32-07:00</updated>
		<content type="html">&lt;p&gt;I just read &lt;a href="http://www.readwriteweb.com/archives/the_olympics_go_mobile.php"&gt;this post on Read Write Web&lt;/a&gt; about the various options for keeping up with Olympics while mobile. It reminded me of &lt;a href="http://www.russellbeattie.com/notebook/1007964.html"&gt;my attempts four years ago&lt;/a&gt; to create a mobile Olympics news aggregator. I registered mOlympics.com and then slapped together a quick and easy news reader linking out to stories for the olympics.&lt;/p&gt;
&lt;p&gt;It's amazing how different things are now... if I had kept that domain (I got rid of it in a purge a long while ago), it'd be so easy to recreate it and actually make money this year.&lt;/p&gt;
&lt;ul&gt;
&lt;li&gt;There's a ton more mobile traffic to take advantage of&lt;/li&gt;
&lt;li&gt;There's ways to monetize - AdMob and Mobile AdSense&lt;/li&gt;
&lt;li&gt;There's ways to promote the site (same as a above)&lt;/li&gt;
&lt;li&gt;There's more news feeds of content to take advantage of&lt;/li&gt;
&lt;li&gt;There's more original mobile sites to link to, and advanced transcoders (Mowser)&lt;/li&gt;
&lt;li&gt;It'd be possible to link to mobile versions of video either via YouTube or using conversion sites&lt;/li&gt;
&lt;/ul&gt;
&lt;p&gt;All of this of course makes me cringe at how early I was (again). Timing is everything and being four years off the market is obviously not good (in either direction). The question in my mind is it a matter of choosing a new idea and sticking with it for years and years until the market catches up to you, or is it a matter of timing it just right? I guess the answer to that question depends on how much money you can afford to lose before you start making money.&lt;/p&gt;
&lt;p&gt;Speaking of making money, mOlympics.com now points to one of those SEO link-farm pages... I wonder how much cash that generates every month for its owner? Probably not a lot up until now, but it may pay for itself in the next couple months, I bet.&lt;/p&gt;
&lt;p&gt;-Russ&lt;/p&gt;

&lt;p&gt;&lt;a href="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?a=hmb7xZ"&gt;&lt;img src="http://feeds.russellbeattie.com/~a/RussellBeattieWeblog?i=hmb7xZ" border="0"&gt;&lt;/img&gt;&lt;/a&gt;&lt;/p&gt;</content>
	</entry>
</feed>
