#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include "SLOReader.h"
#include "BaseCommunication.h"

#define base CSYOReader

CSLOReader::CSLOReader(CReader *Owner, CBaseCommunication *Communicator)
	:base(Owner, Communicator)
{
}

CSLOReader::~CSLOReader(void)
{
}




void CSLOReader::SetHWString(char *String)
{
	strcpy(String, "SLO_");
}

void CSLOReader::GetProductString(uint8_t *Product)
{
	memcpy(Product, "CJSLO", 5);
}

void CSLOReader::CompressModifyStructure(CCID_Message& Message)
{
	if (Message.Data.Secure.Data.Modify.bNumberMessage == 0)
	{
		memmove(&(Message.Data.Secure.Data.Modify.bMsgIndex2), Message.Data.Secure.Data.Modify.bTeoPrologue, Message.dwLength - 17);
		Message.dwLength -= 2;
	}
	else if (Message.Data.Secure.Data.Modify.bNumberMessage != 3)
	{
		memmove(&(Message.Data.Secure.Data.Modify.bMsgIndex3), Message.Data.Secure.Data.Modify.bTeoPrologue, Message.dwLength - 17);
		Message.dwLength -= 1;
	}
}

bool CSLOReader::HastModulestoreInfo()
{
	return true;
}

CJ_RESULT CSLOReader::CtSetSilentMode(bool boolMode, bool *pboolMode, uint32_t *Result)
{
	if (pboolMode)
		*pboolMode = boolMode;
	if (Result)
		*Result = 0;
	return CJ_SUCCESS;
}

CJ_RESULT CSLOReader::CtGetSilentMode(bool *pboolMode, uint32_t *Result)
{
	if (pboolMode)
		*pboolMode = 0;
	if (Result)
		*Result = 0;
	return CJ_SUCCESS;
}
