// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtVsOptions.C                           //
// ************************************************************************* //

#include <avtVsOptions.h>

#include <DBOptionsAttributes.h>

#include <string>


// ****************************************************************************
//  Function: GetVsReadOptions
//
//  Purpose:
//      Creates the options for Vs readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Wed Aug 11 13:45:13 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetVsReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    rv->SetBool("Process Data Selections in the Reader", true);

    return rv;
}


// ****************************************************************************
//  Function: GetVsWriteOptions
//
//  Purpose:
//      Creates the options for Vs writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: allen -- generated by xml2avt
//  Creation:   Wed Aug 11 13:45:13 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetVsWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
