/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 *
 * This file was converted to C code from the raw file found at
 * ftp://ftp.cbi.pku.edu.cn/pub/software/blast/matrices/BLOSUM100, the
 * Center for Bioinformatics, Peking University, China.
 */
#ifndef _PARASAIL_BLOSUM100_H_
#define _PARASAIL_BLOSUM100_H_

#include "parasail.h"
#include "blosum_map.h"

#ifdef __cplusplus
extern "C" {
#endif

/* #  Matrix made by matblas from blosum100_3.iij */
/* #  * column uses minimum score */
/* #  BLOSUM Clustered Scoring Matrix in 1/3 Bit Units */
/* #  Blocks Database = /data/blocks_5.0/blocks.dat */
/* #  Cluster Percentage: >= 100 */
/* #  Entropy =   1.4516, Expected =  -1.0948 */

static const int parasail_blosum100_[] = {
/*        A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
/* A */   8, -3, -4, -5, -2, -2, -3, -1, -4, -4, -4, -2, -3, -5, -2,  1, -1, -6, -5, -2, -4, -2, -2,-10,
/* R */  -3, 10, -2, -5, -8,  0, -2, -6, -1, -7, -6,  3, -4, -6, -5, -3, -3, -7, -5, -6, -4, -1, -3,-10,
/* N */  -4, -2, 11,  1, -5, -1, -2, -2,  0, -7, -7, -1, -5, -7, -5,  0, -1, -8, -5, -7,  5, -2, -3,-10,
/* D */  -5, -5,  1, 10, -8, -2,  2, -4, -3, -8, -8, -3, -8, -8, -5, -2, -4,-10, -7, -8,  6,  0, -4,-10,
/* C */  -2, -8, -5, -8, 14, -7, -9, -7, -8, -3, -5, -8, -4, -4, -8, -3, -3, -7, -6, -3, -7, -8, -5,-10,
/* Q */  -2,  0, -1, -2, -7, 11,  2, -5,  1, -6, -5,  2, -2, -6, -4, -2, -3, -5, -4, -5, -2,  5, -2,-10,
/* E */  -3, -2, -2,  2, -9,  2, 10, -6, -2, -7, -7,  0, -5, -8, -4, -2, -3, -8, -7, -5,  0,  7, -3,-10,
/* G */  -1, -6, -2, -4, -7, -5, -6,  9, -6, -9, -8, -5, -7, -8, -6, -2, -5, -7, -8, -8, -3, -5, -4,-10,
/* H */  -4, -1,  0, -3, -8,  1, -2, -6, 13, -7, -6, -3, -5, -4, -5, -3, -4, -5,  1, -7, -2, -1, -4,-10,
/* I */  -4, -7, -7, -8, -3, -6, -7, -9, -7,  8,  2, -6,  1, -2, -7, -5, -3, -6, -4,  4, -8, -7, -3,-10,
/* L */  -4, -6, -7, -8, -5, -5, -7, -8, -6,  2,  8, -6,  3,  0, -7, -6, -4, -5, -4,  0, -8, -6, -3,-10,
/* K */  -2,  3, -1, -3, -8,  2,  0, -5, -3, -6, -6, 10, -4, -6, -3, -2, -3, -8, -5, -5, -2,  0, -3,-10,
/* M */  -3, -4, -5, -8, -4, -2, -5, -7, -5,  1,  3, -4, 12, -1, -5, -4, -2, -4, -5,  0, -7, -4, -3,-10,
/* F */  -5, -6, -7, -8, -4, -6, -8, -8, -4, -2,  0, -6, -1, 11, -7, -5, -5,  0,  4, -3, -7, -7, -4,-10,
/* P */  -2, -5, -5, -5, -8, -4, -4, -6, -5, -7, -7, -3, -5, -7, 12, -3, -4, -8, -7, -6, -5, -4, -4,-10,
/* S */   1, -3,  0, -2, -3, -2, -2, -2, -3, -5, -6, -2, -4, -5, -3,  9,  2, -7, -5, -4, -1, -2, -2,-10,
/* T */  -1, -3, -1, -4, -3, -3, -3, -5, -4, -3, -4, -3, -2, -5, -4,  2,  9, -7, -5, -1, -2, -3, -2,-10,
/* W */  -6, -7, -8,-10, -7, -5, -8, -7, -5, -6, -5, -8, -4,  0, -8, -7, -7, 17,  2, -5, -9, -7, -6,-10,
/* Y */  -5, -5, -5, -7, -6, -4, -7, -8,  1, -4, -4, -5, -5,  4, -7, -5, -5,  2, 12, -5, -6, -6, -4,-10,
/* V */  -2, -6, -7, -8, -3, -5, -5, -8, -7,  4,  0, -5,  0, -3, -6, -4, -1, -5, -5,  8, -7, -5, -3,-10,
/* B */  -4, -4,  5,  6, -7, -2,  0, -3, -2, -8, -8, -2, -7, -7, -5, -1, -2, -9, -6, -7,  6,  0, -4,-10,
/* Z */  -2, -1, -2,  0, -8,  5,  7, -5, -1, -7, -6,  0, -4, -7, -4, -2, -3, -7, -6, -5,  0,  6, -2,-10,
/* X */  -2, -3, -3, -4, -5, -2, -3, -4, -4, -3, -3, -3, -3, -4, -4, -2, -2, -6, -4, -3, -4, -2, -3,-10,
/* * */ -10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,  1
};

static const parasail_matrix_t parasail_blosum100 = {
    "blosum100",
    parasail_blosum100_,
    parasail_blosum_map,
    24,
    17,
    -10,
    NULL
};

#ifdef __cplusplus
}
#endif

#endif /* _PARASAIL_BLOSUM100_H_ */

