// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type DeleteRouteTableRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* RouteTable ID  */
    RouteTableId string `json:"routeTableId"`
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDeleteRouteTableRequest(
    regionId string,
    routeTableId string,
) *DeleteRouteTableRequest {

	return &DeleteRouteTableRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/routeTables/{routeTableId}",
			Method:  "DELETE",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        RouteTableId: routeTableId,
	}
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 */
func NewDeleteRouteTableRequestWithAllParams(
    regionId string,
    routeTableId string,
) *DeleteRouteTableRequest {

    return &DeleteRouteTableRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        RouteTableId: routeTableId,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewDeleteRouteTableRequestWithoutParam() *DeleteRouteTableRequest {

    return &DeleteRouteTableRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}",
            Method:  "DELETE",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *DeleteRouteTableRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param routeTableId: RouteTable ID(Required) */
func (r *DeleteRouteTableRequest) SetRouteTableId(routeTableId string) {
    r.RouteTableId = routeTableId
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DeleteRouteTableRequest) GetRegionId() string {
    return r.RegionId
}

type DeleteRouteTableResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result DeleteRouteTableResult `json:"result"`
}

type DeleteRouteTableResult struct {
}