/******************************************************************************
 *                                                                            *
 *                       (C) 1997-1999 ESS Technology, Inc.                   *
 *                                                                            *
 * This source code, its compiled object code, and its associated data sets   *
 * are copyright (C) 1997-1999 ESS Technology, Inc. 			      *
 *                                                                            *
 ******************************************************************************/

/*---------------------------------------------------------------------------
 *              Copyright (C) 1997-1999, ESS Technology, Inc.
 *---------------------------------------------------------------------------
 * FILENAME: kernelbn.c   v1.01
 *---------------------------------------------------------------------------
 * DESCRIPTION: DSP binaries
 *---------------------------------------------------------------------------
 * AUTHOR:  Henry Tang / Hong Kim / Alger Yeung/Don Kim
 *---------------------------------------------------------------------------
 * HISTORY:
 *    09/25/97  HT  Created.
 *    01/20/97  PJCC (CRL) modified to include Sensaura 3D positional &
 *              speaker virtualization
 *    05/05/99  AY  cleanup for NT modem drivers
 *    05/18/99  AY  add cpythru for 400/500/600/800
 *    05/24/99  AY  add cpythru for 4C0/680
 *---------------------------------------------------------------------------
 */

#ifdef NT_MODEL
#ifdef DON
#include "../port.h"
#include "kernel.h"
#endif
#endif

/* */
/* Kernel */
/* */

WORD gawKernelVectCode[] = {
#include "kernel.dat"
};

KERNEL_BIN gsKernelVectCode = {
  gawKernelVectCode,
  sizeof (gawKernelVectCode)
};

/* */
/* Memory Check Kernel */
/* */

WORD gawMemChkVectCode[] = {
#include "memchk.dat"
};

KERNEL_BIN gsMemChkVectCode = {
  gawMemChkVectCode,
  sizeof (gawMemChkVectCode)
};


/* */
/* Copy Through */
/* */

WORD gawCpyThruDataXXXX[] = {
  0x0000
};

WORD gawCpyThruVect0400[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawCpyThruCode0400[] = {
  0				/*#include "400cpyth.dat" */
};

WORD gawCpyThruVect04C0[] = {
  0x7980, 0x04C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawCpyThruCode04C0[] = {
  0				/*#include "4C0cpyth.dat" */
};

WORD gawCpyThruVect0500[] = {
  0x7980, 0x0500, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawCpyThruCode0500[] = {
  0				/*#include "500cpyth.dat" */
};

WORD gawCpyThruVect0600[] = {
  0x7980, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawCpyThruCode0600[] = {
  0				/*#include "600cpyth.dat" */
};


WORD gawCpyThruVect0680[] = {
  0x7980, 0x0680, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawCpyThruCode0680[] = {
  0				/*#include "680cpyth.dat" */
};

WORD gawCpyThruVect0800[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawCpyThruCode0800[] = {
  0				/*#include "800cpyth.dat" */
};

CLIENT_BIN gasCpyThruVectCode[] = {
  {
   0x0400,
   gawCpyThruVect0400,
   gawCpyThruCode0400,
   gawCpyThruDataXXXX,
   sizeof (gawCpyThruVect0400),
   sizeof (gawCpyThruCode0400),
   sizeof (gawCpyThruDataXXXX)}
  ,
  {
   0x04C0,
   gawCpyThruVect04C0,
   gawCpyThruCode04C0,
   gawCpyThruDataXXXX,
   sizeof (gawCpyThruVect04C0),
   sizeof (gawCpyThruCode04C0),
   sizeof (gawCpyThruDataXXXX)}
  ,
  {
   0x0500,
   gawCpyThruVect0500,
   gawCpyThruCode0500,
   gawCpyThruDataXXXX,
   sizeof (gawCpyThruVect0500),
   sizeof (gawCpyThruCode0500),
   sizeof (gawCpyThruDataXXXX)}
  ,
  {
   0x0600,
   gawCpyThruVect0600,
   gawCpyThruCode0600,
   gawCpyThruDataXXXX,
   sizeof (gawCpyThruVect0600),
   sizeof (gawCpyThruCode0600),
   sizeof (gawCpyThruDataXXXX)}
  ,
  {
   0x0680,
   gawCpyThruVect0680,
   gawCpyThruCode0680,
   gawCpyThruDataXXXX,
   sizeof (gawCpyThruVect0680),
   sizeof (gawCpyThruCode0680),
   sizeof (gawCpyThruDataXXXX)}
  ,
  {
   0x0800,
   gawCpyThruVect0800,
   gawCpyThruCode0800,
   gawCpyThruDataXXXX,
   sizeof (gawCpyThruVect0800),
   sizeof (gawCpyThruCode0800),
   sizeof (gawCpyThruDataXXXX)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};

/* */
/* Modem */
/* */

WORD gawModemData[] = {
  /* M3 HSP client data area starts at 0x1100 */
  /* 80H words at 1100H */

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

  /* 80H words at 1180H */

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

#ifdef NT_MODEL
  /* 80H words at 1200H */

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,

  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,

  /* 80H words at 1280H */

  0				/*#include "modemntd.dat" */
#else
  /* 80H words at 1200H */

  0				/*#include "modemd.dat" */
#endif
};

WORD gawModemVect400[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
#ifdef NT_MODEL
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7980, 0x0449,
#else
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7980, 0x0449,
#endif
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawModemVect800[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
#ifdef NT_MODEL
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7980, 0x0849,
#else
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7980, 0x0849,
#endif
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawModemCode400[] = {
#ifdef NT_MODEL
  0				/*#include "modemnt4.dat" */
#else
  0				/*#include "400modem.dat" */
#endif
};

WORD gawModemCode800[] = {
#ifdef NT_MODEL
  0				/*#include "modemnt8.dat" */
#else
  0				/*#include "800modem.dat" */
#endif
};

CLIENT_BIN gasModemVectCode[] = {
  {
   0x0400,
   gawModemVect400,
   gawModemCode400,
   gawModemData,
   sizeof (gawModemVect400),
   sizeof (gawModemCode400),
   sizeof (gawModemData)}
  ,
  {
   0x0800,
   gawModemVect800,
   gawModemCode800,
   gawModemData,
   sizeof (gawModemVect800),
   sizeof (gawModemCode800),
   sizeof (gawModemData)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};


/* */
/* Positional 3D */
/* */
/* Note: Data image contains 25 words (first 22 are CDATA_HEADER + */
/* kernel spare, next 3 are dpaddr, control_enabled and current_count */
/* for Pos3d) */
/* */

WORD gawPos3DDataXXXX[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000
};

WORD gawPos3DVect0400[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawPos3DCode0400[] = {
  0				/*#include "4pos3d.dat" */
};

WORD gawPos3DVect0800[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawPos3DCode0800[] = {
  0				/*#include "8pos3d.dat" */
};

CLIENT_BIN gasPos3DVectCode[] = {
  {
   0x0400,
   gawPos3DVect0400,
   gawPos3DCode0400,
   gawPos3DDataXXXX,
   sizeof (gawPos3DVect0400),
   sizeof (gawPos3DCode0400),
   sizeof (gawPos3DDataXXXX)}
  ,
  {
   0x0800,
   gawPos3DVect0800,
   gawPos3DCode0800,
   gawPos3DDataXXXX,
   sizeof (gawPos3DVect0800),
   sizeof (gawPos3DCode0800),
   sizeof (gawPos3DDataXXXX)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};

/* */
/* Speaker Virtualization */
/* */

WORD gawSpkVirtDataXXXX[] = {
  0x0000
};

WORD gawSpkVirtVect0400[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawSpkVirtCode0400[] = {
  0				/*#include "4vmax.dat" */
};

WORD gawSpkVirtVect0800[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawSpkVirtCode0800[] = {
  0				/*#include "8vmax.dat" */
};

CLIENT_BIN gasSpkVirtVectCode[] = {
  {
   0x0400,
   gawSpkVirtVect0400,
   gawSpkVirtCode0400,
   gawSpkVirtDataXXXX,
   sizeof (gawSpkVirtVect0400),
   sizeof (gawSpkVirtCode0400),
   sizeof (gawSpkVirtDataXXXX)}
  ,
  {
   0x0800,
   gawSpkVirtVect0800,
   gawSpkVirtCode0800,
   gawSpkVirtDataXXXX,
   sizeof (gawSpkVirtVect0800),
   sizeof (gawSpkVirtCode0800),
   sizeof (gawSpkVirtDataXXXX)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};

/* */
/* CRL Speaker Virtualization */
/* */

WORD gawSpkVirtDataXXXX_CRL[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000
};

WORD gawSpkVirtVect0400_CRL[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawSpkVirtCode0400_CRL[] = {
  0				/*#include "4spkvirt.dat" */
};

WORD gawSpkVirtVect0800_CRL[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000
};

WORD gawSpkVirtCode0800_CRL[] = {
  0				/*#include "8spkvirt.dat" */
};

CLIENT_BIN gasSpkVirtVectCode_CRL[] = {
  {
   0x0400,
   gawSpkVirtVect0400_CRL,
   gawSpkVirtCode0400_CRL,
   gawSpkVirtDataXXXX_CRL,
   sizeof (gawSpkVirtVect0400_CRL),
   sizeof (gawSpkVirtCode0400_CRL),
   sizeof (gawSpkVirtDataXXXX_CRL)}
  ,
  {
   0x0800,
   gawSpkVirtVect0800_CRL,
   gawSpkVirtCode0800_CRL,
   gawSpkVirtDataXXXX_CRL,
   sizeof (gawSpkVirtVect0800_CRL),
   sizeof (gawSpkVirtCode0800_CRL),
   sizeof (gawSpkVirtDataXXXX_CRL)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};

/* */
/* Sample Rate Conversion */
/* */

WORD gawSRCDataXXXX[] = {
  0x0000
};


WORD gawSRCVect0400[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSRCCode0400[] = {
  0				/*#include "400src36.dat" */
};

WORD gawSRCVect0500[] = {
  0x7980, 0x0500, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSRCCode0500[] = {
  0				/*#include "500src36.dat" */
};

WORD gawSRCVect0600[] = {
  0x7980, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSRCCode0600[] = {
  0				/*#include "600src36.dat" */
};

WORD gawSRCVect0800[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSRCCode0800[] = {
  0				/*#include "800src36.dat" */
};

CLIENT_BIN gasSRCVectCode[] = {
  {
   0x0400,
   gawSRCVect0400,
   gawSRCCode0400,
   gawSRCDataXXXX,
   sizeof (gawSRCVect0400),
   sizeof (gawSRCCode0400),
   sizeof (gawSRCDataXXXX)}
  ,
  {
   0x0500,
   gawSRCVect0500,
   gawSRCCode0500,
   gawSRCDataXXXX,
   sizeof (gawSRCVect0500),
   sizeof (gawSRCCode0500),
   sizeof (gawSRCDataXXXX)}
  ,
  {
   0x0600,
   gawSRCVect0600,
   gawSRCCode0600,
   gawSRCDataXXXX,
   sizeof (gawSRCVect0600),
   sizeof (gawSRCCode0600),
   sizeof (gawSRCDataXXXX)}
  ,
  {
   0x0800,
   gawSRCVect0800,
   gawSRCCode0800,
   gawSRCDataXXXX,
   sizeof (gawSRCVect0800),
   sizeof (gawSRCCode0800),
   sizeof (gawSRCDataXXXX)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};

/* */
/* MINI Sample Rate Conversion */
/* */

WORD gawMINISRCDataXXXX[] = {
  0x0000
};

WORD gawMINISRCVect0400[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawMINISRCCode0400[] = {
#include "400m_src.dat"
};

WORD gawMINISRCVect0500[] = {
  0x7980, 0x0500, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawMINISRCCode0500[] = {
#include "500m_src.dat"
};

WORD gawMINISRCVect0600[] = {
  0x7980, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawMINISRCCode0600[] = {
#include "600m_src.dat"
};

WORD gawMINISRCVect0800[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawMINISRCCode0800[] = {
#include "800m_src.dat"
};


WORD gawMINISRCVect0900[] = {
  0x7980, 0x0900, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawMINISRCCode0900[] = {
#include "900m_src.dat"
};


WORD gawMINISRCVect0A00[] = {
  0x7980, 0x0A00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawMINISRCCode0A00[] = {
#include "a00m_src.dat"
};

WORD gawMINISRCVect0A80[] = {
  0x7980, 0x0A80, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawMINISRCCode0A80[] = {
#include "a80m_src.dat"
};

CLIENT_BIN gasMINISRCVectCode[] = {
  {
   0x0400,
   gawMINISRCVect0400,
   gawMINISRCCode0400,
   gawMINISRCDataXXXX,
   sizeof (gawMINISRCVect0400),
   sizeof (gawMINISRCCode0400),
   sizeof (gawMINISRCDataXXXX)}
  ,
  {
   0x0500,
   gawMINISRCVect0500,
   gawMINISRCCode0500,
   gawMINISRCDataXXXX,
   sizeof (gawMINISRCVect0500),
   sizeof (gawMINISRCCode0500),
   sizeof (gawMINISRCDataXXXX)}
  ,
  {
   0x0600,
   gawMINISRCVect0600,
   gawMINISRCCode0600,
   gawMINISRCDataXXXX,
   sizeof (gawMINISRCVect0600),
   sizeof (gawMINISRCCode0600),
   sizeof (gawMINISRCDataXXXX)}
  ,
  {
   0x0800,
   gawMINISRCVect0800,
   gawMINISRCCode0800,
   gawMINISRCDataXXXX,
   sizeof (gawMINISRCVect0800),
   sizeof (gawMINISRCCode0800),
   sizeof (gawMINISRCDataXXXX)}
  ,
  {
   0x0900,
   gawMINISRCVect0900,
   gawMINISRCCode0900,
   gawMINISRCDataXXXX,
   sizeof (gawMINISRCVect0900),
   sizeof (gawMINISRCCode0900),
   sizeof (gawMINISRCDataXXXX)}
  ,
  {
   0x0A00,
   gawMINISRCVect0A00,
   gawMINISRCCode0A00,
   gawMINISRCDataXXXX,
   sizeof (gawMINISRCVect0A00),
   sizeof (gawMINISRCCode0A00),
   sizeof (gawMINISRCDataXXXX)}
  ,
  {
   0x0A80,
   gawMINISRCVect0A80,
   gawMINISRCCode0A80,
   gawMINISRCDataXXXX,
   sizeof (gawMINISRCVect0A80),
   sizeof (gawMINISRCCode0A80),
   sizeof (gawMINISRCDataXXXX)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};

/* */
/* SPDIF */
/* */

WORD gawSPDIFDataXXXX[] = {
  0x0000
};

WORD gawSPDIFVect0400[] = {
  0x7980, 0x0400, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSPDIFCode0400[] = {
  0				/*#include "400spdif.dat" */
};

WORD gawSPDIFVect0500[] = {
  0x7980, 0x0500, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSPDIFCode0500[] = {
  0				/*#include "500spdif.dat" */
};

WORD gawSPDIFVect0600[] = {
  0x7980, 0x0600, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSPDIFCode0600[] = {
  0				/*#include "600spdif.dat" */
};

WORD gawSPDIFVect0700[] = {
  0x7980, 0x0700, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSPDIFCode0700[] = {
  0				/*#include "700spdif.dat" */
};

WORD gawSPDIFVect0800[] = {
  0x7980, 0x0800, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSPDIFCode0800[] = {
  0				/*#include "800spdif.dat" */
};

WORD gawSPDIFVect0900[] = {
  0x7980, 0x0900, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSPDIFCode0900[] = {
  0				/*#include "900spdif.dat" */
};

WORD gawSPDIFVect0A00[] = {
  0x7980, 0x0A00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000,
};

WORD gawSPDIFCode0A00[] = {
  0				/*#include "A00spdif.dat" */
};

CLIENT_BIN gasSPDIFVectCode[] = {
  {
   0x0400,
   gawSPDIFVect0400,
   gawSPDIFCode0400,
   gawSPDIFDataXXXX,
   sizeof (gawSPDIFVect0400),
   sizeof (gawSPDIFCode0400),
   sizeof (gawSPDIFDataXXXX)}
  ,
  {
   0x0500,
   gawSPDIFVect0500,
   gawSPDIFCode0500,
   gawSPDIFDataXXXX,
   sizeof (gawSPDIFVect0500),
   sizeof (gawSPDIFCode0500),
   sizeof (gawSPDIFDataXXXX)}
  ,
  {
   0x0600,
   gawSPDIFVect0600,
   gawSPDIFCode0600,
   gawSPDIFDataXXXX,
   sizeof (gawSPDIFVect0600),
   sizeof (gawSPDIFCode0600),
   sizeof (gawSPDIFDataXXXX)}
  ,
  {
   0x0700,
   gawSPDIFVect0700,
   gawSPDIFCode0700,
   gawSPDIFDataXXXX,
   sizeof (gawSPDIFVect0700),
   sizeof (gawSPDIFCode0700),
   sizeof (gawSPDIFDataXXXX)}
  ,
  {
   0x0800,
   gawSPDIFVect0800,
   gawSPDIFCode0800,
   gawSPDIFDataXXXX,
   sizeof (gawSPDIFVect0800),
   sizeof (gawSPDIFCode0800),
   sizeof (gawSPDIFDataXXXX)}
  ,
  {
   0x0900,
   gawSPDIFVect0900,
   gawSPDIFCode0900,
   gawSPDIFDataXXXX,
   sizeof (gawSPDIFVect0900),
   sizeof (gawSPDIFCode0900),
   sizeof (gawSPDIFDataXXXX)}
  ,
  {
   0x0A00,
   gawSPDIFVect0A00,
   gawSPDIFCode0A00,
   gawSPDIFDataXXXX,
   sizeof (gawSPDIFVect0A00),
   sizeof (gawSPDIFCode0A00),
   sizeof (gawSPDIFDataXXXX)}
  ,
  {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL}
};

#if 0
#ifndef NT_MODEL
/* */
/* FM client is a special case */
/* */
/* Note: If FM .dat images without passthru support are used */
/* PASSTHRU_SIZE can be set to zero. */
/* */

#define PASSTHRU_SIZE   256

WORD gawFMData[1024 + PASSTHRU_SIZE] = {
#include "fm_d1000.dat"
};

WORD gawFMData2[] = {
#include "fm_d2000.dat"
};

WORD gawFMVectCode[256 + PASSTHRU_SIZE] = {
#include "fm_c0000.dat"
};

WORD gawFMCode[1024] = {
#include "fm_c0800.dat"
};

FMCLIENT_BIN gsFMVectCode = {
  0x0800,
  0x2000,
  gawFMVectCode,
  gawFMCode,
  gawFMData,
  gawFMData2,
  sizeof (gawFMVectCode),
  sizeof (gawFMCode),
  sizeof (gawFMData),
  sizeof (gawFMData2)
};
#endif
#endif
WORD MIXER_TASK_NUMBER = 0;

/*--------------------------------------------------------------------------- */
/*  End of File: kernelbn.h */
/*--------------------------------------------------------------------------- */

/******************************************************************************
 *                                                                            *
 *                       (C) 1997-1999 ESS Technology, Inc.                   *
 *                                                                            *
 ******************************************************************************/
