#!/usr/bin/perl
# Do not add to makefile.am

use strict;
use warnings;
use Test::More;
use Test::Warnings ':report_warnings';

use Try::Tiny;
use File::Basename;
use File::Path qw(make_path remove_tree);
use Cwd;


use OpenQA::Benchmark::Stopwatch;


# optional but very useful
eval 'use Test::More::Color';
eval 'use Test::More::Color "foreground"';

use cv;

cv::init();
require tinycv;

my $data_dir = dirname(__FILE__) . '/data/';
my $img1     = tinycv::read($data_dir . 'xorg_vt-Xorg-20140729.png');
my $ppm      = $img1->ppm_data();
my $ppmv     = $ppm;
$ppmv =~ s,# Generated by OpenCV \S+\s,,;
# make sure we don't explode in case of failure
$ppmv = substr($ppmv, 0, 80);
like($ppmv, qr/^P6\s1024 768\s255/, 'is a ppm');
my $img2 = tinycv::from_ppm($ppm);

is(1000000, $img1->similarity($img2));

done_testing();
