%feature("docstring") OT::IntegrationStrategy
R"RAW(Integration strategy for the approximation coefficients.

Available constructors:
    IntegrationStrategy(*measure*)

    IntegrationStrategy(*weightedExp*)

    IntegrationStrategy(*measure, weightedExp*)

    IntegrationStrategy(*inputSample, outputSample*)

    IntegrationStrategy(*inputSample, weights, outputSample*)

Parameters
----------
weightedExp : :class:`~openturns.WeightedExperiment`
    Experimental design used for the transformed input data. When not precised,
    OpenTURNS uses a :class:`~openturns.MonteCarloExperiment`.
measure : :class:`~openturns.Distribution`
    Distribution :math:`\mu` with respect to which the basis is orthonormal.
    When not precised, OpenTURNS uses the limit measure defined within the
    :class:`~openturns.WeightedExperiment`.
inputSample : 2-d sequence of float
    The input random observations :math:`\left\{\vect{X}^{(1)}, ..., \vect{X}^{(n)}\right\}` 
    where :math:`\vect{X}=(X_1, \dots, X_{n_X})^T` is the input of the physical
    model, :math:`n_X` is the input dimension and :math:`n` is the sample size.
outputSample : 2-d sequence of float
    The output random observations :math:`\left\{\vect{Y}^{(1)}, ..., \vect{Y}^{(n)}\right\}` 
    where :math:`\vect{Y}=(Y_1, \dots, Y_{n_Y})^T` is the output of the physical
    model, :math:`n_Y` is the output dimension and :math:`n` is the sample size.
weights : sequence of float
    Numerical point that are the weights associated to the input sample points
    such that the corresponding weighted experiment is a good approximation of
    :math:`\mu`. If not provided, all weights are equal to 
    :math:`\omega_i = \frac{1}{n}`, where :math:`n` is the size of the
    sample.

See also
--------
FunctionalChaosAlgorithm, ProjectionStrategy, LeastSquaresStrategy

Notes
-----
This class is not usable because it has sense only within the
:class:`~openturns.FunctionalChaosAlgorithm` : the integration strategy
evaluates the coefficients :math:`(a_k)_{k \in K}` of the polynomials
decomposition as follows:

.. math::
    
    \vect{a} = E_{\mu} \left[ g \circ T^{-1} (\vect{U}) \vect{\Psi}(\vect{U}) \right]

where :math:`\vect{U} = T(\vect{X})`.

The mean expectation :math:`E_{\mu}` is approximated by a relation of type:

.. math::
    
    E_{\mu} \left[ f(\vect{U}) \right] \approx \sum_{i \in I} \omega_i f(\Xi_i)

where is a function :math:`L_1(\mu)` defined as:

.. math::

    f(\vect{U} = g \circ T^{-1} (\vect{U}) \vect{\Psi}(\vect{U})

In the approximation of the mean expectation, the set *I*, the points 
:math:`(\Xi_i)_{i \in I}` and the weights :math:`(\omega_i)_{i \in I}` are
evaluated from methods implemented in the :class:`~openturns.WeightedExperiment`.)RAW"
