/*
 * oFono - Open Source Telephony
 * Copyright (C) 2011  ST-Ericsson AB
 * Copyright (C) 2011  Nokia Corporation and/or its subsidiary(-ies)
 *
 * SPDX-License-Identifier: GPL-2.0-only
 */

#ifndef __ISIMODEM_UICC_H
#define __ISIMODEM_UICC_H

#ifdef __cplusplus
extern "C" {
#endif

#include <gisi/client.h>
#include <gisi/modem.h>

#define PN_UICC 0x8C

#define UICC_APPL_ID_UNKNOWN			0x00
#define UICC_SFI_NOT_PRESENT			0x00
#define UICC_SESSION_ID_NOT_USED		0x00

enum uicc_status {
	UICC_STATUS_OK =			0x00,
	UICC_STATUS_FAIL =			0x01,
	UICC_STATUS_UNKNOWN =			0x02,
	UICC_STATUS_NOT_READY =			0x10,
	UICC_STATUS_START_UP_COMPLETED =	0x11,
	UICC_STATUS_SHUTTING_DOWN =		0x12,
	UICC_STATUS_CARD_NOT_READY =		0x20,
	UICC_STATUS_CARD_READY =		0x21,
	UICC_STATUS_CARD_DISCONNECTED =		0x22,
	UICC_STATUS_CARD_NOT_PRESENT =		0x23,
	UICC_STATUS_CARD_REJECTED =		0x24,
	UICC_STATUS_APPL_ACTIVE =		0x30,
	UICC_STATUS_APPL_NOT_ACTIVE =		0x31,
	UICC_STATUS_PIN_ENABLED =		0x40,
	UICC_STATUS_PIN_DISABLED =		0x41,
};

enum uicc_subblock {
	UICC_SB_SHUT_DOWN_CONFIG =		0x0023,
	UICC_SB_CARD_STATUS =			0x0001,
	UICC_SB_CARD_INFO =			0x0024,
	UICC_SB_CARD_REJECT_CAUSE =		0x0025,
	UICC_SB_CLIENT =			0x001F,
	UICC_SB_APPL_DATA_OBJECT =		0x0002,
	UICC_SB_APPLICATION =			0x0003,
	UICC_SB_APPL_INFO =			0x0004,
	UICC_SB_APPL_STATUS =			0x0005,
	UICC_SB_FCP =				0x0007,
	UICC_SB_FCI =				0x001C,
	UICC_SB_CHV =				0x001B,
	UICC_SB_PIN =				0x0008,
	UICC_SB_PIN_REF =			0x0009,
	UICC_SB_PUK =				0x000A,
	UICC_SB_PIN_SUBST =			0x000B,
	UICC_SB_PIN_INFO =			0x000C,
	UICC_SB_APPL_PATH =			0x000D,
	UICC_SB_SESSION =			0x000E,
	UICC_SB_FILE_DATA =			0x000F,
	UICC_SB_APDU =				0x0014,
	UICC_SB_TRANSPARENT_READ =		0x0010,
	UICC_SB_TRANSPARENT_UPDATE =		0x0011,
	UICC_SB_TRANSPARENT =			0x0012,
	UICC_SB_LINEAR_FIXED =			0x0013,
	UICC_SB_CYCLIC =			0x0026,
	UICC_SB_TERMINAL_PROFILE =		0x0015,
	UICC_SB_TERMINAL_RESPONSE =		0x001D,
	UICC_SB_ENVELOPE =			0x0021,
	UICC_SB_POLLING_SET =			0x0016,
	UICC_SB_REFRESH =			0x0017,
	UICC_SB_AID =				0x0006,
	UICC_SB_REFRESH_RESULT =		0x0018,
	UICC_SB_APDU_ACTIONS =			0x0019,
	UICC_SB_OBJECT_ID =			0x001A,
	UICC_SB_STATUS_WORD =			0x0020,
	UICC_SB_APDU_SAP_INFO =			0x0022,
	UICC_SB_ACCESS_MODE =			0x0027,
	UICC_SB_RESP_INFO =			0x0028,
	UICC_SB_APDU_SAP_CONFIG =		0x0029,
};

enum uicc_message_id {
	UICC_REQ =				0x00,
	UICC_RESP =				0x01,
	UICC_IND =				0x02,
	UICC_CARD_REQ =				0x03,
	UICC_CARD_RESP =			0x04,
	UICC_CARD_IND =				0x05,
	UICC_APPLICATION_REQ =			0x06,
	UICC_APPLICATION_RESP =			0x07,
	UICC_APPLICATION_IND =			0x08,
	UICC_PIN_REQ =				0x09,
	UICC_PIN_RESP =				0x0A,
	UICC_PIN_IND =				0x0B,
	UICC_APPL_CMD_REQ =			0x0C,
	UICC_APPL_CMD_RESP =			0x0D,
	UICC_APPL_CMD_IND =			0x0E,
	UICC_CONNECTOR_REQ =			0x0F,
	UICC_CONNECTOR_RESP =			0x10,
	UICC_CAT_REQ =				0x12,
	UICC_CAT_RESP =				0x13,
	UICC_CAT_IND =				0x14,
	UICC_APDU_REQ =				0x15,
	UICC_APDU_RESP =			0x16,
	UICC_APDU_RESET_IND =			0x17,
	UICC_REFRESH_REQ =			0x18,
	UICC_REFRESH_RESP =			0x19,
	UICC_REFRESH_IND =			0x1A,
	UICC_SIMLOCK_REQ =			0x1B,
	UICC_SIMLOCK_RESP =			0x1C,
	UICC_APDU_SAP_REQ =			0x1E,
	UICC_APDU_SAP_RESP =			0x1F,
	UICC_APDU_SAP_IND =			0x20,
	UICC_PWR_CTRL_REQ =			0x21,
	UICC_PWR_CTRL_RESP =			0x22,
	UICC_PWR_CTRL_IND =			0x23,
	UICC_CARD_READER_IND =			0x26,
};

enum uicc_service_type {
	UICC_APPL_LIST =			0x01,
	UICC_APPL_HOST_ACTIVATE =		0x03,
	UICC_APPL_START_UP_COMPLETE =		0x05,
	UICC_APPL_SHUT_DOWN_INITIATED =		0x06,
	UICC_APPL_STATUS_GET =			0x07,
	UICC_APPL_HOST_DEACTIVATE =		0x09,
	UICC_PIN_VERIFY =			0x11,
	UICC_PIN_UNBLOCK =			0x12,
	UICC_PIN_DISABLE =			0x13,
	UICC_PIN_ENABLE =			0x14,
	UICC_PIN_CHANGE =			0x15,
	UICC_PIN_SUBSTITUTE =			0x16,
	UICC_PIN_INFO =				0x17,
	UICC_PIN_PROMPT_VERIFY =		0x18,
	UICC_APPL_READ_TRANSPARENT =		0x21,
	UICC_APPL_UPDATE_TRANSPARENT =		0x22,
	UICC_APPL_READ_LINEAR_FIXED =		0x23,
	UICC_APPL_UPDATE_LINEAR_FIXED =		0x24,
	UICC_APPL_FILE_INFO =			0x25,
	UICC_APPL_APDU_SEND =			0x26,
	UICC_APPL_CLEAR_CACHE =			0x27,
	UICC_APPL_SESSION_START	=		0x28,
	UICC_APPL_SESSION_END =			0x29,
	UICC_APPL_READ_CYCLIC =			0x2A,
	UICC_APPL_UPDATE_CYCLIC =		0x2B,
	UICC_CONNECT =				0x31,
	UICC_DISCONNECT =			0x32,
	UICC_RECONNECT =			0x33,
	UICC_CAT_ENABLE =			0x41,
	UICC_CAT_DISABLE =			0x42,
	UICC_CAT_TERMINAL_PROFILE =		0x43,
	UICC_CAT_TERMINAL_RESPONSE =		0x44,
	UICC_CAT_ENVELOPE =			0x45,
	UICC_CAT_POLLING_SET =			0x46,
	UICC_CAT_REFRESH =			0x47,
	UICC_CAT_POLL =				0x48,
	UICC_APDU_SEND =			0x51,
	UICC_APDU_ATR_GET =			0x52,
	UICC_APDU_CONTROL =			0x53,
	UICC_REFRESH_STATUS =			0x61,
	UICC_APPL_TERMINATED =			0x71,
	UICC_APPL_RECOVERED =			0x72,
	UICC_APPL_ACTIVATED =			0x75,
	UICC_PIN_VERIFY_NEEDED =		0x81,
	UICC_PIN_UNBLOCK_NEEDED =		0x82,
	UICC_PIN_PERMANENTLY_BLOCKED =		0x83,
	UICC_PIN_VERIFIED =			0x84,
	UICC_CAT_FETCHED_CMD =			0x91,
	UICC_CAT_NOT_SUPPORTED =		0x92,
	UICC_CAT_REG_FAILED =			0x93,
	UICC_CAT_REG_OK =			0x94,
	UICC_REFRESH_PERMISSION =		0xA1,
	UICC_REFRESH_STARTING =			0xA2,
	UICC_REFRESH_CANCELLED =		0xA3,
	UICC_REFRESH_NOW =			0xA4,
	UICC_START_UP_COMPLETE =		0xB0,
	UICC_STATUS_GET =			0xB1,
	UICC_READY =				0xB2,
	UICC_READY_FOR_ACTIVATION =		0xB3,
	UICC_INITIALIZED =			0xB4,
	UICC_SHUTTING_DOWN =			0xB5,
	UICC_SHUT_DOWN_CONFIG =			0xB6,
	UICC_ERROR =				0xB7,
	UICC_CARD_DISCONNECTED =		0xC0,
	UICC_CARD_REMOVED =			0xC1,
	UICC_CARD_NOT_PRESENT =			0xC2,
	UICC_CARD_READY =			0xC4,
	UICC_CARD_STATUS_GET =			0xC5,
	UICC_CARD_REJECTED =			0xC8,
	UICC_CARD_INFO_GET =			0xC9,
	UICC_SIMLOCK_ACTIVE =			0xD0,
	UICC_APDU_SAP_ACTIVATE =		0xE1,
	UICC_APDU_SAP_DEACTIVATE =		0xE2,
	UICC_APDU_SAP_ATR_GET =			0xE3,
	UICC_APDU_SAP_COLD_RESET =		0xE4,
	UICC_APDU_SAP_WARM_RESET =		0xE5,
	UICC_APDU_SAP_APDU_SEND =		0xE6,
	UICC_APDU_SAP_RECOVERY =		0xE7,
	UICC_APDU_SAP_CONFIG_GET =		0xE8,
	UICC_PWR_CTRL_ENABLE =			0xF1,
	UICC_PWR_CTRL_DISABLE =			0xF2,
	UICC_PWR_CTRL_WAIT =			0xF3,
	UICC_PWR_CTRL_PROCEED =			0xF4,
	UICC_PWR_CTRL_PERMISSION =		0xFA,
};

enum uicc_appl_type_table {
	UICC_APPL_TYPE_UNKNOWN =		0x00,
	UICC_APPL_TYPE_ICC_SIM =		0x01,
	UICC_APPL_TYPE_UICC_USIM =		0x02,
};

enum uicc_pin_qualifier {
	UICC_PIN_NEW =				0x01,
	UICC_PIN_OLD =				0x02,
};

enum uicc_appl_start_up_type {
	UICC_APPL_START_UP_NO_INIT_PROC =	0x00,
	UICC_APPL_START_UP_INIT_PROC =		0x01,
};

enum uicc_card_type {
	UICC_CARD_TYPE_ICC =			0x01,
	UICC_CARD_TYPE_UICC =			0x02,
};

enum uicc_details {
	UICC_NO_DETAILS =			0x00,
	UICC_INVALID_PARAMETERS =		0x01,
	UICC_FILE_NOT_FOUND =			0x02,
	UICC_SECURITY_CONDITIONS_NOT_SATISFIED =	0x03,
	UICC_APPL_CONFLICT =				0x04,
	UICC_CARD_ERROR =				0x05,
	UICC_SERVICE_NOT_SUPPORTED =			0x06,
	UICC_SESSION_EXPIRED =				0x07,
};

enum uicc_simlock_status {
	UICC_SIMLOCK_STATUS_ACTIVE =		0x01,
	UICC_SIMLOCK_STATUS_INACTIVE =		0x02,
};

enum uicc_apdu_status_word {
	UICC_PIN_STATUS_AUTH_RETRIES =		0x63c0,
	UICC_PIN_STATUS_AUTH_BLOCKED =		0x6983,
	UICC_PIN_STATUS_AUTH_FAILED =		0x9840,
};

enum uicc_template {
	UICC_TEMPLATE_APPLICATION =		0x61,
	UICC_TEMPLATE_FCP =			0x62,
	UICC_TEMPLATE_SECURITY_ENVIRONMENT =	0x7B,
};

enum uicc_fcp_param {
	UICC_FCP_PARAM_FILE_SIZE_DATA =		0x80,
	UICC_FCP_PARAM_FILE_SIZE_TOTAL =	0x81,
	UICC_FCP_PARAM_FILE_DESC =		0x82,
	UICC_FCP_PARAM_FILE_ID =		0x83,
	UICC_FCP_PARAM_AID =			0x84,
	UICC_FCP_PARAM_LIFECYCLE =		0x8A,
	UICC_FCP_PARAM_SECURITY_REFERENCE =	0x8B,
	UICC_FCP_PARAM_SECURITY_COMPACT =	0x8C,
	UICC_FCP_PARAM_SECURITY_EXPANDED =	0xAB,
	UICC_FCP_PARAM_PIN_STATUS =		0xC6,
};

enum uicc_app_param {
	UICC_APP_PARAM_ID =			0x4F,
	UICC_APP_PARAM_LABEL =			0x50,
	UICC_APP_PARAM_PATH =			0x51,
	UICC_APP_PARAM_COMMAND =		0x52,
	UICC_APP_PARAM_DISC_DATA =		0x53,
	UICC_APP_PARAM_DISC_TEMPLATE =		0x73,
	UICC_APP_PARAM_URL =			0x5F50,
};

#ifdef __cplusplus
};
#endif

#endif /* __ISIMODEM_UICC_H */
