/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToNWChemInput
extends AbstractBasisSetXmlToText {
    protected boolean specifics = true;

    public BasisXmlToNWChemInput() {
    }

    public BasisXmlToNWChemInput(boolean includeSpecifics) {
        this.specifics = includeSpecifics;
    }

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        String title = "";
        String basisSetType = root.getChildText("basisSetType", BSEProperties.mBseNs);
        if (basisSetType != null) {
            output.append("BASIS \"");
            if (basisSetType.equals("orbital")) {
                output.append("ao basis\"");
            } else if (basisSetType.equals("dftorb")) {
                output.append("ao basis\"");
            } else if (basisSetType.equals("dftxfit")) {
                output.append("xc basis\"");
            } else if (basisSetType.equals("dftcfit")) {
                output.append("cd basis\"");
            } else if (basisSetType.equals("ecporb")) {
                output.append("ao basis\"");
            } else {
                output.append("ao basis\"");
            }
            output.append(" PRINT\n");
        }
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
        output.append("END\n");
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        Element description = contractions.getChild("description", BSEProperties.mDcNs);
        String descStr = "";
        if (description != null) {
            descStr = description.getValue();
        }
        output.append("#BASIS SET: " + descStr + "\n");
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        for (int k = 0; k < matrices.size(); ++k) {
            Matrix matrix = (Matrix)matrices.get(k);
            int rows = matrix.getNumRows();
            int columns = matrix.getNumColumns();
            output.append(element + "    " + shell + "\n");
            try {
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < columns; ++j) {
                        String value = this.formattedValue(matrix.getValue(i, j));
                        output.append(value);
                    }
                    output.append("\n");
                }
                continue;
            }
            catch (IndexOutOfBoundsException ie) {
                throw new FormatException(ie.getMessage());
            }
        }
    }
}

