/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.pertable.PerTable;

public class GaussianInputToBasisXml
extends AbstractBasisSetToXml {
    protected PerTable mPertable = PerTable.getPerTable();

    @Override
    public Vector convert(String title, String xmlFileName, String harmonicType, String description, InputStream inputStream) throws IOException, FormatException {
        Vector<Document> ret = new Vector<Document>();
        boolean hasBasisSet = false;
        boolean hasEcp = false;
        boolean hasSo = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim().toUpperCase();
            Document doc = null;
            if (line.length() == 0) continue;
            Vector columns = this.tokenize(line);
            String element = this.parseElement((String)columns.get(0));
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element)) || columns.size() != 2) continue;
            if (!hasBasisSet) {
                doc = this.loadBasisSet(reader, line, title, xmlFileName, harmonicType, description);
                if (doc != null) {
                    String[] types = this.getContractionTypes(doc);
                    hasBasisSet = true;
                }
            } else {
                doc = this.loadECPs(reader, line, title, xmlFileName);
                if (doc != null) {
                    hasEcp = true;
                }
            }
            if (doc == null) continue;
            ret.add(doc);
        }
        if (ret.size() == 0) {
            throw new FormatException("Unable to find start of basis set data.  Make sure you have specified the correct file type.");
        }
        for (Document doc : ret) {
            String docType = doc.getRootElement().getName().toLowerCase();
            if (!docType.equals("basisset")) continue;
            if (hasEcp) {
                doc.getRootElement().addContent(this.createEcpLink(xmlFileName));
            }
            if (!hasSo) continue;
            doc.getRootElement().addContent(this.createSoLink(xmlFileName));
        }
        return ret;
    }

    protected Document loadBasisSet(BufferedReader reader, String options, String name, String xmlFileName, String harmonicType, String description) throws IOException, FormatException {
        Element root = this.createBasisRoot();
        root.addContent(this.createBasisMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createHarmonicType(harmonicType));
        root.addContent(this.createContractionType("segmented"));
        root.addContent(this.createRefLink(xmlFileName + "-BS-REF.xml"));
        root.addContent(this.createDescription(description));
        String line = options;
        String maxShell = this.getMinimumShell();
        String lastElement = "";
        Element contractions = null;
        while (line != null) {
            if ((line = line.trim().toUpperCase()).startsWith("!")) continue;
            if (line.length() == 0) break;
            Vector columns = this.tokenize(line);
            String element = this.parseElement((String)columns.get(0));
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) {
                throw new FormatException("Unrecognized element: " + element);
            }
            if (columns.size() != 2) {
                throw new FormatException("Missing L values: " + line);
            }
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim().toUpperCase()).startsWith("!")) continue;
                if (line.equals("****")) break;
                columns = this.tokenize(line);
                if (columns.size() != 3) {
                    throw new FormatException("Missing shell block values: " + line);
                }
                String shell = (String)columns.get(0);
                if (!this.isValidShell(shell)) {
                    throw new FormatException("Unrecognized shell type " + shell);
                }
                if (!element.equals(lastElement)) {
                    contractions = this.createContractions(element);
                    root.addContent(contractions);
                    lastElement = element;
                }
                Element contraction = this.createContraction(shell);
                maxShell = this.selectMaxShell(shell, maxShell);
                contractions.addContent(contraction);
                int nRows = Integer.parseInt((String)columns.get(1));
                this.readMatrix(reader, contraction, nRows);
            }
            line = reader.readLine();
        }
        return new Document(root);
    }

    protected boolean readMatrix(BufferedReader reader, Element parent, int nRows) throws IOException {
        boolean ret = true;
        Vector matrix = new Vector();
        int nColumns = 0;
        for (int i = 0; i < nRows; ++i) {
            String line = reader.readLine();
            if (line == null) {
                ret = false;
            }
            if ((line = line.trim().toUpperCase()).length() == 0 || line.startsWith("!")) continue;
            Vector data = this.tokenize(line);
            reader.mark(80);
            nColumns = data.size();
            matrix.addAll(data);
        }
        Element matrixEl = this.createMatrix(matrix, nRows, nColumns);
        parent.addContent(matrixEl);
        reader.reset();
        return ret;
    }

    protected Document loadECPs(BufferedReader reader, String options, String name, String xmlFileName) throws IOException, FormatException {
        return this.loadECPFormattedData(reader, options, "scalar", name, xmlFileName);
    }

    protected Document loadSpinOrbitals(BufferedReader reader, String options, String name, String xmlFileName) throws IOException, FormatException {
        return this.loadECPFormattedData(reader, options, "spin", name + "-so", xmlFileName);
    }

    protected Document loadECPFormattedData(BufferedReader reader, String options, String type, String name, String xmlFileName) throws IOException, FormatException {
        Element root = this.createEcpRoot();
        root.addContent(this.createEcpMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createEcpType("type"));
        if (xmlFileName.endsWith("-ECP")) {
            root.addContent(this.createRefLink(xmlFileName + "-REF.xml"));
        } else {
            root.addContent(this.createRefLink(xmlFileName + "-ECP-REF.xml"));
        }
        String line = options;
        while (line != null && (line = line.trim().toUpperCase()).length() != 0) {
            String shell;
            if (line.startsWith("!")) continue;
            Vector columns = this.tokenize(line);
            String element = this.parseElement((String)columns.get(0));
            if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) break;
            if (columns.size() != 2) {
                throw new FormatException("Missing L values: " + line);
            }
            do {
                if ((line = reader.readLine().trim().toUpperCase()) != null) continue;
                throw new FormatException("Missing i/p line");
            } while (line.length() == 0);
            columns = this.tokenize(line);
            String ecpWord = (String)columns.get(0);
            if (!ecpWord.equals(element.toUpperCase() + "-ECP")) {
                throw new FormatException("Missing ECP line: " + line);
            }
            String nElectrons = (String)columns.get(columns.size() - 1);
            String maxShell = this.getMinimumShell();
            Element potentials = this.createPotentials(element, nElectrons);
            root.addContent(potentials);
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim().toUpperCase()).length() == 0) continue;
                boolean isMarked = false;
                columns = this.tokenize(line);
                String check = (String)columns.get(1);
                if (!check.equals("POTENTIAL")) {
                    reader.reset();
                    break;
                }
                if (columns.size() != 2) {
                    throw new FormatException("Expected potential line: E.g. s potential" + line);
                }
                String shells = (String)columns.get(0);
                String[] temp = shells.split("-");
                shell = temp[0];
                if (!this.isValidShell(shell)) {
                    throw new FormatException("Unrecognized shell type " + shell);
                }
                maxShell = this.selectMaxShell(shell, maxShell);
                Element potential = this.createPotential(shell.toLowerCase() + " potential", shell);
                potentials.addContent(potential);
                do {
                    if ((line = reader.readLine().trim().toUpperCase()) != null) continue;
                    throw new FormatException("Missing line: # of potentials.");
                } while (line.length() == 0);
                columns = this.tokenize(line);
                int nRows = Integer.parseInt((String)columns.get(0));
                this.readMatrix(reader, potential, nRows);
            }
            maxShell = maxShell.toLowerCase();
            List potentialEls = potentials.getChildren("potential", mEmslNs);
            for (Element p : potentialEls) {
                Attribute attribute = p.getAttribute("potentialType");
                shell = p.getAttribute("shell").getValue().toLowerCase();
                if (shell.equals(maxShell)) {
                    attribute.setValue(shell + " potential");
                    continue;
                }
                attribute.setValue(shell + "-" + maxShell + " potential");
            }
            line = reader.readLine();
        }
        return new Document(root);
    }

    protected String parseElement(String value) {
        String ret = value;
        if (ret != null && (ret = ret.trim()).charAt(0) == '-') {
            ret = ret.substring(1);
        }
        return ret;
    }
}

