/* NVTV data vesa -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: data_vesa.c,v 1.1 2003/02/06 17:35:37 dthierbach Exp $
 *
 * Contents: VESA modelines, as a fallback
 *
 */

#include "local.h" /* before everything else */

#include <string.h>

#include "data.h"
#include "data_vesa.h"

typedef struct {
  char *name;
  int clock;
  int hdisplay;	/* horizontal timing */
  int hsyncstart;
  int hsyncend;
  int htotal;
  int vdisplay;	/* vertical timing */
  int vsyncstart;
  int vsyncend;
  int vtotal;
} VesaModeLine;


static VesaModeLine modes [] = {
  {"640x350@85",    31500,  640, 672, 736, 832,  350, 382, 385, 445, },
  {"640x400@85",    31500,  640, 672, 736, 832,  400, 401, 404, 445, },
  {"720x400@85",    35500,  720, 756, 828, 936,  400, 401, 404, 446, },
  {"640x480@60",    25200,  640, 656, 752, 800,  480, 490, 492, 525, },
  {"640x480@72",    31500,  640, 664, 704, 832,  480, 489, 491, 520, },
  {"640x480@75",    31500,  640, 656, 720, 840,  480, 481, 484, 500, },
  {"640x480@85",    36000,  640, 696, 752, 832,  480, 481, 484, 509, },
  {"800x600@56",    36000,  800, 824, 896,1024,  600, 601, 603, 625, },
  {"800x600@60",    40000,  800, 840, 968,1056,  600, 601, 605, 628, },
  {"800x600@72",    50000,  800, 856, 976,1040,  600, 637, 643, 666, },
  {"800x600@75",    49500,  800, 816, 896,1056,  600, 601, 604, 625, },
  {"800x600@85",    56300,  800, 832, 896,1048,  600, 601, 604, 631, },
  {"1024x768@60",   65000, 1024,1048,1184,1344,  768, 771, 777, 806, },
  {"1024x768@70",   75000, 1024,1048,1184,1328,  768, 771, 777, 806, },
  {"1024x768@75",   78800, 1024,1040,1136,1312,  768, 769, 772, 800, },
  {"1024x768@85",   94500, 1024,1072,1168,1376,  768, 769, 772, 808, },
  {"1152x864@75",  108000, 1152,1216,1344,1600,  864, 865, 868, 900, },
  {"1280x960@60",  108000, 1280,1376,1488,1800,  960, 961, 964,1000, },
  {"1280x960@85",  148500, 1280,1344,1504,1728,  960, 961, 964,1011, },
  {"1280x1024@60", 108000, 1280,1328,1440,1688, 1024,1025,1028,1066, },
  {"1280x1024@75", 135000, 1280,1296,1440,1688, 1024,1025,1028,1066, },
  {"1280x1024@85", 157500, 1280,1344,1504,1728, 1024,1025,1028,1072, },
  {"1600x1200@60", 162000, 1600,1664,1856,2160, 1200,1201,1204,1250, },
  {"1600x1200@65", 175500, 1600,1664,1856,2160, 1200,1201,1204,1250, },
  {"1600x1200@70", 189000, 1600,1664,1856,2160, 1200,1201,1204,1250, },
  {"1600x1200@75", 202500, 1600,1664,1856,2160, 1200,1201,1204,1250, },
  {"1600x1200@85", 229500, 1600,1664,1856,2160, 1200,1201,1204,1250, },
  {"1792x1344@60", 204800, 1792,1920,2120,2448, 1344,1345,1348,1394, },
  {"1792x1344@75", 261000, 1792,1888,2104,2456, 1344,1345,1348,1417, },
  {"1856x1392@60", 218300, 1856,1952,2176,2528, 1392,1393,1396,1439, },
  {"1856x1392@75", 288000, 1856,1984,2208,2560, 1392,1393,1396,1500, },
  {"1920x1440@60", 234000, 1920,2048,2256,2600, 1440,1441,1444,1500, },
  {"1920x1440@75", 297000, 1920,2064,2288,2640, 1440,1441,1444,1500, },
  {"1400x1050@60", 122000, 1400,1488,1640,1880, 1050,1052,1064,1082, },
  {"1400x1050@75", 155800, 1400,1464,1784,1912, 1050,1052,1064,1090, },
  {NULL,                0,    0,   0,   0,   0,    0,   0,   0,   0,} 
};

Bool data_vesa_mode (char *name, TVCrtcRegs *crt, make_vidmode make)
{
  VesaModeLine *m;

  for (m = modes; m->name; m++) {
    if (strcmp (m->name, name) == 0) {
      make (m->hdisplay, m->hsyncstart, 
	m->hsyncend, m->htotal,    
	m->vdisplay, m->vsyncstart,
	m->vsyncend, m->vtotal, 
	m->clock, crt);
      return TRUE;
    }
  }
  return FALSE;
}

