/* $Id: AaInterval.cpp 497242 2016-04-05 14:40:38Z foleyjp $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'variation_irep.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <objects/varrep/AaSite.hpp>
#include <corelib/ncbiexpt.hpp>

// generated includes
#include <objects/varrep/AaInterval.hpp>


// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CAaInterval::~CAaInterval(void)
{
}


size_t CAaInterval::size(void) const
{
    const auto start_index = GetStart().GetIndex();
    const auto stop_index = GetStop().GetIndex();
    if ( stop_index <= start_index ) {
        NCBI_THROW(CException, eUnknown, "Invalid interval limits");
    }
    const size_t length = stop_index-start_index+1;
    return length;
}


string CAaInterval::GetString(void) const
{
    const auto start_residue = GetStart().GetAa();
    const auto stop_residue = GetStop().GetAa();
    return start_residue + ".." + stop_residue;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1766, CRC32: dbe74b6e */
