/* $Id: PmcID.hpp 498065 2016-04-12 22:14:52Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PmcID.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: PmcID_.hpp


#ifndef OBJECTS_BIBLIO_PMCID_HPP
#define OBJECTS_BIBLIO_PMCID_HPP


// generated includes
#include <objects/biblio/PmcID_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIBLIO_EXPORT CPmcID : public CPmcID_Base
{
    typedef CPmcID_Base Tparent;
public:
    CPmcID(void) {}

    /// Explicit constructor from the primitive type.
    explicit CPmcID(const ncbi::TEntrezId& data)
        : Tparent(data) {}

#ifdef NCBI_STRICT_ENTREZ_ID
    /// Explicit constructor from zero.
    explicit CPmcID(std::nullptr_t zero)
        : Tparent((TIntId)0) {}
#endif
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_PMCID_HPP
/* Original file checksum: lines: 70, chars: 2135, CRC32: dbe555d8 */
