/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .SUMMARY:
//  Define DrawingPriority class
//
// .DESCRIPTION
//
// .SEE ALSO
//
//

#ifndef DrawingPriority_H
#define DrawingPriority_H

#include <set>
#include <map>

class ObjectInfo;

class DrawingPriority
{
public:
    // Constructors
    DrawingPriority();

    // Destructor
    ~DrawingPriority();

    // Methods
    int Priority(MvRequest&);
    void SetPriority(MvRequest&);
    int GetPriority(string);

    string DescribeYourself(ObjectInfo&, string);

    Cached DrawSegmentName(int, MvRequest&, int);

private:
    // No copy allowed
    //DrawingPriority ( const DrawingPriority& );
    DrawingPriority& operator=(const DrawingPriority&)
    {
        return *this;
    }

    int IsValidKey(string);

    // Members
    std::set<string> mySet_;
    std::map<string, int> myMap_;
};

#endif
