#include <algorithm>
#include <vector>

#include "atlas/array.h"
#include "atlas/grid.h"
#include "atlas/option.h"
#include "atlas/util/Config.h"
#include "tests/AtlasTestEnvironment.h"

using namespace atlas::util;
using namespace atlas::grid;

namespace {

const double lonlat_arp_t32c24[] = {
    2.00000000000000000,    48.46708828700425187,  1.17799068975270704,    48.37772379915030996,
    0.44418972240584109,    48.11926090196744354,  -0.12512266986032569,   47.71926346185548340,
    -0.47479391972813606,   47.21956618120344018,  -0.57569351104372468,   46.67109320702403608,
    -0.42528132740345748,   46.12813070368466839,  -0.04494770792091035,   45.64287023699112211,
    0.52444137510688571,    45.26073815098433784,  1.22762737065264282,    45.01674523281888440,
    2.00000000000000000,    44.93291171299576092,  2.77237262934735629,    45.01674523281888440,
    3.47555862489311407,    45.26073815098433784,  4.04494770792090996,    45.64287023699112211,
    4.42528132740345725,    46.12813070368466839,  4.57569351104372490,    46.67109320702403608,
    4.47479391972813634,    47.21956618120344018,  4.12512266986032561,    47.71926346185548340,
    3.55581027759415846,    48.11926090196744354,  2.82200931024729318,    48.37772379915030996,
    2.00000000000000000,    50.76274729016172671,  0.52357145823104279,    50.64425941434981837,
    -0.85309402263029532,   50.29690558565773273,  -2.04123891610972796,   49.74407157963349846,
    -2.97152383528954323,   49.02183412771946536,  -3.59837298636155323,   48.17535393470686955,
    -3.90029306374494222,   47.25496955383284359,  -3.87730059701688790,   46.31256836954069911,
    -3.54692456688646551,   45.39855083314470363,  -2.93998927128814502,   44.55946699558614910,
    -2.09688983996385936,   43.83625800397906147,  -1.06462721424400342,   43.26298044031561574,
    0.10541754825032876,    42.86589673132546352,  1.35912400589531490,    42.66284629701862485,
    2.64087599410468910,    42.66284629701862485,  3.89458245174967033,    42.86589673132546352,
    5.06462721424400453,    43.26298044031561574,  6.09688983996385936,    43.83625800397906147,
    6.93998927128814458,    44.55946699558614910,  7.54692456688646551,    45.39855083314470363,
    7.87730059701688656,    46.31256836954069911,  7.90029306374494134,    47.25496955383284359,
    7.59837298636155190,    48.17535393470686955,  6.97152383528954367,    49.02183412771946536,
    6.04123891610972930,    49.74407157963349846,  4.85309402263029188,    50.29690558565773273,
    3.47642854176895577,    50.64425941434981837,  2.00000000000000089,    53.08763788054714894,
    -0.06435502534210064,   52.94800110445672203,  -2.01378910799337474,   52.53707313311167582,
    -3.74622775989939782,   51.87782553848720113,  -5.18197003975669812,   51.00557820511744467,
    -6.26810804950859701,   49.96440199105025926,  -6.97806564551988018,   48.80336562297891589,
    -7.30784824781774223,   47.57322688923063225,  -7.27090590027329053,   46.32385288536406875,
    -6.89307303713296715,   45.10238649522262477,  -6.20837670733706215,   43.95202523375940729,
    -5.25594876339865014,   42.91123363953519743,  -4.07794770476515911,   42.01322983391511201,
    -2.71826031811739588,   41.28563184510834105,  -1.22173788476928480,   40.75019560382368411,
    0.36623707967922525,    40.42261301497919845,  1.99999999999999933,    40.31236211945285675,
    3.63376292032077286,    40.42261301497919845,  5.22173788476928369,    40.75019560382368411,
    6.71826031811739455,    41.28563184510834105,  8.07794770476515822,    42.01322983391511201,
    9.25594876339864925,    42.91123363953519743,  10.20837670733705949,   43.95202523375940729,
    10.89307303713296804,   45.10238649522262477,  11.27090590027328965,   46.32385288536406875,
    11.30784824781774311,   47.57322688923063225,  10.97806564551988195,   48.80336562297891589,
    10.26810804950859790,   49.96440199105025926,  9.18197003975669901,    51.00557820511744467,
    7.74622775989939960,    51.87782553848720113,  6.01378910799337607,    52.53707313311167582,
    4.06435502534210169,    52.94800110445672203,  2.00000000000000089,    55.44054043583248159,
    -0.39391037845720578,   55.31115535850048559,  -2.68766853851381882,   54.92865613654313961,
    -4.79116029542177202,   54.30937174533021050,  -6.63193584333677855,   53.47856301011842106,
    -8.15903975007321769,   52.46802323745790630,  -9.34306219743110411,   51.31353838046217675,
    -10.17346129570704782,  50.05261748260089405,  -10.65454278958191026,  48.72271255422421632,
    -10.80126342211737800,  47.35996933207513848,  -10.63557388477568999,  45.99843704779454612,
    -10.18359521918176824,  44.66961909752426152,  -9.47363915243209931,   43.40224634648851065,
    -8.53494002107633598,   42.22217718966415845,  -7.39692139773956647,   41.15235690381517486,
    -6.08882962579569487,   40.21279467492543347,  -4.63959771096107954,   39.42053684981195261,
    -3.07783882564465205,   38.78962916423042628,  -1.43190111561111988,   38.33106975566338548,
    0.27005804914242593,    38.05275970261258323,  1.99999999999999956,    37.95945956416753120,
    3.72994195085757241,    38.05275970261258323,  5.43190111561111788,    38.33106975566338548,
    7.07783882564465028,    38.78962916423042628,  8.63959771096107865,    39.42053684981195261,
    10.08882962579569309,   40.21279467492543347,  11.39692139773956647,   41.15235690381517486,
    12.53494002107633243,   42.22217718966415845,  13.47363915243209576,   43.40224634648851065,
    14.18359521918176824,   44.66961909752426152,  14.63557388477568999,   45.99843704779454612,
    14.80126342211737445,   47.35996933207513848,  14.65454278958191381,   48.72271255422421632,
    14.17346129570704782,   50.05261748260089405,  13.34306219743110766,   51.31353838046217675,
    12.15903975007321769,   52.46802323745790630,  10.63193584333677855,   53.47856301011842106,
    8.79116029542177380,    54.30937174533021050,  6.68766853851382059,    54.92865613654313961,
    4.39391037845720867,    55.31115535850048559,  2.00000000000000222,    57.82915094012270174,
    -0.88089731877775757,   57.69078537163564846,  -3.64890062321652664,   57.28147795233979167,
    -6.20331014929099656,   56.61787273415653488,  -8.46463908845755597,   55.72551502002679058,
    -10.37873026754043693,  54.63620962052475960,  -11.91616209561276740,  53.38530347804498888,
    -13.06845153476416321,  52.00935252683229493,  -13.84288249522568925,  50.54439040009851425,
    -14.25738892575702366,  49.02480894996942595,  -14.33628744864260440,  47.48274104170999976,
    -14.10711920596712332,  45.94779768044404733,  -13.59853603019004176,  44.44702279967973624,
    -12.83902541924944174,  43.00496062724707258,  -11.85624296375186937,  41.64376435793402464,
    -10.67674963753560036,  40.38330297070848474,  -9.32599718132065902,   39.24124360712294646,
    -7.82844927012504055,   38.23310085983992224,  -6.20776260081896769,   37.37225322309888043,
    -4.48697963071903061,   36.66993230518373537,  -2.68870484500073204,   36.13519327177002793,
    -0.83525097543211291,   35.77487607444932394,  1.05124791602986001,    35.59356675116022473,
    2.94875208397013866,    35.59356675116022473,  4.83525097543211047,    35.77487607444932394,
    6.68870484500073026,    36.13519327177002793,  8.48697963071903061,    36.66993230518373537,
    10.20776260081896680,   37.37225322309888043,  11.82844927012503966,   38.23310085983992224,
    13.32599718132065725,   39.24124360712293225,  14.67674963753560391,   40.38330297070848474,
    15.85624296375187114,   41.64376435793402464,  16.83902541924944174,   43.00496062724707258,
    17.59853603019003998,   44.44702279967973624,  18.10711920596712687,   45.94779768044404733,
    18.33628744864260796,   47.48274104170998555,  18.25738892575703076,   49.02480894996942595,
    17.84288249522569458,   50.54439040009851425,  17.06845153476416499,   52.00935252683229493,
    15.91616209561277273,   53.38530347804498888,  14.37873026754043870,   54.63620962052475960,
    12.46463908845756130,   55.72551502002679058,  10.20331014929099922,   56.61787273415653488,
    7.64890062321653019,    57.28147795233979167,  4.88089731877776067,    57.69078537163564846,
    2.00000000000000222,    60.26295411645657651,  -1.52099396835736300,   60.10440004572244277,
    -4.89637618755807136,   59.63591573610307250,  -7.99912115224313958,   58.87795079119066344,
    -10.73370655373201643,  57.86135900031617751,  -13.04067793585433499,  56.62367212326139310,
    -14.89384545876526111,  55.20548791890712437,  -16.29319722451073105,  53.64760968250063655,
    -17.25667322722224029,  51.98914605534769606,  -17.81285996059914467,  50.26647329190694080,
    -17.99546453290829007,  48.51282952087984768,  -17.83961562141898938,  46.75830290430587155,
    -17.37966075266355759,  45.03002540480565585,  -16.64804001511417297,  43.35244484209054860,
    -15.67486490585672243,  41.74759899443786537,  -14.48792157318536411,  40.23535159216241652,
    -13.11290455740948957,  38.83357308646102979,  -11.57375501535206475,  37.55826279697890158,
    -9.89302536639832653,   36.42361680044041350,  -8.09222434325374884,   35.44205010622848562,
    -6.19211732580419838,   34.62418375193039566,  -4.21297051898843300,   33.97880825794451454,
    -2.17473678976558649,   33.51283479810019372,  -0.09718755711549092,   33.23124463343540214,
    1.99999999999999889,    33.13704588354342917,  4.09718755711548877,    33.23124463343540214,
    6.17473678976558382,    33.51283479810019372,  8.21297051898843122,    33.97880825794451454,
    10.19211732580419572,   34.62418375193039566,  12.09222434325374707,   35.44205010622848562,
    13.89302536639832830,   36.42361680044041350,  15.57375501535206297,   37.55826279697889447,
    17.11290455740948602,   38.83357308646102268,  18.48792157318536766,   40.23535159216240942,
    19.67486490585671888,   41.74759899443786537,  20.64804001511417653,   43.35244484209054860,
    21.37966075266355404,   45.03002540480565585,  21.83961562141898582,   46.75830290430587155,
    21.99546453290829007,   48.51282952087984768,  21.81285996059914822,   50.26647329190694080,
    21.25667322722224739,   51.98914605534769606,  20.29319722451073105,   53.64760968250062234,
    18.89384545876525934,   55.20548791890712437,  17.04067793585434032,   56.62367212326139310,
    14.73370655373202354,   57.86135900031617751,  11.99912115224314491,   58.87795079119066344,
    8.89637618755807580,    59.63591573610307250,  5.52099396835736744,    60.10440004572244277,
    2.00000000000000222,    62.75242980718265784,  -1.60371952785031557,   62.62270582496653049,
    -5.08984714396560278,   62.23829052070698253,  -8.35401191716921510,   61.61281120273996237,
    -11.31471471060360656,  60.76704034614787986,  -13.91751559979281083,  59.72658657388572578,
    -16.13405311103923978,  58.51955862209560166,  -17.95764487214750815,  57.17460858105235388,
    -19.39751805719553701,  55.71953428872550518,  -20.47321926655622448,  54.18043392376822709,
    -21.21002592824931199,  52.58130404832083116,  -21.63559425749199150,  50.94394459368972150,
    -21.77773936992417703,  49.28804930270956675,  -21.66310777053267600,  47.63139077670034283,
    -21.31648826424519072,  45.99003977573201496,  -20.76054697060167342,  44.37858250245571412,
    -20.01582559662803007,  42.81031632956308641,  -19.10089088783405842,  41.29741507659190347,
    -18.03256121225549791,  39.85106125278488065,  -16.82616341777592339,  38.48154618161254348,
    -15.49579145727241247,  37.19834072287546434,  -14.05455017155123087,  36.01014014726423795,
    -12.51477509868480809,  34.92488704934376642,  -10.88822378743807739,  33.94977626735131793,
    -9.18623692372254119,   33.09124574576954103,  -7.41986936545087783,   32.35495718584156322,
    -5.59999239238874669,   31.74577019145995394,  -3.73736939611796615,   31.26771342119434749,
    -1.84270801296844233,   30.92395598105918353,  0.07330759755401026,    30.71678191817960268,
    1.99999999999999889,    30.64757019281734074,  3.92669240244598639,    30.71678191817960268,
    5.84270801296843878,    30.92395598105918353,  7.73736939611796526,    31.26771342119434749,
    9.59999239238874225,    31.74577019145995394,  11.41986936545087516,   32.35495718584156322,
    13.18623692372254119,   33.09124574576954103,  14.88822378743807207,   33.94977626735131793,
    16.51477509868480809,   34.92488704934376642,  18.05455017155123087,   36.01014014726423795,
    19.49579145727241070,   37.19834072287546434,  20.82616341777592339,   38.48154618161253637,
    22.03256121225549791,   39.85106125278488065,  23.10089088783405842,   41.29741507659190347,
    24.01582559662803007,   42.81031632956308641,  24.76054697060167342,   44.37858250245571412,
    25.31648826424519072,   45.99003977573201496,  25.66310777053267600,   47.63139077670033572,
    25.77773936992417703,   49.28804930270955964,  25.63559425749199505,   50.94394459368972150,
    25.21002592824931199,   52.58130404832083116,  24.47321926655622448,   54.18043392376822709,
    23.39751805719553701,   55.71953428872550518,  21.95764487214750460,   57.17460858105235388,
    20.13405311103924333,   58.51955862209560166,  17.91751559979281438,   59.72658657388572578,
    15.31471471060361011,   60.76704034614787986,  12.35401191716921865,   61.61281120273996237,
    9.08984714396560634,    62.23829052070698253,  5.60371952785031979,    62.62270582496653049,
    2.00000000000000311,    65.30899890463146562,  -2.55165837938126616,   65.14506774788591770,
    -6.91821393310037980,   64.66099291349783584,  -10.94248311853021427,  63.87850997409253040,
    -14.51323316925390294,  62.82970044453450953,  -17.56939664790982292,  61.55243525845713748,
    -20.09325961331439458,  60.08625295311978931,  -22.09844461997003506,  58.46939890910893922,
    -23.61769060836897438,  56.73712764036461920,  -24.69307609487012556,  54.92100894435518654,
    -25.36933297612858951,  53.04888396821036167,  -25.68983696232584535,  51.14517010976478417,
    -25.69453569648834801,  49.23130925676766623,  -25.41912613625677153,  47.32623888788154431,
    -24.89496528133907205,  45.44682484300304282,  -24.14937074714975296,  43.60823042135866956,
    -23.20610004359021517,  41.82421587722975431,  -22.08588698105332782,  40.10737174655498194,
    -20.80696969977402944,  38.46929323359992736,  -19.38557795842460507,  36.92070387379718710,
    -17.83636590786354148,  35.47153642700349963,  -16.17278641740254130,  34.13097826525054046,
    -14.40740784814351017,  32.90748779465315721,  -12.55217628249286932,  31.80878785141789677,
    -10.61862699669389443,  30.84184157026976436,  -8.61804920168179045,   30.01281590885307438,
    -6.56160821625925728,   29.32703776203888069,  -4.46042949045145676,   28.78894734383437992,
    -2.32564933647368921,   28.40205318377053345,  -0.16843782661930862,   28.16889262543881500,
    1.99999999999999889,    28.09100109536852585,  4.16843782661930629,    28.16889262543881500,
    6.32564933647368743,    28.40205318377053345,  8.46042949045145498,    28.78894734383437992,
    10.56160821625925372,   29.32703776203888069,  12.61804920168178867,   30.01281590885307438,
    14.61862699669389265,   30.84184157026976436,  16.55217628249286577,   31.80878785141789677,
    18.40740784814351017,   32.90748779465315721,  20.17278641740253775,   34.13097826525054046,
    21.83636590786353793,   35.47153642700349963,  23.38557795842460152,   36.92070387379718710,
    24.80696969977402588,   38.46929323359992026,  26.08588698105332426,   40.10737174655498194,
    27.20610004359021161,   41.82421587722975431,  28.14937074714974941,   43.60823042135866956,
    28.89496528133906494,   45.44682484300304282,  29.41912613625676798,   47.32623888788153721,
    29.69453569648834446,   49.23130925676766623,  29.68983696232584180,   51.14517010976478417,
    29.36933297612858951,   53.04888396821034746,  28.69307609487012911,   54.92100894435518654,
    27.61769060836897438,   56.73712764036461920,  26.09844461997003506,   58.46939890910893922,
    24.09325961331439814,   60.08625295311978931,  21.56939664790982292,   61.55243525845713748,
    18.51323316925390827,   62.82970044453450953,  14.94248311853021960,   63.87850997409253040,
    10.91821393310038779,   64.66099291349783584,  6.55165837938127193,    65.14506774788591770,
    2.00000000000000400,    67.94514236453578349,  -3.38533547682125890,   67.76325974975715383,
    -8.52326664933801226,   67.22759281764989225,  -13.21138564172178143,  66.36584339331807314,
    -17.31841683118042496,  65.21781824976642383,  -20.78586461017365750,  63.82887077001763032,
    -23.61278608277912383,  62.24449065808524040,  -25.83517004248913196,  60.50690475312734407,
    -27.50782877801382043,  58.65352526302899605,  -28.69170289014789077,  56.71665696607985296,
    -29.44632120220701665,  54.72388646563504011,  -29.82602201650912477,  52.69875031809839783,
    -29.87852862440772839,  50.66145188613276673,  -29.64483525740958925,  48.62951713112133945,
    -29.15973753507462618,  46.61834908938176625,  -28.45262246278107554,  44.64167567492752653,
    -27.54831327014242959,  42.71190039889389567,  -26.46787020033523774,  40.84037031204417190,
    -25.22930648122764552,  39.03757551632936185,  -23.84820859564655038,  37.31329283883029291,
    -22.33826403031283903,  35.67668409468497970,  -20.71170528699355629,  34.13635737784334623,
    -18.97968026705781242,  32.70039821822412307,  -17.15255849246134900,  31.37637626233231813,
    -15.24018123567453742,  30.17133232687284305,  -13.25206214192900944,  29.09175016726920759,
    -11.19754366142445079,  28.14351701208745027,  -9.08591371200913400,   27.33187675649334381,
    -6.92648650789847675,   26.66137960320710931,  -4.72865139696445702,   26.13583181560235502,
    -2.50189378344492486,   25.75824904385734371,  -0.25579267831605296,   25.53081635683327733,
    1.99999999999999889,    25.45485763546421154,  4.25579267831605002,    25.53081635683327733,
    6.50189378344492308,    25.75824904385734371,  8.72865139696445347,    26.13583181560235502,
    10.92648650789847764,   26.66137960320710931,  13.08591371200913400,   27.33187675649334381,
    15.19754366142444724,   28.14351701208745027,  17.25206214192900589,   29.09175016726920759,
    19.24018123567453742,   30.17133232687284305,  21.15255849246134545,   31.37637626233231813,
    22.97968026705781242,   32.70039821822412307,  24.71170528699354918,   34.13635737784334623,
    26.33826403031282837,   35.67668409468497259,  27.84820859564654683,   37.31329283883029291,
    29.22930648122764197,   39.03757551632935474,  30.46787020033523419,   40.84037031204417190,
    31.54831327014242248,   42.71190039889389567,  32.45262246278107199,   44.64167567492752653,
    33.15973753507462618,   46.61834908938176625,  33.64483525740958214,   48.62951713112133945,
    33.87852862440772839,   50.66145188613276673,  33.82602201650912122,   52.69875031809839783,
    33.44632120220701665,   54.72388646563502590,  32.69170289014788011,   56.71665696607985296,
    31.50782877801381687,   58.65352526302899605,  29.83517004248913906,   60.50690475312734407,
    27.61278608277913094,   62.24449065808524040,  24.78586461017366460,   63.82887077001763032,
    21.31841683118043562,   65.21781824976642383,  17.21138564172179031,   66.36584339331807314,
    12.52326664933801936,   67.22759281764989225,  7.38533547682126645,    67.76325974975715383,
    2.00000000000000488,    70.67459026401789401,  -4.83336207267744200,   70.44359392189112157,
    -11.25145387811900299,  69.76794994271870110,  -16.94303945184942606,  68.69426490502790728,
    -21.74696599568290978,  67.28571148577093197,  -25.63456841105837825,  65.60910965714572285,
    -28.66225471925319823,  63.72633555655123416,  -30.92626834358740595,  61.69055635034530383,
    -32.53242307522426557,  59.54571651024583190,  -33.58017141013023377,  57.32758829402004608,
    -34.15616674923442986,  55.06530104282313687,  -34.33296113360040636,  52.78282385843581892,
    -34.17004600591189956,  50.50021197832979425,  -33.71572773969587900,  48.23458650173874673,
    -33.00911969333094476,  46.00087796034757304,  -32.08195470333168231,  43.81237943576640248,
    -30.96012666362175025,  41.68115224019865650,  -29.66495985223924237,  39.61831917500947498,
    -28.21423852322426740,  37.63427208010365632,  -26.62303747247054986,  35.73881343521247089,
    -24.90439178940930276,  33.94124647006630369,  -23.06983782140640216,  32.25042441190934994,
    -21.12985059268007149,  30.67476685924403057,  -19.09419678103115459,  29.22224954465700009,
    -16.97221728412494457,  27.90037270541385794,  -14.77304947679039238,  26.71611272875198750,
    -12.50579641562138100,  25.67586152120415832,  -10.17964838758363832,  24.78535803035031648,
    -7.80396120930039583,   24.04961640006232315,  -5.38829543151647705,   23.47285525677743223,
    -2.94242093509331726,   23.05843251151437201,  -0.47629214130109782,   22.80878975038074685,
    1.99999999999999800,    22.72540973598210812,  4.47629214130109521,    22.80878975038074685,
    6.94242093509331326,    23.05843251151437201,  9.38829543151647350,    23.47285525677743223,
    11.80396120930039316,   24.04961640006232315,  14.17964838758363655,   24.78535803035031648,
    16.50579641562137567,   25.67586152120415832,  18.77304947679039060,   26.71611272875198750,
    20.97221728412493746,   27.90037270541385439,  23.09419678103115103,   29.22224954465700009,
    25.12985059268006793,   30.67476685924402702,  27.06983782140639860,   32.25042441190934994,
    28.90439178940930631,   33.94124647006630369,  30.62303747247054275,   35.73881343521246379,
    32.21423852322426029,   37.63427208010365632,  33.66495985223924237,   39.61831917500946787,
    34.96012666362174315,   41.68115224019865650,  36.08195470333167520,   43.81237943576640248,
    37.00911969333093765,   46.00087796034757304,  37.71572773969587189,   48.23458650173873252,
    38.17004600591188535,   50.50021197832979425,  38.33296113360039925,   52.78282385843581892,
    38.15616674923441565,   55.06530104282313687,  37.58017141013023377,   57.32758829402004608,
    36.53242307522427268,   59.54571651024581769,  34.92626834358741661,   61.69055635034530383,
    32.66225471925319823,   63.72633555655123416,  29.63456841105838535,   65.60910965714572285,
    25.74696599568291333,   67.28571148577093197,  20.94303945184943316,   68.69426490502790728,
    15.25145387811901188,   69.76794994271870110,  8.83336207267745088,    70.44359392189112157,
    2.00000000000000622,    73.51255823132638056,  -6.80643587234800940,   73.21444539538327945,
    -14.87413258170036379,  72.35214877025040892,  -21.72462936947633594,  71.00751554077180572,
    -27.20553396293055215,  69.28213523998356038,  -31.39257932570032139,  67.27265449907143591,
    -34.46283411458643542,  65.05952649321666570,  -36.61111913565843423,  62.70556553816149403,
    -38.01204327449661236,  60.25870541573158334,  -38.80901819915838047,  57.75559962131574565,
    -39.11518954384546731,  55.22475594928482678,  -39.01828312042780311,  52.68892136253921876,
    -38.58594887503603132,  50.16679739569313057,  -37.87042151784342536,  47.67424596736638875,
    -36.91224672041000332,  45.22513042719018728,  -35.74315247327934486,  42.83190113242096686,
    -34.38823113470312620,  40.50600232791481403,  -32.86759479425492714,  38.25815259440047811,
    -31.19763777135731431,  36.09853399317181299,  -29.39200856069424006,  34.03691345955112979,
    -27.46236656888655148,  32.08271233019573287,  -25.41897786066869003,  30.24503490367625247,
    -23.27118821325056430,  28.53266378578365448,  -21.02780000980340347,  26.95402789495273055,
    -18.69737092792362887,  25.51714801636046559,  -16.28844626261447814,  24.22956442487017625,
    -13.80973254683687124,  23.09825113914620331,  -11.27021753707410845,  22.12952164603582617,
    -8.67924035399200910,   21.32893128539883065,  -6.04651538477557082,   20.70118176192879744,
    -3.38211423303386649,   20.25003331964319386,  -0.69641128035122979,   19.97822987242789239,
    1.99999999999999756,    19.88744176867360025,  4.69641128035122613,    19.97822987242789239,
    7.38211423303386205,    20.25003331964319386,  10.04651538477556727,   20.70118176192879744,
    12.67924035399200378,   21.32893128539883065,  15.27021753707410667,   22.12952164603582617,
    17.80973254683686946,   23.09825113914620331,  20.28844626261447814,   24.22956442487017270,
    22.69737092792362532,   25.51714801636046559,  25.02780000980339992,   26.95402789495272700,
    27.27118821325056786,   28.53266378578365448,  29.41897786066868292,   30.24503490367624536,
    31.46236656888655503,   32.08271233019573287,  33.39200856069423651,   34.03691345955112979,
    35.19763777135730720,   36.09853399317180589,  36.86759479425493424,   38.25815259440047811,
    38.38823113470313331,   40.50600232791481403,  39.74315247327934486,   42.83190113242095975,
    40.91224672041000332,   45.22513042719018728,  41.87042151784342536,   47.67424596736638165,
    42.58594887503603132,   50.16679739569313057,  43.01828312042781022,   52.68892136253921876,
    43.11518954384546731,   55.22475594928482678,  42.80901819915838757,   57.75559962131573144,
    42.01204327449661946,   60.25870541573157624,  40.61111913565844134,   62.70556553816149403,
    38.46283411458643542,   65.05952649321666570,  35.39257932570031784,   67.27265449907143591,
    31.20553396293055926,   69.28213523998356038,  25.72462936947633949,   71.00751554077180572,
    18.87413258170037267,   72.35214877025040892,  10.80643587234802361,   73.21444539538327945,
    2.00000000000000844,    76.47602837656471308,  -9.67376613190775814,   76.07990221077976400,
    -19.91726594386999949,  74.95625177955801632,  -28.02735732207738550,  73.25702648451857613,
    -34.02194152863378918,  71.14627956201684356,  -38.25028545833758642,  68.75766348420627594,
    -41.10709162054251209,  66.18773615332521842,  -42.92334661203305757,  63.50367340927638793,
    -43.94927569193657035,  60.75248226909388904,  -44.36709840828364548,  57.96800639328736793,
    -44.30826862884845241,  55.17560336970880286,  -43.86791757533286074,  52.39514197266055362,
    -43.11549450115907689,  49.64291142290011294,  -42.10226597817306526,  46.93284831506371546,
    -40.86653894639825779,  44.27733603455973110,  -39.43731045663169965,  41.68773239540036002,
    -37.83684688715485578,  39.17472027603687934,  -36.08253581911941410,  36.74853923728758076,
    -34.18824090805679816,  34.41913389699746517,  -32.16531367916817885,  32.19624133969532664,
    -30.02336509370288198,  30.08943159705432890,  -27.77086550998262382,  28.10811023218007776,
    -25.41561850057673411,  26.26148912292403992,  -22.96513811238918379,  24.55852997196868515,
    -20.42694818201796281,  23.00786444863284785,  -17.80881477377849720,  21.61769490666709714,
    -15.11891780975726896,  20.39568010883170501,  -12.36596498789072740,  19.34881113120014717,
    -9.55924980839402672,   18.48328342761256593,  -6.70865569654629645,   17.80437171431731613,
    -3.82460955068694286,   17.31631470128239414,  -0.91799021933643277,   17.02221659443388191,
    1.99999999999999756,    16.92397162343524286,  4.91799021933642866,    17.02221659443388191,
    7.82460955068693664,    17.31631470128239414,  10.70865569654629290,   17.80437171431731613,
    13.55924980839402139,   18.48328342761256593,  16.36596498789072740,   19.34881113120014717,
    19.11891780975726363,   20.39568010883170501,  21.80881477377850075,   21.61769490666709714,
    24.42694818201795925,   23.00786444863284430,  26.96513811238918024,   24.55852997196867804,
    29.41561850057672345,   26.26148912292403637,  31.77086550998261671,   28.10811023218007065,
    34.02336509370287132,   30.08943159705432180,  36.16531367916817885,   32.19624133969532664,
    38.18824090805679106,   34.41913389699745807,  40.08253581911941410,   36.74853923728758076,
    41.83684688715484867,   39.17472027603687934,  43.43731045663169255,   41.68773239540036002,
    44.86653894639826490,   44.27733603455973110,  46.10226597817306526,   46.93284831506371546,
    47.11549450115907689,   49.64291142290011294,  47.86791757533286784,   52.39514197266055362,
    48.30826862884845951,   55.17560336970880286,  48.36709840828365259,   57.96800639328736793,
    47.94927569193657746,   60.75248226909387483,  46.92334661203305757,   63.50367340927638793,
    45.10709162054252630,   66.18773615332521842,  42.25028545833760063,   68.75766348420627594,
    38.02194152863379628,   71.14627956201684356,  32.02735732207738550,   73.25702648451857613,
    23.91726594387000659,   74.95625177955801632,  13.67376613190777590,   76.07990221077976400,
    2.00000000000001155,    79.58407807962322522,  -14.24038894313819092,  79.03039199474196153,
    -27.34759503822197502,  77.51867325981696411,  -36.54693285975560713,  75.34972495190746145,
    -42.57629367046713753,  72.78039612779681988,  -46.37308749001456221,  69.97672254379963874,
    -48.64383991815974895,  67.03853932314146391,  -49.85773173662808233,  64.02688869849654907,
    -50.31863539857851464,  60.98111330635318694,  -50.22511448054331140,  57.92830381592441569,
    -49.70950811496560107,  54.88845672164920586,  -48.86197695521289575,  51.87735585154322138,
    -47.74524369263553325,  48.90823812634897649,  -46.40377244059971673,  45.99279145534946167,
    -44.86961926381133026,  43.14177213432515856,  -43.16626004327478228,  40.36539642075791789,
    -41.31116510791174079,  37.67359181604234664,  -39.31758136998610098,  35.07615645611910082,
    -37.19580324741198041,  32.58285444844916867,  -34.95410730493897233,  30.20346328869343466,
    -32.59946098845734497,  27.94778271439298933,  -30.13807554901531915,  25.82561045671564770,
    -27.57584735879238025,  23.84668824688734645,  -24.91871466466540852,  22.02062053097340311,
    -22.17294518233925871,  20.35676830949395466,  -19.34536199373425802,  18.86412113035556004,
    -16.44350999615492270,  17.55115134744557182,  -13.47576217013061850,  16.42565612762181360,
    -10.45136393475438830,  15.49459412897927280,  -7.38041466390653600,   14.76392503362292707,
    -4.27378779825515664,   14.23846093632396936,  -1.14299451095196525,   13.92173872937387458,
    1.99999999999999756,    13.81592192037676980,  5.14299451095195970,    13.92173872937387458,
    8.27378779825515132,    14.23846093632396936,  11.38041466390652978,   14.76392503362292707,
    14.45136393475438119,   15.49459412897927280,  17.47576217013061495,   16.42565612762181360,
    20.44350999615491560,   17.55115134744557182,  23.34536199373425447,   18.86412113035556004,
    26.17294518233925515,   20.35676830949395466,  28.91871466466540852,   22.02062053097340311,
    31.57584735879237314,   23.84668824688734645,  34.13807554901531205,   25.82561045671564415,
    36.59946098845733786,   27.94778271439298933,  38.95410730493897233,   30.20346328869342756,
    41.19580324741196620,   32.58285444844916867,  43.31758136998610098,   35.07615645611910082,
    45.31116510791174079,   37.67359181604234664,  47.16626004327477517,   40.36539642075791789,
    48.86961926381131605,   43.14177213432515856,  50.40377244059970963,   45.99279145534945457,
    51.74524369263552614,   48.90823812634896228,  52.86197695521290285,   51.87735585154322138,
    53.70950811496559396,   54.88845672164920586,  54.22511448054331140,   57.92830381592441569,
    54.31863539857851464,   60.98111330635318694,  53.85773173662808233,   64.02688869849654907,
    52.64383991815974895,   67.03853932314146391,  50.37308749001457642,   69.97672254379963874,
    46.57629367046714464,   72.78039612779681988,  40.54693285975561423,   75.34972495190746145,
    31.34759503822198212,   77.51867325981696411,  18.24038894313820691,   79.03039199474196153,
    2.00000000000001998,    82.85826214470431239,  -22.58690897303193523,  82.01033616765489853,
    -38.96575654499159924,  79.88802174923017674,  -48.17735288037921038,  77.11452529323827321,
    -53.18593275925196195,  74.03707888623914357,  -55.81801935702030448,  70.81486693953937106,
    -57.03453256694833584,  67.52503657439315532,  -57.35114187047393841,  64.20957103321012482,
    -57.05957379451162126,  60.89430451319173443,  -56.33378767939932885,  57.59709162031844443,
    -55.28230228211860009,  54.33161333463023368,  -53.97533567047437231,  51.10929358481432416,
    -52.45964870701570248,  47.94033352757975308,  -50.76707508825830928,  44.83430401955754974,
    -48.91964996438991875,  41.80050199367043007,  -46.93282539675249154,  38.84817223653459450,
    -44.81756887288366897,  35.98664677769215103,  -42.58178882927894193,  33.22542941501406233,
    -40.23134383513492196,  30.57423988556289629,  -37.77078829775713587,  28.04302503644353806,
    -35.20394762734520100,  25.64194033091114022,  -32.53437968696509586,  23.38130282889364508,
    -29.76575655354334771,  21.27151577227776258,  -26.90218550361062810,  19.32296477964254322,
    -23.94847769357362566,  17.54588626406437513,  -20.91036566952359976,  15.95020993686824795,
    -17.79466590782826074,  14.54537904344352306,  -14.60937983520193661,  13.34015413091371371,
    -11.36372621835939434,  12.34240842556757833,  -8.06809948196382720,   11.55892497220584580,
    -4.73395228112668587,   10.99520717814031734,  -1.37360609917944543,   10.65531494200142504,
    1.99999999999999756,    10.54173785529561336,  5.37360609917944032,    10.65531494200142504,
    8.73395228112667965,    10.99520717814031734,  12.06809948196382187,   11.55892497220584580,
    15.36372621835939078,   12.34240842556757833,  18.60937983520193484,   13.34015413091371371,
    21.79466590782825364,   14.54537904344352306,  24.91036566952359621,   15.95020993686824795,
    27.94847769357362210,   17.54588626406437513,  30.90218550361061745,   19.32296477964254322,
    33.76575655354334060,   21.27151577227776258,  36.53437968696508875,   23.38130282889363798,
    39.20394762734519389,   25.64194033091114022,  41.77078829775712165,   28.04302503644353095,
    44.23134383513491485,   30.57423988556289629,  46.58178882927893483,   33.22542941501406233,
    48.81756887288366187,   35.98664677769215103,  50.93282539675248444,   38.84817223653458029,
    52.91964996438991164,   41.80050199367041586,  54.76707508825830928,   44.83430401955754263,
    56.45964870701569538,   47.94033352757973887,  57.97533567047437231,   51.10929358481431706,
    59.28230228211859298,   54.33161333463023368,  60.33378767939932885,   57.59709162031844443,
    61.05957379451161415,   60.89430451319173443,  61.35114187047394552,   64.20957103321012482,
    61.03453256694833584,   67.52503657439315532,  59.81801935702030448,   70.81486693953937106,
    57.18593275925196906,   74.03707888623914357,  52.17735288037921038,   77.11452529323827321,
    42.96575654499162056,   79.88802174923017674,  26.58690897303196721,   82.01033616765489853,
    2.00000000000004352,    86.32305404620944955,  -41.28583165458979920,  84.76914638163376026,
    -57.58131858106001744,  81.70467639663135628,  -63.56415050352948981,  78.26774990878784877,
    -65.82714145548160900,  74.71983727667711150,  -66.41516373728856593,  71.13755089586129543,
    -66.11115128919476547,  67.55274433031233627,  -65.27043361461275595,  63.98289851135272244,
    -64.07470870335011170,  60.43992354246546483,  -62.62500642980751309,  56.93332642202356197,
    -60.98089250042357889,  53.47155025248752480,  -59.17889520468775544,  50.06261728049957327,
    -57.24193904387428233,  46.71447239476329827,  -55.18452370168171939,  43.43518400478754415,
    -53.01574257648425004,  40.23307020728445593,  -50.74114071516557800,  37.11678138456306897,
    -48.36392121341754802,  34.09535373993877982,  -45.88577372237665486,  31.17824007995576707,
    -43.30747895739605013,  28.37531978094453677,  -40.62937881000767959,  25.69688738457191945,
    -37.85176517580522670,  23.15361781597290758,  -34.97521854780547557,  20.75650546647104377,
    -32.00091302933286386,  18.51677422677156670,  -28.93089420696503922,  16.44575600838861718,
    -25.76832854644280602,  14.55473640862136619,  -22.51771689758312078,  12.85476800444173051,
    -19.18506021909563941,  11.35645428598744111,  -15.77796305903055440,  10.06971032975658353,
    -12.30566013367807265,  9.00350968307662569,   -8.77895396829167218,   8.16563014493928918,
    -5.21005712455211789,   7.56241362477411272,   -1.61234064761579554,   7.19855645524003407,
    1.99999999999999734,    7.07694595379053126,   5.61234064761579088,    7.19855645524003407,
    9.21005712455211167,    7.56241362477411272,   12.77895396829166685,   8.16563014493928918,
    16.30566013367807088,   9.00350968307662569,   19.77796305903055085,   10.06971032975658353,
    23.18506021909563231,   11.35645428598744111,  26.51771689758312078,   12.85476800444173051,
    29.76832854644280246,   14.55473640862136619,  32.93089420696504277,   16.44575600838861718,
    36.00091302933286386,   18.51677422677156670,  38.97521854780546846,   20.75650546647104022,
    41.85176517580521960,   23.15361781597290403,  44.62937881000767248,   25.69688738457191590,
    47.30747895739604303,   28.37531978094453322,  49.88577372237665486,   31.17824007995575997,
    52.36392121341754091,   34.09535373993877982,  54.74114071516557800,   37.11678138456306897,
    57.01574257648425004,   40.23307020728444883,  59.18452370168172649,   43.43518400478754415,
    61.24193904387428944,   46.71447239476329827,  63.17889520468774833,   50.06261728049956616,
    64.98089250042356468,   53.47155025248752480,  66.62500642980749888,   56.93332642202356197,
    68.07470870335012592,   60.43992354246546483,  69.27043361461275595,   63.98289851135272244,
    70.11115128919477968,   67.55274433031233627,  70.41516373728855172,   71.13755089586129543,
    69.82714145548160900,   74.71983727667711150,  67.56415050352947560,   78.26774990878784877,
    61.58131858106001744,   81.70467639663135628,  45.28583165458984183,   84.76914638163376026,
    -178.00000000002495426, 89.99364961382421768,  -86.04670840724655534,  86.14286053253547948,
    -83.94730489861873934,  82.29066165213360762,  -81.87003129087820241,  78.44836496333867615,
    -79.78661098119418682,  74.62102007313750107,  -77.68757690134611948,  70.81379178736982283,
    -75.56653776770212971,  67.03200075627314902,  -73.41791965045068480,  63.28116415502336878,
    -71.23639478559491067,  59.56703711552955127,  -69.01668877482984499,  55.89565494125256606,
    -66.75350545455997064,  52.27337593848611164,  -64.44149951448400770,  48.70692450151241104,
    -62.07527488350018530,  45.20343384586799118,  -59.64940188352277772,  41.77048747717444854,
    -57.15845171105518574,  38.41615810166682365,  -54.59704918478396252,  35.14904222145087687,
    -51.95994579953059400,  31.97828811153562256,  -49.24211556220075892,  28.91361425616476666,
    -46.43887601207384819,  25.96531465470105005,  -43.54603622089217652,  23.14424674184217068,
    -40.56007232189229228,  20.46179708442632972,  -37.47832910130670570,  17.92981963683196156,
    -34.29924330014637945,  15.56054131855884570,  -31.02258051120933402,  13.36643021383323848,
    -27.64967308093982012,  11.36002298851478542,  -24.18364165385173337,  9.55371034930798224,
    -20.62957864939022201,  7.95948261839810733,   -16.99466904928961242,  6.58864168091602309,
    -13.28822357553577405,  5.45149036402020837,   -9.52160273595813855,   4.55701513369246669,
    -5.70801791517022217,   3.91258202080964690,   -1.86220744039441199,   3.52366797872773274,
    1.99999999999999734,    3.39364961385021413,   5.86220744039440689,    3.52366797872773274,
    9.70801791517021861,    3.91258202080964690,   13.52160273595813145,   4.55701513369246669,
    17.28822357553576694,   5.45149036402020837,   20.99466904928960886,   6.58864168091602309,
    24.62957864939021491,   7.95948261839810733,   28.18364165385172981,   9.55371034930798224,
    31.64967308093981302,   11.36002298851478542,  35.02258051120933402,   13.36643021383323848,
    38.29924330014637235,   15.56054131855884570,  41.47832910130669859,   17.92981963683195801,
    44.56007232189227807,   20.46179708442632261,  47.54603622089216231,   23.14424674184217068,
    50.43887601207384819,   25.96531465470104649,  53.24211556220075892,   28.91361425616475955,
    55.95994579953058690,   31.97828811153562256,  58.59704918478396252,   35.14904222145087687,
    61.15845171105517863,   38.41615810166681655,  63.64940188352278483,   41.77048747717444854,
    66.07527488350018530,   45.20343384586799118,  68.44149951448399349,   48.70692450151241104,
    70.75350545455997064,   52.27337593848611164,  73.01668877482984499,   55.89565494125256606,
    75.23639478559491067,   59.56703711552955127,  77.41791965045068480,   63.28116415502336878,
    79.56653776770211550,   67.03200075627314902,  81.68757690134611948,   70.81379178736982283,
    83.78661098119418682,   74.62102007313750107,  85.87003129087820241,   78.44836496333867615,
    87.94730489861875355,   82.29066165213360762,  90.04670840724658376,   86.14286053253547948,
    -178.00000000000005684, 86.05996156130565566,  -130.58473801020662108, 84.39088722277173815,
    -110.19717929614465390, 81.10053146183230410,  -100.10346048738929881, 77.40995108179684792,
    -93.69886509454548218,  73.59868574092435267,  -88.93011750021230455,  69.74815881341463353,
    -85.00534896567366161,  65.89187266757556927,  -81.55981529780905248,  62.04795929474798299,
    -78.40205491898922219,  58.22861013398448193,  -75.42099130058548440,  54.44347433172315220,
    -72.54676554128549526,  50.70110112272598712,  -69.73234087330638431,  47.00963897352001908,
    -66.94410839385282941,  43.37721635788606989,  -64.15676435641834985,  39.81217237539897269,
    -61.35037195723166548,  36.32321005821970061,  -58.50861449014277582,  32.91950572923986584,
    -55.61773745881250619,  29.61078975921034129,  -52.66591251909912330,  26.40740499964346810,
    -49.64287529119710030,  23.32034407821754840,  -46.53975201683548590,  20.36126354510683711,
    -43.34902402209520034,  17.54247066454981407,  -40.06459700293881809,  14.87687712846902599,
    -36.68195074563113423,  12.37791309905906445,  -33.19834740797973893,  10.05939491571369260,
    -29.61307490596015057,  7.93534078498541273,   -25.92769777693465372,  6.01973109672258389,
    -22.14628266758476371,  4.32621388981253130,   -18.27556116130716646,  2.86776143955401652,
    -14.32499114491301384,  1.65629062554436479,   -10.30668142622437244,  0.70226688878528098,
    -6.23515434659414680,   0.01431798130227213,   -2.12693783758673716,   -0.40111214042971233,
    1.99999999999999689,    -0.54003843869414525,  6.12693783758673050,    -0.40111214042971233,
    10.23515434659414147,   0.01431798130227213,   14.30668142622436712,   0.70226688878528098,
    18.32499114491300318,   1.65629062554436479,   22.27556116130715580,   2.86776143955401652,
    26.14628266758476016,   4.32621388981253130,   29.92769777693464306,   6.01973109672258389,
    33.61307490596014702,   7.93534078498541273,   37.19834740797973183,   10.05939491571369260,
    40.68195074563112001,   12.37791309905905912,  44.06459700293881809,   14.87687712846902421,
    47.34902402209520034,   17.54247066454981052,  50.53975201683548590,   20.36126354510683711,
    53.64287529119709319,   23.32034407821754485,  56.66591251909911620,   26.40740499964346455,
    59.61773745881250619,   29.61078975921033418,  62.50861449014276872,   32.91950572923986584,
    65.35037195723165837,   36.32321005821969351,  68.15676435641833564,   39.81217237539895848,
    70.94410839385281520,   43.37721635788606989,  73.73234087330637010,   47.00963897352000487,
    76.54676554128549526,   50.70110112272598002,  79.42099130058548440,   54.44347433172315220,
    82.40205491898922219,   58.22861013398448193,  85.55981529780903827,   62.04795929474798299,
    89.00534896567364740,   65.89187266757556927,  92.93011750021230455,   69.74815881341463353,
    97.69886509454546797,   73.59868574092435267,  104.10346048738931302,  77.40995108179684792,
    114.19717929614462548,  81.10053146183230410,  134.58473801020659266,  84.39088722277173815,
    -178.00000000000002842, 81.83938189765240168,  -149.15668933029422760, 80.85560324742941418,
    -128.64763601333984866, 78.39753950634394641,  -115.34882263320223217, 75.18923730101467129,
    -106.23509874248557594, 71.62987479878029262,  -99.45761459629794388,  67.90061168070624831,
    -94.04421718085441739,  64.08831694761892095,  -89.47013935832345055,  60.23965935256792648,
    -85.43460651588344490,  56.38292751246400769,  -81.75424365182693975,  52.53738247574246856,
    -78.31071017117777444,  48.71761719224470966,  -75.02360369831293951,  44.93576201889581512,
    -71.83567948061782715,  41.20268880474466755,  -68.70439458886511375,  37.52871692222674938,
    -65.59687011372152199,  33.92405612452550656,  -62.48679120890344052,  30.39910192691253599,
    -59.35245736607464551,  26.96464262473804041,  -56.17554747078253996,  23.63200834498021408,
    -52.94035098918124760,  20.41317688045037926,  -49.63331929525543984,  17.32084182287969298,
    -46.24284889074778704,  14.36844259642658983,  -42.75924066894448572,  11.57015196980180605,
    -39.17479644658766347,  8.94081392759362537,   -35.48402100288603123,  6.49582334126627892,
    -31.68389780238809195,  4.25093893994812166,   -27.77420154083882053,  2.22202305439570358,
    -23.75780275269854158,  0.42470591907018640,   -19.64091162595336826,  -1.12602081331554005,
    -15.43320327160518524,  -2.41626750988024330,  -11.14776873556009384,  -3.43374257581262743,
    -6.80084816537008940,   -4.16824654595516098,  -2.41132592404073165,   -4.61212239418478553,
    1.99999999999999689,    -4.76061810234754024,  6.41132592404072632,    -4.61212239418478553,
    10.80084816537008230,   -4.16824654595516098,  15.14776873556009029,   -3.43374257581262743,
    19.43320327160517991,   -2.41626750988024330,  23.64091162595336115,   -1.12602081331554005,
    27.75780275269853803,   0.42470591907018640,   31.77420154083881698,   2.22202305439570358,
    35.68389780238808129,   4.25093893994812166,   39.48402100288601702,   6.49582334126627270,
    43.17479644658765636,   8.94081392759361826,   46.75924066894447861,   11.57015196980179894,
    50.24284889074777283,   14.36844259642658628,  53.63331929525543273,   17.32084182287968943,
    56.94035098918124049,   20.41317688045037571,  60.17554747078253286,   23.63200834498020697,
    63.35245736607463840,   26.96464262473803331,  66.48679120890342631,   30.39910192691252178,
    69.59687011372152199,   33.92405612452549946,  72.70439458886511375,   37.52871692222674227,
    75.83567948061782715,   41.20268880474466755,  79.02360369831293951,   44.93576201889580091,
    82.31071017117776023,   48.71761719224470255,  85.75424365182693975,   52.53738247574246145,
    89.43460651588344490,   56.38292751246400769,  93.47013935832345055,   60.23965935256792648,
    98.04421718085441739,   64.08831694761892095,  103.45761459629794388,  67.90061168070624831,
    110.23509874248557594,  71.62987479878029262,  119.34882263320223217,  75.18923730101467129,
    132.64763601333982024,  78.39753950634394641,  153.15668933029419918,  80.85560324742941418,
    -178.00000000000002842, 77.29014606148251687,  -157.47781378002883912, 76.59572545663588983,
    -140.18467631053607647, 74.70285264202438213,  -126.87442892417496410, 71.99165187875776439,
    -116.75095597801099245, 68.78228497629521598,  -108.83745587761724494, 65.27873175231235336,
    -102.40541928769302160, 61.60190913800556700,  -96.97173315822051620,  57.82466562901673512,
    -92.22157019495104180,  53.99321139219064491,  -87.94629406419838347,  50.13884820321026581,
    -84.00357763838492531,  46.28434439562811065,  -80.29307189810650414,  42.44749809608728697,
    -76.74158359961857911,  38.64321178012773572,  -73.29390254081907585,  34.88475663106463287,
    -69.90700610430916129,  31.18458087158649406,  -66.54632400302145356,  27.55485191826680591,
    -63.18329478816111333,  24.00783659504740086,  -59.79375952890369916,  20.55617726580612015,
    -56.35691981311008192,  17.21309536720795919,  -52.85469423510679832,  13.99253787292509621,
    -49.27137129744098587,  10.90927185095380558,  -45.59349430020986915,  7.97892504367260802,
    -41.80993456941939712,  5.21796518077428839,   -37.91211819209929246,  2.64360721178194558,
    -33.89437094593881739,  0.27363605581641759,   -29.75433817509684786,  -1.87386656696368226,
    -25.49342310484703589,  -3.78089833576525525,  -21.11717183125961128,  -5.43001433583734983,
    -16.63552097548324937,  -6.80489321395614066,  -12.06282113870962114,  -7.89096231408011839,
    -7.41756212661334047,   -8.67603648837036268,  -2.72175805422022021,   -9.15091230991673399,
    1.99999999999999645,    -9.30985393851741172,  6.72175805422021444,    -9.15091230991673399,
    11.41756212661333691,   -8.67603648837036268,  16.06282113870961581,   -7.89096231408011839,
    20.63552097548324582,   -6.80489321395614066,  25.11717183125960418,   -5.43001433583734983,
    29.49342310484702523,   -3.78089833576525525,  33.75433817509684786,   -1.87386656696368226,
    37.89437094593881028,   0.27363605581641121,   41.91211819209927114,   2.64360721178193936,
    45.80993456941938291,   5.21796518077428217,   49.59349430020984784,   7.97892504367260180,
    53.27137129744098587,   10.90927185095380203,  56.85469423510678411,   13.99253787292509266,
    60.35691981311008192,   17.21309536720795563,  63.79375952890369206,   20.55617726580611659,
    67.18329478816110623,   24.00783659504739376,  70.54632400302143935,   27.55485191826679880,
    73.90700610430916129,   31.18458087158649050,  77.29390254081907585,   34.88475663106463287,
    80.74158359961856490,   38.64321178012773572,  84.29307189810650414,   42.44749809608728697,
    88.00357763838491110,   46.28434439562810354,  91.94629406419836926,   50.13884820321025160,
    96.22157019495104180,   53.99321139219064491,  100.97173315822050199,  57.82466562901673512,
    106.40541928769302160,  61.60190913800556700,  112.83745587761723073,  65.27873175231235336,
    120.75095597801100666,  68.78228497629521598,  130.87442892417493567,  71.99165187875776439,
    144.18467631053604805,  74.70285264202438213,  161.47781378002881070,  76.59572545663588983,
    -178.00000000000002842, 72.36459406509962378,  -162.05644118521095720, 71.82662636485281382,
    -147.60742176334812825, 70.30250402254888797,  -135.36255278451204731, 68.00113945880528377,
    -125.26976638159491984, 65.14478524125108549,  -116.94158660124730886, 61.91142197433249095,
    -109.95470750710923369, 58.42738157410047961,  -103.95825647893495614, 54.77900423463843538,
    -98.68725830824647005,  51.02562354013957702,  -93.94726867835278483,  47.20919167069192923,
    -89.59567144235911940,  43.36062114047545890,  -85.52649044264862255,  39.50382677214758331,
    -81.65938939021744147,  35.65830698143167155,  -77.93201512996090230,  31.84082402428231973,
    -74.29472888122153051,  28.06652943785655552,  -70.70698212428176532,  24.34974403770184992,
    -67.13481958525987636,  20.70451849248450316,  -63.54916484650964748,  17.14505004500528074,
    -59.92466443809041010,  13.68599977255222377,  -56.23894695811429756,  10.34273467530951152,
    -52.47220691225792422,  7.13150506907927006,   -48.60705694133756083,  4.06955754229704603,
    -44.62861191461713162,  1.17517574056815666,   -40.52477649322946007,  -1.53236497867592147,
    -36.28670514160292981,  -4.03294710811187507,  -31.90939060170597941,  -6.30588392466837533,
    -27.39231472226267528,  -8.33033151194295662,  -22.74006765897273397,  -10.08584610023313921,
    -17.96281473836326725,  -11.55307649365679090, -13.07647532339788654,  -12.71455858250937254,
    -8.10248720394762678,   -13.55555303790299426, -3.06707279862612969,   -14.06484423228424063,
    1.99999999999999600,    -14.23540593490034212, 7.06707279862612125,    -14.06484423228424063,
    12.10248720394761790,   -13.55555303790299426, 17.07647532339788299,   -12.71455858250937254,
    21.96281473836326015,   -11.55307649365679090, 26.74006765897273041,   -10.08584610023313921,
    31.39231472226266817,   -8.33033151194295662,  35.90939060170597230,   -6.30588392466837533,
    40.28670514160292271,   -4.03294710811188128,  44.52477649322944586,   -1.53236497867592791,
    48.62861191461712451,   1.17517574056815022,   52.60705694133754662,   4.06955754229703981,
    56.47220691225791711,   7.13150506907926740,   60.23894695811429756,   10.34273467530950796,
    63.92466443809040300,   13.68599977255221667,  67.54916484650964037,   17.14505004500527363,
    71.13481958525987636,   20.70451849248449605,  74.70698212428177953,   24.34974403770184992,
    78.29472888122153051,   28.06652943785655197,  81.93201512996088809,   31.84082402428231262,
    85.65938939021744147,   35.65830698143166444,  89.52649044264860834,   39.50382677214758331,
    93.59567144235911940,   43.36062114047545180,  97.94726867835277062,   47.20919167069192213,
    102.68725830824645584,  51.02562354013956281,  107.95825647893494192,  54.77900423463843538,
    113.95470750710921948,  58.42738157410047961,  120.94158660124729465,  61.91142197433249095,
    129.26976638159487720,  65.14478524125108549,  139.36255278451201889,  68.00113945880528377,
    151.60742176334809983,  70.30250402254888797,  166.05644118521092878,  71.82662636485281382,
    -178.00000000000002842, 67.00865712643569339,  -164.95645291666266985, 66.56908368553206401,
    -152.69437932769912436, 65.29863962109095610,  -141.70578215046154469, 63.31961305621509695,
    -132.12712761110685733, 60.78156430751474204,  -123.85428534979440940, 57.82417470821774685,
    -116.68240638414135901, 54.56141374911145192,  -110.39390839554111778, 51.08045112569507751,
    -104.79614728017998004, 47.44644408577498496,  -99.73088255981890882,  43.70821480745370025,
    -95.07197748871266185,  39.90302877816822757,  -90.71961138434764393,  36.06017287638244539,
    -86.59435351833845118,  32.20351875194761959,  -82.63216392910496211,  28.35333972343855535,
    -78.78048521884275601,  24.52760876444716587,  -74.99529352424694650,  20.74294398926493699,
    -71.23891693218340038,  17.01531594444593765,  -67.47845003929684538,  13.36059248585088355,
    -63.68463403089357655,  9.79496963802121101,   -59.83111160507219495,  6.33531713186757539,
    -55.89399913408760057,  2.99945241539763696,   -51.85174332801064168,  -0.19365520038940248,
    -47.68524592294902931,  -3.22375917751486485,  -43.37824652323212860,  -6.06930752874206636,
    -38.91794868987490474,  -8.70753794849322027,  -34.29585521437643081,  -11.11472732454917001,
    -29.50874372060167872,  -13.26662598462659126, -24.55966518490711081,  -15.13909773195326558,
    -19.45879403720245193,  -16.70896594558295334, -14.22391622121717880,  -17.95503295463868554,
    -8.88033504279663255,   -18.85919797266866027, -3.46002704385166027,   -19.40755726556069405,
    1.99999999999999645,    -19.59134287356426540, 7.46002704385165316,    -19.40755726556069405,
    12.88033504279662367,   -18.85919797266866027, 18.22391622121717347,   -17.95503295463868554,
    23.45879403720244127,   -16.70896594558295334, 28.55966518490710015,   -15.13909773195326558,
    33.50874372060167161,   -13.26662598462659126, 38.29585521437642370,   -11.11472732454917534,
    42.91794868987490474,   -8.70753794849322738,  47.37824652323212149,   -6.06930752874207258,
    51.68524592294901510,   -3.22375917751487107,  55.85174332801063457,   -0.19365520038940884,
    59.89399913408759346,   2.99945241539763385,   63.83111160507218784,   6.33531713186756917,
    67.68463403089357655,   9.79496963802120568,   71.47845003929684538,   13.36059248585087822,
    75.23891693218338617,   17.01531594444593054,  78.99529352424693229,   20.74294398926492988,
    82.78048521884274180,   24.52760876444715521,  86.63216392910494790,   28.35333972343854825,
    90.59435351833845118,   32.20351875194761959,  94.71961138434764393,   36.06017287638243118,
    99.07197748871266185,   39.90302877816822047,  103.73088255981890882,  43.70821480745368603,
    108.79614728017998004,  47.44644408577497074,  114.39390839554110357,  51.08045112569504909,
    120.68240638414135901,  54.56141374911145192,  127.85428534979438098,  57.82417470821774685,
    136.12712761110682891,  60.78156430751474204,  145.70578215046154469,  63.31961305621509695,
    156.69437932769909594,  65.29863962109095610,  168.95645291666264143,  66.56908368553206401,
    -178.00000000000002842, 61.16162880179430772,  -166.97884079028878546, 60.79043532425956897,
    -156.40162010671977555, 59.70518607311999659,  -146.59283359977425221, 57.98141283097307053,
    -137.70772458687926587, 55.72003625021811501,  -129.75638606304184464, 53.02581189527144545,
    -122.65952710171549711, 49.99368843662635697,  -116.29889149413011751, 46.70342202473146642,
    -110.54933935400606515, 43.21943287866469774,  -105.29473060869931089, 39.59298941537671368,
    -100.43366587620559471, 35.86497163386139420,  -95.88003723653146437,  32.06843215731343832,
    -91.56137924921046078,  28.23071203179445376,  -87.41655400532016529,  24.37510563102819461,
    -83.39346098727328638,  20.52214967325533124,  -79.44703540885105042,  16.69062430422997423,
    -75.53760403336077900,  12.89834287286322301,  -71.62959031828354739,  9.16278970353470967,
    -67.69053915995506543,  5.50164833296652400,   -63.69043463465567356,  1.93324784086672841,
    -59.60129716846515180,  -1.52305829704237294,  -55.39706222812606740,  -4.84657887125734721,
    -51.05375641269629483,  -8.01504773475606314,  -46.54999441522540593,  -11.00448645615599474,
    -41.86781613095839560,  -13.78920372951384543, -36.99386004100858116,  -16.34197985921976581,
    -31.92081946357624034,  -18.63449057116782015, -26.64904852681421588,  -20.63801909702448611,
    -21.18808138888132930,  -22.32448212182582026, -15.55772615655294366,  -23.66774871950555692,
    -9.78834011215971245,   -24.64516330804185174, -3.91994134356475854,   -25.23910692117754806,
    1.99999999999999556,    -25.43837119820565107, 7.91994134356474966,    -25.23910692117754806,
    13.78834011215970534,   -24.64516330804185174, 19.55772615655293123,   -23.66774871950555692,
    25.18808138888131865,   -22.32448212182582026, 30.64904852681421232,   -20.63801909702448611,
    35.92081946357622968,   -18.63449057116782015, 40.99386004100855985,   -16.34197985921976581,
    45.86781613095838850,   -13.78920372951385076, 50.54999441522539882,   -11.00448645615600007,
    55.05375641269628773,   -8.01504773475606846,  59.39706222812605318,   -4.84657887125735343,
    63.60129716846514469,   -1.52305829704237916,  67.69043463465565935,   1.93324784086672197,
    71.69053915995505122,   5.50164833296651778,   75.62959031828353318,   9.16278970353470434,
    79.53760403336076479,   12.89834287286321590,  83.44703540885105042,   16.69062430422996712,
    87.39346098727328638,   20.52214967325532413,  91.41655400532015108,   24.37510563102818750,
    95.56137924921046078,   28.23071203179444666,  99.88003723653145016,   32.06843215731343832,
    104.43366587620558050,  35.86497163386137288,  109.29473060869932510,  39.59298941537669947,
    114.54933935400606515,  43.21943287866469774,  120.29889149413010330,  46.70342202473146642,
    126.65952710171551132,  49.99368843662635697,  133.75638606304187306,  53.02581189527144545,
    141.70772458687926587,  55.72003625021811501,  150.59283359977422379,  57.98141283097307053,
    160.40162010671977555,  59.70518607311999659,  170.97884079028878546,  60.79043532425956897,
    -178.00000000000002842, 54.75649468439711143,  -168.49285933765114009, 54.43639475342744305,
    -159.25249258416440057, 53.49372597518600259,  -150.49218436749950456, 51.97706503648645082,
    -142.34201331309026273, 49.95526128262039123,  -134.84908760812987794, 47.50530446205828383,
    -127.99715883033752561, 44.70273256173389598,  -121.73118977168118704, 41.61600262291977259,
    -115.97779813807071037, 38.30427835916992052,  -110.65884380836621403, 34.81740352705595143,
    -105.69899804029306267, 31.19696754875727152,  -101.02917319698202903, 27.47775433026597725,
    -96.58749981932022877,  23.68920100972959730,  -92.31902021078286680,  19.85670886149115688,
    -88.17480572169651509,  16.00276430383187076,  -84.11088800598805904,  12.14788119395578825,
    -80.08720437104130951,  8.31139512800513991,   -76.06665407661381550,  4.51214364124032752,
    -72.01431282527251199,  0.76906207426875217,   -67.89683474738467339,  -2.89828246890512542,
    -63.68207179147747610,  -6.46920580966549608,  -59.33895182482493880,  -9.92146778444055499,
    -54.83767345094592827,  -13.23089104518994574, -50.15029168417838434,  -16.37106576006626568,
    -45.25177543408179304,  -19.31318879069117145, -40.12160159745184274,  -22.02610835172851722,
    -34.74589265732009835,  -24.47666503668304117, -29.11998552133064422,  -26.63042818683534207,
    -23.25113130544623985,  -28.45290874783366064, -17.16079514785620930,  -29.91127029421519978,
    -10.88583393507997776,  -30.97645080660139172, -4.47781225763253765,   -31.62546289221583962,
    1.99999999999999534,    -31.84350531560284736, 8.47781225763252877,    -31.62546289221583962,
    14.88583393507996711,   -30.97645080660139172, 21.16079514785619509,   -29.91127029421519978,
    27.25113130544623274,   -28.45290874783366064, 33.11998552133064067,   -26.63042818683534207,
    38.74589265732009835,   -24.47666503668304117, 44.12160159745183563,   -22.02610835172851722,
    49.25177543408178593,   -19.31318879069118211, 54.15029168417837724,   -16.37106576006627279,
    58.83767345094592827,   -13.23089104518995285, 63.33895182482493169,   -9.92146778444056032,
    67.68207179147748320,   -6.46920580966550229,  71.89683474738467339,   -2.89828246890513164,
    76.01431282527251199,   0.76906207426874584,   80.06665407661380129,   4.51214364124032308,
    84.08720437104132372,   8.31139512800513458,   88.11088800598805904,   12.14788119395578470,
    92.17480572169650088,   16.00276430383186366,  96.31902021078285259,   19.85670886149114978,
    100.58749981932022877,  23.68920100972959020,  105.02917319698201482,  27.47775433026597014,
    109.69899804029304846,  31.19696754875725375,  114.65884380836618561,  34.81740352705593722,
    119.97779813807069615,  38.30427835916992052,  125.73118977168117283,  41.61600262291977259,
    131.99715883033749719,  44.70273256173389598,  138.84908760812987794,  47.50530446205828383,
    146.34201331309026273,  49.95526128262039123,  154.49218436749950456,  51.97706503648645082,
    163.25249258416440057,  53.49372597518600259,  172.49285933765111167,  54.43639475342744305,
    -178.00000000000002842, 47.72124472298390430,  -169.69217969866491558, 47.44157216781381692,
    -161.55074086228117380, 46.61395503653132266,  -153.71667350566602295, 45.27051130755705799,
    -146.28885177460344380, 43.45866798082070659,  -139.31958252044236701, 41.23439386179803279,
    -132.82020109922686402, 38.65601141858345358,  -126.77168357131760956, 35.77969749489390949,
    -121.13576891124588997, 32.65687547770472321,  -115.86406835852179142, 29.33315055785289260,
    -110.90442707083994378, 25.84827445710250160,  -106.20481280215612685, 22.23668760419472790,
    -101.71535755141638901, 18.52832281285149207,  -97.38917071735673403,  14.74948212031801020,
    -93.18240447461121789,  10.92369066480776674,  -89.05390189983984328,  7.07248905242842607,
    -84.96463936229969249,  3.21615784383777559,   -80.87709425893895343,  -0.62561625366165152,
    -76.75462189677602964,  -4.43311662588922051,  -72.56090370117536281,  -8.18599910867232161,
    -68.25952713288315010,  -11.86270778471483389, -63.81377209114523907,  -15.43989911427394368,
    -59.18670666190919150,  -18.89188184637555068, -54.34173321358174746,  -22.19009961204913850,
    -49.24376548995358149,  -25.30271165018387691, -43.86123932751760890,  -28.19436585459229860,
    -38.16912769952225659,  -30.82630445836841915, -32.15298964123236658,  -33.15698491696964112,
    -25.81377244810833815,  -35.14341202945125531, -19.17259140539265516,  -36.74332279213026453,
    -12.27414365511957151,  -37.91820250638207312, -5.18708125479775184,   -38.63683300066042392,
    1.99999999999999489,    -38.87875527701606160, 9.18708125479774296,    -38.63683300066042392,
    16.27414365511955907,   -37.91820250638207312, 23.17259140539264095,   -36.74332279213026453,
    29.81377244810832394,   -35.14341202945125531, 36.15298964123235947,   -33.15698491696964112,
    42.16912769952225659,   -30.82630445836841915, 47.86123932751760179,   -28.19436585459229860,
    53.24376548995357439,   -25.30271165018388402, 58.34173321358174746,   -22.19009961204914205,
    63.18670666190918439,   -18.89188184637555779, 67.81377209114522486,   -15.43989911427395079,
    72.25952713288313589,   -11.86270778471484277, 76.56090370117536281,   -8.18599910867232872,
    80.75462189677602964,   -4.43311662588922673,  84.87709425893895343,   -0.62561625366165630,
    88.96463936229967828,   3.21615784383776981,   93.05390189983984328,   7.07248905242842163,
    97.18240447461121789,   10.92369066480776141,  101.38917071735671982,  14.74948212031800310,
    105.71535755141637480,  18.52832281285148497,  110.20481280215611264,  22.23668760419472079,
    114.90442707083992957,  25.84827445710249449,  119.86406835852177721,  29.33315055785288550,
    125.13576891124587576,  32.65687547770470900,  130.77168357131759535,  35.77969749489390949,
    136.82020109922683559,  38.65601141858345358,  143.31958252044236701,  41.23439386179803279,
    150.28885177460347222,  43.45866798082070659,  157.71667350566602295,  45.27051130755705799,
    165.55074086228114538,  46.61395503653132266,  173.69217969866488716,  47.44157216781381692,
    -178.00000000000002842, 39.98177927524727693,  -170.20476659278793363, 39.70189618399165710,
    -162.53782868216148927, 38.87197455633481979,  -155.11038900941949237, 37.51968052984662449,
    -148.00450116657361832, 35.68659928106227852,  -141.26850797118672176, 33.42299645292870736,
    -134.91921485966395267, 30.78272820361293327,  -128.94811747553873715, 27.81921722445741452,
    -123.32885205682140395, 24.58281725765701253,  -118.02393786261990272, 21.11944988981388605,
    -112.98994385952538266, 17.47019805768939449,  -108.18096363521175363, 13.67152082594358653,
    -103.55065416712271542, 9.75582109859903390,   -99.05319914949195947,  5.75218534812640492,
    -94.64352777118511995,  1.68719008387413827,   -90.27704477012913742,  -2.41427530523583656,
    -85.90905356028720519,  -6.52818370181667529,  -81.49400025392820623,  -10.63053585607600837,
    -76.98463901984250413,  -14.69649678201448140, -72.33122188826867216,  -18.69947873486281864,
    -67.48085419487966874,  -22.61014977269736193, -62.37723925505212463,  -26.39536140379772533,
    -56.96117255247644096,  -30.01702215459737033, -51.17233704527057370,  -33.43100825355479344,
    -44.95316063861177014,  -36.58631299796492442, -38.25559890256131723,  -39.42480136235259636,
    -31.05142021090808413,  -41.88213387768102791, -23.34546416576216643,  -43.89055765093644368,
    -15.18911080317680451,  -45.38412606933154336, -6.68839576675081293,   -46.30624543028365991,
    1.99999999999999445,    -46.61822072475268186, 10.68839576675079961,   -46.30624543028365991,
    19.18911080317679918,   -45.38412606933154336, 27.34546416576215222,   -43.89055765093644368,
    35.05142021090807702,   -41.88213387768102791, 42.25559890256131013,   -39.42480136235259636,
    48.95316063861175593,   -36.58631299796492442, 55.17233704527057370,   -33.43100825355479344,
    60.96117255247643385,   -30.01702215459737744, 66.37723925505210332,   -26.39536140379773244,
    71.48085419487965453,   -22.61014977269736548, 76.33122188826865795,   -18.69947873486282575,
    80.98463901984250413,   -14.69649678201448850, 85.49400025392819202,   -10.63053585607601548,
    89.90905356028720519,   -6.52818370181668062,  94.27704477012913742,   -2.41427530523584188,
    98.64352777118510573,   1.68719008387413361,   103.05319914949195947,  5.75218534812639781,
    107.55065416712271542,  9.75582109859902680,   112.18096363521173942,  13.67152082594358120,
    116.98994385952536845,  17.47019805768938738,  122.02393786261990272,  21.11944988981387894,
    127.32885205682140395,  24.58281725765700187,  132.94811747553873715,  27.81921722445741452,
    138.91921485966392424,  30.78272820361293327,  145.26850797118672176,  33.42299645292870736,
    152.00450116657361832,  35.68659928106227852,  159.11038900941949237,  37.51968052984662449,
    166.53782868216146085,  38.87197455633481979,  174.20476659278793363,  39.70189618399165710,
    -178.00000000000002842, 31.46720374958098887,  -171.12910064316457692, 31.22051723140710067,
    -164.34108626834762390, 30.48695101230147841,  -157.71017626763574526, 29.28521267182222587,
    -151.29523174265207786, 27.64411687523926986,  -145.13620894054648147, 25.59967735271197498,
    -139.25381666270027381, 23.19203115841211726,  -133.65157520973266969, 20.46271167815037728,
    -128.31914580979304219, 17.45256126555711873,  -123.23592626204657563, 14.20035582641498806,
    -118.37425008640165913, 10.74206713847307348,  -113.70187269530693186, 7.11062322287716331,
    -109.18367588372132104, 3.33602075627005945,   -104.78265670493266271, -0.55433148808729127,
    -100.46031614728222792, -4.53512373056416163,  -96.17656220612794016,  -8.58256192749418290,
    -91.88921878897831164,  -12.67371220268469223, -87.55320457280681978,  -16.78577161643179849,
    -83.11942634360052296,  -20.89524495725206421, -78.53343020155088539,  -24.97699141478169338,
    -73.73388667252179118,  -29.00309226896919412, -68.65107920217621995,  -32.94148403257255353,
    -63.20576633421556068,  -36.75430974219704439, -57.30916699148811233,  -40.39598469592144880,
    -50.86545369174167774,  -43.81109166541019562, -43.77902429867569367,  -46.93247902115529513,
    -35.96960367385943158,  -49.68040408706252720, -27.39769711559288723,  -51.96422430511800172,
    -18.09872704828334378,  -53.68864395349498864, -8.21451927262478065,   -54.76594013073759015,
    1.99999999999999289,    -55.13279625041898413, 12.21451927262476822,   -54.76594013073759015,
    22.09872704828332601,   -53.68864395349498864, 31.39769711559288012,   -51.96422430511800172,
    39.96960367385942448,   -49.68040408706252720, 47.77902429867568657,   -46.93247902115529513,
    54.86545369174167064,   -43.81109166541019562, 61.30916699148811233,   -40.39598469592146301,
    67.20576633421555357,   -36.75430974219705149, 72.65107920217620574,   -32.94148403257256064,
    77.73388667252179118,   -29.00309226896920123, 82.53343020155088539,   -24.97699141478170048,
    87.11942634360052296,   -20.89524495725207132, 91.55320457280680557,   -16.78577161643180560,
    95.88921878897831164,   -12.67371220268469756, 100.17656220612792595,  -8.58256192749419000,
    104.46031614728221371,  -4.53512373056416607,  108.78265670493264849,  -0.55433148808729760,
    113.18367588372132104,  3.33602075627005323,   117.70187269530691765,  7.11062322287715620,
    122.37425008640165913,  10.74206713847306816,  127.23592626204656142,  14.20035582641498095,
    132.31914580979304219,  17.45256126555711162,  137.65157520973264127,  20.46271167815036662,
    143.25381666270027381,  23.19203115841211726,  149.13620894054645305,  25.59967735271197498,
    155.29523174265207786,  27.64411687523926986,  161.71017626763577368,  29.28521267182222587,
    168.34108626834759548,  30.48695101230147841,  175.12910064316457692,  31.22051723140710067,
    -178.00000000000002842, 22.11837781753018817,  -170.46891148411387462, 21.78042227826199095,
    -163.04151372648448159, 20.77699151155475477,  -155.80845268931921055, 19.13794220572576776,
    -148.83768595785252842, 16.90865838596958781,  -142.17005258660481104, 14.14485028302004999,
    -135.81978239976487544, 10.90731557455581147,  -129.77826339847271697, 7.25759760165333567,
    -124.01906809075352101, 3.25496397729521814,   -118.50268451884778642, -1.04529436283411115,
    -113.18006743498142441, -5.59247248797413210,  -107.99465974304708027, -10.34025377357217934,
    -102.88281945262124850, -15.24594064653213898, -97.77265218881962028,  -20.26925377022462982,
    -92.58116190590757810,  -25.37072818781790673, -87.20945067766288616,  -30.50961194071436111,
    -81.53547443418635510,  -35.64102404029979709, -75.40370496549049051,  -40.71192873614232610,
    -68.61131289029849256,  -45.65520975111465418, -60.89227178252910733,  -50.38082342875217989,
    -51.90710322947828104,  -54.76300160634039571, -41.26325159838054901,  -58.62403790832019723,
    -28.62428016143747200,  -61.72174914658255318, -13.98037118830461445,  -63.76341508305664263,
    1.99999999999999090,    -64.48162218246977773, 17.98037118830459491,   -63.76341508305664263,
    32.62428016143745424,   -61.72174914658255318, 45.26325159838053480,   -58.62403790832019723,
    55.90710322947827393,   -54.76300160634039571, 64.89227178252910733,   -50.38082342875217989,
    72.61131289029847835,   -45.65520975111467550, 79.40370496549049051,   -40.71192873614232610,
    85.53547443418635510,   -35.64102404029981841, 91.20945067766287195,   -30.50961194071436822,
    96.58116190590757810,   -25.37072818781791383, 101.77265218881962028,  -20.26925377022463692,
    106.88281945262124850,  -15.24594064653214609, 111.99465974304708027,  -10.34025377357218289,
    117.18006743498143862,  -5.59247248797413921,  122.50268451884780063,  -1.04529436283411759,
    128.01906809075350679,  3.25496397729521192,   133.77826339847268855,  7.25759760165332857,
    139.81978239976487544,  10.90731557455580436,  146.17005258660478262,  14.14485028302004999,
    152.83768595785250000,  16.90865838596958781,  159.80845268931921055,  19.13794220572576776,
    167.04151372648448159,  20.77699151155475477,  174.46891148411387462,  21.78042227826199095,
    -178.00000000000002842, 11.90033356154828503,  -171.03550378237531504, 11.56695807154089728,
    -164.15259832130166728, 10.57562338306961180,  -157.42382961455143686, 8.95164656051215069,
    -150.90567761562240889, 6.73398631258200187,   -144.63474532961075170, 3.97127289925851068,
    -138.62718020698264354, 0.71762564121834338,   -132.88045216690298389, -2.97103149043460757,
    -127.37626453526326031, -7.03975713563777195,  -122.08348616854385682, -11.43638098615609344,
    -116.96030366998827787, -16.11238508810905401, -111.95506961066591600, -21.02304593053227677,
    -107.00543419047215821, -26.12699149209596428, -102.03522828445495918, -31.38525381109429446,
    -96.94814060146437384,  -36.75977477892173084, -91.61632617812561818,  -42.21112686087874266,
    -85.86029859026153588,  -47.69485768882572785, -79.41299264536502278,  -53.15514845029933610,
    -71.85455169648275842,  -58.51289100414830102, -62.49613000707146426,  -63.64173578517077345,
    -50.20367738593296281,  -68.31866526945105988, -33.33636828365784055,  -72.13161644510194037,
    -10.78607194201629582,  -74.39304559691805707, 14.78607194201627273,   -74.39304559691805707,
    37.33636828365781213,   -72.13161644510194037, 54.20367738593294149,   -68.31866526945105988,
    66.49613000707145716,   -63.64173578517077345, 75.85455169648274421,   -58.51289100414830102,
    83.41299264536502278,   -53.15514845029933610, 89.86029859026150746,   -47.69485768882574916,
    95.61632617812561818,   -42.21112686087874266, 100.94814060146437384,  -36.75977477892173084,
    106.03522828445494497,  -31.38525381109429446, 111.00543419047215821,  -26.12699149209597138,
    115.95506961066591600,  -21.02304593053228388, 120.96030366998827787,  -16.11238508810905756,
    126.08348616854387103,  -11.43638098615609699, 131.37626453526326031,  -7.03975713563777816,
    136.88045216690298389,  -2.97103149043461379,  142.62718020698264354,  0.71762564121833694,
    148.63474532961075170,  3.97127289925851068,   154.90567761562243732,  6.73398631258200187,
    161.42382961455140844,  8.95164656051215069,   168.15259832130169571,  10.57562338306961180,
    175.03550378237531504,  11.56695807154089728,  -178.00000000000002842, 0.81833312891115306,
    -171.37485237931247184, 0.46152536384328174,   -164.82591385569978115, -0.60006016949342578,
    -158.42170502724641779, -2.34091526057736310,  -152.21700460768090579, -4.72161659803607048,
    -146.24942513902283281, -7.69266569608215889,  -140.53869867413175143, -11.19861017149900739,
    -135.08801440266989857, -15.18177122287804615, -129.88641650799127092, -19.58517424494497305,
    -124.91129483912591525, -24.35455549606792047, -120.13018318901130499, -29.43951176908901957,
    -115.50120511177955507, -34.79395188944583595, -110.97138028465980142, -40.37601690822956613,
    -106.47134737780879732, -46.14758359783259323, -101.90317607822893820, -52.07335345715244301,
    -97.11263541171206271,  -58.11928872485960085, -91.82057104813961246,  -64.24948773689963843,
    -85.42499621356618889,  -70.41813086842684299, -76.27768438369074033,  -76.54083121758115738,
    -57.87324357773111672,  -82.33459525449163152, 1.99999999999996114,    -85.78166687108868871,
    61.87324357773107408,   -82.33459525449163152, 80.27768438369074033,   -76.54083121758115738,
    89.42499621356618889,   -70.41813086842684299, 95.82057104813959825,   -64.24948773689963843,
    101.11263541171206271,  -58.11928872485960085, 105.90317607822892398,  -52.07335345715245722,
    110.47134737780879732,  -46.14758359783259323, 114.97138028465980142,  -40.37601690822956613,
    119.50120511177955507,  -34.79395188944583595, 124.13018318901127657,  -29.43951176908902667,
    128.91129483912592946,  -24.35455549606792403, 133.88641650799127092,  -19.58517424494497661,
    139.08801440266989857,  -15.18177122287804970, 144.53869867413172301,  -11.19861017149901272,
    150.24942513902280439,  -7.69266569608215889,  156.21700460768090579,  -4.72161659803607048,
    162.42170502724644621,  -2.34091526057736310,  168.82591385569978115,  -0.60006016949342578,
    175.37485237931247184,  0.46152536384328174,   -178.00000000000000000, -11.06408152044379101,
    -171.33870321353637678, -11.51266748991093891, -164.78020742076523675, -12.84550987892848539,
    -158.41822389716838870, -15.02545489467462403, -152.33085313434585828, -17.99542592709287803,
    -146.57821873782722832, -21.68429473238734673, -141.20455296082769792, -26.01294410398721979,
    -136.24424010430539056, -30.89942669541638764, -131.73150447900647464, -36.26259289105208694,
    -127.71480673751507595, -42.02394287044848653, -124.28024682035200499, -48.10755262562803125,
    -121.59604777627559713, -54.43751136022502379, -120.01228809564838684, -60.93070105520797597,
    -120.32470998353322500, -67.47696540683870126, -124.60898756414846389, -73.87349687490876704,
    -139.22778135121401988, -79.54230031515007227, -178.00000000000000000, -82.33591847955618448,
    143.22778135121404830,  -79.54230031515007227, 128.60898756414846389,  -73.87349687490876704,
    124.32470998353322500,  -67.47696540683870126, 124.01228809564837263,  -60.93070105520797597,
    125.59604777627561134,  -54.43751136022503090, 128.28024682035200499,  -48.10755262562803125,
    131.71480673751509016,  -42.02394287044850074, 135.73150447900647464,  -36.26259289105208694,
    140.24424010430539056,  -30.89942669541638764, 145.20455296082769792,  -26.01294410398722334,
    150.57821873782722832,  -21.68429473238734673, 156.33085313434585828,  -17.99542592709287803,
    162.41822389716838870,  -15.02545489467462403, 168.78020742076520833,  -12.84550987892848539,
    175.33870321353637678,  -11.51266748991093891, -178.00000000000000000, -23.60656536858034116,
    -172.31484199740026497, -24.06074499849094650, -166.76206145225543764, -25.40835290264588053,
    -161.47033176340409000, -27.60594661847371611, -156.56387974300261590, -30.58514629912493277,
    -152.16715015384193066, -34.25717258827405942, -148.41689072479888978, -38.51667916926085411,
    -145.48413942807309240, -43.24305393544465659, -143.61056018478930696, -48.29703252527734492,
    -143.16669319413330186, -53.50931894776815057, -144.73891790293430404, -58.65522080377154168,
    -149.21912766680259210, -63.40582055258879279, -157.69810487935359333, -67.25441721659638006,
    -170.53118545218148938, -69.49384617858525814, 174.53118545218146096,  -69.49384617858525814,
    161.69810487935359333,  -67.25441721659638006, 153.21912766680256368,  -63.40582055258877858,
    148.73891790293430404,  -58.65522080377152747, 147.16669319413330186,  -53.50931894776815767,
    147.61056018478930696,  -48.29703252527734492, 149.48413942807309240,  -43.24305393544464948,
    152.41689072479886136,  -38.51667916926086122, 156.16715015384193066,  -34.25717258827403811,
    160.56387974300261590,  -30.58514629912493277, 165.47033176340409000,  -27.60594661847371611,
    170.76206145225546607,  -25.40835290264587698, 176.31484199740026497,  -24.06074499849094295,
    -178.00000000000000000, -36.54741287921620341, -174.09065200901946469, -36.97055608025468132,
    -170.42266827604018431, -38.21219158951615213, -167.24101930549508666, -40.18968456371464271,
    -164.79950790329061761, -42.76713193279059766, -163.36621335583259906, -45.75617589753742465,
    -163.22080918295719698, -48.91487419033276751, -164.62326642581021474, -51.94637057143930292,
    -167.72066876086483944, -54.50623527875517738, -172.37525674045562596, -56.23764348052387874,
    -178.00000000000000000, -56.85258712078380228, 176.37525674045562596,  -56.23764348052387874,
    171.72066876086483944,  -54.50623527875517738, 168.62326642581021474,  -51.94637057143930292,
    167.22080918295719698,  -48.91487419033276751, 167.36621335583259906,  -45.75617589753742465,
    168.79950790329058918,  -42.76713193279060476, 171.24101930549508666,  -40.18968456371464271,
    174.42266827604018431,  -38.21219158951615213, 178.09065200901943626,  -36.97055608025468132};

};

namespace atlas {
namespace test {
CASE( "t31c2.4" ) {
    auto nx = std::vector<int>{20, 27, 32, 40, 45, 48, 60, 60, 64, 64, 64, 64, 64, 64, 64, 64,
                               64, 64, 64, 64, 64, 64, 64, 64, 60, 60, 48, 45, 40, 32, 27, 20};

    auto proj = Projection( "rotated_schmidt", Config( "stretching_factor", 2.4 ) | Config( "rotation_angle", 180.0 ) |
                                                   Config( "north_pole", {2.0, 46.7} ) );

    auto grid = ReducedGaussianGrid( nx, proj );

    for ( int j = 0, jglo = 0; j < grid.ny(); j++ ) {
        for ( int i = 0; i < grid.nx( j ); i++, jglo++ ) {
            auto ll1 = PointLonLat( lonlat_arp_t32c24[2 * jglo + 0], lonlat_arp_t32c24[2 * jglo + 1] );
            auto ll2 = grid.lonlat( i, j );
            EXPECT_APPROX_EQ( ll1.lon(), ll2.lon(), 1.e-10 );
            EXPECT_APPROX_EQ( ll1.lat(), ll2.lat(), 1.e-10 );
        }
    }
}


}  // namespace test
}  // namespace atlas


int main( int argc, char* argv[] ) {
    return atlas::test::run( argc, argv );
}
