// Copyright 2021 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.1.0. DO NOT EDIT.

package mocks

import (
	dbus "github.com/mendersoftware/mender-connect/client/dbus"
	mock "github.com/stretchr/testify/mock"

	time "time"
)

// DBusAPI is an autogenerated mock type for the DBusAPI type
type DBusAPI struct {
	mock.Mock
}

// BusGet provides a mock function with given fields: _a0
func (_m *DBusAPI) BusGet(_a0 uint) (dbus.Handle, error) {
	ret := _m.Called(_a0)

	var r0 dbus.Handle
	if rf, ok := ret.Get(0).(func(uint) dbus.Handle); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Get(0).(dbus.Handle)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(uint) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BusProxyCall provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *DBusAPI) BusProxyCall(_a0 dbus.Handle, _a1 string, _a2 interface{}, _a3 int) (dbus.DBusCallResponse, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 dbus.DBusCallResponse
	if rf, ok := ret.Get(0).(func(dbus.Handle, string, interface{}, int) dbus.DBusCallResponse); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(dbus.DBusCallResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(dbus.Handle, string, interface{}, int) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BusProxyNew provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *DBusAPI) BusProxyNew(_a0 dbus.Handle, _a1 string, _a2 string, _a3 string) (dbus.Handle, error) {
	ret := _m.Called(_a0, _a1, _a2, _a3)

	var r0 dbus.Handle
	if rf, ok := ret.Get(0).(func(dbus.Handle, string, string, string) dbus.Handle); ok {
		r0 = rf(_a0, _a1, _a2, _a3)
	} else {
		r0 = ret.Get(0).(dbus.Handle)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(dbus.Handle, string, string, string) error); ok {
		r1 = rf(_a0, _a1, _a2, _a3)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelForSignal provides a mock function with given fields: signalName
func (_m *DBusAPI) GetChannelForSignal(signalName string) chan []dbus.SignalParams {
	ret := _m.Called(signalName)

	var r0 chan []dbus.SignalParams
	if rf, ok := ret.Get(0).(func(string) chan []dbus.SignalParams); ok {
		r0 = rf(signalName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan []dbus.SignalParams)
		}
	}

	return r0
}

// HandleSignal provides a mock function with given fields: signalName, params
func (_m *DBusAPI) HandleSignal(signalName string, params []dbus.SignalParams) {
	_m.Called(signalName, params)
}

// MainLoopNew provides a mock function with given fields:
func (_m *DBusAPI) MainLoopNew() dbus.MainLoop {
	ret := _m.Called()

	var r0 dbus.MainLoop
	if rf, ok := ret.Get(0).(func() dbus.MainLoop); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(dbus.MainLoop)
	}

	return r0
}

// MainLoopQuit provides a mock function with given fields: _a0
func (_m *DBusAPI) MainLoopQuit(_a0 dbus.MainLoop) {
	_m.Called(_a0)
}

// MainLoopRun provides a mock function with given fields: _a0
func (_m *DBusAPI) MainLoopRun(_a0 dbus.MainLoop) {
	_m.Called(_a0)
}

// WaitForSignal provides a mock function with given fields: signalName, timeout
func (_m *DBusAPI) WaitForSignal(signalName string, timeout time.Duration) ([]dbus.SignalParams, error) {
	ret := _m.Called(signalName, timeout)

	var r0 []dbus.SignalParams
	if rf, ok := ret.Get(0).(func(string, time.Duration) []dbus.SignalParams); ok {
		r0 = rf(signalName, timeout)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]dbus.SignalParams)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string, time.Duration) error); ok {
		r1 = rf(signalName, timeout)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
