# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.non_linear_cell import NonLinearCell


class QuadraticHexahedron(NonLinearCell):
    r"""
    QuadraticHexahedron - cell represents a parabolic, 20-node
    isoparametric hexahedron
    
    Superclass: NonLinearCell
    
    QuadraticHexahedron is a concrete implementation of
    NonLinearCell to represent a three-dimensional, 20-node
    isoparametric parabolic hexahedron. The interpolation is the standard
    finite element, quadratic isoparametric shape function. The cell
    includes a mid-edge node. The ordering of the twenty points defining
    the cell is point ids (0-7,8-19) where point ids 0-7 are the eight
    corner vertices of the cube; followed by twelve midedge nodes (8-19).
    Note that these midedge nodes correspond lie on the edges defined by
    (0,1), (1,2), (2,3), (3,0), (4,5), (5,6), (6,7), (7,4), (0,4), (1,5),
    (2,6), (3,7).
    
    @sa
    QuadraticEdge QuadraticTriangle QuadraticTetra
    QuadraticQuad QuadraticPyramid QuadraticWedge
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkQuadraticHexahedron, obj, update, **traits)
    
    def get_edge_array(self, *args):
        """
        get_edge_array(edgeId:int) -> Pointer
        C++: static const IdType *get_edge_array(IdType edgeId)
        Return the ids of the vertices defining edge/face
        (`edgeId`/`faceId'). Ids are related to the cell, not to the
        dataset.
        
        ote The return type changed. It used to be int*, it is now const
        IdType*. This is so ids are unified between Cell and
        Points.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeArray, *args)
        return ret

    def get_face_array(self, *args):
        """
        get_face_array(faceId:int) -> Pointer
        C++: static const IdType *get_face_array(IdType faceId)"""
        ret = self._wrap_call(self._vtk_obj.GetFaceArray, *args)
        return ret

    def interpolation_derivs(self, *args):
        """
        interpolation_derivs(pcoords:(float, float, float), derivs:[float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float])
            -> None
        C++: static void interpolation_derivs(const double pcoords[3],
            double derivs[60])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationDerivs, *args)
        return ret

    def interpolation_functions(self, *args):
        """
        interpolation_functions(pcoords:(float, float, float),
            weights:[float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float]) -> None
        C++: static void interpolation_functions(const double pcoords[3],
            double weights[20])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationFunctions, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(QuadraticHexahedron, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit QuadraticHexahedron properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit QuadraticHexahedron properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit QuadraticHexahedron properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

