/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

#include <basegfx/polygon/b2dpolygontriangulator.hxx>
#include <svx/svxdllapi.h>
#include <tools/long.hxx>
#include <unotools/resmgr.hxx>

class SdrModel;
class SdrObject;
class SfxItemSet;

class SVXCORE_DLLPUBLIC ConstructHelper
{
public:
    // Helper to find the shape for a given line end
    static ::basegfx::B2DPolyPolygon GetLineEndPoly(TranslateId pResId, const SdrModel& rModel);

    // set line starts and ends for newly created objects
    static void SetLineEnds(SfxItemSet& rAttr, const SdrObject& rObj, sal_uInt16 nSlotId,
                            tools::Long nWidth);
    static void SetAttributes(SfxItemSet& rAttr, sal_uInt16 nSlotId);
};

//////////////////////////////////////////////////////////////////////////////
/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
