/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#pragma once

#include <sal/config.h>

#define OOO_STRING_SVTOOLS_RTF_HEXCHAR "\\'"
#define OOO_STRING_SVTOOLS_RTF_IGNORE "\\*"
#define OOO_STRING_SVTOOLS_RTF_OPTHYPH "\\-"
#define OOO_STRING_SVTOOLS_RTF_SUBENTRY "\\:"
#define OOO_STRING_SVTOOLS_RTF_NOBRKHYPH "\\_"
#define OOO_STRING_SVTOOLS_RTF_AB "\\ab"
#define OOO_STRING_SVTOOLS_RTF_ABSH "\\absh"
#define OOO_STRING_SVTOOLS_RTF_ABSLOCK "\\abslock" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ABSNOOVRLP "\\absnoovrlp"
#define OOO_STRING_SVTOOLS_RTF_ABSW "\\absw"
#define OOO_STRING_SVTOOLS_RTF_ACAPS "\\acaps"
#define OOO_STRING_SVTOOLS_RTF_ACCCIRCLE "\\acccircle" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ACCCOMMA "\\acccomma" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ACCDOT "\\accdot" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ACCNONE "\\accnone" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ACCUNDERDOT "\\accunderdot" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ACF "\\acf"
#define OOO_STRING_SVTOOLS_RTF_ADDITIVE "\\additive"
#define OOO_STRING_SVTOOLS_RTF_ADEFF "\\adeff" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ADEFLANG "\\adeflang" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ADJUSTRIGHT "\\adjustright" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ADN "\\adn"
#define OOO_STRING_SVTOOLS_RTF_AENDDOC "\\aenddoc"
#define OOO_STRING_SVTOOLS_RTF_AENDNOTES "\\aendnotes"
#define OOO_STRING_SVTOOLS_RTF_AEXPND "\\aexpnd"
#define OOO_STRING_SVTOOLS_RTF_AF "\\af"
#define OOO_STRING_SVTOOLS_RTF_AFS "\\afs"
#define OOO_STRING_SVTOOLS_RTF_AFTNBJ "\\aftnbj"
#define OOO_STRING_SVTOOLS_RTF_AFTNCN "\\aftncn"
#define OOO_STRING_SVTOOLS_RTF_AFTNNALC "\\aftnnalc"
#define OOO_STRING_SVTOOLS_RTF_AFTNNAR "\\aftnnar"
#define OOO_STRING_SVTOOLS_RTF_AFTNNAUC "\\aftnnauc"
#define OOO_STRING_SVTOOLS_RTF_AFTNNCHI "\\aftnnchi"
#define OOO_STRING_SVTOOLS_RTF_AFTNNCHOSUNG "\\aftnnchosung" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNCNUM "\\aftnncnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNDBAR "\\aftnndbar" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNDBNUM "\\aftnndbnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMD "\\aftnndbnumd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMK "\\aftnndbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNDBNUMT "\\aftnndbnumt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNGANADA "\\aftnnganada" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNGBNUM "\\aftnngbnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMD "\\aftnngbnumd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNGBNUMK "\\aftnngbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNGBNUML "\\aftnngbnuml" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNRLC "\\aftnnrlc"
#define OOO_STRING_SVTOOLS_RTF_AFTNNRUC "\\aftnnruc"
#define OOO_STRING_SVTOOLS_RTF_AFTNNZODIAC "\\aftnnzodiac" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNZODIACD "\\aftnnzodiacd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNNZODIACL "\\aftnnzodiacl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AFTNRESTART "\\aftnrestart"
#define OOO_STRING_SVTOOLS_RTF_AFTNRSTCONT "\\aftnrstcont"
#define OOO_STRING_SVTOOLS_RTF_AFTNSEP "\\aftnsep"
#define OOO_STRING_SVTOOLS_RTF_AFTNSEPC "\\aftnsepc"
#define OOO_STRING_SVTOOLS_RTF_AFTNSTART "\\aftnstart"
#define OOO_STRING_SVTOOLS_RTF_AFTNTJ "\\aftntj"
#define OOO_STRING_SVTOOLS_RTF_AI "\\ai"
#define OOO_STRING_SVTOOLS_RTF_ALANG "\\alang"
#define OOO_STRING_SVTOOLS_RTF_ALLPROT "\\allprot"
#define OOO_STRING_SVTOOLS_RTF_ALT "\\alt"
#define OOO_STRING_SVTOOLS_RTF_ANIMTEXT "\\animtext" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ANNOTATION "\\annotation"
#define OOO_STRING_SVTOOLS_RTF_ANNOTPROT "\\annotprot"
#define OOO_STRING_SVTOOLS_RTF_ANSI "\\ansi"
#define OOO_STRING_SVTOOLS_RTF_ANSICPG "\\ansicpg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_AOUTL "\\aoutl"
#define OOO_STRING_SVTOOLS_RTF_ASCAPS "\\ascaps"
#define OOO_STRING_SVTOOLS_RTF_ASHAD "\\ashad"
#define OOO_STRING_SVTOOLS_RTF_ASPALPHA "\\aspalpha" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ASTRIKE "\\astrike"
#define OOO_STRING_SVTOOLS_RTF_ATNAUTHOR "\\atnauthor"
#define OOO_STRING_SVTOOLS_RTF_ATNDATE "\\atndate"
#define OOO_STRING_SVTOOLS_RTF_ATNICN "\\atnicn"
#define OOO_STRING_SVTOOLS_RTF_ATNID "\\atnid"
#define OOO_STRING_SVTOOLS_RTF_ATNREF "\\atnref"
#define OOO_STRING_SVTOOLS_RTF_ATNTIME "\\atntime"
#define OOO_STRING_SVTOOLS_RTF_ATRFEND "\\atrfend"
#define OOO_STRING_SVTOOLS_RTF_ATRFSTART "\\atrfstart"
#define OOO_STRING_SVTOOLS_RTF_AUL "\\aul"
#define OOO_STRING_SVTOOLS_RTF_AULD "\\auld"
#define OOO_STRING_SVTOOLS_RTF_AULDB "\\auldb"
#define OOO_STRING_SVTOOLS_RTF_AULNONE "\\aulnone"
#define OOO_STRING_SVTOOLS_RTF_AULW "\\aulw"
#define OOO_STRING_SVTOOLS_RTF_AUP "\\aup"
#define OOO_STRING_SVTOOLS_RTF_AUTHOR "\\author"
#define OOO_STRING_SVTOOLS_RTF_B "\\b"
#define OOO_STRING_SVTOOLS_RTF_BACKGROUND "\\background" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BDBFHDR "\\bdbfhdr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BGBDIAG "\\bgbdiag"
#define OOO_STRING_SVTOOLS_RTF_BGCROSS "\\bgcross"
#define OOO_STRING_SVTOOLS_RTF_BGDCROSS "\\bgdcross"
#define OOO_STRING_SVTOOLS_RTF_BGDKBDIAG "\\bgdkbdiag"
#define OOO_STRING_SVTOOLS_RTF_BGDKCROSS "\\bgdkcross"
#define OOO_STRING_SVTOOLS_RTF_BGDKDCROSS "\\bgdkdcross"
#define OOO_STRING_SVTOOLS_RTF_BGDKFDIAG "\\bgdkfdiag"
#define OOO_STRING_SVTOOLS_RTF_BGDKHORIZ "\\bgdkhoriz"
#define OOO_STRING_SVTOOLS_RTF_BGDKVERT "\\bgdkvert"
#define OOO_STRING_SVTOOLS_RTF_BGFDIAG "\\bgfdiag"
#define OOO_STRING_SVTOOLS_RTF_BGHORIZ "\\bghoriz"
#define OOO_STRING_SVTOOLS_RTF_BGVERT "\\bgvert"
#define OOO_STRING_SVTOOLS_RTF_BIN "\\bin"
#define OOO_STRING_SVTOOLS_RTF_BINFSXN "\\binfsxn"
#define OOO_STRING_SVTOOLS_RTF_BINSXN "\\binsxn"
#define OOO_STRING_SVTOOLS_RTF_BKMKCOLF "\\bkmkcolf"
#define OOO_STRING_SVTOOLS_RTF_BKMKCOLL "\\bkmkcoll"
#define OOO_STRING_SVTOOLS_RTF_BKMKEND "\\bkmkend"
#define OOO_STRING_SVTOOLS_RTF_BKMKKEY "\\bkmkkey" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_BKMKPUB "\\bkmkpub"
#define OOO_STRING_SVTOOLS_RTF_BKMKSTART "\\bkmkstart"
#define OOO_STRING_SVTOOLS_RTF_BLIPTAG "\\bliptag" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BLIPUID "\\blipuid" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BLIPUPI "\\blipupi" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BLUE "\\blue"
#define OOO_STRING_SVTOOLS_RTF_BOX "\\box"
#define OOO_STRING_SVTOOLS_RTF_BRDRART "\\brdrart" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRB "\\brdrb"
#define OOO_STRING_SVTOOLS_RTF_BRDRBAR "\\brdrbar"
#define OOO_STRING_SVTOOLS_RTF_BRDRBTW "\\brdrbtw"
#define OOO_STRING_SVTOOLS_RTF_BRDRCF "\\brdrcf"
#define OOO_STRING_SVTOOLS_RTF_BRDRDASH "\\brdrdash"
#define OOO_STRING_SVTOOLS_RTF_BRDRDASHD "\\brdrdashd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRDASHDD "\\brdrdashdd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRDASHDOTSTR "\\brdrdashdotstr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRDASHSM "\\brdrdashsm" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRDB "\\brdrdb"
#define OOO_STRING_SVTOOLS_RTF_BRDRDOT "\\brdrdot"
#define OOO_STRING_SVTOOLS_RTF_BRDREMBOSS "\\brdremboss" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRENGRAVE "\\brdrengrave" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRFRAME "\\brdrframe" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRHAIR "\\brdrhair"
#define OOO_STRING_SVTOOLS_RTF_BRDRINSET "\\brdrinset" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRL "\\brdrl"
#define OOO_STRING_SVTOOLS_RTF_BRDRNONE "\\brdrnone" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDROUTSET "\\brdroutset" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRR "\\brdrr"
#define OOO_STRING_SVTOOLS_RTF_BRDRS "\\brdrs"
#define LO_STRING_SVTOOLS_RTF_BRDRSH "\\brdrsh"
#define OOO_STRING_SVTOOLS_RTF_BRDRSH "\\brdrsh"
#define OOO_STRING_SVTOOLS_RTF_BRDRT "\\brdrt"
#define OOO_STRING_SVTOOLS_RTF_BRDRTH "\\brdrth"
#define OOO_STRING_SVTOOLS_RTF_BRDRTHTNLG "\\brdrthtnlg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTHTNMG "\\brdrthtnmg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTHTNSG "\\brdrthtnsg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTNTHLG "\\brdrtnthlg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTNTHMG "\\brdrtnthmg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTNTHSG "\\brdrtnthsg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNLG "\\brdrtnthtnlg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNMG "\\brdrtnthtnmg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTNTHTNSG "\\brdrtnthtnsg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRTRIPLE "\\brdrtriple" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRW "\\brdrw"
#define OOO_STRING_SVTOOLS_RTF_BRDRWAVY "\\brdrwavy" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRDRWAVYDB "\\brdrwavydb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_BRKFRM "\\brkfrm"
#define OOO_STRING_SVTOOLS_RTF_BRSP "\\brsp"
#define OOO_STRING_SVTOOLS_RTF_BULLET "\\bullet"
#define OOO_STRING_SVTOOLS_RTF_BUPTIM "\\buptim"
#define OOO_STRING_SVTOOLS_RTF_BXE "\\bxe"
#define OOO_STRING_SVTOOLS_RTF_CAPS "\\caps"
#define OOO_STRING_SVTOOLS_RTF_CATEGORY "\\category" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CB "\\cb"
#define OOO_STRING_SVTOOLS_RTF_CBPAT "\\cbpat"
#define OOO_STRING_SVTOOLS_RTF_CCHS "\\cchs"
#define OOO_STRING_SVTOOLS_RTF_CELL "\\cell"
#define OOO_STRING_SVTOOLS_RTF_CELLX "\\cellx"
#define OOO_STRING_SVTOOLS_RTF_CF "\\cf"
#define OOO_STRING_SVTOOLS_RTF_CFPAT "\\cfpat"
#define OOO_STRING_SVTOOLS_RTF_CGRID "\\cgrid" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHARSCALEX "\\charscalex" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHATN "\\chatn"
#define OOO_STRING_SVTOOLS_RTF_CHBGBDIAG "\\chbgbdiag" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGCROSS "\\chbgcross" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGDCROSS "\\chbgdcross" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGDKBDIAG "\\chbgdkbdiag" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGDKCROSS "\\chbgdkcross" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGDKDCROSS "\\chbgdkdcross" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGDKFDIAG "\\chbgdkfdiag" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGDKHORIZ "\\chbgdkhoriz" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGDKVERT "\\chbgdkvert" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGFDIAG "\\chbgfdiag" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGHORIZ "\\chbghoriz" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBGVERT "\\chbgvert" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHBRDR "\\chbrdr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHCBPAT "\\chcbpat" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHCFPAT "\\chcfpat" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHDATE "\\chdate"
#define OOO_STRING_SVTOOLS_RTF_CHDPA "\\chdpa"
#define OOO_STRING_SVTOOLS_RTF_CHDPL "\\chdpl"
#define OOO_STRING_SVTOOLS_RTF_CHFTN "\\chftn"
#define OOO_STRING_SVTOOLS_RTF_CHFTNSEP "\\chftnsep"
#define OOO_STRING_SVTOOLS_RTF_CHFTNSEPC "\\chftnsepc"
#define OOO_STRING_SVTOOLS_RTF_CHPGN "\\chpgn"
#define OOO_STRING_SVTOOLS_RTF_CHSHDNG "\\chshdng" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CHTIME "\\chtime"
#define OOO_STRING_SVTOOLS_RTF_CLBGBDIAG "\\clbgbdiag"
#define OOO_STRING_SVTOOLS_RTF_CLBGCROSS "\\clbgcross"
#define OOO_STRING_SVTOOLS_RTF_CLBGDCROSS "\\clbgdcross"
#define OOO_STRING_SVTOOLS_RTF_CLBGDKBDIAG "\\clbgdkbdiag"
#define OOO_STRING_SVTOOLS_RTF_CLBGDKCROSS "\\clbgdkcross"
#define OOO_STRING_SVTOOLS_RTF_CLBGDKDCROSS "\\clbgdkdcross"
#define OOO_STRING_SVTOOLS_RTF_CLBGDKFDIAG "\\clbgdkfdiag"
#define OOO_STRING_SVTOOLS_RTF_CLBGDKHOR "\\clbgdkhor"
#define OOO_STRING_SVTOOLS_RTF_CLBGDKVERT "\\clbgdkvert"
#define OOO_STRING_SVTOOLS_RTF_CLBGFDIAG "\\clbgfdiag"
#define OOO_STRING_SVTOOLS_RTF_CLBGHORIZ "\\clbghoriz"
#define OOO_STRING_SVTOOLS_RTF_CLBGVERT "\\clbgvert"
#define OOO_STRING_SVTOOLS_RTF_CLBRDRB "\\clbrdrb"
#define OOO_STRING_SVTOOLS_RTF_CLBRDRL "\\clbrdrl"
#define OOO_STRING_SVTOOLS_RTF_CLBRDRR "\\clbrdrr"
#define OOO_STRING_SVTOOLS_RTF_CLBRDRT "\\clbrdrt"
#define OOO_STRING_SVTOOLS_RTF_CLCBPAT "\\clcbpat"
#define OOO_STRING_SVTOOLS_RTF_CLCFPAT "\\clcfpat"
#define OOO_STRING_SVTOOLS_RTF_CLMGF "\\clmgf"
#define OOO_STRING_SVTOOLS_RTF_CLMRG "\\clmrg"
#define OOO_STRING_SVTOOLS_RTF_CLPADB "\\clpadb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLPADFB "\\clpadfb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLPADFL "\\clpadfl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLPADFR "\\clpadfr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLPADFT "\\clpadft" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLPADL "\\clpadl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLPADR "\\clpadr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLPADT "\\clpadt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLSHDNG "\\clshdng"
#define OOO_STRING_SVTOOLS_RTF_CLTXBTLR "\\cltxbtlr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLTXLRTB "\\cltxlrtb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLTXLRTBV "\\cltxlrtbv" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLTXTBRL "\\cltxtbrl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLTXTBRLV "\\cltxtbrlv" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLVERTALB "\\clvertalb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLVERTALC "\\clvertalc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLVERTALT "\\clvertalt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLVMGF "\\clvmgf" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CLVMRG "\\clvmrg" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_COLNO "\\colno"
#define OOO_STRING_SVTOOLS_RTF_COLORTBL "\\colortbl"
#define OOO_STRING_SVTOOLS_RTF_COLS "\\cols"
#define OOO_STRING_SVTOOLS_RTF_COLSR "\\colsr"
#define OOO_STRING_SVTOOLS_RTF_COLSX "\\colsx"
#define OOO_STRING_SVTOOLS_RTF_COLUMN "\\column"
#define OOO_STRING_SVTOOLS_RTF_COLW "\\colw"
#define OOO_STRING_SVTOOLS_RTF_COMMENT "\\comment"
#define OOO_STRING_SVTOOLS_RTF_COMPANY "\\company" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CONTEXTUALSPACE "\\contextualspace"
#define OOO_STRING_SVTOOLS_RTF_CPG "\\cpg"
#define OOO_STRING_SVTOOLS_RTF_CRAUTH "\\crauth" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CRDATE "\\crdate" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_CREATIM "\\creatim"
#define OOO_STRING_SVTOOLS_RTF_CS "\\cs"
#define OOO_STRING_SVTOOLS_RTF_CTRL "\\ctrl"
#define OOO_STRING_SVTOOLS_RTF_CVMME "\\cvmme"
#define OOO_STRING_SVTOOLS_RTF_DATAFIELD "\\datafield"
#define OOO_STRING_SVTOOLS_RTF_DATE "\\date" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DBCH "\\dbch" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_DEFF "\\deff"
#define OOO_STRING_SVTOOLS_RTF_DEFFORMAT "\\defformat"
#define OOO_STRING_SVTOOLS_RTF_DEFLANG "\\deflang"
#define OOO_STRING_SVTOOLS_RTF_DEFLANGFE "\\deflangfe" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DEFTAB "\\deftab"
#define OOO_STRING_SVTOOLS_RTF_DELETED "\\deleted"
#define OOO_STRING_SVTOOLS_RTF_DFRAUTH "\\dfrauth" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DFRDATE "\\dfrdate" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DFRMTXTL "\\dfrmtxtl" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_DFRMTXTR "\\dfrmtxtr" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_DFRMTXTU "\\dfrmtxtu" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_DFRMTXTW "\\dfrmtxtw" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_DFRMTXTX "\\dfrmtxtx"
#define OOO_STRING_SVTOOLS_RTF_DFRMTXTY "\\dfrmtxty"
#define OOO_STRING_SVTOOLS_RTF_DFRSTART "\\dfrstart" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DFRSTOP "\\dfrstop" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DFRXST "\\dfrxst" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DGMARGIN "\\dgmargin" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DIBITMAP "\\dibitmap"
#define OOO_STRING_SVTOOLS_RTF_DN "\\dn"
#define OOO_STRING_SVTOOLS_RTF_DNTBLNSBDB "\\dntblnsbdb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DO "\\do"
#define OOO_STRING_SVTOOLS_RTF_DOBXCOLUMN "\\dobxcolumn"
#define OOO_STRING_SVTOOLS_RTF_DOBXMARGIN "\\dobxmargin"
#define OOO_STRING_SVTOOLS_RTF_DOBXPAGE "\\dobxpage"
#define OOO_STRING_SVTOOLS_RTF_DOBYMARGIN "\\dobymargin"
#define OOO_STRING_SVTOOLS_RTF_DOBYPAGE "\\dobypage"
#define OOO_STRING_SVTOOLS_RTF_DOBYPARA "\\dobypara"
#define OOO_STRING_SVTOOLS_RTF_DOCCOMM "\\doccomm"
#define OOO_STRING_SVTOOLS_RTF_DOCTEMP "\\doctemp"
#define OOO_STRING_SVTOOLS_RTF_DOCTYPE "\\doctype" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DOCVAR "\\docvar" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DODHGT "\\dodhgt"
#define OOO_STRING_SVTOOLS_RTF_DOLOCK "\\dolock"
#define OOO_STRING_SVTOOLS_RTF_DPAENDHOL "\\dpaendhol"
#define OOO_STRING_SVTOOLS_RTF_DPAENDL "\\dpaendl"
#define OOO_STRING_SVTOOLS_RTF_DPAENDSOL "\\dpaendsol"
#define OOO_STRING_SVTOOLS_RTF_DPAENDW "\\dpaendw"
#define OOO_STRING_SVTOOLS_RTF_DPARC "\\dparc"
#define OOO_STRING_SVTOOLS_RTF_DPARCFLIPX "\\dparcflipx"
#define OOO_STRING_SVTOOLS_RTF_DPARCFLIPY "\\dparcflipy"
#define OOO_STRING_SVTOOLS_RTF_DPASTARTHOL "\\dpastarthol"
#define OOO_STRING_SVTOOLS_RTF_DPASTARTL "\\dpastartl"
#define OOO_STRING_SVTOOLS_RTF_DPASTARTSOL "\\dpastartsol"
#define OOO_STRING_SVTOOLS_RTF_DPASTARTW "\\dpastartw"
#define OOO_STRING_SVTOOLS_RTF_DPCALLOUT "\\dpcallout"
#define OOO_STRING_SVTOOLS_RTF_DPCOA "\\dpcoa"
#define OOO_STRING_SVTOOLS_RTF_DPCOACCENT "\\dpcoaccent"
#define OOO_STRING_SVTOOLS_RTF_DPCOBESTFIT "\\dpcobestfit"
#define OOO_STRING_SVTOOLS_RTF_DPCOBORDER "\\dpcoborder"
#define OOO_STRING_SVTOOLS_RTF_DPCODABS "\\dpcodabs"
#define OOO_STRING_SVTOOLS_RTF_DPCODBOTTOM "\\dpcodbottom"
#define OOO_STRING_SVTOOLS_RTF_DPCODCENTER "\\dpcodcenter"
#define OOO_STRING_SVTOOLS_RTF_DPCODESCENT "\\dpcodescent" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_DPCODTOP "\\dpcodtop"
#define OOO_STRING_SVTOOLS_RTF_DPCOLENGTH "\\dpcolength"
#define OOO_STRING_SVTOOLS_RTF_DPCOMINUSX "\\dpcominusx"
#define OOO_STRING_SVTOOLS_RTF_DPCOMINUSY "\\dpcominusy"
#define OOO_STRING_SVTOOLS_RTF_DPCOOFFSET "\\dpcooffset"
#define OOO_STRING_SVTOOLS_RTF_DPCOSMARTA "\\dpcosmarta"
#define OOO_STRING_SVTOOLS_RTF_DPCOTDOUBLE "\\dpcotdouble"
#define OOO_STRING_SVTOOLS_RTF_DPCOTRIGHT "\\dpcotright"
#define OOO_STRING_SVTOOLS_RTF_DPCOTSINGLE "\\dpcotsingle"
#define OOO_STRING_SVTOOLS_RTF_DPCOTTRIPLE "\\dpcottriple"
#define OOO_STRING_SVTOOLS_RTF_DPCOUNT "\\dpcount"
#define OOO_STRING_SVTOOLS_RTF_DPELLIPSE "\\dpellipse"
#define OOO_STRING_SVTOOLS_RTF_DPENDGROUP "\\dpendgroup"
#define OOO_STRING_SVTOOLS_RTF_DPFILLBGCB "\\dpfillbgcb"
#define OOO_STRING_SVTOOLS_RTF_DPFILLBGCG "\\dpfillbgcg"
#define OOO_STRING_SVTOOLS_RTF_DPFILLBGCR "\\dpfillbgcr"
#define OOO_STRING_SVTOOLS_RTF_DPFILLBGGRAY "\\dpfillbggray"
#define OOO_STRING_SVTOOLS_RTF_DPFILLBGPAL "\\dpfillbgpal"
#define OOO_STRING_SVTOOLS_RTF_DPFILLFGCB "\\dpfillfgcb"
#define OOO_STRING_SVTOOLS_RTF_DPFILLFGCG "\\dpfillfgcg"
#define OOO_STRING_SVTOOLS_RTF_DPFILLFGCR "\\dpfillfgcr"
#define OOO_STRING_SVTOOLS_RTF_DPFILLFGGRAY "\\dpfillfggray"
#define OOO_STRING_SVTOOLS_RTF_DPFILLFGPAL "\\dpfillfgpal"
#define OOO_STRING_SVTOOLS_RTF_DPFILLPAT "\\dpfillpat"
#define OOO_STRING_SVTOOLS_RTF_DPGROUP "\\dpgroup"
#define OOO_STRING_SVTOOLS_RTF_DPLINE "\\dpline"
#define OOO_STRING_SVTOOLS_RTF_DPLINECOB "\\dplinecob"
#define OOO_STRING_SVTOOLS_RTF_DPLINECOG "\\dplinecog"
#define OOO_STRING_SVTOOLS_RTF_DPLINECOR "\\dplinecor"
#define OOO_STRING_SVTOOLS_RTF_DPLINEDADO "\\dplinedado"
#define OOO_STRING_SVTOOLS_RTF_DPLINEDADODO "\\dplinedadodo"
#define OOO_STRING_SVTOOLS_RTF_DPLINEDASH "\\dplinedash"
#define OOO_STRING_SVTOOLS_RTF_DPLINEDOT "\\dplinedot"
#define OOO_STRING_SVTOOLS_RTF_DPLINEGRAY "\\dplinegray"
#define OOO_STRING_SVTOOLS_RTF_DPLINEHOLLOW "\\dplinehollow"
#define OOO_STRING_SVTOOLS_RTF_DPLINEPAL "\\dplinepal"
#define OOO_STRING_SVTOOLS_RTF_DPLINESOLID "\\dplinesolid"
#define OOO_STRING_SVTOOLS_RTF_DPLINEW "\\dplinew"
#define OOO_STRING_SVTOOLS_RTF_DPPOLYCOUNT "\\dppolycount"
#define OOO_STRING_SVTOOLS_RTF_DPPOLYGON "\\dppolygon"
#define OOO_STRING_SVTOOLS_RTF_DPPOLYLINE "\\dppolyline"
#define OOO_STRING_SVTOOLS_RTF_DPPTX "\\dpptx"
#define OOO_STRING_SVTOOLS_RTF_DPPTY "\\dppty"
#define OOO_STRING_SVTOOLS_RTF_DPRECT "\\dprect"
#define OOO_STRING_SVTOOLS_RTF_DPROUNDR "\\dproundr"
#define OOO_STRING_SVTOOLS_RTF_DPSHADOW "\\dpshadow"
#define OOO_STRING_SVTOOLS_RTF_DPSHADX "\\dpshadx"
#define OOO_STRING_SVTOOLS_RTF_DPSHADY "\\dpshady"
#define OOO_STRING_SVTOOLS_RTF_DPTXBX "\\dptxbx"
#define OOO_STRING_SVTOOLS_RTF_DPTXBXMAR "\\dptxbxmar"
#define OOO_STRING_SVTOOLS_RTF_DPTXBXTEXT "\\dptxbxtext"
#define OOO_STRING_SVTOOLS_RTF_DPX "\\dpx"
#define OOO_STRING_SVTOOLS_RTF_DPXSIZE "\\dpxsize"
#define OOO_STRING_SVTOOLS_RTF_DPY "\\dpy"
#define OOO_STRING_SVTOOLS_RTF_DPYSIZE "\\dpysize"
#define OOO_STRING_SVTOOLS_RTF_DROPCAPLI "\\dropcapli"
#define OOO_STRING_SVTOOLS_RTF_DROPCAPT "\\dropcapt"
#define OOO_STRING_SVTOOLS_RTF_DS "\\ds"
#define OOO_STRING_SVTOOLS_RTF_DXFRTEXT "\\dxfrtext"
#define OOO_STRING_SVTOOLS_RTF_DY "\\dy"
#define OOO_STRING_SVTOOLS_RTF_EDMINS "\\edmins"
#define OOO_STRING_SVTOOLS_RTF_EMBO "\\embo" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_EMDASH "\\emdash"
#define OOO_STRING_SVTOOLS_RTF_EMFBLIP "\\emfblip" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_EMSPACE "\\emspace"
#define OOO_STRING_SVTOOLS_RTF_ENDASH "\\endash"
#define OOO_STRING_SVTOOLS_RTF_ENDDOC "\\enddoc"
#define OOO_STRING_SVTOOLS_RTF_ENDNHERE "\\endnhere"
#define OOO_STRING_SVTOOLS_RTF_ENDNOTES "\\endnotes"
#define OOO_STRING_SVTOOLS_RTF_ENSPACE "\\enspace"
#define OOO_STRING_SVTOOLS_RTF_EXPND "\\expnd"
#define OOO_STRING_SVTOOLS_RTF_EXPNDTW "\\expndtw"
#define OOO_STRING_SVTOOLS_RTF_EXPSHRTN "\\expshrtn" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_F "\\f"
#define OOO_STRING_SVTOOLS_RTF_FAAUTO "\\faauto" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FACENTER "\\facenter" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_FACINGP "\\facingp"
#define OOO_STRING_SVTOOLS_RTF_FACPGSXN "\\facpgsxn"
#define OOO_STRING_SVTOOLS_RTF_FAFIXED "\\fafixed" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_FAHANG "\\fahang" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_FALT "\\falt"
#define OOO_STRING_SVTOOLS_RTF_FAROMAN "\\faroman" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_FAVAR "\\favar" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_FBIAS "\\fbias" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FBIDI "\\fbidi"
#define OOO_STRING_SVTOOLS_RTF_FCHARSET "\\fcharset"
#define OOO_STRING_SVTOOLS_RTF_FDECOR "\\fdecor"
#define OOO_STRING_SVTOOLS_RTF_FET "\\fet"
#define OOO_STRING_SVTOOLS_RTF_FFDEFRES "\\ffdefres" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFDEFTEXT "\\ffdeftext" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFENTRYMCR "\\ffentrymcr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFEXITMCR "\\ffexitmcr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFFORMAT "\\ffformat" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFHASLISTBOX "\\ffhaslistbox" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFHELPTEXT "\\ffhelptext" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFHPS "\\ffhps" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFL "\\ffl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFMAXLEN "\\ffmaxlen" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFNAME "\\ffname" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFOWNHELP "\\ffownhelp" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFOWNSTAT "\\ffownstat" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFPROT "\\ffprot" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFRECALC "\\ffrecalc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFRES "\\ffres" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFSIZE "\\ffsize" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFSTATTEXT "\\ffstattext" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFTYPE "\\fftype" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FFTYPETXT "\\fftypetxt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FI "\\fi"
#define OOO_STRING_SVTOOLS_RTF_FID "\\fid"
#define OOO_STRING_SVTOOLS_RTF_FIELD "\\field"
#define OOO_STRING_SVTOOLS_RTF_FILE "\\file"
#define OOO_STRING_SVTOOLS_RTF_FILETBL "\\filetbl"
#define OOO_STRING_SVTOOLS_RTF_FLDALT "\\fldalt"
#define OOO_STRING_SVTOOLS_RTF_FLDDIRTY "\\flddirty"
#define OOO_STRING_SVTOOLS_RTF_FLDEDIT "\\fldedit"
#define OOO_STRING_SVTOOLS_RTF_FLDINST "\\fldinst"
#define OOO_STRING_SVTOOLS_RTF_FLDLOCK "\\fldlock"
#define OOO_STRING_SVTOOLS_RTF_FLDPRIV "\\fldpriv"
#define OOO_STRING_SVTOOLS_RTF_FLDRSLT "\\fldrslt"
#define OOO_STRING_SVTOOLS_RTF_FLDTYPE "\\fldtype" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FLYANCHOR "\\flyanchor" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYCNTNT "\\flycntnt" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYCOLUMN "\\flycolumn" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYHORZ "\\flyhorz" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYINPARA "\\flyinpara" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYMAINCNT "\\flymaincnt" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYOPAQUE "\\flyopaque" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYPAGE "\\flypage" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYPRINT "\\flyprint" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYPRTCTD "\\flyprtctd" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FLYVERT "\\flyvert" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FMODERN "\\fmodern"
#define OOO_STRING_SVTOOLS_RTF_FN "\\fn"
#define OOO_STRING_SVTOOLS_RTF_FNAME "\\fname" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FNETWORK "\\fnetwork"
#define OOO_STRING_SVTOOLS_RTF_FNIL "\\fnil"
#define OOO_STRING_SVTOOLS_RTF_FONTEMB "\\fontemb"
#define OOO_STRING_SVTOOLS_RTF_FONTFILE "\\fontfile"
#define OOO_STRING_SVTOOLS_RTF_FONTTBL "\\fonttbl"
#define OOO_STRING_SVTOOLS_RTF_FOOTER "\\footer"
#define OOO_STRING_SVTOOLS_RTF_FOOTERF "\\footerf"
#define OOO_STRING_SVTOOLS_RTF_FOOTERL "\\footerl"
#define OOO_STRING_SVTOOLS_RTF_FOOTERR "\\footerr"
#define OOO_STRING_SVTOOLS_RTF_FOOTERXL "\\footerxl" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FOOTERXR "\\footerxr" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FOOTERY "\\footery"
#define OOO_STRING_SVTOOLS_RTF_FOOTERYH "\\footeryh" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FOOTERYT "\\footeryt" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_FOOTNOTE "\\footnote"
#define OOO_STRING_SVTOOLS_RTF_FORMDISP "\\formdisp"
#define OOO_STRING_SVTOOLS_RTF_FORMFIELD "\\formfield" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FORMPROT "\\formprot"
#define OOO_STRING_SVTOOLS_RTF_FORMSHADE "\\formshade"
#define OOO_STRING_SVTOOLS_RTF_FOSNUM "\\fosnum"
#define OOO_STRING_SVTOOLS_RTF_FPRQ "\\fprq"
#define OOO_STRING_SVTOOLS_RTF_FRACWIDTH "\\fracwidth"
#define OOO_STRING_SVTOOLS_RTF_FRELATIVE "\\frelative"
#define OOO_STRING_SVTOOLS_RTF_FRMTXBTLR "\\frmtxbtlr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FRMTXLRTB "\\frmtxlrtb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FRMTXLRTBV "\\frmtxlrtbv" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FRMTXTBRL "\\frmtxtbrl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FRMTXTBRLV "\\frmtxtbrlv" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FROMAN "\\froman"
#define OOO_STRING_SVTOOLS_RTF_FROMTEXT "\\fromtext" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FS "\\fs"
#define OOO_STRING_SVTOOLS_RTF_FSCRIPT "\\fscript"
#define OOO_STRING_SVTOOLS_RTF_FSWISS "\\fswiss"
#define OOO_STRING_SVTOOLS_RTF_FTECH "\\ftech"
#define OOO_STRING_SVTOOLS_RTF_FTNALT "\\ftnalt"
#define OOO_STRING_SVTOOLS_RTF_FTNBJ "\\ftnbj"
#define OOO_STRING_SVTOOLS_RTF_FTNCN "\\ftncn"
#define OOO_STRING_SVTOOLS_RTF_FTNIL "\\ftnil"
#define OOO_STRING_SVTOOLS_RTF_FTNNALC "\\ftnnalc"
#define OOO_STRING_SVTOOLS_RTF_FTNNAR "\\ftnnar"
#define OOO_STRING_SVTOOLS_RTF_FTNNAUC "\\ftnnauc"
#define OOO_STRING_SVTOOLS_RTF_FTNNCHI "\\ftnnchi"
#define OOO_STRING_SVTOOLS_RTF_FTNNCHOSUNG "\\ftnnchosung" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNCNUM "\\ftnncnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNDBAR "\\ftnndbar" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNDBNUM "\\ftnndbnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNDBNUMD "\\ftnndbnumd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNDBNUMK "\\ftnndbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNDBNUMT "\\ftnndbnumt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNGANADA "\\ftnnganada" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNGBNUM "\\ftnngbnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNGBNUMD "\\ftnngbnumd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNGBNUMK "\\ftnngbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNGBNUML "\\ftnngbnuml" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNRLC "\\ftnnrlc"
#define OOO_STRING_SVTOOLS_RTF_FTNNRUC "\\ftnnruc"
#define OOO_STRING_SVTOOLS_RTF_FTNNZODIAC "\\ftnnzodiac" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNZODIACD "\\ftnnzodiacd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNNZODIACL "\\ftnnzodiacl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_FTNRESTART "\\ftnrestart"
#define OOO_STRING_SVTOOLS_RTF_FTNRSTCONT "\\ftnrstcont"
#define OOO_STRING_SVTOOLS_RTF_FTNRSTPG "\\ftnrstpg"
#define OOO_STRING_SVTOOLS_RTF_FTNSEP "\\ftnsep"
#define OOO_STRING_SVTOOLS_RTF_FTNSEPC "\\ftnsepc"
#define OOO_STRING_SVTOOLS_RTF_FTNSTART "\\ftnstart"
#define OOO_STRING_SVTOOLS_RTF_FTNTJ "\\ftntj"
#define OOO_STRING_SVTOOLS_RTF_FTTRUETYPE "\\fttruetype"
#define OOO_STRING_SVTOOLS_RTF_FVALIDDOS "\\fvaliddos"
#define OOO_STRING_SVTOOLS_RTF_FVALIDHPFS "\\fvalidhpfs"
#define OOO_STRING_SVTOOLS_RTF_FVALIDMAC "\\fvalidmac"
#define OOO_STRING_SVTOOLS_RTF_FVALIDNTFS "\\fvalidntfs"
#define OOO_STRING_SVTOOLS_RTF_G "\\g" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_GCW "\\gcw" // rtf 1.5
#define LO_STRING_SVTOOLS_RTF_GENERATOR "\\generator"
#define OOO_STRING_SVTOOLS_RTF_GREEN "\\green"
#define OOO_STRING_SVTOOLS_RTF_GRFALIGNH "\\grfalignh" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_GRFALIGNV "\\grfalignv" // swg-specific attribute
#define OOO_STRING_SVTOOLS_RTF_GRFMIRROR "\\grfmirror" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_GRIDTBL "\\gridtbl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_GUTTER "\\gutter"
#define LO_STRING_SVTOOLS_RTF_GUTTERPRL "\\gutterprl"
#define OOO_STRING_SVTOOLS_RTF_GUTTERSXN "\\guttersxn"
#define OOO_STRING_SVTOOLS_RTF_HEADER "\\header"
#define OOO_STRING_SVTOOLS_RTF_HEADERF "\\headerf"
#define OOO_STRING_SVTOOLS_RTF_HEADERL "\\headerl"
#define OOO_STRING_SVTOOLS_RTF_HEADERR "\\headerr"
#define OOO_STRING_SVTOOLS_RTF_HEADERXL "\\headerxl" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_HEADERXR "\\headerxr" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_HEADERY "\\headery"
#define OOO_STRING_SVTOOLS_RTF_HEADERYB "\\headeryb" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_HEADERYH "\\headeryh" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_HICH "\\hich" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_HIGHLIGHT "\\highlight" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_HLFR "\\hlfr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_HLINKBASE "\\hlinkbase" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_HLLOC "\\hlloc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_HLSRC "\\hlsrc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_HORZVERT "\\horzvert" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_HR "\\hr"
#define LO_STRING_SVTOOLS_RTF_HTMAUTSP "\\htmautsp"
#define OOO_STRING_SVTOOLS_RTF_HYPHAUTO "\\hyphauto"
#define OOO_STRING_SVTOOLS_RTF_HYPHCAPS "\\hyphcaps"
#define OOO_STRING_SVTOOLS_RTF_HYPHCONSEC "\\hyphconsec"
#define OOO_STRING_SVTOOLS_RTF_HYPHEN "\\hyphen"
#define OOO_STRING_SVTOOLS_RTF_HYPHHOTZ "\\hyphhotz"
#define OOO_STRING_SVTOOLS_RTF_HYPHLEAD "\\hyphlead"
#define OOO_STRING_SVTOOLS_RTF_HYPHMAX "\\hyphmax"
#define OOO_STRING_SVTOOLS_RTF_HYPHPAR "\\hyphpar"
#define OOO_STRING_SVTOOLS_RTF_HYPHTRAIL "\\hyphtrail"
#define OOO_STRING_SVTOOLS_RTF_I "\\i"
#define OOO_STRING_SVTOOLS_RTF_ID "\\id"
#define OOO_STRING_SVTOOLS_RTF_ILVL "\\ilvl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_IMPR "\\impr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_INFO "\\info"
#define OOO_STRING_SVTOOLS_RTF_INTBL "\\intbl"
#define OOO_STRING_SVTOOLS_RTF_ITAP "\\itap" // nested tables support
#define OOO_STRING_SVTOOLS_RTF_IXE "\\ixe"
#define OOO_STRING_SVTOOLS_RTF_JPEGBLIP "\\jpegblip" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_KEEP "\\keep"
#define OOO_STRING_SVTOOLS_RTF_KEEPN "\\keepn"
#define OOO_STRING_SVTOOLS_RTF_KERNING "\\kerning"
#define OOO_STRING_SVTOOLS_RTF_KEYCODE "\\keycode"
#define OOO_STRING_SVTOOLS_RTF_KEYWORDS "\\keywords"
#define OOO_STRING_SVTOOLS_RTF_LANDSCAPE "\\landscape"
#define OOO_STRING_SVTOOLS_RTF_LANG "\\lang"
#define OOO_STRING_SVTOOLS_RTF_LANGFE "\\langfe" // MS-2000
#define LO_STRING_SVTOOLS_RTF_LBR "\\lbr"
#define OOO_STRING_SVTOOLS_RTF_LDBLQUOTE "\\ldblquote"
#define OOO_STRING_SVTOOLS_RTF_LEVEL "\\level"
#define OOO_STRING_SVTOOLS_RTF_LEVELFOLLOW "\\levelfollow" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELINDENT "\\levelindent" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELJC "\\leveljc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELLEGAL "\\levellegal" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELNFC "\\levelnfc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELNORESTART "\\levelnorestart" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELNUMBERS "\\levelnumbers" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELOLD "\\levelold" // rtf 1.5
#define LO_STRING_SVTOOLS_RTF_LEVELPICTURE "\\levelpicture"
#define OOO_STRING_SVTOOLS_RTF_LEVELPREV "\\levelprev" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELPREVSPACE "\\levelprevspace" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELSPACE "\\levelspace" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELSTARTAT "\\levelstartat" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LEVELTEXT "\\leveltext" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LFOLEVEL "\\lfolevel" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LI "\\li"
#define OOO_STRING_SVTOOLS_RTF_LIN "\\lin"
#define OOO_STRING_SVTOOLS_RTF_LINE "\\line"
#define OOO_STRING_SVTOOLS_RTF_LINEBETCOL "\\linebetcol"
#define OOO_STRING_SVTOOLS_RTF_LINECONT "\\linecont"
#define OOO_STRING_SVTOOLS_RTF_LINEMOD "\\linemod"
#define OOO_STRING_SVTOOLS_RTF_LINEPPAGE "\\lineppage"
#define OOO_STRING_SVTOOLS_RTF_LINERESTART "\\linerestart"
#define OOO_STRING_SVTOOLS_RTF_LINESTART "\\linestart"
#define OOO_STRING_SVTOOLS_RTF_LINESTARTS "\\linestarts"
#define OOO_STRING_SVTOOLS_RTF_LINEX "\\linex"
#define OOO_STRING_SVTOOLS_RTF_LINKSELF "\\linkself"
#define OOO_STRING_SVTOOLS_RTF_LINKSTYLES "\\linkstyles"
#define OOO_STRING_SVTOOLS_RTF_LINKVAL "\\linkval" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LIST "\\list" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTID "\\listid" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTLEVEL "\\listlevel" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTNAME "\\listname" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTOVERRIDE "\\listoverride" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTOVERRIDECOUNT "\\listoverridecount" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTOVERRIDEFORMAT "\\listoverrideformat" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTOVERRIDESTART "\\listoverridestart" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTOVERRIDETABLE "\\listoverridetable" // rtf 1.5
#define LO_STRING_SVTOOLS_RTF_LISTPICTURE "\\listpicture"
#define OOO_STRING_SVTOOLS_RTF_LISTRESTARTHDN "\\listrestarthdn" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTSIMPLE "\\listsimple" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTTABLE "\\listtable" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTTEMPLATEID "\\listtemplateid" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LISTTEXT "\\listtext" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LNDSCPSXN "\\lndscpsxn"
#define OOO_STRING_SVTOOLS_RTF_LOCH "\\loch" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_LQUOTE "\\lquote"
#define OOO_STRING_SVTOOLS_RTF_LS "\\ls" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LTRCH "\\ltrch"
#define OOO_STRING_SVTOOLS_RTF_LTRDOC "\\ltrdoc"
#define OOO_STRING_SVTOOLS_RTF_LTRMARK "\\ltrmark"
#define OOO_STRING_SVTOOLS_RTF_LTRPAR "\\ltrpar"
#define OOO_STRING_SVTOOLS_RTF_LTRROW "\\ltrrow"
#define OOO_STRING_SVTOOLS_RTF_LTRSECT "\\ltrsect"
#define OOO_STRING_SVTOOLS_RTF_LYTEXCTTP "\\lytexcttp" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_LYTPRTMET "\\lytprtmet" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_MAC "\\mac"
#define LO_STRING_SVTOOLS_RTF_MACC "\\macc" // Math
#define LO_STRING_SVTOOLS_RTF_MACCPR "\\maccPr" // Math
#define OOO_STRING_SVTOOLS_RTF_MACPICT "\\macpict"
#define OOO_STRING_SVTOOLS_RTF_MAKEBACKUP "\\makebackup"
#define OOO_STRING_SVTOOLS_RTF_MANAGER "\\manager" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_MARGB "\\margb"
#define OOO_STRING_SVTOOLS_RTF_MARGBSXN "\\margbsxn"
#define OOO_STRING_SVTOOLS_RTF_MARGL "\\margl"
#define OOO_STRING_SVTOOLS_RTF_MARGLSXN "\\marglsxn"
#define OOO_STRING_SVTOOLS_RTF_MARGMIRROR "\\margmirror"
#define OOO_STRING_SVTOOLS_RTF_MARGR "\\margr"
#define OOO_STRING_SVTOOLS_RTF_MARGRSXN "\\margrsxn"
#define OOO_STRING_SVTOOLS_RTF_MARGT "\\margt"
#define OOO_STRING_SVTOOLS_RTF_MARGTSXN "\\margtsxn"
#define LO_STRING_SVTOOLS_RTF_MBAR "\\mbar" // Math
#define LO_STRING_SVTOOLS_RTF_MBARPR "\\mbarPr" // Math
#define LO_STRING_SVTOOLS_RTF_MBEGCHR "\\mbegChr" // Math
#define LO_STRING_SVTOOLS_RTF_MBORDERBOX "\\mborderBox" // Math
#define LO_STRING_SVTOOLS_RTF_MBORDERBOXPR "\\mborderBoxPr" // Math
#define LO_STRING_SVTOOLS_RTF_MCHR "\\mchr" // Math
#define LO_STRING_SVTOOLS_RTF_MD "\\md" // Math
#define LO_STRING_SVTOOLS_RTF_MDPR "\\mdPr" // Math
#define LO_STRING_SVTOOLS_RTF_MDEG "\\mdeg" // Math
#define LO_STRING_SVTOOLS_RTF_MDEGHIDE "\\mdegHide" // Math
#define LO_STRING_SVTOOLS_RTF_MDEN "\\mden" // Math
#define LO_STRING_SVTOOLS_RTF_ME "\\me" // Math
#define LO_STRING_SVTOOLS_RTF_MENDCHR "\\mendChr" // Math
#define LO_STRING_SVTOOLS_RTF_MEQARR "\\meqArr" // Math
#define LO_STRING_SVTOOLS_RTF_MF "\\mf" // Math
#define LO_STRING_SVTOOLS_RTF_MFNAME "\\mfName" // Math
#define LO_STRING_SVTOOLS_RTF_MFPR "\\mfPr" // Math
#define LO_STRING_SVTOOLS_RTF_MFUNC "\\mfunc" // Math
#define LO_STRING_SVTOOLS_RTF_MGROUPCHR "\\mgroupChr" // Math
#define LO_STRING_SVTOOLS_RTF_MGROUPCHRPR "\\mgroupChrPr" // Math
#define LO_STRING_SVTOOLS_RTF_MHIDEBOT "\\mhideBot" // Math
#define LO_STRING_SVTOOLS_RTF_MHIDELEFT "\\mhideLeft" // Math
#define LO_STRING_SVTOOLS_RTF_MHIDERIGHT "\\mhideRight" // Math
#define LO_STRING_SVTOOLS_RTF_MHIDETOP "\\mhideTop" // Math
#define OOO_STRING_SVTOOLS_RTF_MIN "\\min"
#define LO_STRING_SVTOOLS_RTF_MLIM "\\mlim" // Math
#define LO_STRING_SVTOOLS_RTF_MLIMLOW "\\mlimLow" // Math
#define LO_STRING_SVTOOLS_RTF_MLIMUPP "\\mlimUpp" // Math
#define LO_STRING_SVTOOLS_RTF_MM "\\mm" // Math
#define LO_STRING_SVTOOLS_RTF_MMATH "\\mmath" // Math
#define LO_STRING_SVTOOLS_RTF_MMATHPICT "\\mmathPict" // Math
#define LO_STRING_SVTOOLS_RTF_MMR "\\mmr" // Math
#define LO_STRING_SVTOOLS_RTF_MNARY "\\mnary" // Math
#define LO_STRING_SVTOOLS_RTF_MNARYPR "\\mnaryPr" // Math
#define LO_STRING_SVTOOLS_RTF_MNOR "\\mnor" // Math
#define LO_STRING_SVTOOLS_RTF_MNUM "\\mnum" // Math
#define OOO_STRING_SVTOOLS_RTF_MO "\\mo"
#define LO_STRING_SVTOOLS_RTF_MOMATH "\\moMath" // Math
#define LO_STRING_SVTOOLS_RTF_MPOS "\\mpos" // Math
#define LO_STRING_SVTOOLS_RTF_MR "\\mr" // Math
#define LO_STRING_SVTOOLS_RTF_MRAD "\\mrad" // Math
#define LO_STRING_SVTOOLS_RTF_MRADPR "\\mradPr" // Math
#define LO_STRING_SVTOOLS_RTF_MSPRE "\\msPre" // Math
#define LO_STRING_SVTOOLS_RTF_MSSUB "\\msSub" // Math
#define LO_STRING_SVTOOLS_RTF_MSSUBSUP "\\msSubSup" // Math
#define LO_STRING_SVTOOLS_RTF_MSSUP "\\msSup" // Math
#define LO_STRING_SVTOOLS_RTF_MSEPCHR "\\msepChr" // Math
#define OOO_STRING_SVTOOLS_RTF_MSMCAP "\\msmcap" // rtf 1.5
#define LO_STRING_SVTOOLS_RTF_MSTRIKEH "\\mstrikeH" // Math
#define LO_STRING_SVTOOLS_RTF_MSUB "\\msub" // Math
#define LO_STRING_SVTOOLS_RTF_MSUBHIDE "\\msubHide" // Math
#define LO_STRING_SVTOOLS_RTF_MSUP "\\msup" // Math
#define LO_STRING_SVTOOLS_RTF_MSUPHIDE "\\msupHide" // Math
#define LO_STRING_SVTOOLS_RTF_MTYPE "\\mtype" // Math
#define LO_STRING_SVTOOLS_RTF_MVERTJC "\\mvertJc" // Math
#define OOO_STRING_SVTOOLS_RTF_NESTCELL "\\nestcell" // nested tables support
#define OOO_STRING_SVTOOLS_RTF_NESTROW "\\nestrow" // nested tables support
#define OOO_STRING_SVTOOLS_RTF_NESTTABLEPROPRS "\\nesttableprops" // nested tables support
#define OOO_STRING_SVTOOLS_RTF_NEXTCSET "\\nextcset"
#define OOO_STRING_SVTOOLS_RTF_NEXTFILE "\\nextfile"
#define LO_STRING_SVTOOLS_RTF_NOBRKWRPTBL "\\nobrkwrptbl"
#define OOO_STRING_SVTOOLS_RTF_NOCOLBAL "\\nocolbal"
#define OOO_STRING_SVTOOLS_RTF_NOCWRAP "\\nocwrap" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_NOEXTRASPRL "\\noextrasprl"
#define OOO_STRING_SVTOOLS_RTF_NOFCHARS "\\nofchars"
#define OOO_STRING_SVTOOLS_RTF_NOFCHARSWS "\\nofcharsws" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_NOFPAGES "\\nofpages"
#define OOO_STRING_SVTOOLS_RTF_NOFWORDS "\\nofwords"
#define OOO_STRING_SVTOOLS_RTF_NOLEAD "\\nolead" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_NOLINE "\\noline"
#define OOO_STRING_SVTOOLS_RTF_NONESTTABLES "\\nonesttables" // nested tables support
#define OOO_STRING_SVTOOLS_RTF_NONSHPPICT "\\nonshppict" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_NOOVERFLOW "\\nooverflow" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_NOSECTEXPAND "\\nosectexpand" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_NOSNAPLINEGRID "\\nosnaplinegrid" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_NOSPACEFORUL "\\nospaceforul" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_NOSUPERSUB "\\nosupersub"
#define OOO_STRING_SVTOOLS_RTF_NOTABIND "\\notabind"
#define OOO_STRING_SVTOOLS_RTF_NOULTRLSPC "\\noultrlspc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_NOWIDCTLPAR "\\nowidctlpar"
#define OOO_STRING_SVTOOLS_RTF_NOWRAP "\\nowrap"
#define OOO_STRING_SVTOOLS_RTF_NOXLATTOYEN "\\noxlattoyen" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_OBJALIAS "\\objalias"
#define OOO_STRING_SVTOOLS_RTF_OBJALIGN "\\objalign"
#define OOO_STRING_SVTOOLS_RTF_OBJATTPH "\\objattph" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_OBJAUTLINK "\\objautlink"
#define OOO_STRING_SVTOOLS_RTF_OBJCLASS "\\objclass"
#define OOO_STRING_SVTOOLS_RTF_OBJCROPB "\\objcropb"
#define OOO_STRING_SVTOOLS_RTF_OBJCROPL "\\objcropl"
#define OOO_STRING_SVTOOLS_RTF_OBJCROPR "\\objcropr"
#define OOO_STRING_SVTOOLS_RTF_OBJCROPT "\\objcropt"
#define OOO_STRING_SVTOOLS_RTF_OBJDATA "\\objdata"
#define OOO_STRING_SVTOOLS_RTF_OBJECT "\\object"
#define OOO_STRING_SVTOOLS_RTF_OBJEMB "\\objemb"
#define OOO_STRING_SVTOOLS_RTF_OBJH "\\objh"
#define OOO_STRING_SVTOOLS_RTF_OBJHTML "\\objhtml" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_OBJICEMB "\\objicemb"
#define OOO_STRING_SVTOOLS_RTF_OBJLINK "\\objlink"
#define OOO_STRING_SVTOOLS_RTF_OBJLOCK "\\objlock"
#define OOO_STRING_SVTOOLS_RTF_OBJNAME "\\objname"
#define OOO_STRING_SVTOOLS_RTF_OBJOCX "\\objocx" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_OBJPUB "\\objpub"
#define OOO_STRING_SVTOOLS_RTF_OBJSCALEX "\\objscalex"
#define OOO_STRING_SVTOOLS_RTF_OBJSCALEY "\\objscaley"
#define OOO_STRING_SVTOOLS_RTF_OBJSECT "\\objsect"
#define OOO_STRING_SVTOOLS_RTF_OBJSETSIZE "\\objsetsize"
#define OOO_STRING_SVTOOLS_RTF_OBJSUB "\\objsub"
#define OOO_STRING_SVTOOLS_RTF_OBJTIME "\\objtime"
#define OOO_STRING_SVTOOLS_RTF_OBJTRANSY "\\objtransy"
#define OOO_STRING_SVTOOLS_RTF_OBJUPDATE "\\objupdate"
#define OOO_STRING_SVTOOLS_RTF_OBJW "\\objw"
#define OOO_STRING_SVTOOLS_RTF_OL "\\ol" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLC "\\olc" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLD "\\old" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLDASH "\\oldash" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLDASHD "\\oldashd" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLDASHDD "\\oldashdd" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLDB "\\oldb" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLDLINEWRAP "\\oldlinewrap" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_OLHWAVE "\\olhwave" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLLDASH "\\olldash" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLNONE "\\olnone" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLOLDBWAVE "\\ololdbwave" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLTH "\\olth" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLTHD "\\olthd" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLTHDASH "\\olthdash" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLTHDASHD "\\olthdashd" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLTHDASHDD "\\olthdashdd" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLTHLDASH "\\olthldash" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLW "\\olw" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OLWAVE "\\olwave" // overline attribute
#define OOO_STRING_SVTOOLS_RTF_OPERATOR "\\operator"
#define OOO_STRING_SVTOOLS_RTF_OTBLRUL "\\otblrul"
#define OOO_STRING_SVTOOLS_RTF_OUTL "\\outl"
#define OOO_STRING_SVTOOLS_RTF_OUTLINELEVEL "\\outlinelevel" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_OVERLAY "\\overlay" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PAGE "\\page"
#define OOO_STRING_SVTOOLS_RTF_PAGEBB "\\pagebb"
#define OOO_STRING_SVTOOLS_RTF_PANOSE "\\panose" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PAPERH "\\paperh"
#define OOO_STRING_SVTOOLS_RTF_PAPERW "\\paperw"
#define OOO_STRING_SVTOOLS_RTF_PAR "\\par"
#define OOO_STRING_SVTOOLS_RTF_PARD "\\pard"
#define OOO_STRING_SVTOOLS_RTF_PC "\\pc"
#define OOO_STRING_SVTOOLS_RTF_PCA "\\pca"
#define OOO_STRING_SVTOOLS_RTF_PGBRDRB "\\pgbrdrb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRDRFOOT "\\pgbrdrfoot" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRDRHEAD "\\pgbrdrhead" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRDRL "\\pgbrdrl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRDROPT "\\pgbrdropt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRDRR "\\pgbrdrr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRDRSNAP "\\pgbrdrsnap" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRDRT "\\pgbrdrt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGBRK "\\pgbrk"
#define OOO_STRING_SVTOOLS_RTF_PGDSC "\\pgdsc"
#define OOO_STRING_SVTOOLS_RTF_PGDSCNO "\\pgdscno"
#define OOO_STRING_SVTOOLS_RTF_PGDSCNXT "\\pgdscnxt"
#define OOO_STRING_SVTOOLS_RTF_PGDSCUSE "\\pgdscuse"
#define OOO_STRING_SVTOOLS_RTF_PGHSXN "\\pghsxn"
#define OOO_STRING_SVTOOLS_RTF_PGNCHOSUNG "\\pgnchosung" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNCNUM "\\pgncnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNCONT "\\pgncont"
#define OOO_STRING_SVTOOLS_RTF_PGNDBNUMK "\\pgndbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNDBNUMT "\\pgndbnumt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNDEC "\\pgndec"
#define OOO_STRING_SVTOOLS_RTF_PGNGANADA "\\pgnganada" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNGBNUM "\\pgngbnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNGBNUMD "\\pgngbnumd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNGBNUMK "\\pgngbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNGBNUML "\\pgngbnuml" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNHN "\\pgnhn"
#define OOO_STRING_SVTOOLS_RTF_PGNHNSC "\\pgnhnsc"
#define OOO_STRING_SVTOOLS_RTF_PGNHNSH "\\pgnhnsh"
#define OOO_STRING_SVTOOLS_RTF_PGNHNSM "\\pgnhnsm"
#define OOO_STRING_SVTOOLS_RTF_PGNHNSN "\\pgnhnsn"
#define OOO_STRING_SVTOOLS_RTF_PGNHNSP "\\pgnhnsp"
#define OOO_STRING_SVTOOLS_RTF_PGNLCLTR "\\pgnlcltr"
#define OOO_STRING_SVTOOLS_RTF_PGNLCRM "\\pgnlcrm"
#define OOO_STRING_SVTOOLS_RTF_PGNRESTART "\\pgnrestart"
#define OOO_STRING_SVTOOLS_RTF_PGNSTART "\\pgnstart"
#define OOO_STRING_SVTOOLS_RTF_PGNSTARTS "\\pgnstarts"
#define OOO_STRING_SVTOOLS_RTF_PGNUCLTR "\\pgnucltr"
#define OOO_STRING_SVTOOLS_RTF_PGNUCRM "\\pgnucrm"
#define OOO_STRING_SVTOOLS_RTF_PGNX "\\pgnx"
#define OOO_STRING_SVTOOLS_RTF_PGNY "\\pgny"
#define OOO_STRING_SVTOOLS_RTF_PGNZODIAC "\\pgnzodiac" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNZODIACD "\\pgnzodiacd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGNZODIACL "\\pgnzodiacl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PGWSXN "\\pgwsxn"
#define OOO_STRING_SVTOOLS_RTF_PHCOL "\\phcol"
#define OOO_STRING_SVTOOLS_RTF_PHMRG "\\phmrg"
#define OOO_STRING_SVTOOLS_RTF_PHPG "\\phpg"
#define OOO_STRING_SVTOOLS_RTF_PICBMP "\\picbmp"
#define OOO_STRING_SVTOOLS_RTF_PICBPP "\\picbpp"
#define OOO_STRING_SVTOOLS_RTF_PICCROPB "\\piccropb"
#define OOO_STRING_SVTOOLS_RTF_PICCROPL "\\piccropl"
#define OOO_STRING_SVTOOLS_RTF_PICCROPR "\\piccropr"
#define OOO_STRING_SVTOOLS_RTF_PICCROPT "\\piccropt"
#define OOO_STRING_SVTOOLS_RTF_PICH "\\pich"
#define OOO_STRING_SVTOOLS_RTF_PICHGOAL "\\pichgoal"
#define OOO_STRING_SVTOOLS_RTF_PICPROP "\\picprop" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PICSCALED "\\picscaled"
#define OOO_STRING_SVTOOLS_RTF_PICSCALEX "\\picscalex"
#define OOO_STRING_SVTOOLS_RTF_PICSCALEY "\\picscaley"
#define OOO_STRING_SVTOOLS_RTF_PICT "\\pict"
#define OOO_STRING_SVTOOLS_RTF_PICW "\\picw"
#define OOO_STRING_SVTOOLS_RTF_PICWGOAL "\\picwgoal"
#define OOO_STRING_SVTOOLS_RTF_PLAIN "\\plain"
#define OOO_STRING_SVTOOLS_RTF_PMMETAFILE "\\pmmetafile"
#define OOO_STRING_SVTOOLS_RTF_PN "\\pn"
#define OOO_STRING_SVTOOLS_RTF_PNACROSS "\\pnacross"
#define OOO_STRING_SVTOOLS_RTF_PNAIUEO "\\pnaiueo" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNAIUEOD "\\pnaiueod" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNB "\\pnb"
#define OOO_STRING_SVTOOLS_RTF_PNCAPS "\\pncaps"
#define OOO_STRING_SVTOOLS_RTF_PNCARD "\\pncard"
#define OOO_STRING_SVTOOLS_RTF_PNCF "\\pncf"
#define OOO_STRING_SVTOOLS_RTF_PNCHOSUNG "\\pnchosung" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNDBNUMD "\\pndbnumd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNDBNUMK "\\pndbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNDBNUML "\\pndbnuml" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNDBNUMT "\\pndbnumt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNDEC "\\pndec"
#define OOO_STRING_SVTOOLS_RTF_PNF "\\pnf"
#define OOO_STRING_SVTOOLS_RTF_PNFS "\\pnfs"
#define OOO_STRING_SVTOOLS_RTF_PNGANADA "\\pnganada" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNGBLIP "\\pngblip" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNGBNUM "\\pngbnum" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNGBNUMD "\\pngbnumd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNGBNUMK "\\pngbnumk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNGBNUML "\\pngbnuml" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNHANG "\\pnhang"
#define OOO_STRING_SVTOOLS_RTF_PNI "\\pni"
#define OOO_STRING_SVTOOLS_RTF_PNINDENT "\\pnindent"
#define OOO_STRING_SVTOOLS_RTF_PNLCLTR "\\pnlcltr"
#define OOO_STRING_SVTOOLS_RTF_PNLCRM "\\pnlcrm"
#define OOO_STRING_SVTOOLS_RTF_PNLVL "\\pnlvl"
#define OOO_STRING_SVTOOLS_RTF_PNLVLBLT "\\pnlvlblt"
#define OOO_STRING_SVTOOLS_RTF_PNLVLBODY "\\pnlvlbody"
#define OOO_STRING_SVTOOLS_RTF_PNLVLCONT "\\pnlvlcont"
#define OOO_STRING_SVTOOLS_RTF_PNNUMONCE "\\pnnumonce"
#define OOO_STRING_SVTOOLS_RTF_PNORD "\\pnord"
#define OOO_STRING_SVTOOLS_RTF_PNORDT "\\pnordt"
#define OOO_STRING_SVTOOLS_RTF_PNPREV "\\pnprev"
#define OOO_STRING_SVTOOLS_RTF_PNQC "\\pnqc"
#define OOO_STRING_SVTOOLS_RTF_PNQL "\\pnql"
#define OOO_STRING_SVTOOLS_RTF_PNQR "\\pnqr"
#define OOO_STRING_SVTOOLS_RTF_PNRAUTH "\\pnrauth" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRDATE "\\pnrdate" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRESTART "\\pnrestart"
#define OOO_STRING_SVTOOLS_RTF_PNRNFC "\\pnrnfc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRNOT "\\pnrnot" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRPNBR "\\pnrpnbr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRRGB "\\pnrrgb" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRSTART "\\pnrstart" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRSTOP "\\pnrstop" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNRXST "\\pnrxst" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNSCAPS "\\pnscaps"
#define OOO_STRING_SVTOOLS_RTF_PNSECLVL "\\pnseclvl"
#define OOO_STRING_SVTOOLS_RTF_PNSP "\\pnsp"
#define OOO_STRING_SVTOOLS_RTF_PNSTART "\\pnstart"
#define OOO_STRING_SVTOOLS_RTF_PNSTRIKE "\\pnstrike"
#define OOO_STRING_SVTOOLS_RTF_PNTEXT "\\pntext"
#define OOO_STRING_SVTOOLS_RTF_PNTXTA "\\pntxta"
#define OOO_STRING_SVTOOLS_RTF_PNTXTB "\\pntxtb"
#define OOO_STRING_SVTOOLS_RTF_PNUCLTR "\\pnucltr"
#define OOO_STRING_SVTOOLS_RTF_PNUCRM "\\pnucrm"
#define OOO_STRING_SVTOOLS_RTF_PNUL "\\pnul"
#define OOO_STRING_SVTOOLS_RTF_PNULD "\\pnuld"
#define OOO_STRING_SVTOOLS_RTF_PNULDB "\\pnuldb"
#define OOO_STRING_SVTOOLS_RTF_PNULNONE "\\pnulnone"
#define OOO_STRING_SVTOOLS_RTF_PNULW "\\pnulw"
#define OOO_STRING_SVTOOLS_RTF_PNZODIAC "\\pnzodiac" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNZODIACD "\\pnzodiacd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PNZODIACL "\\pnzodiacl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_POSNEGX "\\posnegx"
#define OOO_STRING_SVTOOLS_RTF_POSNEGY "\\posnegy"
#define OOO_STRING_SVTOOLS_RTF_POSX "\\posx"
#define OOO_STRING_SVTOOLS_RTF_POSXC "\\posxc"
#define OOO_STRING_SVTOOLS_RTF_POSXI "\\posxi"
#define OOO_STRING_SVTOOLS_RTF_POSXL "\\posxl"
#define OOO_STRING_SVTOOLS_RTF_POSXO "\\posxo"
#define OOO_STRING_SVTOOLS_RTF_POSXR "\\posxr"
#define OOO_STRING_SVTOOLS_RTF_POSY "\\posy"
#define OOO_STRING_SVTOOLS_RTF_POSYB "\\posyb"
#define OOO_STRING_SVTOOLS_RTF_POSYC "\\posyc"
#define OOO_STRING_SVTOOLS_RTF_POSYIL "\\posyil"
#define OOO_STRING_SVTOOLS_RTF_POSYIN "\\posyin" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_POSYOUT "\\posyout" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_POSYT "\\posyt"
#define OOO_STRING_SVTOOLS_RTF_PRCOLBL "\\prcolbl"
#define OOO_STRING_SVTOOLS_RTF_PRINTDATA "\\printdata"
#define OOO_STRING_SVTOOLS_RTF_PRINTIM "\\printim"
#define OOO_STRING_SVTOOLS_RTF_PRIVATE "\\private" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PROPNAME "\\propname" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PROPTYPE "\\proptype" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_PRTDATA "\\prtdata" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_PSOVER "\\psover"
#define OOO_STRING_SVTOOLS_RTF_PSZ "\\psz"
#define OOO_STRING_SVTOOLS_RTF_PUBAUTO "\\pubauto"
#define OOO_STRING_SVTOOLS_RTF_PVMRG "\\pvmrg"
#define OOO_STRING_SVTOOLS_RTF_PVPARA "\\pvpara"
#define OOO_STRING_SVTOOLS_RTF_PVPG "\\pvpg"
#define OOO_STRING_SVTOOLS_RTF_QC "\\qc"
#define OOO_STRING_SVTOOLS_RTF_QD "\\qd"
#define OOO_STRING_SVTOOLS_RTF_QJ "\\qj"
#define OOO_STRING_SVTOOLS_RTF_QL "\\ql"
#define OOO_STRING_SVTOOLS_RTF_QR "\\qr"
#define OOO_STRING_SVTOOLS_RTF_RDBLQUOTE "\\rdblquote"
#define OOO_STRING_SVTOOLS_RTF_RED "\\red"
#define OOO_STRING_SVTOOLS_RTF_RESULT "\\result"
#define OOO_STRING_SVTOOLS_RTF_REVAUTH "\\revauth"
#define OOO_STRING_SVTOOLS_RTF_REVAUTHDEL "\\revauthdel" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_REVBAR "\\revbar"
#define OOO_STRING_SVTOOLS_RTF_REVDTTM "\\revdttm"
#define OOO_STRING_SVTOOLS_RTF_REVDTTMDEL "\\revdttmdel" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_REVISED "\\revised"
#define OOO_STRING_SVTOOLS_RTF_REVISIONS "\\revisions"
#define OOO_STRING_SVTOOLS_RTF_REVPROP "\\revprop"
#define OOO_STRING_SVTOOLS_RTF_REVPROT "\\revprot"
#define OOO_STRING_SVTOOLS_RTF_REVTBL "\\revtbl"
#define OOO_STRING_SVTOOLS_RTF_REVTIM "\\revtim"
#define OOO_STRING_SVTOOLS_RTF_RI "\\ri"
#define OOO_STRING_SVTOOLS_RTF_RIN "\\rin"
#define OOO_STRING_SVTOOLS_RTF_ROW "\\row"
#define OOO_STRING_SVTOOLS_RTF_RQUOTE "\\rquote"
#define OOO_STRING_SVTOOLS_RTF_RSLTBMP "\\rsltbmp"
#define OOO_STRING_SVTOOLS_RTF_RSLTMERGE "\\rsltmerge"
#define OOO_STRING_SVTOOLS_RTF_RSLTPICT "\\rsltpict"
#define OOO_STRING_SVTOOLS_RTF_RSLTRTF "\\rsltrtf"
#define OOO_STRING_SVTOOLS_RTF_RSLTTXT "\\rslttxt"
#define OOO_STRING_SVTOOLS_RTF_RTF "\\rtf"
#define OOO_STRING_SVTOOLS_RTF_RTLCH "\\rtlch"
#define OOO_STRING_SVTOOLS_RTF_RTLDOC "\\rtldoc"
#define LO_STRING_SVTOOLS_RTF_RTLGUTTER "\\rtlgutter"
#define OOO_STRING_SVTOOLS_RTF_RTLMARK "\\rtlmark"
#define OOO_STRING_SVTOOLS_RTF_RTLPAR "\\rtlpar"
#define OOO_STRING_SVTOOLS_RTF_RTLROW "\\rtlrow"
#define OOO_STRING_SVTOOLS_RTF_RTLSECT "\\rtlsect"
#define OOO_STRING_SVTOOLS_RTF_RXE "\\rxe"
#define OOO_STRING_SVTOOLS_RTF_S "\\s"
#define OOO_STRING_SVTOOLS_RTF_SA "\\sa"
#define LO_STRING_SVTOOLS_RTF_SAAUTO "\\saauto"
#define OOO_STRING_SVTOOLS_RTF_SAFTNNALC "\\saftnnalc"
#define OOO_STRING_SVTOOLS_RTF_SAFTNNAR "\\saftnnar"
#define OOO_STRING_SVTOOLS_RTF_SAFTNNAUC "\\saftnnauc"
#define OOO_STRING_SVTOOLS_RTF_SAFTNNCHI "\\saftnnchi"
#define OOO_STRING_SVTOOLS_RTF_SAFTNNRLC "\\saftnnrlc"
#define OOO_STRING_SVTOOLS_RTF_SAFTNNRUC "\\saftnnruc"
#define OOO_STRING_SVTOOLS_RTF_SAUTOUPD "\\sautoupd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SB "\\sb"
#define OOO_STRING_SVTOOLS_RTF_SBASEDON "\\sbasedon"
#define LO_STRING_SVTOOLS_RTF_SBAUTO "\\sbauto"
#define OOO_STRING_SVTOOLS_RTF_SBKCOL "\\sbkcol"
#define OOO_STRING_SVTOOLS_RTF_SBKEVEN "\\sbkeven"
#define OOO_STRING_SVTOOLS_RTF_SBKNONE "\\sbknone"
#define OOO_STRING_SVTOOLS_RTF_SBKODD "\\sbkodd"
#define OOO_STRING_SVTOOLS_RTF_SBKPAGE "\\sbkpage"
#define OOO_STRING_SVTOOLS_RTF_SBYS "\\sbys"
#define OOO_STRING_SVTOOLS_RTF_SCAPS "\\scaps"
#define OOO_STRING_SVTOOLS_RTF_SEC "\\sec"
#define OOO_STRING_SVTOOLS_RTF_SECT "\\sect"
#define OOO_STRING_SVTOOLS_RTF_SECTD "\\sectd"
#define OOO_STRING_SVTOOLS_RTF_SECTDEFAULTCL "\\sectdefaultcl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SECTEXPAND "\\sectexpand" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SECTLINEGRID "\\sectlinegrid" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SECTNUM "\\sectnum"
#define OOO_STRING_SVTOOLS_RTF_SECTSPECIFYCL "\\sectspecifycl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SECTSPECIFYL "\\sectspecifyl" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SECTUNLOCKED "\\sectunlocked"
#define OOO_STRING_SVTOOLS_RTF_SFTNNALC "\\sftnnalc"
#define OOO_STRING_SVTOOLS_RTF_SFTNNAR "\\sftnnar"
#define OOO_STRING_SVTOOLS_RTF_SFTNNAUC "\\sftnnauc"
#define OOO_STRING_SVTOOLS_RTF_SFTNNCHI "\\sftnnchi"
#define OOO_STRING_SVTOOLS_RTF_SFTNNRLC "\\sftnnrlc"
#define OOO_STRING_SVTOOLS_RTF_SFTNNRUC "\\sftnnruc"
#define OOO_STRING_SVTOOLS_RTF_SHAD "\\shad"
#define OOO_STRING_SVTOOLS_RTF_SHADING "\\shading"
#define OOO_STRING_SVTOOLS_RTF_SHADOW "\\shadow"
#define OOO_STRING_SVTOOLS_RTF_SHDWCOL "\\shdwcol"
#define OOO_STRING_SVTOOLS_RTF_SHDWDIST "\\shdwdist"
#define OOO_STRING_SVTOOLS_RTF_SHDWFCOL "\\shdwfcol"
#define OOO_STRING_SVTOOLS_RTF_SHDWSTYLE "\\shdwstyle"
#define OOO_STRING_SVTOOLS_RTF_SHIDDEN "\\shidden" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHIFT "\\shift"
#define OOO_STRING_SVTOOLS_RTF_SHP "\\shp"
#define OOO_STRING_SVTOOLS_RTF_SHPBOTTOM "\\shpbottom" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBXCOLUMN "\\shpbxcolumn" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBXIGNORE "\\shpbxignore" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBXMARGIN "\\shpbxmargin" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBXPAGE "\\shpbxpage" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBYIGNORE "\\shpbyignore" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBYMARGIN "\\shpbymargin" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBYPAGE "\\shpbypage" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPBYPARA "\\shpbypara" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPFBLWTXT "\\shpfblwtxt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPFHDR "\\shpfhdr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPGRP "\\shpgrp" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPINST "\\shpinst" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPLEFT "\\shpleft" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPLID "\\shplid" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPLOCKANCHOR "\\shplockanchor" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPPICT "\\shppict" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPRIGHT "\\shpright" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPRSLT "\\shprslt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPTOP "\\shptop" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPTXT "\\shptxt" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPWR "\\shpwr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPWRK "\\shpwrk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SHPZ "\\shpz" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SL "\\sl"
#define OOO_STRING_SVTOOLS_RTF_SLMULT "\\slmult"
#define OOO_STRING_SVTOOLS_RTF_SN "\\sn"
#define OOO_STRING_SVTOOLS_RTF_SNEXT "\\snext"
#define OOO_STRING_SVTOOLS_RTF_SOFTCOL "\\softcol"
#define OOO_STRING_SVTOOLS_RTF_SOFTLHEIGHT "\\softlheight"
#define OOO_STRING_SVTOOLS_RTF_SOFTLINE "\\softline"
#define OOO_STRING_SVTOOLS_RTF_SOFTPAGE "\\softpage"
#define OOO_STRING_SVTOOLS_RTF_SOUTLVL "\\soutlvl"
#define OOO_STRING_SVTOOLS_RTF_SP "\\sp"
#define OOO_STRING_SVTOOLS_RTF_SPRSBSP "\\sprsbsp" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SPRSLNSP "\\sprslnsp" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SPRSSPBF "\\sprsspbf"
#define OOO_STRING_SVTOOLS_RTF_SPRSTSM "\\sprstsm" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SPRSTSP "\\sprstsp"
#define OOO_STRING_SVTOOLS_RTF_STATICVAL "\\staticval" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_STEXTFLOW "\\stextflow" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_STRIKE "\\strike"
#define OOO_STRING_SVTOOLS_RTF_STRIKED "\\striked" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_STYLESHEET "\\stylesheet"
#define OOO_STRING_SVTOOLS_RTF_SUB "\\sub"
#define OOO_STRING_SVTOOLS_RTF_SUBDOCUMENT "\\subdocument"
#define OOO_STRING_SVTOOLS_RTF_SUBFONTBYSIZE "\\subfontbysize" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_SUBJECT "\\subject"
#define OOO_STRING_SVTOOLS_RTF_SUPER "\\super"
#define OOO_STRING_SVTOOLS_RTF_SV "\\sv"
#define OOO_STRING_SVTOOLS_RTF_BALANCEDCOLUMN "\\swcolmnblnc" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_SWPBDR "\\swpbdr"
#define OOO_STRING_SVTOOLS_RTF_TAB "\\tab"
#define LO_STRING_SVTOOLS_RTF_TABSNOOVRLP "\\tabsnoovrlp"
#define OOO_STRING_SVTOOLS_RTF_TB "\\tb"
#define OOO_STRING_SVTOOLS_RTF_TC "\\tc"
#define OOO_STRING_SVTOOLS_RTF_TCELLD "\\tcelld" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_TCF "\\tcf"
#define OOO_STRING_SVTOOLS_RTF_TCL "\\tcl"
#define OOO_STRING_SVTOOLS_RTF_TCN "\\tcn"
#define LO_STRING_SVTOOLS_RTF_TDFRMTXTBOTTOM "\\tdfrmtxtBottom"
#define LO_STRING_SVTOOLS_RTF_TDFRMTXTLEFT "\\tdfrmtxtLeft"
#define LO_STRING_SVTOOLS_RTF_TDFRMTXTRIGHT "\\tdfrmtxtRight"
#define LO_STRING_SVTOOLS_RTF_TDFRMTXTTOP "\\tdfrmtxtTop"
#define OOO_STRING_SVTOOLS_RTF_TEMPLATE "\\template"
#define OOO_STRING_SVTOOLS_RTF_TIME "\\time" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_TITLE "\\title"
#define OOO_STRING_SVTOOLS_RTF_TITLEPG "\\titlepg"
#define OOO_STRING_SVTOOLS_RTF_TLDOT "\\tldot"
#define OOO_STRING_SVTOOLS_RTF_TLEQ "\\tleq"
#define OOO_STRING_SVTOOLS_RTF_TLHYPH "\\tlhyph"
#define OOO_STRING_SVTOOLS_RTF_TLSWG "\\tlswg"
#define OOO_STRING_SVTOOLS_RTF_TLTH "\\tlth"
#define OOO_STRING_SVTOOLS_RTF_TLUL "\\tlul"
#define LO_STRING_SVTOOLS_RTF_TPHCOL "\\tphcol"
#define LO_STRING_SVTOOLS_RTF_TPHMRG "\\tphmrg"
#define LO_STRING_SVTOOLS_RTF_TPHPG "\\tphpg"
#define LO_STRING_SVTOOLS_RTF_TPOSX "\\tposx"
#define LO_STRING_SVTOOLS_RTF_TPOSXC "\\tposxc"
#define LO_STRING_SVTOOLS_RTF_TPOSXL "\\tposxl"
#define LO_STRING_SVTOOLS_RTF_TPOSXR "\\tposxr"
#define LO_STRING_SVTOOLS_RTF_TPOSY "\\tposy"
#define LO_STRING_SVTOOLS_RTF_TPOSYB "\\tposyb"
#define LO_STRING_SVTOOLS_RTF_TPOSYC "\\tposyc"
#define LO_STRING_SVTOOLS_RTF_TPOSYT "\\tposyt"
#define LO_STRING_SVTOOLS_RTF_TPVMRG "\\tpvmrg"
#define LO_STRING_SVTOOLS_RTF_TPVPARA "\\tpvpara"
#define LO_STRING_SVTOOLS_RTF_TPVPG "\\tpvpg"
#define OOO_STRING_SVTOOLS_RTF_TQC "\\tqc"
#define OOO_STRING_SVTOOLS_RTF_TQDEC "\\tqdec"
#define OOO_STRING_SVTOOLS_RTF_TQL "\\tql"
#define OOO_STRING_SVTOOLS_RTF_TQR "\\tqr"
#define OOO_STRING_SVTOOLS_RTF_TRANSMF "\\transmf"
#define OOO_STRING_SVTOOLS_RTF_TRBRDRB "\\trbrdrb"
#define OOO_STRING_SVTOOLS_RTF_TRBRDRH "\\trbrdrh"
#define OOO_STRING_SVTOOLS_RTF_TRBRDRL "\\trbrdrl"
#define OOO_STRING_SVTOOLS_RTF_TRBRDRR "\\trbrdrr"
#define OOO_STRING_SVTOOLS_RTF_TRBRDRT "\\trbrdrt"
#define OOO_STRING_SVTOOLS_RTF_TRBRDRV "\\trbrdrv"
#define OOO_STRING_SVTOOLS_RTF_TRGAPH "\\trgaph"
#define OOO_STRING_SVTOOLS_RTF_TRHDR "\\trhdr"
#define OOO_STRING_SVTOOLS_RTF_TRKEEP "\\trkeep"
#define OOO_STRING_SVTOOLS_RTF_TRLEFT "\\trleft"
#define OOO_STRING_SVTOOLS_RTF_TROWD "\\trowd"
#define OOO_STRING_SVTOOLS_RTF_TRPADDB "\\trpaddb"
#define OOO_STRING_SVTOOLS_RTF_TRPADDFB "\\trpaddfb"
#define OOO_STRING_SVTOOLS_RTF_TRPADDFL "\\trpaddfl"
#define OOO_STRING_SVTOOLS_RTF_TRPADDFR "\\trpaddfr"
#define OOO_STRING_SVTOOLS_RTF_TRPADDFT "\\trpaddft"
#define OOO_STRING_SVTOOLS_RTF_TRPADDL "\\trpaddl"
#define OOO_STRING_SVTOOLS_RTF_TRPADDR "\\trpaddr"
#define OOO_STRING_SVTOOLS_RTF_TRPADDT "\\trpaddt"
#define OOO_STRING_SVTOOLS_RTF_TRQC "\\trqc"
#define OOO_STRING_SVTOOLS_RTF_TRQL "\\trql"
#define OOO_STRING_SVTOOLS_RTF_TRQR "\\trqr"
#define OOO_STRING_SVTOOLS_RTF_TRRH "\\trrh"
#define OOO_STRING_SVTOOLS_RTF_TRUNCATEFONTHEIGHT "\\truncatefontheight" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_TWOINONE "\\twoinone" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_TX "\\tx"
#define OOO_STRING_SVTOOLS_RTF_TXE "\\txe"
#define OOO_STRING_SVTOOLS_RTF_U "\\u" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_UC "\\uc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_UD "\\ud" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_UL "\\ul"
#define OOO_STRING_SVTOOLS_RTF_ULC "\\ulc" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ULD "\\uld"
#define OOO_STRING_SVTOOLS_RTF_ULDASH "\\uldash" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ULDASHD "\\uldashd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ULDASHDD "\\uldashdd" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ULDB "\\uldb"
#define OOO_STRING_SVTOOLS_RTF_ULHWAVE "\\ulhwave" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULLDASH "\\ulldash" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULNONE "\\ulnone"
#define OOO_STRING_SVTOOLS_RTF_ULTH "\\ulth" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ULTHD "\\ulthd" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULTHDASH "\\ulthdash" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULTHDASHD "\\ulthdashd" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULTHDASHDD "\\ulthdashdd" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULTHLDASH "\\ulthldash" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULULDBWAVE "\\ululdbwave" // MS-2000
#define OOO_STRING_SVTOOLS_RTF_ULW "\\ulw"
#define OOO_STRING_SVTOOLS_RTF_ULWAVE "\\ulwave" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_UP "\\up"
#define OOO_STRING_SVTOOLS_RTF_UPDNPROP "\\updnprop" // free-flying frames attribute
#define OOO_STRING_SVTOOLS_RTF_UPR "\\upr" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_USERPROPS "\\userprops" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_V "\\v"
#define OOO_STRING_SVTOOLS_RTF_VERN "\\vern"
#define OOO_STRING_SVTOOLS_RTF_VERSION "\\version"
#define OOO_STRING_SVTOOLS_RTF_VERTALB "\\vertalb"
#define OOO_STRING_SVTOOLS_RTF_VERTALC "\\vertalc"
#define OOO_STRING_SVTOOLS_RTF_VERTALJ "\\vertalj"
#define OOO_STRING_SVTOOLS_RTF_VERTALT "\\vertalt"
#define LO_STRING_SVTOOLS_RTF_VIEWBKSP "\\viewbksp"
#define OOO_STRING_SVTOOLS_RTF_VIEWKIND "\\viewkind" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_VIEWSCALE "\\viewscale" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_VIEWZK "\\viewzk" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_WBITMAP "\\wbitmap"
#define OOO_STRING_SVTOOLS_RTF_WBMBITSPIXEL "\\wbmbitspixel"
#define OOO_STRING_SVTOOLS_RTF_WBMPLANES "\\wbmplanes"
#define OOO_STRING_SVTOOLS_RTF_WBMWIDTHBYTES "\\wbmwidthbytes"
#define OOO_STRING_SVTOOLS_RTF_WIDCTLPAR "\\widctlpar" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_WIDOWCTRL "\\widowctrl"
#define OOO_STRING_SVTOOLS_RTF_WINDOWCAPTION "\\windowcaption" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_WMETAFILE "\\wmetafile"
#define OOO_STRING_SVTOOLS_RTF_WPEQN "\\wpeqn" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_WPJST "\\wpjst" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_WPSP "\\wpsp" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_WRAPTRSP "\\wraptrsp"
#define OOO_STRING_SVTOOLS_RTF_XE "\\xe"
#define OOO_STRING_SVTOOLS_RTF_XEF "\\xef"
#define OOO_STRING_SVTOOLS_RTF_YR "\\yr"
#define OOO_STRING_SVTOOLS_RTF_YXE "\\yxe" // rtf 1.5
#define OOO_STRING_SVTOOLS_RTF_ZWJ "\\zwj"
#define OOO_STRING_SVTOOLS_RTF_ZWNJ "\\zwnj"
#define OOO_STRING_SVTOOLS_RTF_FORMULA "\\|"
#define OOO_STRING_SVTOOLS_RTF_NOBREAK "\\~"

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
