/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */


/**************************************************************************
                                TODO
 **************************************************************************

 **************************************************************************

    Props/Commands:

                           root    folder  folder  link    link
                                   (new)           (new)
    ----------------------------------------------------------------
    ContentType            x       x       x       x       x
    IsDocument             x       x       x       x       x
    IsFolder               x       x       x       x       x
    Title                  x       x       x       x       x
    TargetURL                                      x       x
    CreatableContentsInfo  x       x       x       x       x

    getCommandInfo         x       x       x       x       x
    getPropertySetInfo     x       x       x       x       x
    getPropertyValues      x       x       x       x       x
    setPropertyValues      x       x       x       x       x
    createNewContent       x               x
    insert                                 x               x
    delete                         x               x
    open                   x       x
    transfer               x       x

 *************************************************************************/

#include <com/sun/star/beans/Property.hpp>
#include <com/sun/star/beans/PropertyAttribute.hpp>
#include <com/sun/star/beans/PropertyValue.hpp>
#include <com/sun/star/ucb/CommandInfo.hpp>
#include <com/sun/star/ucb/OpenCommandArgument2.hpp>
#include <com/sun/star/ucb/TransferInfo.hpp>
#include <com/sun/star/uno/Sequence.hxx>
#include <sal/macros.h>
#include "hierarchycontent.hxx"

using namespace com::sun::star;
using namespace hierarchy_ucp;


// HierarchyContent implementation.


#define MAKEPROPSEQUENCE( a ) \
    uno::Sequence< beans::Property >( a, SAL_N_ELEMENTS( a ) )

#define MAKECMDSEQUENCE( a ) \
    uno::Sequence< ucb::CommandInfo >( a, SAL_N_ELEMENTS( a ) )


// IMPORTANT: If any property data ( name / type / ... ) are changed, then
//            HierarchyContent::getPropertyValues(...) must be adapted too!


// virtual
uno::Sequence< beans::Property > HierarchyContent::getProperties(
            const uno::Reference< ucb::XCommandEnvironment > & /*xEnv*/ )
{
    osl::Guard< osl::Mutex > aGuard( m_aMutex );

    if ( m_eKind == LINK )
    {


        // Link: Supported properties


        if ( isReadOnly() )
        {
            static const beans::Property aLinkPropertyInfoTable[] =
            {

                // Required properties

                beans::Property(
                    u"ContentType"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsDocument"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsFolder"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"Title"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),

                // Optional standard properties

                beans::Property(
                    u"TargetURL"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"CreatableContentsInfo"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< ucb::ContentInfo >>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY )

                // New properties

            };
            return MAKEPROPSEQUENCE( aLinkPropertyInfoTable );
        }
        else
        {
            static const beans::Property aLinkPropertyInfoTable[] =
            {

                // Required properties

                beans::Property(
                    u"ContentType"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsDocument"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsFolder"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"Title"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                ),

                // Optional standard properties

                beans::Property(
                    u"TargetURL"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                ),
                beans::Property(
                    u"CreatableContentsInfo"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< ucb::ContentInfo >>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY )

                // New properties

            };
            return MAKEPROPSEQUENCE( aLinkPropertyInfoTable );
        }
    }
    else if ( m_eKind == FOLDER )
    {


        // Folder: Supported properties


        if ( isReadOnly() )
        {
            static const beans::Property aFolderPropertyInfoTable[] =
            {

                // Required properties

                beans::Property(
                    u"ContentType"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsDocument"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsFolder"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"Title"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),

                // Optional standard properties

                beans::Property(
                    u"CreatableContentsInfo"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< ucb::ContentInfo >>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY )

                // New properties

            };
            return MAKEPROPSEQUENCE( aFolderPropertyInfoTable );
        }
        else
        {
            static const beans::Property aFolderPropertyInfoTable[] =
            {

                // Required properties

                beans::Property(
                    u"ContentType"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsDocument"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"IsFolder"_ustr,
                    -1,
                    cppu::UnoType<bool>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY
                ),
                beans::Property(
                    u"Title"_ustr,
                    -1,
                    cppu::UnoType<OUString>::get(),
                    beans::PropertyAttribute::BOUND
                ),

                // Optional standard properties

                beans::Property(
                    u"CreatableContentsInfo"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< ucb::ContentInfo >>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY )

                // New properties

            };
            return MAKEPROPSEQUENCE( aFolderPropertyInfoTable );
        }
    }
    else
    {


        // Root Folder: Supported properties


        // Currently no difference between read-only/read-write
        // -> all props are read-only

        static const beans::Property aRootFolderPropertyInfoTable[] =
        {

            // Required properties

            beans::Property(
                u"ContentType"_ustr,
                -1,
                cppu::UnoType<OUString>::get(),
                beans::PropertyAttribute::BOUND
                    | beans::PropertyAttribute::READONLY
            ),
            beans::Property(
                u"IsDocument"_ustr,
                -1,
                cppu::UnoType<bool>::get(),
                beans::PropertyAttribute::BOUND
                    | beans::PropertyAttribute::READONLY
            ),
            beans::Property(
                u"IsFolder"_ustr,
                -1,
                cppu::UnoType<bool>::get(),
                beans::PropertyAttribute::BOUND
                    | beans::PropertyAttribute::READONLY
            ),
            beans::Property(
                u"Title"_ustr,
                -1,
                cppu::UnoType<OUString>::get(),
                beans::PropertyAttribute::BOUND
                    | beans::PropertyAttribute::READONLY
            ),

            // Optional standard properties

            beans::Property(
                    u"CreatableContentsInfo"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< ucb::ContentInfo >>::get(),
                    beans::PropertyAttribute::BOUND
                        | beans::PropertyAttribute::READONLY )

            // New properties

        };
        return MAKEPROPSEQUENCE( aRootFolderPropertyInfoTable );
    }
}


// virtual
uno::Sequence< ucb::CommandInfo > HierarchyContent::getCommands(
            const uno::Reference< ucb::XCommandEnvironment > & /*xEnv*/ )
{
    osl::Guard< osl::Mutex > aGuard( m_aMutex );

    if ( m_eKind == LINK )
    {


        // Link: Supported commands


        if ( isReadOnly() )
        {
            static const ucb::CommandInfo aLinkCommandInfoTable[] =
            {

                // Required commands

                ucb::CommandInfo(
                    u"getCommandInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertySetInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::Property >>::get()
                ),
                ucb::CommandInfo(
                    u"setPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::PropertyValue >>::get()
                )

                // Optional standard commands


                // New commands

            };
            return MAKECMDSEQUENCE( aLinkCommandInfoTable );
        }
        else
        {
            static const ucb::CommandInfo aLinkCommandInfoTable[] =
            {

                // Required commands

                ucb::CommandInfo(
                    u"getCommandInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertySetInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::Property >>::get()
                ),
                ucb::CommandInfo(
                    u"setPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::PropertyValue >>::get()
                ),

                // Optional standard commands

                ucb::CommandInfo(
                    u"delete"_ustr,
                    -1,
                    cppu::UnoType<bool>::get()
                ),
                ucb::CommandInfo(
                    u"insert"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                )

                // New commands

            };
            return MAKECMDSEQUENCE( aLinkCommandInfoTable );
        }
    }
    else if ( m_eKind == FOLDER )
    {


        // Folder: Supported commands


        if ( isReadOnly() )
        {
            static const ucb::CommandInfo aFolderCommandInfoTable[] =
            {

                // Required commands

                ucb::CommandInfo(
                    u"getCommandInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertySetInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::Property >>::get()
                ),
                ucb::CommandInfo(
                    u"setPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::PropertyValue >>::get()
                ),

                // Optional standard commands

                ucb::CommandInfo(
                    u"open"_ustr,
                    -1,
                    cppu::UnoType<ucb::OpenCommandArgument2>::get()
                )

                // New commands

            };
            return MAKECMDSEQUENCE( aFolderCommandInfoTable );
        }
        else
        {
            static const ucb::CommandInfo aFolderCommandInfoTable[] =
            {

                // Required commands

                ucb::CommandInfo(
                    u"getCommandInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertySetInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::Property >>::get()
                ),
                ucb::CommandInfo(
                    u"setPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::PropertyValue >>::get()
                ),

                // Optional standard commands

                ucb::CommandInfo(
                    u"delete"_ustr,
                    -1,
                    cppu::UnoType<bool>::get()
                ),
                ucb::CommandInfo(
                    u"insert"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"open"_ustr,
                    -1,
                    cppu::UnoType<ucb::OpenCommandArgument2>::get()
                ),
                ucb::CommandInfo(
                    u"transfer"_ustr,
                    -1,
                    cppu::UnoType<ucb::TransferInfo>::get()
                ),
                ucb::CommandInfo(
                    u"createNewContent"_ustr,
                    -1,
                    cppu::UnoType<ucb::ContentInfo>::get()
                )

                // New commands

            };
            return MAKECMDSEQUENCE( aFolderCommandInfoTable );
        }
    }
    else
    {


        // Root Folder: Supported commands


        if ( isReadOnly() )
        {
            static const ucb::CommandInfo aRootFolderCommandInfoTable[] =
            {

                // Required commands

                ucb::CommandInfo(
                    u"getCommandInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertySetInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::Property >>::get()
                ),
                ucb::CommandInfo(
                    u"setPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::PropertyValue >>::get()
                ),

                // Optional standard commands

                ucb::CommandInfo(
                    u"open"_ustr,
                    -1,
                    cppu::UnoType<ucb::OpenCommandArgument2>::get()
                )

                // New commands

            };
            return MAKECMDSEQUENCE( aRootFolderCommandInfoTable );
        }
        else
        {
            static const ucb::CommandInfo aRootFolderCommandInfoTable[] =
            {

                // Required commands

                ucb::CommandInfo(
                    u"getCommandInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertySetInfo"_ustr,
                    -1,
                    cppu::UnoType<void>::get()
                ),
                ucb::CommandInfo(
                    u"getPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::Property >>::get()
                ),
                ucb::CommandInfo(
                    u"setPropertyValues"_ustr,
                    -1,
                    cppu::UnoType<uno::Sequence< beans::PropertyValue >>::get()
                ),

                // Optional standard commands

                ucb::CommandInfo(
                    u"open"_ustr,
                    -1,
                    cppu::UnoType<ucb::OpenCommandArgument2>::get()
                ),
                ucb::CommandInfo(
                    u"transfer"_ustr,
                    -1,
                    cppu::UnoType<ucb::TransferInfo>::get()
                ),
                ucb::CommandInfo(
                    u"createNewContent"_ustr,
                    -1,
                    cppu::UnoType<ucb::ContentInfo>::get()
                )

                // New commands

            };
            return MAKECMDSEQUENCE( aRootFolderCommandInfoTable );
        }
    }
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
