/* vim: set tabstop=8 shiftwidth=4 softtabstop=4 expandtab smarttab colorcolumn=80: */
/*
 * Copyright (c) 2016 Red Hat, Inc.
 * Author: Nathaniel McCallum <npmccallum@redhat.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "test.h"
#include <errno.h>
#include <error.h>
#include <stdlib.h>
#include <string.h>

static const luksmeta_uuid_t UUID = {
    0xd3, 0xd5, 0xf1, 0xe0, 0xa4, 0x6c, 0xbd, 0xf4,
    0xca, 0x20, 0x30, 0x1f, 0xdd, 0xa0, 0xf7, 0xa8
};

static const uint8_t DATA[] = "DATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA"
      "DATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATADATA";

int
main(int argc, char *argv[])
{
    uint8_t data[sizeof(DATA)] = {};
    struct crypt_device *cd = NULL;
    luksmeta_uuid_t uuid = {};
    uint32_t offset = 0;
    uint32_t length = 0;
    int r;

    crypt_free(test_format());
    cd = test_init();
    test_hole(cd, &offset, &length);

    /* Set the data. */
    r = luksmeta_save(cd, CRYPT_ANY_SLOT, UUID, DATA, sizeof(DATA));
    if (r < 0)
        error(EXIT_FAILURE, -r, "luksmeta_save()");

    assert(test_layout((range_t[]) {
        { 0, 1024 },                   /* LUKS header */
        { 1024, 3072, true },          /* Keyslot Area */
        { offset, 4096 },              /* luksmeta header */
        { offset + 4096, 4096 },       /* luksmeta slot 0 */
        { offset + 8192, 4096 },       /* luksmeta slot 0 (cont) */
        END(offset + 12288),           /* Rest of the file */
    }));

    assert(luksmeta_load(cd, r, uuid, data, sizeof(data)) == sizeof(data));
    assert(memcmp(uuid, UUID, sizeof(UUID)) == 0);
    assert(memcmp(data, DATA, sizeof(DATA)) == 0);

    /* Delete the data. */
    assert(luksmeta_wipe(cd, r, UUID) == 0);

    assert(test_layout((range_t[]) {
        { 0, 1024 },                   /* LUKS header */
        { 1024, 3072, true },          /* Keyslot Area */
        { offset, 4096 },              /* luksmeta header */
        END(offset + 4096),            /* Rest of the file */
    }));

    crypt_free(cd);
    unlink(filename);
    return 0;
}
