/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.wizards;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.lisaac.ldt.LisaacMessages;

public abstract class AbstractNewFileWizardPage
extends WizardPage {
    private IStructuredSelection selection;
    private Text containerText;
    private Text fileText;
    private String fileExtension = "";

    protected AbstractNewFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setPageComplete(false);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    protected void setFileExtension(String ext) {
        this.fileExtension = ext;
    }

    protected abstract InputStream getInitialContents(String var1);

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(LisaacMessages.getString("AbstractNewFileWizardPage_1"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNewFileWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(LisaacMessages.getString("AbstractNewFileWizardPage_2"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNewFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(LisaacMessages.getString("AbstractNewFileWizardPage_3"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNewFileWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 258);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.createAdvancedControls(container);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void createAdvancedControls(Composite parent) {
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
                this.fileText.setFocus();
            }
        }
        this.fileText.setText(this.getInitialFileName());
    }

    protected abstract String getInitialFileName();

    private void handleBrowse() {
        Object result;
        Object[] results;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LisaacMessages.getString("AbstractNewFileWizardPage_4"));
        if (dialog.open() == 0 && (results = dialog.getResult()).length == 1 && (result = results[0]) instanceof IPath) {
            IPath ipath = (IPath)result;
            this.containerText.setText(ipath.toString());
        }
    }

    private void dialogChanged() {
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(LisaacMessages.getString("AbstractNewFileWizardPage_5"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(LisaacMessages.getString("AbstractNewFileWizardPage_6"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public boolean isPageComplete() {
        return !this.checkFolderForExistingFile() && super.isPageComplete();
    }

    protected boolean checkFolderForExistingFile() {
        IFile file;
        IContainer container = this.getFileContainer();
        if (container != null && (file = container.getFile((IPath)new Path(this.fileText.getText().trim()))) != null && file.exists()) {
            this.setErrorMessage(LisaacMessages.getString("AbstractNewFileWizardPage_7"));
            return true;
        }
        return false;
    }

    private IContainer getFileContainer() {
        if (this.containerText.getText() != null) {
            Path containerPath = new Path(this.containerText.getText().trim());
            IFolder container = null;
            if (containerPath.segmentCount() > 1) {
                container = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)containerPath);
            } else if (containerPath.segmentCount() == 1) {
                container = ResourcesPlugin.getWorkspace().getRoot().getProject(this.containerText.getText().trim());
            }
            if (container != null && container.exists()) {
                return container;
            }
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String fileName = this.fileText.getText().trim();
            if (this.getFileContainer() != null && fileName.equalsIgnoreCase(this.getInitialFileName())) {
                this.fileText.setFocus();
                this.fileText.setText(fileName);
                this.fileText.setSelection(0, fileName.length() - new Path(this.getInitialFileName()).getFileExtension().length() - 1);
            }
        }
    }
}

