
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAccessibleTableInterface.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAccessibleTableInterface>
#include <QAccessibleInterface>
#include <QAccessibleTableModelChangeEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include "gsiDeclQtGuiTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAccessibleTableInterface

// QAccessibleInterface *QAccessibleTableInterface::caption()


static void _init_f_caption_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_caption_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleTableInterface *)cls)->caption ());
}


// QAccessibleInterface *QAccessibleTableInterface::cellAt(int row, int column)


static void _init_f_cellAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_cellAt_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleTableInterface *)cls)->cellAt (arg1, arg2));
}


// int QAccessibleTableInterface::columnCount()


static void _init_f_columnCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface *)cls)->columnCount ());
}


// QString QAccessibleTableInterface::columnDescription(int column)


static void _init_f_columnDescription_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_columnDescription_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QAccessibleTableInterface *)cls)->columnDescription (arg1));
}


// bool QAccessibleTableInterface::isColumnSelected(int column)


static void _init_f_isColumnSelected_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isColumnSelected_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface *)cls)->isColumnSelected (arg1));
}


// bool QAccessibleTableInterface::isRowSelected(int row)


static void _init_f_isRowSelected_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isRowSelected_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface *)cls)->isRowSelected (arg1));
}


// void QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent *event)


static void _init_f_modelChange_3790 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QAccessibleTableModelChangeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_modelChange_3790 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAccessibleTableModelChangeEvent *arg1 = gsi::arg_reader<QAccessibleTableModelChangeEvent * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTableInterface *)cls)->modelChange (arg1);
}


// int QAccessibleTableInterface::rowCount()


static void _init_f_rowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rowCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface *)cls)->rowCount ());
}


// QString QAccessibleTableInterface::rowDescription(int row)


static void _init_f_rowDescription_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_rowDescription_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QAccessibleTableInterface *)cls)->rowDescription (arg1));
}


// bool QAccessibleTableInterface::selectColumn(int column)


static void _init_f_selectColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_selectColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface *)cls)->selectColumn (arg1));
}


// bool QAccessibleTableInterface::selectRow(int row)


static void _init_f_selectRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_selectRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface *)cls)->selectRow (arg1));
}


// int QAccessibleTableInterface::selectedCellCount()


static void _init_f_selectedCellCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectedCellCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface *)cls)->selectedCellCount ());
}


// QList<QAccessibleInterface*> QAccessibleTableInterface::selectedCells()


static void _init_f_selectedCells_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAccessibleInterface*> > ();
}

static void _call_f_selectedCells_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAccessibleInterface*> > ((QList<QAccessibleInterface*>)((QAccessibleTableInterface *)cls)->selectedCells ());
}


// int QAccessibleTableInterface::selectedColumnCount()


static void _init_f_selectedColumnCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectedColumnCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface *)cls)->selectedColumnCount ());
}


// QList<int> QAccessibleTableInterface::selectedColumns()


static void _init_f_selectedColumns_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_selectedColumns_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAccessibleTableInterface *)cls)->selectedColumns ());
}


// int QAccessibleTableInterface::selectedRowCount()


static void _init_f_selectedRowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectedRowCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface *)cls)->selectedRowCount ());
}


// QList<int> QAccessibleTableInterface::selectedRows()


static void _init_f_selectedRows_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_selectedRows_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAccessibleTableInterface *)cls)->selectedRows ());
}


// QAccessibleInterface *QAccessibleTableInterface::summary()


static void _init_f_summary_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_summary_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleTableInterface *)cls)->summary ());
}


// bool QAccessibleTableInterface::unselectColumn(int column)


static void _init_f_unselectColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_unselectColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface *)cls)->unselectColumn (arg1));
}


// bool QAccessibleTableInterface::unselectRow(int row)


static void _init_f_unselectRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_unselectRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface *)cls)->unselectRow (arg1));
}


namespace gsi
{

static gsi::Methods methods_QAccessibleTableInterface () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("caption", "@brief Method QAccessibleInterface *QAccessibleTableInterface::caption()\n", true, &_init_f_caption_c0, &_call_f_caption_c0);
  methods += new qt_gsi::GenericMethod ("cellAt", "@brief Method QAccessibleInterface *QAccessibleTableInterface::cellAt(int row, int column)\n", true, &_init_f_cellAt_c1426, &_call_f_cellAt_c1426);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Method int QAccessibleTableInterface::columnCount()\n", true, &_init_f_columnCount_c0, &_call_f_columnCount_c0);
  methods += new qt_gsi::GenericMethod ("columnDescription", "@brief Method QString QAccessibleTableInterface::columnDescription(int column)\n", true, &_init_f_columnDescription_c767, &_call_f_columnDescription_c767);
  methods += new qt_gsi::GenericMethod ("isColumnSelected?", "@brief Method bool QAccessibleTableInterface::isColumnSelected(int column)\n", true, &_init_f_isColumnSelected_c767, &_call_f_isColumnSelected_c767);
  methods += new qt_gsi::GenericMethod ("isRowSelected?", "@brief Method bool QAccessibleTableInterface::isRowSelected(int row)\n", true, &_init_f_isRowSelected_c767, &_call_f_isRowSelected_c767);
  methods += new qt_gsi::GenericMethod ("modelChange", "@brief Method void QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent *event)\n", false, &_init_f_modelChange_3790, &_call_f_modelChange_3790);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QAccessibleTableInterface::rowCount()\n", true, &_init_f_rowCount_c0, &_call_f_rowCount_c0);
  methods += new qt_gsi::GenericMethod ("rowDescription", "@brief Method QString QAccessibleTableInterface::rowDescription(int row)\n", true, &_init_f_rowDescription_c767, &_call_f_rowDescription_c767);
  methods += new qt_gsi::GenericMethod ("selectColumn", "@brief Method bool QAccessibleTableInterface::selectColumn(int column)\n", false, &_init_f_selectColumn_767, &_call_f_selectColumn_767);
  methods += new qt_gsi::GenericMethod ("selectRow", "@brief Method bool QAccessibleTableInterface::selectRow(int row)\n", false, &_init_f_selectRow_767, &_call_f_selectRow_767);
  methods += new qt_gsi::GenericMethod ("selectedCellCount", "@brief Method int QAccessibleTableInterface::selectedCellCount()\n", true, &_init_f_selectedCellCount_c0, &_call_f_selectedCellCount_c0);
  methods += new qt_gsi::GenericMethod ("selectedCells", "@brief Method QList<QAccessibleInterface*> QAccessibleTableInterface::selectedCells()\n", true, &_init_f_selectedCells_c0, &_call_f_selectedCells_c0);
  methods += new qt_gsi::GenericMethod ("selectedColumnCount", "@brief Method int QAccessibleTableInterface::selectedColumnCount()\n", true, &_init_f_selectedColumnCount_c0, &_call_f_selectedColumnCount_c0);
  methods += new qt_gsi::GenericMethod ("selectedColumns", "@brief Method QList<int> QAccessibleTableInterface::selectedColumns()\n", true, &_init_f_selectedColumns_c0, &_call_f_selectedColumns_c0);
  methods += new qt_gsi::GenericMethod ("selectedRowCount", "@brief Method int QAccessibleTableInterface::selectedRowCount()\n", true, &_init_f_selectedRowCount_c0, &_call_f_selectedRowCount_c0);
  methods += new qt_gsi::GenericMethod ("selectedRows", "@brief Method QList<int> QAccessibleTableInterface::selectedRows()\n", true, &_init_f_selectedRows_c0, &_call_f_selectedRows_c0);
  methods += new qt_gsi::GenericMethod ("summary", "@brief Method QAccessibleInterface *QAccessibleTableInterface::summary()\n", true, &_init_f_summary_c0, &_call_f_summary_c0);
  methods += new qt_gsi::GenericMethod ("unselectColumn", "@brief Method bool QAccessibleTableInterface::unselectColumn(int column)\n", false, &_init_f_unselectColumn_767, &_call_f_unselectColumn_767);
  methods += new qt_gsi::GenericMethod ("unselectRow", "@brief Method bool QAccessibleTableInterface::unselectRow(int row)\n", false, &_init_f_unselectRow_767, &_call_f_unselectRow_767);
  return methods;
}

gsi::Class<QAccessibleTableInterface> decl_QAccessibleTableInterface ("QtGui", "QAccessibleTableInterface_Native",
  methods_QAccessibleTableInterface (),
  "@hide\n@alias QAccessibleTableInterface");

GSI_QTGUI_PUBLIC gsi::Class<QAccessibleTableInterface> &qtdecl_QAccessibleTableInterface () { return decl_QAccessibleTableInterface; }

}


class QAccessibleTableInterface_Adaptor : public QAccessibleTableInterface, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAccessibleTableInterface_Adaptor();

  //  [adaptor ctor] QAccessibleTableInterface::QAccessibleTableInterface()
  QAccessibleTableInterface_Adaptor() : QAccessibleTableInterface()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QAccessibleInterface *QAccessibleTableInterface::caption()
  QAccessibleInterface * cbs_caption_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("caption");
  }

  virtual QAccessibleInterface * caption() const
  {
    if (cb_caption_c0_0.can_issue()) {
      return cb_caption_c0_0.issue<QAccessibleTableInterface_Adaptor, QAccessibleInterface *>(&QAccessibleTableInterface_Adaptor::cbs_caption_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("caption");
    }
  }

  //  [adaptor impl] QAccessibleInterface *QAccessibleTableInterface::cellAt(int row, int column)
  QAccessibleInterface * cbs_cellAt_c1426_0(int row, int column) const
  {
    __SUPPRESS_UNUSED_WARNING (row);
    __SUPPRESS_UNUSED_WARNING (column);
    throw qt_gsi::AbstractMethodCalledException("cellAt");
  }

  virtual QAccessibleInterface * cellAt(int row, int column) const
  {
    if (cb_cellAt_c1426_0.can_issue()) {
      return cb_cellAt_c1426_0.issue<QAccessibleTableInterface_Adaptor, QAccessibleInterface *, int, int>(&QAccessibleTableInterface_Adaptor::cbs_cellAt_c1426_0, row, column);
    } else {
      throw qt_gsi::AbstractMethodCalledException("cellAt");
    }
  }

  //  [adaptor impl] int QAccessibleTableInterface::columnCount()
  int cbs_columnCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("columnCount");
  }

  virtual int columnCount() const
  {
    if (cb_columnCount_c0_0.can_issue()) {
      return cb_columnCount_c0_0.issue<QAccessibleTableInterface_Adaptor, int>(&QAccessibleTableInterface_Adaptor::cbs_columnCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("columnCount");
    }
  }

  //  [adaptor impl] QString QAccessibleTableInterface::columnDescription(int column)
  QString cbs_columnDescription_c767_0(int column) const
  {
    __SUPPRESS_UNUSED_WARNING (column);
    throw qt_gsi::AbstractMethodCalledException("columnDescription");
  }

  virtual QString columnDescription(int column) const
  {
    if (cb_columnDescription_c767_0.can_issue()) {
      return cb_columnDescription_c767_0.issue<QAccessibleTableInterface_Adaptor, QString, int>(&QAccessibleTableInterface_Adaptor::cbs_columnDescription_c767_0, column);
    } else {
      throw qt_gsi::AbstractMethodCalledException("columnDescription");
    }
  }

  //  [adaptor impl] bool QAccessibleTableInterface::isColumnSelected(int column)
  bool cbs_isColumnSelected_c767_0(int column) const
  {
    __SUPPRESS_UNUSED_WARNING (column);
    throw qt_gsi::AbstractMethodCalledException("isColumnSelected");
  }

  virtual bool isColumnSelected(int column) const
  {
    if (cb_isColumnSelected_c767_0.can_issue()) {
      return cb_isColumnSelected_c767_0.issue<QAccessibleTableInterface_Adaptor, bool, int>(&QAccessibleTableInterface_Adaptor::cbs_isColumnSelected_c767_0, column);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isColumnSelected");
    }
  }

  //  [adaptor impl] bool QAccessibleTableInterface::isRowSelected(int row)
  bool cbs_isRowSelected_c767_0(int row) const
  {
    __SUPPRESS_UNUSED_WARNING (row);
    throw qt_gsi::AbstractMethodCalledException("isRowSelected");
  }

  virtual bool isRowSelected(int row) const
  {
    if (cb_isRowSelected_c767_0.can_issue()) {
      return cb_isRowSelected_c767_0.issue<QAccessibleTableInterface_Adaptor, bool, int>(&QAccessibleTableInterface_Adaptor::cbs_isRowSelected_c767_0, row);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isRowSelected");
    }
  }

  //  [adaptor impl] void QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent *event)
  void cbs_modelChange_3790_0(QAccessibleTableModelChangeEvent *event)
  {
    __SUPPRESS_UNUSED_WARNING (event);
    throw qt_gsi::AbstractMethodCalledException("modelChange");
  }

  virtual void modelChange(QAccessibleTableModelChangeEvent *event)
  {
    if (cb_modelChange_3790_0.can_issue()) {
      cb_modelChange_3790_0.issue<QAccessibleTableInterface_Adaptor, QAccessibleTableModelChangeEvent *>(&QAccessibleTableInterface_Adaptor::cbs_modelChange_3790_0, event);
    } else {
      throw qt_gsi::AbstractMethodCalledException("modelChange");
    }
  }

  //  [adaptor impl] int QAccessibleTableInterface::rowCount()
  int cbs_rowCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("rowCount");
  }

  virtual int rowCount() const
  {
    if (cb_rowCount_c0_0.can_issue()) {
      return cb_rowCount_c0_0.issue<QAccessibleTableInterface_Adaptor, int>(&QAccessibleTableInterface_Adaptor::cbs_rowCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("rowCount");
    }
  }

  //  [adaptor impl] QString QAccessibleTableInterface::rowDescription(int row)
  QString cbs_rowDescription_c767_0(int row) const
  {
    __SUPPRESS_UNUSED_WARNING (row);
    throw qt_gsi::AbstractMethodCalledException("rowDescription");
  }

  virtual QString rowDescription(int row) const
  {
    if (cb_rowDescription_c767_0.can_issue()) {
      return cb_rowDescription_c767_0.issue<QAccessibleTableInterface_Adaptor, QString, int>(&QAccessibleTableInterface_Adaptor::cbs_rowDescription_c767_0, row);
    } else {
      throw qt_gsi::AbstractMethodCalledException("rowDescription");
    }
  }

  //  [adaptor impl] bool QAccessibleTableInterface::selectColumn(int column)
  bool cbs_selectColumn_767_0(int column)
  {
    __SUPPRESS_UNUSED_WARNING (column);
    throw qt_gsi::AbstractMethodCalledException("selectColumn");
  }

  virtual bool selectColumn(int column)
  {
    if (cb_selectColumn_767_0.can_issue()) {
      return cb_selectColumn_767_0.issue<QAccessibleTableInterface_Adaptor, bool, int>(&QAccessibleTableInterface_Adaptor::cbs_selectColumn_767_0, column);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectColumn");
    }
  }

  //  [adaptor impl] bool QAccessibleTableInterface::selectRow(int row)
  bool cbs_selectRow_767_0(int row)
  {
    __SUPPRESS_UNUSED_WARNING (row);
    throw qt_gsi::AbstractMethodCalledException("selectRow");
  }

  virtual bool selectRow(int row)
  {
    if (cb_selectRow_767_0.can_issue()) {
      return cb_selectRow_767_0.issue<QAccessibleTableInterface_Adaptor, bool, int>(&QAccessibleTableInterface_Adaptor::cbs_selectRow_767_0, row);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectRow");
    }
  }

  //  [adaptor impl] int QAccessibleTableInterface::selectedCellCount()
  int cbs_selectedCellCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("selectedCellCount");
  }

  virtual int selectedCellCount() const
  {
    if (cb_selectedCellCount_c0_0.can_issue()) {
      return cb_selectedCellCount_c0_0.issue<QAccessibleTableInterface_Adaptor, int>(&QAccessibleTableInterface_Adaptor::cbs_selectedCellCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectedCellCount");
    }
  }

  //  [adaptor impl] QList<QAccessibleInterface*> QAccessibleTableInterface::selectedCells()
  QList<QAccessibleInterface*> cbs_selectedCells_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("selectedCells");
  }

  virtual QList<QAccessibleInterface*> selectedCells() const
  {
    if (cb_selectedCells_c0_0.can_issue()) {
      return cb_selectedCells_c0_0.issue<QAccessibleTableInterface_Adaptor, QList<QAccessibleInterface*> >(&QAccessibleTableInterface_Adaptor::cbs_selectedCells_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectedCells");
    }
  }

  //  [adaptor impl] int QAccessibleTableInterface::selectedColumnCount()
  int cbs_selectedColumnCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("selectedColumnCount");
  }

  virtual int selectedColumnCount() const
  {
    if (cb_selectedColumnCount_c0_0.can_issue()) {
      return cb_selectedColumnCount_c0_0.issue<QAccessibleTableInterface_Adaptor, int>(&QAccessibleTableInterface_Adaptor::cbs_selectedColumnCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectedColumnCount");
    }
  }

  //  [adaptor impl] QList<int> QAccessibleTableInterface::selectedColumns()
  QList<int> cbs_selectedColumns_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("selectedColumns");
  }

  virtual QList<int> selectedColumns() const
  {
    if (cb_selectedColumns_c0_0.can_issue()) {
      return cb_selectedColumns_c0_0.issue<QAccessibleTableInterface_Adaptor, QList<int> >(&QAccessibleTableInterface_Adaptor::cbs_selectedColumns_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectedColumns");
    }
  }

  //  [adaptor impl] int QAccessibleTableInterface::selectedRowCount()
  int cbs_selectedRowCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("selectedRowCount");
  }

  virtual int selectedRowCount() const
  {
    if (cb_selectedRowCount_c0_0.can_issue()) {
      return cb_selectedRowCount_c0_0.issue<QAccessibleTableInterface_Adaptor, int>(&QAccessibleTableInterface_Adaptor::cbs_selectedRowCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectedRowCount");
    }
  }

  //  [adaptor impl] QList<int> QAccessibleTableInterface::selectedRows()
  QList<int> cbs_selectedRows_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("selectedRows");
  }

  virtual QList<int> selectedRows() const
  {
    if (cb_selectedRows_c0_0.can_issue()) {
      return cb_selectedRows_c0_0.issue<QAccessibleTableInterface_Adaptor, QList<int> >(&QAccessibleTableInterface_Adaptor::cbs_selectedRows_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectedRows");
    }
  }

  //  [adaptor impl] QAccessibleInterface *QAccessibleTableInterface::summary()
  QAccessibleInterface * cbs_summary_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("summary");
  }

  virtual QAccessibleInterface * summary() const
  {
    if (cb_summary_c0_0.can_issue()) {
      return cb_summary_c0_0.issue<QAccessibleTableInterface_Adaptor, QAccessibleInterface *>(&QAccessibleTableInterface_Adaptor::cbs_summary_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("summary");
    }
  }

  //  [adaptor impl] bool QAccessibleTableInterface::unselectColumn(int column)
  bool cbs_unselectColumn_767_0(int column)
  {
    __SUPPRESS_UNUSED_WARNING (column);
    throw qt_gsi::AbstractMethodCalledException("unselectColumn");
  }

  virtual bool unselectColumn(int column)
  {
    if (cb_unselectColumn_767_0.can_issue()) {
      return cb_unselectColumn_767_0.issue<QAccessibleTableInterface_Adaptor, bool, int>(&QAccessibleTableInterface_Adaptor::cbs_unselectColumn_767_0, column);
    } else {
      throw qt_gsi::AbstractMethodCalledException("unselectColumn");
    }
  }

  //  [adaptor impl] bool QAccessibleTableInterface::unselectRow(int row)
  bool cbs_unselectRow_767_0(int row)
  {
    __SUPPRESS_UNUSED_WARNING (row);
    throw qt_gsi::AbstractMethodCalledException("unselectRow");
  }

  virtual bool unselectRow(int row)
  {
    if (cb_unselectRow_767_0.can_issue()) {
      return cb_unselectRow_767_0.issue<QAccessibleTableInterface_Adaptor, bool, int>(&QAccessibleTableInterface_Adaptor::cbs_unselectRow_767_0, row);
    } else {
      throw qt_gsi::AbstractMethodCalledException("unselectRow");
    }
  }

  gsi::Callback cb_caption_c0_0;
  gsi::Callback cb_cellAt_c1426_0;
  gsi::Callback cb_columnCount_c0_0;
  gsi::Callback cb_columnDescription_c767_0;
  gsi::Callback cb_isColumnSelected_c767_0;
  gsi::Callback cb_isRowSelected_c767_0;
  gsi::Callback cb_modelChange_3790_0;
  gsi::Callback cb_rowCount_c0_0;
  gsi::Callback cb_rowDescription_c767_0;
  gsi::Callback cb_selectColumn_767_0;
  gsi::Callback cb_selectRow_767_0;
  gsi::Callback cb_selectedCellCount_c0_0;
  gsi::Callback cb_selectedCells_c0_0;
  gsi::Callback cb_selectedColumnCount_c0_0;
  gsi::Callback cb_selectedColumns_c0_0;
  gsi::Callback cb_selectedRowCount_c0_0;
  gsi::Callback cb_selectedRows_c0_0;
  gsi::Callback cb_summary_c0_0;
  gsi::Callback cb_unselectColumn_767_0;
  gsi::Callback cb_unselectRow_767_0;
};

QAccessibleTableInterface_Adaptor::~QAccessibleTableInterface_Adaptor() { }

//  Constructor QAccessibleTableInterface::QAccessibleTableInterface() (adaptor class)

static void _init_ctor_QAccessibleTableInterface_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAccessibleTableInterface_Adaptor> ();
}

static void _call_ctor_QAccessibleTableInterface_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleTableInterface_Adaptor *> (new QAccessibleTableInterface_Adaptor ());
}


// QAccessibleInterface *QAccessibleTableInterface::caption()

static void _init_cbs_caption_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_caption_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleTableInterface_Adaptor *)cls)->cbs_caption_c0_0 ());
}

static void _set_callback_cbs_caption_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_caption_c0_0 = cb;
}


// QAccessibleInterface *QAccessibleTableInterface::cellAt(int row, int column)

static void _init_cbs_cellAt_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_cellAt_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleTableInterface_Adaptor *)cls)->cbs_cellAt_c1426_0 (arg1, arg2));
}

static void _set_callback_cbs_cellAt_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_cellAt_c1426_0 = cb;
}


// int QAccessibleTableInterface::columnCount()

static void _init_cbs_columnCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface_Adaptor *)cls)->cbs_columnCount_c0_0 ());
}

static void _set_callback_cbs_columnCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_columnCount_c0_0 = cb;
}


// QString QAccessibleTableInterface::columnDescription(int column)

static void _init_cbs_columnDescription_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_columnDescription_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QString > ((QString)((QAccessibleTableInterface_Adaptor *)cls)->cbs_columnDescription_c767_0 (arg1));
}

static void _set_callback_cbs_columnDescription_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_columnDescription_c767_0 = cb;
}


// bool QAccessibleTableInterface::isColumnSelected(int column)

static void _init_cbs_isColumnSelected_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isColumnSelected_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface_Adaptor *)cls)->cbs_isColumnSelected_c767_0 (arg1));
}

static void _set_callback_cbs_isColumnSelected_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_isColumnSelected_c767_0 = cb;
}


// bool QAccessibleTableInterface::isRowSelected(int row)

static void _init_cbs_isRowSelected_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isRowSelected_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface_Adaptor *)cls)->cbs_isRowSelected_c767_0 (arg1));
}

static void _set_callback_cbs_isRowSelected_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_isRowSelected_c767_0 = cb;
}


// void QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent *event)

static void _init_cbs_modelChange_3790_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QAccessibleTableModelChangeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_modelChange_3790_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAccessibleTableModelChangeEvent *arg1 = args.read<QAccessibleTableModelChangeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTableInterface_Adaptor *)cls)->cbs_modelChange_3790_0 (arg1);
}

static void _set_callback_cbs_modelChange_3790_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_modelChange_3790_0 = cb;
}


// int QAccessibleTableInterface::rowCount()

static void _init_cbs_rowCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface_Adaptor *)cls)->cbs_rowCount_c0_0 ());
}

static void _set_callback_cbs_rowCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_rowCount_c0_0 = cb;
}


// QString QAccessibleTableInterface::rowDescription(int row)

static void _init_cbs_rowDescription_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_rowDescription_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QString > ((QString)((QAccessibleTableInterface_Adaptor *)cls)->cbs_rowDescription_c767_0 (arg1));
}

static void _set_callback_cbs_rowDescription_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_rowDescription_c767_0 = cb;
}


// bool QAccessibleTableInterface::selectColumn(int column)

static void _init_cbs_selectColumn_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_selectColumn_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectColumn_767_0 (arg1));
}

static void _set_callback_cbs_selectColumn_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectColumn_767_0 = cb;
}


// bool QAccessibleTableInterface::selectRow(int row)

static void _init_cbs_selectRow_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_selectRow_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectRow_767_0 (arg1));
}

static void _set_callback_cbs_selectRow_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectRow_767_0 = cb;
}


// int QAccessibleTableInterface::selectedCellCount()

static void _init_cbs_selectedCellCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_selectedCellCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectedCellCount_c0_0 ());
}

static void _set_callback_cbs_selectedCellCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectedCellCount_c0_0 = cb;
}


// QList<QAccessibleInterface*> QAccessibleTableInterface::selectedCells()

static void _init_cbs_selectedCells_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAccessibleInterface*> > ();
}

static void _call_cbs_selectedCells_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAccessibleInterface*> > ((QList<QAccessibleInterface*>)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectedCells_c0_0 ());
}

static void _set_callback_cbs_selectedCells_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectedCells_c0_0 = cb;
}


// int QAccessibleTableInterface::selectedColumnCount()

static void _init_cbs_selectedColumnCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_selectedColumnCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectedColumnCount_c0_0 ());
}

static void _set_callback_cbs_selectedColumnCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectedColumnCount_c0_0 = cb;
}


// QList<int> QAccessibleTableInterface::selectedColumns()

static void _init_cbs_selectedColumns_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_cbs_selectedColumns_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectedColumns_c0_0 ());
}

static void _set_callback_cbs_selectedColumns_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectedColumns_c0_0 = cb;
}


// int QAccessibleTableInterface::selectedRowCount()

static void _init_cbs_selectedRowCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_selectedRowCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectedRowCount_c0_0 ());
}

static void _set_callback_cbs_selectedRowCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectedRowCount_c0_0 = cb;
}


// QList<int> QAccessibleTableInterface::selectedRows()

static void _init_cbs_selectedRows_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_cbs_selectedRows_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QAccessibleTableInterface_Adaptor *)cls)->cbs_selectedRows_c0_0 ());
}

static void _set_callback_cbs_selectedRows_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_selectedRows_c0_0 = cb;
}


// QAccessibleInterface *QAccessibleTableInterface::summary()

static void _init_cbs_summary_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_summary_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleTableInterface_Adaptor *)cls)->cbs_summary_c0_0 ());
}

static void _set_callback_cbs_summary_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_summary_c0_0 = cb;
}


// bool QAccessibleTableInterface::unselectColumn(int column)

static void _init_cbs_unselectColumn_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_unselectColumn_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface_Adaptor *)cls)->cbs_unselectColumn_767_0 (arg1));
}

static void _set_callback_cbs_unselectColumn_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_unselectColumn_767_0 = cb;
}


// bool QAccessibleTableInterface::unselectRow(int row)

static void _init_cbs_unselectRow_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_unselectRow_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QAccessibleTableInterface_Adaptor *)cls)->cbs_unselectRow_767_0 (arg1));
}

static void _set_callback_cbs_unselectRow_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTableInterface_Adaptor *)cls)->cb_unselectRow_767_0 = cb;
}


namespace gsi
{

gsi::Class<QAccessibleTableInterface> &qtdecl_QAccessibleTableInterface ();

static gsi::Methods methods_QAccessibleTableInterface_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAccessibleTableInterface::QAccessibleTableInterface()\nThis method creates an object of class QAccessibleTableInterface.", &_init_ctor_QAccessibleTableInterface_Adaptor_0, &_call_ctor_QAccessibleTableInterface_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("caption", "@hide", true, &_init_cbs_caption_c0_0, &_call_cbs_caption_c0_0);
  methods += new qt_gsi::GenericMethod ("caption", "@brief Virtual method QAccessibleInterface *QAccessibleTableInterface::caption()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_caption_c0_0, &_call_cbs_caption_c0_0, &_set_callback_cbs_caption_c0_0);
  methods += new qt_gsi::GenericMethod ("cellAt", "@hide", true, &_init_cbs_cellAt_c1426_0, &_call_cbs_cellAt_c1426_0);
  methods += new qt_gsi::GenericMethod ("cellAt", "@brief Virtual method QAccessibleInterface *QAccessibleTableInterface::cellAt(int row, int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_cellAt_c1426_0, &_call_cbs_cellAt_c1426_0, &_set_callback_cbs_cellAt_c1426_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c0_0, &_call_cbs_columnCount_c0_0);
  methods += new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QAccessibleTableInterface::columnCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c0_0, &_call_cbs_columnCount_c0_0, &_set_callback_cbs_columnCount_c0_0);
  methods += new qt_gsi::GenericMethod ("columnDescription", "@hide", true, &_init_cbs_columnDescription_c767_0, &_call_cbs_columnDescription_c767_0);
  methods += new qt_gsi::GenericMethod ("columnDescription", "@brief Virtual method QString QAccessibleTableInterface::columnDescription(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnDescription_c767_0, &_call_cbs_columnDescription_c767_0, &_set_callback_cbs_columnDescription_c767_0);
  methods += new qt_gsi::GenericMethod ("isColumnSelected", "@hide", true, &_init_cbs_isColumnSelected_c767_0, &_call_cbs_isColumnSelected_c767_0);
  methods += new qt_gsi::GenericMethod ("isColumnSelected", "@brief Virtual method bool QAccessibleTableInterface::isColumnSelected(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isColumnSelected_c767_0, &_call_cbs_isColumnSelected_c767_0, &_set_callback_cbs_isColumnSelected_c767_0);
  methods += new qt_gsi::GenericMethod ("isRowSelected", "@hide", true, &_init_cbs_isRowSelected_c767_0, &_call_cbs_isRowSelected_c767_0);
  methods += new qt_gsi::GenericMethod ("isRowSelected", "@brief Virtual method bool QAccessibleTableInterface::isRowSelected(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isRowSelected_c767_0, &_call_cbs_isRowSelected_c767_0, &_set_callback_cbs_isRowSelected_c767_0);
  methods += new qt_gsi::GenericMethod ("modelChange", "@hide", false, &_init_cbs_modelChange_3790_0, &_call_cbs_modelChange_3790_0);
  methods += new qt_gsi::GenericMethod ("modelChange", "@brief Virtual method void QAccessibleTableInterface::modelChange(QAccessibleTableModelChangeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_modelChange_3790_0, &_call_cbs_modelChange_3790_0, &_set_callback_cbs_modelChange_3790_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c0_0, &_call_cbs_rowCount_c0_0);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QAccessibleTableInterface::rowCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c0_0, &_call_cbs_rowCount_c0_0, &_set_callback_cbs_rowCount_c0_0);
  methods += new qt_gsi::GenericMethod ("rowDescription", "@hide", true, &_init_cbs_rowDescription_c767_0, &_call_cbs_rowDescription_c767_0);
  methods += new qt_gsi::GenericMethod ("rowDescription", "@brief Virtual method QString QAccessibleTableInterface::rowDescription(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowDescription_c767_0, &_call_cbs_rowDescription_c767_0, &_set_callback_cbs_rowDescription_c767_0);
  methods += new qt_gsi::GenericMethod ("selectColumn", "@hide", false, &_init_cbs_selectColumn_767_0, &_call_cbs_selectColumn_767_0);
  methods += new qt_gsi::GenericMethod ("selectColumn", "@brief Virtual method bool QAccessibleTableInterface::selectColumn(int column)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectColumn_767_0, &_call_cbs_selectColumn_767_0, &_set_callback_cbs_selectColumn_767_0);
  methods += new qt_gsi::GenericMethod ("selectRow", "@hide", false, &_init_cbs_selectRow_767_0, &_call_cbs_selectRow_767_0);
  methods += new qt_gsi::GenericMethod ("selectRow", "@brief Virtual method bool QAccessibleTableInterface::selectRow(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectRow_767_0, &_call_cbs_selectRow_767_0, &_set_callback_cbs_selectRow_767_0);
  methods += new qt_gsi::GenericMethod ("selectedCellCount", "@hide", true, &_init_cbs_selectedCellCount_c0_0, &_call_cbs_selectedCellCount_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedCellCount", "@brief Virtual method int QAccessibleTableInterface::selectedCellCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedCellCount_c0_0, &_call_cbs_selectedCellCount_c0_0, &_set_callback_cbs_selectedCellCount_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedCells", "@hide", true, &_init_cbs_selectedCells_c0_0, &_call_cbs_selectedCells_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedCells", "@brief Virtual method QList<QAccessibleInterface*> QAccessibleTableInterface::selectedCells()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedCells_c0_0, &_call_cbs_selectedCells_c0_0, &_set_callback_cbs_selectedCells_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedColumnCount", "@hide", true, &_init_cbs_selectedColumnCount_c0_0, &_call_cbs_selectedColumnCount_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedColumnCount", "@brief Virtual method int QAccessibleTableInterface::selectedColumnCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedColumnCount_c0_0, &_call_cbs_selectedColumnCount_c0_0, &_set_callback_cbs_selectedColumnCount_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedColumns", "@hide", true, &_init_cbs_selectedColumns_c0_0, &_call_cbs_selectedColumns_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedColumns", "@brief Virtual method QList<int> QAccessibleTableInterface::selectedColumns()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedColumns_c0_0, &_call_cbs_selectedColumns_c0_0, &_set_callback_cbs_selectedColumns_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedRowCount", "@hide", true, &_init_cbs_selectedRowCount_c0_0, &_call_cbs_selectedRowCount_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedRowCount", "@brief Virtual method int QAccessibleTableInterface::selectedRowCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedRowCount_c0_0, &_call_cbs_selectedRowCount_c0_0, &_set_callback_cbs_selectedRowCount_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedRows", "@hide", true, &_init_cbs_selectedRows_c0_0, &_call_cbs_selectedRows_c0_0);
  methods += new qt_gsi::GenericMethod ("selectedRows", "@brief Virtual method QList<int> QAccessibleTableInterface::selectedRows()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedRows_c0_0, &_call_cbs_selectedRows_c0_0, &_set_callback_cbs_selectedRows_c0_0);
  methods += new qt_gsi::GenericMethod ("summary", "@hide", true, &_init_cbs_summary_c0_0, &_call_cbs_summary_c0_0);
  methods += new qt_gsi::GenericMethod ("summary", "@brief Virtual method QAccessibleInterface *QAccessibleTableInterface::summary()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_summary_c0_0, &_call_cbs_summary_c0_0, &_set_callback_cbs_summary_c0_0);
  methods += new qt_gsi::GenericMethod ("unselectColumn", "@hide", false, &_init_cbs_unselectColumn_767_0, &_call_cbs_unselectColumn_767_0);
  methods += new qt_gsi::GenericMethod ("unselectColumn", "@brief Virtual method bool QAccessibleTableInterface::unselectColumn(int column)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unselectColumn_767_0, &_call_cbs_unselectColumn_767_0, &_set_callback_cbs_unselectColumn_767_0);
  methods += new qt_gsi::GenericMethod ("unselectRow", "@hide", false, &_init_cbs_unselectRow_767_0, &_call_cbs_unselectRow_767_0);
  methods += new qt_gsi::GenericMethod ("unselectRow", "@brief Virtual method bool QAccessibleTableInterface::unselectRow(int row)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unselectRow_767_0, &_call_cbs_unselectRow_767_0, &_set_callback_cbs_unselectRow_767_0);
  return methods;
}

gsi::Class<QAccessibleTableInterface_Adaptor> decl_QAccessibleTableInterface_Adaptor (qtdecl_QAccessibleTableInterface (), "QtGui", "QAccessibleTableInterface",
  methods_QAccessibleTableInterface_Adaptor (),
  "@qt\n@brief Binding of QAccessibleTableInterface");

}

