/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Util;
import javax.transaction.xa.Xid;

final class XidImpl
implements Xid {
    protected int formatId;
    protected byte[] gtrid;
    protected byte[] bqual;

    public XidImpl(int n, byte[] byArray, byte[] byArray2) {
        this.formatId = n;
        this.gtrid = byArray;
        this.bqual = byArray2;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    public int getFormatId() {
        return this.formatId;
    }

    String toLogString() {
        String string = " XID:" + XidImpl.xidDisplay(this);
        return string;
    }

    static String xidDisplay(Xid xid) {
        if (null == xid) {
            return "(null)";
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("formatId=");
        stringBuffer.append(xid.getFormatId());
        stringBuffer.append(" gtrid=");
        stringBuffer.append(Util.byteToHexDisplayString(xid.getGlobalTransactionId()));
        stringBuffer.append(" bqual=");
        stringBuffer.append(Util.byteToHexDisplayString(xid.getBranchQualifier()));
        return stringBuffer.toString();
    }
}

