/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AuthenticationJNI;
import com.microsoft.sqlserver.jdbc.FailoverInfo;
import com.microsoft.sqlserver.jdbc.FailoverMapSingleton;
import com.microsoft.sqlserver.jdbc.FailoverServerPortPlaceHolder;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolProxy;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionSecurityManager;
import com.microsoft.sqlserver.jdbc.SQLServerDatabaseMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerSavepoint;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamSSPI;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;

public class SQLServerConnection
implements Connection,
Serializable {
    public static final int TRANSACTION_SNAPSHOT = 4096;
    private static final float TIMEOUTSTEP = 0.08f;
    private boolean sendStringParametersAsUnicode = true;
    private boolean lastUpdateCount;
    private int nLockTimeout;
    private String selectMethod;
    private String responseBuffering;
    private byte requestedEncryptionLevel = (byte)-1;
    private static final String SYSTEM_JRE;
    private boolean trustServerCertificate;
    private byte negotiatedEncryptionLevel = (byte)-1;
    Properties activeConnectionProperties;
    private String applicationName;
    private String instanceName;
    private boolean integratedSecurity = false;
    String sConnectURL;
    String sqlServerVersion;
    boolean xopenStates;
    private boolean databaseAutoCommitMode = true;
    private boolean inXATransaction = false;
    private byte[] transactionDescriptor = new byte[8];
    private boolean inTransaction = false;
    boolean bIsOpen;
    private int connectionID = SQLServerConnection.nextConnectionID();
    static final int maxDecimalPrecision = 38;
    private int maxFieldSize = 0;
    private int maxRows = 0;
    private SQLCollation databaseCollation;
    private static int baseConnectionID;
    private String sCatalog = "master";
    private int transactionIsolationLevel = 2;
    private SQLServerPooledConnection pooledConnectionParent;
    private DatabaseMetaData databaseMetaData;
    private int nNextSavePointId = 10000;
    private SQLServerConnectionSecurityManager securityManager;
    private Logger connectionlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerConnection");
    int udpMillisecondsTimeout = 10000;
    private String failoverPartnerServerProvided = null;
    private int nHoldability = 1;
    static final int DEFAULT_TDS_PACKET_SIZE = 8000;
    private int tdsPacketSize = 4096;
    private int requestedPacketSize = 8000;
    private TDSChannel tdsChannel;
    private TDSCommand currentCommand = null;
    private int tdsVersion = 0;
    private int serverMajorVersion;
    private SQLServerConnectionPoolProxy proxy;
    static final int MAX_SQL_LOGIN_NAME_WCHARS = 128;
    Vector sqlWarnings;
    private static final int ENVCHANGE_DATABASE = 1;
    private static final int ENVCHANGE_LANGUAGE = 2;
    private static final int ENVCHANGE_CHARSET = 3;
    private static final int ENVCHANGE_PACKETSIZE = 4;
    private static final int ENVCHANGE_SORTLOCALEID = 5;
    private static final int ENVCHANGE_SORTFLAGS = 6;
    private static final int ENVCHANGE_SQLCOLLATION = 7;
    private static final int ENVCHANGE_XACT_BEGIN = 8;
    private static final int ENVCHANGE_XACT_COMMIT = 9;
    private static final int ENVCHANGE_XACT_ROLLBACK = 10;
    private static final int ENVCHANGE_DTC_ENLIST = 11;
    private static final int ENVCHANGE_DTC_DEFECT = 12;
    private static final int ENVCHANGE_CHANGE_MIRROR = 13;
    private static final int ENVCHANGE_UNUSED_14 = 14;
    private static final int ENVCHANGE_DTC_PROMOTE = 15;
    private static final int ENVCHANGE_DTC_MGR_ADDR = 16;
    private static final int ENVCHANGE_XACT_ENDED = 17;
    private static final int ENVCHANGE_RESET_COMPLETE = 18;
    private static final int ENVCHANGE_USER_INFO = 19;
    static final char[] OUT;
    static final /* synthetic */ boolean $assertionsDisabled;

    boolean sendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    final boolean useLastUpdateCount() {
        return this.lastUpdateCount;
    }

    final String getSelectMethod() {
        return this.selectMethod;
    }

    final String getResponseBuffering() {
        return this.responseBuffering;
    }

    final byte getRequestedEncryptionLevel() {
        if (!$assertionsDisabled && -1 == this.requestedEncryptionLevel) {
            throw new AssertionError();
        }
        return this.requestedEncryptionLevel;
    }

    final boolean trustServerCertificate() {
        return this.trustServerCertificate;
    }

    final byte getNegotiatedEncryptionLevel() {
        if (!$assertionsDisabled && -1 == this.negotiatedEncryptionLevel) {
            throw new AssertionError();
        }
        return this.negotiatedEncryptionLevel;
    }

    final boolean isInTransaction() {
        return this.inTransaction;
    }

    final void setMaxFieldSize(int n) throws SQLServerException {
        if (this.maxFieldSize != n) {
            this.connectionCommand("SET TEXTSIZE " + (0 == n ? Integer.MAX_VALUE : n), "setMaxFieldSize");
            this.maxFieldSize = n;
        }
    }

    final void setMaxRows(int n) throws SQLServerException {
        if (this.maxRows != n) {
            this.connectionCommand("SET ROWCOUNT " + n, "setMaxRows");
            this.maxRows = n;
        }
    }

    final SQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    final int getTDSPacketSize() {
        return this.tdsPacketSize;
    }

    final boolean isYukonOrLater() {
        if (0 == this.tdsVersion) {
            if (!$assertionsDisabled && this.serverMajorVersion < 8) {
                throw new AssertionError();
            }
            return this.serverMajorVersion >= 9;
        }
        if (!$assertionsDisabled && this.tdsVersion < 0x70100000) {
            throw new AssertionError();
        }
        return this.tdsVersion >= 1913192450;
    }

    SQLServerConnection() {
    }

    void setFailoverPartnerServerProvided(String string) {
        this.failoverPartnerServerProvided = string;
    }

    final void setAssociatedProxy(SQLServerConnectionPoolProxy sQLServerConnectionPoolProxy) {
        this.proxy = sQLServerConnectionPoolProxy;
    }

    final Connection getConnection() {
        if (null != this.proxy) {
            return this.proxy;
        }
        return this;
    }

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    Logger getConnectionLogger() {
        return this.connectionlogger;
    }

    final int getRawLoggingID() {
        return this.connectionID;
    }

    String toLogString() {
        String string = " ConnectionID:" + this.connectionID + " TransactionID:" + Util.byteToHexDisplayString(this.transactionDescriptor);
        return string;
    }

    void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    void checkClosed() throws SQLServerException {
        if (!this.bIsOpen) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    private boolean booleanPropertyOn(String string, String string2) throws SQLServerException {
        if (null == string2) {
            return false;
        }
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidBooleanValue"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        return false;
    }

    private static String AppendNameValue(String string, String string2, String string3) {
        string = string + string2;
        string = string + " : ";
        string = string3 != null ? string + string3 : string + "no value set";
        string = string + "  ";
        return string;
    }

    void ValidateMaxSQLLoginName(String string, String string2) throws SQLServerException {
        if (string2 != null && string2.length() > 128) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_propertyMaximumExceedsChars"));
            Object[] objectArray = new Object[]{string, new Integer(128)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
    }

    Connection connect(Properties properties, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        Object object2;
        MessageFormat messageFormat;
        Object object3;
        String string = "";
        boolean bl = this.connectionlogger.isLoggable(Level.FINE);
        this.activeConnectionProperties = (Properties)properties.clone();
        this.pooledConnectionParent = sQLServerPooledConnection;
        String string2 = null;
        String string3 = null;
        string2 = "user";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "password";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "databaseName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "loginTimeout";
        String string4 = string3 = this.activeConnectionProperties.getProperty(string2);
        if (null != string4 && string4.length() > 0) {
            Object[] objectArray3;
            try {
                int n = Integer.parseInt(string4);
                if (n >= 0 && n <= 65535) {
                    if (n > 10) {
                        this.udpMillisecondsTimeout = n * 1000;
                    }
                } else {
                    object3 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray3 = new Object[]{string4};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object3).format(objectArray3), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object3 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray3 = new Object[]{string4};
                SQLServerException.makeFromDriverError(this, this, ((Format)object3).format(objectArray3), null, false);
            }
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "serverName")) == null) {
            string3 = "localhost";
        }
        String string5 = "portNumber";
        object3 = this.activeConnectionProperties.getProperty(string5);
        int n = string3.indexOf(92);
        String string6 = null;
        String string7 = null;
        if (n >= 0) {
            string7 = string3.substring(n + 1, string3.length());
            this.ValidateMaxSQLLoginName("instanceName", string7);
            string3 = string3.substring(0, n);
            if (object3 == null || ((String)object3).equals("0")) {
                string6 = this.getInstancePort(string3, string7);
            }
        }
        this.activeConnectionProperties.setProperty(string2, string3);
        String string8 = this.activeConnectionProperties.getProperty("instanceName");
        if (null != string8) {
            string7 = string8;
        }
        if (string7 != null) {
            this.ValidateMaxSQLLoginName("instanceName", string7);
            if (object3 == null || ((String)object3).equals("0")) {
                string6 = this.getInstancePort(string3, string7);
            }
            this.activeConnectionProperties.setProperty("instanceName", string7);
        }
        if (object3 == null || ((String)object3).equals("0")) {
            object3 = string6 == null ? "1433" : string6;
        }
        this.activeConnectionProperties.setProperty(string5, (String)object3);
        string2 = "applicationName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "lastUpdateCount";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "true";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "encrypt")) == null) {
            string3 = "false";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        byte by = this.requestedEncryptionLevel = this.booleanPropertyOn("encrypt", string3) ? (byte)1 : 0;
        if (0 == this.requestedEncryptionLevel && (SYSTEM_JRE.startsWith("Sun Microsystems Inc. 1.4") || SYSTEM_JRE.startsWith("BEA Systems, Inc. 1.4"))) {
            this.connectionlogger.fine(this.toLogString() + " Default login encryption not supported for JRE " + SYSTEM_JRE);
            this.requestedEncryptionLevel = (byte)2;
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "trustServerCertificate")) == null) {
            string3 = "false";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.trustServerCertificate = this.booleanPropertyOn("trustServerCertificate", string3);
        string2 = "selectMethod";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "direct";
        }
        if (string3.equalsIgnoreCase("cursor") || string3.equalsIgnoreCase("direct")) {
            this.activeConnectionProperties.setProperty(string2, string3.toLowerCase());
        } else {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidselectMethod"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        string2 = "responseBuffering";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "full";
        }
        if (string3.equalsIgnoreCase("full") || string3.equalsIgnoreCase("adaptive")) {
            this.activeConnectionProperties.setProperty(string2, string3.toLowerCase());
        } else {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        string2 = "disableStatementPooling";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 != null && !this.booleanPropertyOn(string2, string3)) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invaliddisableStatementPooling"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "integratedSecurity")) != null) {
            this.integratedSecurity = this.booleanPropertyOn(string2, string3);
        }
        string2 = "workstationID";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        int n2 = 0;
        try {
            n2 = new Integer(this.activeConnectionProperties.getProperty("portNumber"));
            if (n2 < 0 || n2 > 65535) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                objectArray2 = new Object[]{new Integer(n2)};
                SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray2), null, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            objectArray2 = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
            object = new Object[]{this.activeConnectionProperties.getProperty("portNumber")};
            SQLServerException.makeFromDriverError(this, this, objectArray2.format(object), null, false);
        }
        string3 = this.activeConnectionProperties.getProperty("packetSize");
        if (null != string3 && string3.length() > 0) {
            try {
                this.requestedPacketSize = Integer.parseInt(string3);
                if (-1 == this.requestedPacketSize) {
                    this.requestedPacketSize = 0;
                } else if (0 == this.requestedPacketSize) {
                    this.requestedPacketSize = Short.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.requestedPacketSize = -1;
            }
            if (0 != this.requestedPacketSize && (this.requestedPacketSize < 512 || this.requestedPacketSize > Short.MAX_VALUE)) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPacketSize"));
                objectArray2 = new Object[]{string3};
                SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray2), null, false);
            }
        }
        if (bl) {
            this.connectionlogger.fine(this.toLogString() + " Calling securityManager.checkConnect(" + this.activeConnectionProperties.getProperty("serverName") + "," + n2 + ")");
        }
        this.securityManager = new SQLServerConnectionSecurityManager(this.activeConnectionProperties.getProperty("serverName"), n2);
        this.securityManager.checkConnect();
        if (bl) {
            this.connectionlogger.fine(this.toLogString() + " securityManager.checkConnect succeeded.");
        }
        if (this.integratedSecurity) {
            if (bl) {
                this.connectionlogger.fine(this.toLogString() + " securityManager.checkLink.");
            }
            this.securityManager.checkLink();
            if (bl) {
                this.connectionlogger.fine(this.toLogString() + " securityManager.checkLink succeedded.");
            }
        }
        this.sendStringParametersAsUnicode = null == this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode") ? true : this.booleanPropertyOn("sendStringParametersAsUnicode", this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode"));
        this.lastUpdateCount = this.booleanPropertyOn("lastUpdateCount", this.activeConnectionProperties.getProperty("lastUpdateCount"));
        this.xopenStates = this.booleanPropertyOn("xopenStates", this.activeConnectionProperties.getProperty("xopenStates"));
        this.selectMethod = null;
        if (this.activeConnectionProperties.getProperty("selectMethod") != null && this.activeConnectionProperties.getProperty("selectMethod").length() > 0) {
            this.selectMethod = this.activeConnectionProperties.getProperty("selectMethod");
        }
        this.responseBuffering = null;
        if (this.activeConnectionProperties.getProperty("responseBuffering") != null && this.activeConnectionProperties.getProperty("responseBuffering").length() > 0) {
            this.responseBuffering = this.activeConnectionProperties.getProperty("responseBuffering");
        }
        this.applicationName = Util.nameAndVersion(false);
        if (this.activeConnectionProperties.getProperty("applicationName") != null) {
            this.applicationName = this.activeConnectionProperties.getProperty("applicationName");
            this.ValidateMaxSQLLoginName("applicationName", this.applicationName);
        }
        int n3 = 0;
        if (this.activeConnectionProperties.getProperty("loginTimeout") != null && this.activeConnectionProperties.getProperty("loginTimeout").length() > 0) {
            try {
                int n4 = new Integer(this.activeConnectionProperties.getProperty("loginTimeout"));
                if (n4 >= 0 && n4 <= 65535) {
                    n3 = n4;
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray = new Object[]{this.activeConnectionProperties.getProperty("loginTimeout")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        this.nLockTimeout = -1;
        if (this.activeConnectionProperties.getProperty("lockTimeout") != null && this.activeConnectionProperties.getProperty("lockTimeout").length() > 0) {
            try {
                int n5 = new Integer(this.activeConnectionProperties.getProperty("lockTimeout"));
                if (n5 >= -1) {
                    this.nLockTimeout = n5;
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        FailoverInfo failoverInfo = null;
        if (null != this.activeConnectionProperties.getProperty("databaseName")) {
            failoverInfo = FailoverMapSingleton.getFailoverInfo(this, this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"));
        } else if (null != this.activeConnectionProperties.getProperty("failoverPartner")) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_failoverPartnerWithoutDB"), null, true);
        }
        object = null;
        if (null == failoverInfo) {
            object = this.activeConnectionProperties.getProperty("failoverPartner");
        }
        long l = System.currentTimeMillis();
        if (null == object && null == failoverInfo) {
            this.loginWithoutFailover(this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), n2, n3, l);
        } else {
            this.loginWithFailover(this.activeConnectionProperties.getProperty("serverName"), (String)object, failoverInfo, n2, n3, l);
        }
        if (1 == this.negotiatedEncryptionLevel || 3 == this.negotiatedEncryptionLevel) {
            int n6;
            int n7 = n6 = SYSTEM_JRE.startsWith("IBM") ? 8192 : 16384;
            if (this.tdsPacketSize > n6) {
                this.connectionlogger.fine(this.toLogString() + " Negotiated tdsPacketSize " + this.tdsPacketSize + " is too large for SSL with JRE " + SYSTEM_JRE + " (max size is " + n6 + ")");
                MessageFormat messageFormat2 = new MessageFormat(SQLServerException.getErrString("R_packetSizeTooBigForSSL"));
                Object[] objectArray4 = new Object[]{new Integer(n6)};
                this.terminate(6, messageFormat2.format(objectArray4));
            }
        }
        this.bIsOpen = true;
        if (bl) {
            this.connectionlogger.fine(this.toLogString() + " End of connect");
        }
        return this;
    }

    private void loginWithFailover(String string, String string2, FailoverInfo failoverInfo, int n, int n2, long l) throws SQLServerException {
        String string3;
        String string4;
        long l2;
        long l3;
        long l4;
        FailoverInfo failoverInfo2;
        int n3 = 100;
        boolean bl = false;
        int n4 = n;
        boolean bl2 = this.connectionlogger.isLoggable(Level.FINE);
        FailoverServerPortPlaceHolder failoverServerPortPlaceHolder = null;
        boolean bl3 = false;
        if (null != failoverInfo) {
            failoverInfo2 = failoverInfo;
            failoverServerPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
            bl3 = true;
            bl = failoverServerPortPlaceHolder.getUseFailoverPartner();
        } else {
            failoverInfo2 = new FailoverInfo(string2, this, false);
        }
        if (0 == n2) {
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
        } else {
            long l5 = n2 * 1000;
            l4 = l + l5;
            l3 = (long)(0.08f * (float)l5);
            l2 = l + l3;
            if (bl2) {
                this.connectionlogger.fine(this.toLogString() + " Start time: " + l + " Time out time: " + l4 + " Timeout Unit Interval: " + l3);
            }
        }
        int n5 = 0;
        while (true) {
            if (bl) {
                if (!bl3) {
                    failoverServerPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
                    bl3 = true;
                }
                string4 = failoverServerPortPlaceHolder.getFailoverPartner();
                n4 = failoverServerPortPlaceHolder.getFailoverPortNumber();
            } else {
                string4 = string;
                n4 = n;
            }
            if (bl2) {
                string3 = bl ? failoverServerPortPlaceHolder.getFailoverInstance() : this.instanceName;
                this.connectionlogger.fine(this.toLogString() + " This attempt server name: " + string4 + " port: " + n4 + " InstanceName: " + string3);
                this.connectionlogger.fine(this.toLogString() + " This attempt endtime: " + l2);
                this.connectionlogger.fine(this.toLogString() + " This attempt No: " + n5);
            }
            try {
                this.connectHelper(string4, n4, SQLServerConnection.TimerRemaining(l2), n2);
            }
            catch (SQLServerException sQLServerException) {
                long l6;
                if (18456 == sQLServerException.getErrorCode() || 18488 == sQLServerException.getErrorCode() || 4 == sQLServerException.getDriverErrorCode() || 5 == sQLServerException.getDriverErrorCode() || 6 == sQLServerException.getDriverErrorCode() || 0 != n2 && SQLServerConnection.timerHasExpired(l4)) {
                    throw sQLServerException;
                }
                if (1 == n5 % 2 && 0 != n2 && (l6 = (long)SQLServerConnection.TimerRemaining(l4)) <= (long)n3) {
                    throw sQLServerException;
                }
                if (1 == n5 % 2) {
                    if (bl2) {
                        this.connectionlogger.fine(this.toLogString() + " sleeping milisec: " + n3);
                    }
                    try {
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n3 = n3 < 500 ? n3 * 2 : 1000;
                }
                if (0 != n2 && (l2 = System.currentTimeMillis() + l3 * (long)(++n5 / 2 + 1)) > l4) {
                    l2 = l4;
                }
                bl = !bl;
                continue;
            }
            break;
        }
        if (bl && null == this.failoverPartnerServerProvided) {
            string3 = string4;
            if (null != failoverServerPortPlaceHolder.getFailoverInstance()) {
                string3 = string3 + "\\";
                string3 = string3 + failoverServerPortPlaceHolder.getFailoverInstance();
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPartnerConfiguration"));
            Object[] objectArray = new Object[]{new String(this.activeConnectionProperties.getProperty("databaseName")), string3};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
        if (null != this.failoverPartnerServerProvided) {
            if (null != failoverInfo) {
                failoverInfo.failoverAdd(this, bl, this.failoverPartnerServerProvided);
            } else {
                if (bl2) {
                    this.connectionlogger.fine(this.toLogString() + " adding new failover info server: " + this.activeConnectionProperties.getProperty("serverName") + " instance: " + this.activeConnectionProperties.getProperty("instanceName") + " database: " + this.activeConnectionProperties.getProperty("databaseName") + " server provided failover: " + this.failoverPartnerServerProvided);
                }
                failoverInfo2.failoverAdd(this, bl, this.failoverPartnerServerProvided);
                FailoverMapSingleton.putFailoverInfo(this, string, this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"), failoverInfo2, bl, this.failoverPartnerServerProvided);
            }
        }
    }

    private void loginWithoutFailover(String string, String string2, int n, int n2, long l) throws SQLServerException {
        long l2;
        long l3;
        long l4;
        int n3 = 100;
        String string3 = string;
        int n4 = n;
        boolean bl = this.connectionlogger.isLoggable(Level.FINE);
        if (0 == n2) {
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
        } else {
            long l5 = n2 * 1000;
            l4 = l + l5;
            l3 = (long)(0.08f * (float)l5);
            l2 = l + l3;
            if (bl) {
                this.connectionlogger.fine(this.toLogString() + " Start time: " + l + " Time out time: " + l4 + " Timeout Unit Interval: " + l3);
            }
        }
        int n5 = 0;
        while (true) {
            if (bl) {
                this.connectionlogger.fine(this.toLogString() + " This attempt server name: " + string3 + " port: " + n4 + " InstanceName: " + string2);
                this.connectionlogger.fine(this.toLogString() + " This attempt endtime: " + l2);
                this.connectionlogger.fine(this.toLogString() + " This attempt No: " + n5);
            }
            try {
                this.connectHelper(string3, n4, SQLServerConnection.TimerRemaining(l2), n2);
            }
            catch (SQLServerException sQLServerException) {
                long l6;
                if (18456 == sQLServerException.getErrorCode() || 18488 == sQLServerException.getErrorCode() || 4 == sQLServerException.getDriverErrorCode() || 5 == sQLServerException.getDriverErrorCode() || 6 == sQLServerException.getDriverErrorCode() || SQLServerConnection.timerHasExpired(l4)) {
                    throw sQLServerException;
                }
                if (1 == n5 % 2 && 0 != n2 && (l6 = (long)SQLServerConnection.TimerRemaining(l4)) <= (long)n3) {
                    throw sQLServerException;
                }
                if (1 == n5 % 2) {
                    if (bl) {
                        this.connectionlogger.fine(this.toLogString() + " sleeping milisec: " + n3);
                    }
                    try {
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n3 = n3 < 500 ? n3 * 2 : 1000;
                }
                if (0 == n2 || (l2 = System.currentTimeMillis() + l3 * (long)(++n5 / 2 + 1)) <= l4) continue;
                l2 = l4;
                continue;
            }
            break;
        }
        if (null != this.failoverPartnerServerProvided) {
            FailoverInfo failoverInfo = new FailoverInfo(this.failoverPartnerServerProvided, this, false);
            if (bl) {
                this.connectionlogger.fine(this.toLogString() + " adding new failover info server: " + this.activeConnectionProperties.getProperty("serverName") + " instance: " + this.activeConnectionProperties.getProperty("instanceName") + " database: " + this.activeConnectionProperties.getProperty("databaseName") + " server provided failover: " + this.failoverPartnerServerProvided);
            }
            FailoverMapSingleton.putFailoverInfo(this, this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"), failoverInfo, false, this.failoverPartnerServerProvided);
        }
    }

    static boolean timerHasExpired(long l) {
        boolean bl = System.currentTimeMillis() > l;
        return bl;
    }

    static int TimerRemaining(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l - l2;
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        if (l3 <= 0L) {
            l3 = 1L;
        }
        return (int)l3;
    }

    private void connectHelper(String string, int n, int n2, int n3) throws SQLServerException {
        boolean bl = this.connectionlogger.isLoggable(Level.FINE);
        IOException iOException = null;
        try {
            if (bl) {
                this.connectionlogger.fine(this.toLogString() + " Connecting with server: " + string + " port: " + n + " Timeout slice: " + n2 + " Timeout Full: " + n3);
            }
            this.tdsChannel = new TDSChannel(this);
            if (0 == n3) {
                this.tdsChannel.open(string, n, 0);
            } else {
                this.tdsChannel.open(string, n, n2);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
            Object[] objectArray = new Object[]{""};
            String string2 = iOException.toString();
            string2 = string2.replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
            String string3 = messageFormat.format(objectArray);
            string3 = string3 + " " + string2;
            SQLServerException.makeFromDriverError(this, this, string3, "08001", false);
        }
        this.Prelogin();
        if (2 != this.negotiatedEncryptionLevel) {
            this.tdsChannel.enableSSL(string, n);
        }
        this.executeCommand(new LogonCommand());
    }

    void Prelogin() throws SQLServerException {
        int n;
        byte[] byArray = new byte[]{18, 1, 0, 26, 0, 0, 0, 0, 0, 0, 11, 0, 6, 1, 0, 17, 0, 1, -1, 0, 0, 0, 0, 0, 0, this.requestedEncryptionLevel};
        byte[] byArray2 = new byte[4096];
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine(this.toLogString() + " Requesting encryption level:" + TDS.getEncryptionLevel(this.requestedEncryptionLevel));
        }
        if (this.tdsChannel.isLoggingPackets()) {
            this.tdsChannel.logPacket(byArray, 0, byArray.length, this.toLogString() + " Prelogin request");
        }
        this.tdsChannel.write(byArray, 0, byArray.length);
        this.tdsChannel.flush();
        int n2 = byArray2.length;
        int n3 = 0;
        boolean bl = false;
        while (n3 < n2) {
            n = this.tdsChannel.read(byArray2, n3, n2 - n3);
            if (-1 == n) {
                this.terminate(3, 0 == n3 ? SQLServerException.getErrString("R_incompleteResponseIsSQL2000") : SQLServerException.getErrString("R_truncatedServerResponse"));
            }
            if (!$assertionsDisabled && n < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n > n2 - n3) {
                throw new AssertionError();
            }
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(byArray2, n3, n, this.toLogString() + " Prelogin response");
            }
            if (bl || (n3 += n) < 8) continue;
            if (4 != byArray2[0]) {
                this.connectionlogger.warning(this.toLogString() + " Prelogin response packet not marked as a REPLY");
                this.throwInvalidTDS();
            }
            if (1 != byArray2[1]) {
                this.connectionlogger.warning(this.toLogString() + " Prelogin response packet not marked as EOM");
                this.throwInvalidTDS();
            }
            n2 = Util.readUnsignedShortBigEndian(byArray2, 2);
            if (!$assertionsDisabled && n2 < 0) {
                throw new AssertionError();
            }
            if (n2 >= byArray2.length) {
                this.connectionlogger.warning(this.toLogString() + " Indicated response length:" + n2 + " is greater than allowed length:" + byArray2.length);
                this.throwInvalidTDS();
            }
            bl = true;
        }
        n = 0;
        this.negotiatedEncryptionLevel = (byte)-1;
        int n4 = 8;
        block5: while (true) {
            byte by;
            if (n4 >= n2) {
                this.connectionlogger.warning(this.toLogString() + " Option token not found");
                this.throwInvalidTDS();
            }
            if (-1 == (by = byArray2[n4++])) break;
            if (n4 + 4 >= n2) {
                this.connectionlogger.warning(this.toLogString() + " Offset/Length not found for option:" + by);
                this.throwInvalidTDS();
            }
            int n5 = Util.readUnsignedShortBigEndian(byArray2, n4) + 8;
            n4 += 2;
            if (!$assertionsDisabled && n5 < 0) {
                throw new AssertionError();
            }
            int n6 = Util.readUnsignedShortBigEndian(byArray2, n4);
            n4 += 2;
            if (!$assertionsDisabled && n6 < 0) {
                throw new AssertionError();
            }
            if (n5 + n6 > n2) {
                this.connectionlogger.warning(this.toLogString() + " Offset:" + n5 + " and length:" + n6 + " exceed response length:" + n2);
                this.throwInvalidTDS();
            }
            switch (by) {
                case 0: {
                    if (n != 0) {
                        this.connectionlogger.warning(this.toLogString() + " Version option already received");
                        this.throwInvalidTDS();
                    }
                    if (6 != n6) {
                        this.connectionlogger.warning(this.toLogString() + " Version option length:" + n6 + " is incorrect.  Correct value is 6.");
                        this.throwInvalidTDS();
                    }
                    this.serverMajorVersion = byArray2[n5];
                    if (this.serverMajorVersion < 8) {
                        this.connectionlogger.warning(this.toLogString() + " Server major version:" + this.serverMajorVersion + " is not supported by this driver.");
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedServerVersion"));
                        Object[] objectArray = new Object[]{new Integer(byArray2[n5])};
                        this.terminate(6, messageFormat.format(objectArray));
                    }
                    if (this.connectionlogger.isLoggable(Level.FINE)) {
                        this.connectionlogger.fine(this.toLogString() + " Server returned major version:" + byArray2[n5]);
                    }
                    n = 1;
                    continue block5;
                }
                case 1: {
                    if (-1 != this.negotiatedEncryptionLevel) {
                        this.connectionlogger.warning(this.toLogString() + " Encryption option already received");
                        this.throwInvalidTDS();
                    }
                    if (1 != n6) {
                        this.connectionlogger.warning(this.toLogString() + " Encryption option length:" + n6 + " is incorrect.  Correct value is 1.");
                        this.throwInvalidTDS();
                    }
                    this.negotiatedEncryptionLevel = byArray2[n5];
                    if (0 != this.negotiatedEncryptionLevel && 1 != this.negotiatedEncryptionLevel && 3 != this.negotiatedEncryptionLevel && 2 != this.negotiatedEncryptionLevel) {
                        this.connectionlogger.warning(this.toLogString() + " Server returned " + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                        this.throwInvalidTDS();
                    }
                    if (this.connectionlogger.isLoggable(Level.FINE)) {
                        this.connectionlogger.fine(this.toLogString() + " Negotiated encryption level:" + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                    }
                    if (1 == this.requestedEncryptionLevel && 1 != this.negotiatedEncryptionLevel && 3 != this.negotiatedEncryptionLevel) {
                        this.terminate(5, SQLServerException.getErrString("R_sslRequiredNoServerSupport"));
                    }
                    if (2 != this.requestedEncryptionLevel || 3 != this.negotiatedEncryptionLevel) continue block5;
                    this.terminate(5, SQLServerException.getErrString("R_sslRequiredByServer"));
                    continue block5;
                }
            }
            if (!this.connectionlogger.isLoggable(Level.FINE)) continue;
            this.connectionlogger.fine(this.toLogString() + " Ignoring prelogin response option:" + by);
        }
        if (n == 0 || -1 == this.negotiatedEncryptionLevel) {
            this.connectionlogger.warning(this.toLogString() + " Prelogin response is missing version and/or encryption option.");
            this.throwInvalidTDS();
        }
    }

    final void throwInvalidTDS() throws SQLServerException {
        this.terminate(4, SQLServerException.getErrString("R_invalidTDS"));
    }

    final void terminate(int n, String string) throws SQLServerException {
        String string2;
        String string3 = string2 = this.bIsOpen ? "08006" : "08001";
        if (!this.xopenStates) {
            string2 = SQLServerException.mapFromXopen(string2);
        }
        SQLServerException sQLServerException = new SQLServerException((Object)this, string, string2, 0, true);
        sQLServerException.setDriverErrorCode(n);
        this.notifyPooledConnection(sQLServerException);
        this.close();
        throw sQLServerException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean executeCommand(TDSCommand tDSCommand) throws SQLServerException {
        if (null != this.currentCommand) {
            this.currentCommand.detach();
        }
        boolean bl = false;
        TDSCommand tDSCommand2 = this.currentCommand;
        this.currentCommand = tDSCommand;
        try {
            bl = tDSCommand.execute(this.tdsChannel.getWriter(), this.tdsChannel.getReader());
        }
        finally {
            if (bl) {
                this.currentCommand = tDSCommand2;
            }
        }
        return bl;
    }

    private final void connectionCommand(String string, String string2) throws SQLServerException {
        final class ConnectionCommand
        extends UninterruptableTDSCommand {
            final String sql;

            ConnectionCommand(String string, String string2) {
                super(string2);
                this.sql = string;
            }

            final boolean doExecute() throws SQLServerException {
                this.startRequest((byte)1).writeString(this.sql);
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new ConnectionCommand(string, string2));
    }

    String sqlStatementToInitialize() {
        String string = "";
        if (this.nLockTimeout > -1) {
            string = string + " set lock_timeout " + this.nLockTimeout;
        }
        return string;
    }

    void setCatalogName(String string) {
        if (string != null && string.length() > 0) {
            this.sCatalog = string;
        }
    }

    String sqlStatementToSetTransactionIsolationLevel() throws SQLServerException {
        String string = "set transaction isolation level ";
        switch (this.transactionIsolationLevel) {
            case 1: {
                string = string + " read uncommitted ";
                break;
            }
            case 2: {
                string = string + " read committed ";
                break;
            }
            case 4: {
                string = string + " repeatable read ";
                break;
            }
            case 8: {
                string = string + " serializable ";
                break;
            }
            case 4096: {
                string = string + " snapshot ";
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidTransactionLevel"));
                Object[] objectArray = new Object[]{new Integer(this.transactionIsolationLevel)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
        }
        return string;
    }

    static String sqlStatementToSetCommit(boolean bl) {
        return true == bl ? "set implicit_transactions off " : "set implicit_transactions on ";
    }

    String sqlStatementForSettings() throws SQLServerException {
        String string = "";
        string = string + this.sqlStatementToInitialize() + " " + this.sqlStatementToSetTransactionIsolationLevel() + " " + SQLServerConnection.sqlStatementToSetCommit(this.databaseAutoCommitMode);
        return string;
    }

    String getUrl() {
        return this.sConnectURL;
    }

    public Statement createStatement() throws SQLServerException {
        return this.createStatement(1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLServerException {
        return this.prepareCall(string, 1003, 1007);
    }

    public String nativeSQL(String string) throws SQLServerException {
        this.checkClosed();
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLServerException {
        String string = "";
        this.checkClosed();
        if (bl == this.databaseAutoCommitMode) {
            return;
        }
        if (bl) {
            string = "IF @@TRANCOUNT > 0 COMMIT TRAN ";
        }
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine(this.toLogString() + " Autocommitmode current :" + this.databaseAutoCommitMode + " new: " + bl);
        }
        this.connectionCommand(string + SQLServerConnection.sqlStatementToSetCommit(bl), "setAutoCommit");
        this.databaseAutoCommitMode = bl;
    }

    public boolean getAutoCommit() throws SQLServerException {
        this.checkClosed();
        return !this.inXATransaction && this.databaseAutoCommitMode;
    }

    final byte[] getTransactionDescriptor() {
        return this.transactionDescriptor;
    }

    public void commit() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            return;
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 COMMIT TRAN", "Connection.commit");
    }

    public void rollback() throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, true);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "Connection.rollback");
    }

    public void close() throws SQLServerException {
        if (null != this.pooledConnectionParent) {
            return;
        }
        if (this.connectionlogger.isLoggable(Level.FINE)) {
            this.connectionlogger.fine(this.toLogString() + " closing.");
        }
        this.bIsOpen = false;
        if (null != this.tdsChannel) {
            this.tdsChannel.close();
            this.tdsChannel = null;
        }
    }

    final void poolCloseEventNotify() throws SQLServerException {
        if (this.bIsOpen && null != this.pooledConnectionParent) {
            if (!this.databaseAutoCommitMode && !(this.pooledConnectionParent instanceof XAConnection)) {
                this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "close connection");
            }
            this.notifyPooledConnection(null);
            if (this.connectionlogger.isLoggable(Level.FINE)) {
                this.connectionlogger.fine(this.toLogString() + " Connection closed and returned to connection pool");
            }
        }
    }

    public boolean isClosed() throws SQLServerException {
        return !this.bIsOpen;
    }

    public DatabaseMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerDatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLServerException {
        this.checkClosed();
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return false;
    }

    public void setCatalog(String string) throws SQLServerException {
        this.checkClosed();
        if (string != null) {
            this.connectionCommand("use " + Util.escapeSQLId(string), "setCatalog");
            this.sCatalog = string;
        }
    }

    public String getCatalog() throws SQLServerException {
        this.checkClosed();
        return this.sCatalog;
    }

    public void setTransactionIsolation(int n) throws SQLServerException {
        this.checkClosed();
        if (n == 0) {
            return;
        }
        this.transactionIsolationLevel = n;
        String string = this.sqlStatementToSetTransactionIsolationLevel();
        this.connectionCommand(string, "setTransactionIsolation");
    }

    public int getTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return this.transactionIsolationLevel;
    }

    public SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        if (this.sqlWarnings == null) {
            return null;
        }
        return (SQLWarning)this.sqlWarnings.elementAt(0);
    }

    public void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.sqlWarnings = null;
    }

    public Statement createStatement(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return new SQLServerStatement(this, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return new SQLServerPreparedStatement(this, string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return new SQLServerCallableStatement(this, string, n, n2);
    }

    public void setTypeMap(Map map) throws SQLServerException {
        this.checkClosed();
        if (map != null && map instanceof HashMap && map.isEmpty()) {
            return;
        }
        this.NotImplemented();
    }

    public Map getTypeMap() throws SQLServerException {
        this.checkClosed();
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logon(LogonCommand logonCommand) throws SQLServerException {
        block5: {
            AuthenticationJNI authenticationJNI;
            block6: {
                authenticationJNI = null;
                if (this.integratedSecurity) {
                    authenticationJNI = new AuthenticationJNI();
                }
                try {
                    this.sendLogon(logonCommand, authenticationJNI);
                    this.connectionCommand(this.sqlStatementForSettings(), "Change Settings");
                    Object var4_3 = null;
                    if (!this.integratedSecurity) break block5;
                    if (null == authenticationJNI) break block6;
                    authenticationJNI.ReleaseClientContext();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.integratedSecurity) {
                        if (null != authenticationJNI) {
                            authenticationJNI.ReleaseClientContext();
                        }
                        authenticationJNI = null;
                    }
                    throw throwable;
                }
            }
            authenticationJNI = null;
            {
            }
        }
    }

    private void SSPIData(byte[] byArray, byte[] byArray2, int[] nArray, boolean[] blArray, AuthenticationJNI authenticationJNI) throws SQLServerException {
        int n = null == byArray ? authenticationJNI.GenerateClientContext(null, 0, byArray2, nArray, blArray) : authenticationJNI.GenerateClientContext(byArray, byArray.length, byArray2, nArray, blArray);
        if (n != 0) {
            this.connectionlogger.warning(this.toLogString() + " Authentication failed code" + n);
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notConfiguredForIntegrated"), "08001", false);
        }
    }

    final void processEnvChange(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readUnsignedByte();
        int n = tDSReader.readUnsignedShort();
        TDSReaderMark tDSReaderMark = tDSReader.mark();
        int n2 = tDSReader.readUnsignedByte();
        switch (n2) {
            case 4: {
                try {
                    this.tdsPacketSize = Integer.parseInt(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                }
                catch (NumberFormatException numberFormatException) {
                    tDSReader.throwInvalidTDS();
                }
                this.connectionlogger.fine(this.toLogString() + " Network packet size is " + this.tdsPacketSize + " bytes");
                break;
            }
            case 7: {
                if (5 != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                this.databaseCollation = new SQLCollation(tDSReader);
                break;
            }
            case 8: 
            case 11: {
                this.inTransaction = true;
                if (!this.isYukonOrLater()) break;
                byte[] byArray = this.getTransactionDescriptor();
                if (byArray.length != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                tDSReader.readBytes(byArray, 0, byArray.length);
                if (!this.connectionlogger.isLoggable(Level.FINE)) break;
                String string = 8 == n2 ? " started" : " enlisted";
                this.connectionlogger.fine(this.toLogString() + string);
                break;
            }
            case 10: {
                this.inTransaction = false;
                if (this.inXATransaction) {
                    if (!this.connectionlogger.isLoggable(Level.FINE)) break;
                    this.connectionlogger.fine(this.toLogString() + " rolled back. (DTC)");
                    break;
                }
                if (this.connectionlogger.isLoggable(Level.FINE)) {
                    this.connectionlogger.fine(this.toLogString() + " rolled back");
                }
                if (!this.isYukonOrLater()) break;
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 9: {
                this.inTransaction = false;
                if (this.connectionlogger.isLoggable(Level.FINE)) {
                    this.connectionlogger.fine(this.toLogString() + " committed");
                }
                if (!this.isYukonOrLater()) break;
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 12: {
                this.inTransaction = false;
                if (this.connectionlogger.isLoggable(Level.FINE)) {
                    this.connectionlogger.fine(this.toLogString() + " defected");
                }
                if (!this.isYukonOrLater()) break;
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 1: {
                this.setCatalogName(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
            case 13: {
                this.setFailoverPartnerServerProvided(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
        }
        tDSReader.reset(tDSReaderMark);
        tDSReader.readBytes(new byte[n], 0, n);
    }

    private final void executeDTCCommand(int n, byte[] byArray, String string) throws SQLServerException {
        final class DTCCommand
        extends UninterruptableTDSCommand {
            private final int requestType;
            private final byte[] payload;

            DTCCommand(int n, byte[] byArray, String string) {
                super(string);
                this.requestType = n;
                this.payload = byArray;
            }

            final boolean doExecute() throws SQLServerException {
                TDSWriter tDSWriter = this.startRequest((byte)14);
                tDSWriter.writeShort((short)this.requestType);
                if (null == this.payload) {
                    tDSWriter.writeShort((short)0);
                } else {
                    tDSWriter.writeShort((short)this.payload.length);
                    tDSWriter.writeBytes(this.payload);
                }
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new DTCCommand(n, byArray, string));
    }

    final void JTAUnenlistConnection() throws SQLServerException {
        this.executeDTCCommand(1, null, "MS_DTC unenlist connection");
        this.inXATransaction = false;
    }

    final void JTAEnlistConnection(byte[] byArray) throws SQLServerException {
        if (byArray.length > Short.MAX_VALUE) {
            throw new SQLServerException(null, "Invalid transaction cookie length.", null, 0, true);
        }
        this.executeDTCCommand(1, byArray, "MS_DTC enlist connection");
        this.connectionCommand(this.sqlStatementToSetTransactionIsolationLevel(), "JTAEnlistConnection");
        this.inXATransaction = true;
    }

    private byte[] toUCS16(String string) throws SQLServerException {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c & 0xFF);
            byArray[n2++] = by;
            byArray[n2++] = (byte)(c >> 8 & 0xFF);
        }
        return byArray;
    }

    private byte[] encryptPassword(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            byte by;
            byte by2;
            int n2 = string.charAt(i) ^ 0x5A5A;
            n2 = (n2 & 0xF) << 4 | (n2 & 0xF0) >> 4 | (n2 & 0xF00) << 4 | (n2 & 0xF000) >> 4;
            byArray[i * 2 + 1] = by2 = (byte)((n2 & 0xFF00) >> 8);
            byArray[i * 2 + 0] = by = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private void sendLogon(LogonCommand logonCommand, AuthenticationJNI authenticationJNI) throws SQLServerException {
        TDSReader tDSReader;
        int n;
        String string = this.activeConnectionProperties.getProperty("workstationID");
        String string2 = this.activeConnectionProperties.getProperty("user");
        String string3 = this.activeConnectionProperties.getProperty("password");
        String string4 = this.activeConnectionProperties.getProperty("applicationName");
        String string5 = this.activeConnectionProperties.getProperty("databaseName");
        if (string == null || string.length() == 0) {
            string = Util.lookupHostName();
        }
        byte[] byArray = new byte[]{};
        int[] nArray = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        if (this.integratedSecurity) {
            if (authenticationJNI.IsEnabled()) {
                nArray[0] = authenticationJNI.GetMaxSSPIBlobSize();
                byArray = new byte[nArray[0]];
                authenticationJNI.InitDNSNameAndPort(this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("portNumber"));
                this.SSPIData(null, byArray, nArray, blArray, authenticationJNI);
                string2 = null;
                string3 = null;
            } else {
                SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notConfiguredForIntegrated"), "08001", false);
            }
        }
        byte[] byArray2 = this.toUCS16(string);
        byte[] byArray3 = this.toUCS16(string2);
        byte[] byArray4 = this.encryptPassword(string3);
        int n2 = byArray4 != null ? byArray4.length : 0;
        byte[] byArray5 = this.toUCS16(string4);
        byte[] byArray6 = this.toUCS16(string);
        byte[] byArray7 = this.toUCS16(string5);
        byte[] byArray8 = new byte[6];
        int n3 = 0;
        int n4 = 0;
        if (this.serverMajorVersion >= 9) {
            this.tdsVersion = 1913192450;
            n = 94;
        } else {
            if (!$assertionsDisabled && 8 != this.serverMajorVersion) {
                throw new AssertionError();
            }
            this.tdsVersion = 0x70100000;
            n = 86;
        }
        n3 = n2 + byArray2.length + byArray3.length + byArray5.length + byArray6.length + byArray7.length + n + nArray[0];
        TDSWriter tDSWriter = logonCommand.startRequest((byte)16);
        tDSWriter.writeInt(n3);
        tDSWriter.writeInt(this.tdsVersion);
        tDSWriter.writeInt(this.requestedPacketSize);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeByte((byte)-32);
        if (!this.integratedSecurity) {
            tDSWriter.writeByte((byte)3);
        } else {
            tDSWriter.writeByte((byte)-125);
        }
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeShort((short)n);
        tDSWriter.writeShort((short)(string == null ? 0 : string.length()));
        n4 += byArray2.length;
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)(n + n4));
            tDSWriter.writeShort((short)(string2 == null ? 0 : string2.length()));
            tDSWriter.writeShort((short)(n + (n4 += byArray3.length)));
            tDSWriter.writeShort((short)(string3 == null ? 0 : string3.length()));
            n4 += n2;
        } else {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        }
        tDSWriter.writeShort((short)(n + n4));
        tDSWriter.writeShort((short)(string4 == null ? 0 : string4.length()));
        tDSWriter.writeShort((short)(n + (n4 += byArray5.length)));
        tDSWriter.writeShort((short)(string == null ? 0 : string.length()));
        n4 += byArray6.length;
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)(n + n4));
        tDSWriter.writeShort((short)(string5 == null ? 0 : string5.length()));
        n4 += byArray7.length;
        tDSWriter.writeBytes(byArray8);
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        } else {
            tDSWriter.writeShort((short)(n + n4));
            if (65535 <= nArray[0]) {
                tDSWriter.writeShort((short)-1);
            } else {
                tDSWriter.writeShort((short)nArray[0]);
            }
        }
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        if (this.tdsVersion >= 1913192450) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            if (65535 <= nArray[0]) {
                tDSWriter.writeInt(nArray[0]);
            } else {
                tDSWriter.writeInt(0);
            }
        }
        tDSWriter.writeBytes(byArray2);
        tDSWriter.setDataLoggable(false);
        if (!this.integratedSecurity) {
            tDSWriter.writeBytes(byArray3);
            tDSWriter.writeBytes(byArray4);
        }
        tDSWriter.setDataLoggable(true);
        tDSWriter.writeBytes(byArray5);
        tDSWriter.writeBytes(byArray6);
        tDSWriter.writeBytes(byArray7);
        tDSWriter.setDataLoggable(false);
        if (this.integratedSecurity) {
            tDSWriter.writeBytes(byArray, 0, nArray[0]);
        }
        tDSWriter.setDataLoggable(true);
        final class LogonProcessor
        extends TDSTokenHandler {
            private final AuthenticationJNI intAuth;
            private final byte[] secBlobOut;
            private final int[] outBlobSize;
            StreamLoginAck loginAckToken;

            LogonProcessor(AuthenticationJNI authenticationJNI) {
                super("logon");
                this.intAuth = authenticationJNI;
                this.secBlobOut = (byte[])(null != authenticationJNI ? new byte[authenticationJNI.GetMaxSSPIBlobSize()] : null);
                this.outBlobSize = new int[1];
                this.loginAckToken = null;
            }

            boolean onSSPI(TDSReader tDSReader) throws SQLServerException {
                StreamSSPI streamSSPI = new StreamSSPI();
                streamSSPI.setFromTDS(tDSReader);
                boolean[] blArray = new boolean[]{false};
                LogonProcessor logonProcessor = this;
                this.outBlobSize[0] = logonProcessor.intAuth.GetMaxSSPIBlobSize();
                SQLServerConnection.this.SSPIData(streamSSPI.sspiBlob, this.secBlobOut, this.outBlobSize, blArray, this.intAuth);
                return true;
            }

            boolean onLoginAck(TDSReader tDSReader) throws SQLServerException {
                this.loginAckToken = new StreamLoginAck();
                this.loginAckToken.setFromTDS(tDSReader);
                SQLServerConnection.this.sqlServerVersion = this.loginAckToken.sSQLServerVersion;
                SQLServerConnection.this.tdsVersion = this.loginAckToken.tdsVersion;
                return true;
            }

            final boolean complete(LogonCommand logonCommand, TDSReader tDSReader) throws SQLServerException {
                if (null != this.loginAckToken) {
                    return true;
                }
                if (0 != this.outBlobSize[0]) {
                    logonCommand.startRequest((byte)17).writeBytes(this.secBlobOut, 0, this.outBlobSize[0]);
                    return false;
                }
                --((SQLServerConnection)SQLServerConnection.this).tdsChannel.numMsgsRcvd;
                tDSReader.readPacket();
                TDSParser.parse(tDSReader, this);
                return true;
            }
        }
        LogonProcessor logonProcessor = new LogonProcessor(authenticationJNI);
        do {
            tDSReader = logonCommand.startResponse();
            TDSParser.parse(tDSReader, logonProcessor);
        } while (!logonProcessor.complete(logonCommand, tDSReader));
    }

    private void checkHoldability(int n) throws SQLServerException {
        if (n != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_sqlServerHoldability"), null, false);
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        this.checkHoldability(n3);
        return this.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLServerException {
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = n == 1;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        return sQLServerPreparedStatement;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        throw Util.notSupportedBySQLServer("releaseSavepoint");
    }

    private final Savepoint setNamedSavepoint(String string) throws SQLServerException {
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantSetSavepoint"), null, false);
        }
        SQLServerSavepoint sQLServerSavepoint = new SQLServerSavepoint(this, string);
        this.connectionCommand("IF @@TRANCOUNT = 0 BEGIN BEGIN TRAN IF @@TRANCOUNT = 2 COMMIT TRAN END SAVE TRAN " + Util.escapeSQLId(sQLServerSavepoint.getLabel()), "setSavepoint");
        return sQLServerSavepoint;
    }

    public Savepoint setSavepoint(String string) throws SQLServerException {
        this.checkClosed();
        return this.setNamedSavepoint(string);
    }

    public Savepoint setSavepoint() throws SQLServerException {
        this.checkClosed();
        return this.setNamedSavepoint(null);
    }

    public void rollback(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, false);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN " + Util.escapeSQLId(((SQLServerSavepoint)savepoint).getLabel()), "rollbackSavepoint");
    }

    public int getHoldability() throws SQLServerException {
        return this.nHoldability;
    }

    public void setHoldability(int n) throws SQLServerException {
        this.checkClosed();
        if (n == this.nHoldability) {
            return;
        }
        String string = "SET CURSOR_CLOSE_ON_COMMIT ";
        string = n == 1 ? string + "OFF" : string + "ON";
        this.connectionCommand(string, "setHoldability");
        this.nHoldability = n;
    }

    String replaceParameterMarkers(String string, Parameter[] parameterArray, boolean bl) throws SQLServerException {
        char[] cArray = new char[string.length() + parameterArray.length * (6 + OUT.length)];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = ParameterUtils.scanSQLForChar('?', string, n2);
            string.getChars(n2, n5, cArray, n);
            n += n5 - n2;
            if (string.length() == n5) break;
            n += SQLServerConnection.makeParamName(n3++, cArray, n);
            n2 = n5 + 1;
            if (!parameterArray[n4++].isOutput() || bl && n4 <= 1) continue;
            System.arraycopy(OUT, 0, cArray, n, OUT.length);
            n += OUT.length;
        }
        while (n < cArray.length) {
            cArray[n++] = 32;
        }
        return new String(cArray);
    }

    static int makeParamName(int n, char[] cArray, int n2) {
        cArray[n2 + 0] = 64;
        cArray[n2 + 1] = 80;
        if (n < 10) {
            cArray[n2 + 2] = (char)(48 + n);
            return 3;
        }
        if (n < 100) {
            int n3 = 2;
            while (true) {
                if (n < n3 * 10) {
                    cArray[n2 + 2] = (char)(48 + (n3 - 1));
                    cArray[n2 + 3] = (char)(48 + (n - (n3 - 1) * 10));
                    return 4;
                }
                ++n3;
            }
        }
        String string = "" + n;
        string.getChars(0, string.length(), cArray, n2 + 2);
        return 2 + string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPooledConnection(SQLServerException sQLServerException) {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            if (null != this.pooledConnectionParent) {
                this.pooledConnectionParent.notifyEvent(sQLServerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void DetachFromPool() {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            this.pooledConnectionParent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstancePort(String string, String string2) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        DatagramSocket datagramSocket = null;
        byte[] byArray = new byte[4096];
        int n = 1434;
        int n2 = this.udpMillisecondsTimeout;
        int n3 = 0;
        try {
            object3 = (" " + string2).getBytes();
            object3[0] = 4;
            while (true) {
                datagramSocket = new DatagramSocket();
                object2 = new DatagramPacket((byte[])object3, ((byte[])object3).length, InetAddress.getByName(string), n);
                datagramSocket.send((DatagramPacket)object2);
                datagramSocket.setSoTimeout(1000);
                object2 = new DatagramPacket(byArray, byArray.length);
                try {
                    datagramSocket.receive((DatagramPacket)object2);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (0 == n3 % 30 && this.connectionlogger.isLoggable(Level.FINE)) {
                        this.connectionlogger.fine(this.toLogString() + " Unexpected UDP timeout at " + (n3 + 1) + " seconds resolving instance port.  Target -> udp:" + InetAddress.getByName(string) + ":1434.");
                    }
                    ++n3;
                    n2 -= 1000;
                    if (null == datagramSocket) continue;
                    datagramSocket.close();
                    datagramSocket = null;
                    if (n2 > 0) continue;
                    throw socketTimeoutException;
                }
                break;
            }
            byArray = ((DatagramPacket)object2).getData();
        }
        catch (IOException iOException) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_failedConnection"));
            object = iOException.toString();
            object = ((String)object).replaceAll(this.activeConnectionProperties.getProperty("serverName"), "");
            object = ((String)object).replaceAll(string2, "");
            objectArray = new Object[]{"", object};
            SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(objectArray), "08001", false);
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
        object3 = new String(byArray, 3, byArray.length - 3);
        int n4 = ((String)object3).indexOf("tcp;");
        if (-1 != n4) {
            int n5 = n4 + 4;
            int n6 = ((String)object3).indexOf(59, n5);
            String string3 = ((String)object3).substring(n5, n6);
            return string3;
        }
        object = new MessageFormat(SQLServerException.getErrString("R_notConfiguredToListentcpip"));
        objectArray = new Object[]{string2};
        SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), "08001", false);
        return null;
    }

    int getNextSavepointId() {
        ++this.nNextSavePointId;
        return this.nNextSavePointId;
    }

    SQLServerConnectionSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    static {
        $assertionsDisabled = !SQLServerConnection.class.desiredAssertionStatus();
        SYSTEM_JRE = System.getProperty("java.vendor") + " " + System.getProperty("java.version");
        baseConnectionID = 0;
        OUT = new char[]{' ', 'O', 'U', 'T'};
    }

    private final class LogonCommand
    extends UninterruptableTDSCommand {
        LogonCommand() {
            super("logon");
        }

        final boolean doExecute() throws SQLServerException {
            SQLServerConnection.this.logon(this);
            return true;
        }
    }
}

