ITK Release 4.2
===============

We are pleased to announce the release of the InsightToolkit 4.2.0!
Download links can be found at:

<http://itk.org/ITK/resources/software.html>

This release is the second since ITK 4.0 and includes a number of bug
fixes and new features.

Notable changes:

-   an abundance of bug fixes and compiler issues were addressed
-   Addition of GPU modules for Finite Difference, Smoothing,
    Thresholding, and Registration
-   Physics-Based Non-Ridged Registration
-   Addition of Patch-Based denosing
-   Infrastructure for Remote Modules
-   Numerous Registration V4 enhancements
-   And Much More!

We have also improved compiler support. Specifically, we have been
compiling with the latest gcc 4.7.0. And now Visual Studio 10 works
without any workarounds.

A complete list of changes since the prior release can be found here:
[ITK/Release\_4.2\_Changed\_From\_Previous](ITK/Release_4.2_Changed_From_Previous "wikilink")

New contributors with merged patches include:

-   Dave Chen
-   Marc Bruce
-   Michael Jeulin-L
-   Ren-Hui Gong
-   T.R Shashwath

Thanks to our gerrit code review system its easy to contribute bug fixes
and patches.

Alexandre Gouaillard (1):

`     COMP: the inlude file has been moved to include/`

Andriy Kot (1):

`     ENH: A2D2 Physics-Based Non-Rigid Registration`

Arnaud Gelas (10):

`     ENH: Improve code coverage for LevelSetsv4`\
`     ENH: Possibility to provide an image to weigh the curvature term`\
`     ENH: Review IsoDataThresholdCalculator`\
`     ENH: Review IntermodesThresholdCalculator`\
`     BUG: Luminance in RGB*Pixel was computed as a ComponentType`\
`     ENH: Move ComputeMixedArea from Curvature computation into TriangleHelper`\
`     ENH: Make it works if ImageDimension > 2`\
`     ENH: Add interface to use vnl_sparse_lu as solver for mesh parameterization`\
`     DOC: Fix warning on ITKExamples Dashboard.`\
`     DOC: Fix doxygen warning`

Bill Lorensen (22):

`     DOC: Spelling errors in comments`\
`     DOC: Spelling errors in comments`\
`     DOC: Spelling errors in comments.`\
`     DOC: Spelling errors in comments.`\
`     DOC: Spelling errors`\
`     BUG: Stray character`\
`     DOC: Spelling erros in comments`\
`     DOC: Spelling errors`\
`     DOC: Spelling errors in comments`\
`     DOC: Spelling errors in comments.`\
`     DOC: Spelling errors in comments`\
`     DOC: Bad characters`\
`     COMP: VTK6 API change`\
`     BUG: Bad signature for test.`\
`     COMP: SizeValueType not defined`\
`     BUG: Using a pointer to data that goes out of scope`\
`     BUG: Using a pointer to data that goes out of scope`\
`     ENH: Consistent INSTALL TARGET`\
`     BUG: Remove legacy iterator code`\
`     COMP: VTK6 factory changes`\
`     BUG: Remove conflicting VTK includes`\
`     BUG: Wrong viewport for mixed rgb/non-rgb images.`

Brad King (6):

`     COMP: Update VNL `“`long`` ``long`”` instantiations for vxl 2012-03-16`\
`     COMP: Include CheckIncludeFileCXX before using it`\
`     KWSys: Remove DateStamp`\
`     KWSys: Fix SystemTools environment memory handling (#13156)`\
`     KWSys: Remove dependencies on FundamentalType`\
`     KWSys: Remove unused environ declaration from SystemTools`

Bradley Lowekamp (50):

`     BUG: itkTestDriver should only print usage once`\
`     ENH: Don't use pretty functions strings, as they cause bloat`\
`     PERF: Improved cache coherence of StatisticsImageFilter`\
`     PERF: eliminate false sharing, improved algorithm`\
`     BUG: Corrected parent class in Superclass and TypeMacro`\
`     BUG: Fix incorrect progress reporting, improved exception handling`\
`     PERF: Implementing optimized image copy method`\
`     COMP: Address implicit cast warnings in ImageAlgorithm::DispatchedCopy`\
`     COMP: address warnings in the ImageGrid module`\
`     BUG: Fix exporting for Nrrd library`\
`     COMP: Fixing warning in threshold module related double->short`\
`     BUG: Fix out of bounds access during PrintSelf`\
`     BUG: Addressing some warnings for implicit cast between float and interger`\
`     BUG: Fix leak in NrrdIO when file doesn't exit`\
`     ENH: adding ClearSeeds method to VectorConfidenceConnected filter`\
`     ENH: For VectorImage support, iterators must not return by reference`\
`     PERF: refactor SliceBySliceImageFilter for performance`\
`     ENH: adding VectorImage support to Gradient image filter`\
`     ENH: updating vector ImageFunctions to work with VectorImages`\
`     COMP: correcting the ObjectToObjectMetric for WrapITK`\
`     STYLE: fixes for KWStyle`\
`     COMP: remove erouneous SWIG version check`\
`     BUG: adding missing types for wrapping ResampleImageFilter`\
`     COMP: fix overflow warnings`\
`     BUG: fixing a couple unitialized variables for valgrind`\
`     BUG: add missing ImageToImage for VectorImages`\
`     COMP: Fix compilation warning about typedef shadowing`\
`     COMP: Avoid C++0x constexpr error`\
`     ENH: adding ImageSource module for WrapITK`\
`     ENH: adding PatchBasedDenoising to WrapITK`\
`     COMP: fix compilation warnings in GPU code`\
`     COMP: Rename ITKImageSource module to ITKImageSources`\
`     COMP: don't construct a object only to use static methods`\
`     COMP: fix implicit conversion warnings`\
`     COMP: Use SFINAE for pixel type in PatchDenoing methods`\
`     BUG: fix incorrect class name used in PhysicalPoint source`\
`     COMP: Fix compilation of EnableIf methods in patch denoising`\
`     COMP: pass only unique include paths to GCC_XML`\
`     COMP: add explicit exception specification for IO exceptions`\
`     BUG: Display warning when returning null pointer`\
`     COMP: Fix definition of Rigid3DTransform when LEGACY enabled`\
`     COMP: Remove the use of legacy method`\
`     COMP: fix compilation error where IndexType is undefined`\
`     STYLE: fixing style according to KWStyle`\
`     COMP: fix some conversion warnings from SimpleITK dashboard`\
`     BUG: Use the input type for the threshold value`\
`     BUG: Output image is zero when no seeds are provided`\
`     BUG: Inputs to filters should be constant`\
`     BUG: remove PatchBasedDenoising from WrapITK until fixed`\
`     COMP: WrapITK: removed Denosing, matching dim for ObjectToObject`

Brian Avants (3):

`     ENH: gradient descent optimizer with golden section line search`\
`     BUG: scales setting in wrong place`\
`     PERF: improve speed of GetNumberOfLocalParameters`

Cory Quammen (4):

`     BUG: Fixed template arguments in deconvolution filters`\
`     BUG: Fixed kernel index shifting to handle kernels with non-zero indices`\
`     ENH: Added parametric blind least squares deconvolution`\
`     COMP: Fixed problem with linking to system FFTW`

Dave Chen (1):

`     BUG: Fixed show2d WrapITK command for Macs.`

Gaëtan Lehmann (1):

`     ENH: wrap the deconvolution filters`

Hans Johnson (11):

`     COMP:  Default parameters belong at declaration`\
`     COMP: Missing this-> required for clang++`\
`     BUG: Introduce proper .md5 based testing data`\
`     COMP: Remove unnecessary clang compiler option`\
`     STYLE: Remove DEPRECATED_METADATA_ORIENTATION`\
`     COMP: Variable was conditionally unitialized`\
`     STYLE:  #if 0 sections of dead code removed`\
`     STYLE: Deprecated functions respect itkLegacyMacro`\
`     STYLE: Change intiial to initial`\
`     COMP: Removing a variety of compiler warnings.`\
`     STYLE:  Remove refernces to itkTestMain.h`

ITK Migration V4 (1):

`     DOC: Modify BinaryErodeImageFilter comments.`

Jim Miller (2):

`     COMP: there is not GPUCommonRegistration library`\
`     DOC: correct documentation of Directions`

Kent Williams (5):

`     COMP: add cstring include for memcpy`\
`     DOC: fixed up comment about GetNumberOfComponentsPerPixel()`\
`     BUG: gdcm crashed when looking at non-dicom files.`\
`     BUG: BSplineDeformable::InsideValidRegion problem`\
`     BUG: Remove itkWarningMacro from BSplineDeformableTransform::TransformPoint`

Kris Zygmunt (17):

`     BUG: fix GPUCommon tests`\
`     ENH: add GPU Finite Difference module`\
`     ENH: add GPU ImageFilterBase module`\
`     ENH: add GPU Smoothing module`\
`     ENH: add GPU Thresholding module`\
`     ENH: add GPU RegistrationCommon module`\
`     ENH: add GPU PDE Deformable Registration module`\
`     ENH: add GPU Anisotropic Diffusion module`\
`     BUG: BoundaryFacesCalculator returns duplicate regions sometimes`\
`     BUG: SymmetricSecondRankTensor Pre and PostMultiply return wrong type`\
`     ENH: Add Subsampling Strategies to Statistics`\
`     ENH: A2D2 Denoising`\
`     COMP: Fix Patch-based Denoising 64-bit type compile errors`\
`     COMP: Fix compile error when TR1 not available`\
`     STYLE: Patch-based Denoising KWStyle fixes`\
`     COMP: Enable an Iterator with VectorImageToImageAdaptor`\
`     COMP: Fix GPUCommon warnings and circular include error`

Luis Ibanez (2):

`     ENH: VTK6 API change. VTK_MAJOR_VERSION has moved.`\
`     BUG: Was not Rendering when screen capture was off.`

Marc Bruce (1):

`     ENH: Expanded TIFF IO for 32-bit floating-point tiffs.`

Matthew McCormick (40):

`     ENH: Bump version to 4.2`\
`     COMP: Fix ImageSource MakeOutput overload error.`\
`     PERF: Improve ScalarImageToTextureFeaturesFilter pipeline setup.`\
`     COMP: Fix DivideOrZeroOut Functor not-used warning.`\
`     ENH: Add itk::Math FloatAlmostEqual and FloatDifferenceULP`\
`     COMP: PhilipsRECImageIO orientation test variable name.`\
`     BUG: Fix PolyLineParametricPath endpoint detection.`\
`     COMP: Fix bool comparison warning in itkMathTest.`\
`     COMP: Fix Clang cast-align warnings in DICOMSource.h.`\
`     COMP: Disable HeaderTests for Visual Studio 10.`\
`     PERF: Prevent HeaderTest re-building with CMake configuration.`\
`     BUG: Remove extra m_DirectionChange from Transform.`\
`     COMP: ITK-2901 arg_min is not a member of vnl_sse`<double>`.`\
`     ENH: Improve precision of JointHistogramMI with compensated summation.`\
`     COMP: Add PyBuffer.h to the header test black list.`\
`     BUG: Fix baseline tests for DiffusionTensor3DReconstructionImageFilterTest.`\
`     ENH: Add CMake infrastructure for fetching Remote modules.`\
`     ENH:  Add the LesionSizingToolkit as a Remote Module.`\
`     BUG: Fix wrapping of ObjectToObjectMetric.`\
`     BUG: LevelSetsv4 'Base' in class name.`\
`     STYLE: Fix alignment in ImageBase.`\
`     COMP: Fix uninitialized memory conditional in FEM tests.`\
`     COMP: Fix wrapping for dimension = 1.`\
`     DOC: Fix PipelineMonitorImageFilter class doc spelling.`\
`     COMP: Update doxygen.config for version 1.8.1.`\
`     COMP: Fix Doxygen warnings in DOMNode.`\
`     COMP: itkRegionGrow2DTest uninitialized variable.`\
`     COMP: RGBGibbsPriorFilter uninitialized variable.`\
`     COMP: GaussianInterpolateImageFunction uninitialized variable.`\
`     COMP: MaskedFFTNormalizedCorrelationImageFilter not initialized.`\
`     COMP: Fix GPU class doxygen warnings.`\
`     BUG: Improve HeaderTest regeneration.`\
`     BUG: Update the Python DicomSliceRead example.`\
`     COMP: HeaderTest configuration CMake version check.`\
`     COMP: RegionGrow2DTest unintialized value.`\
`     COMP: Fix doxygen warning in GPUFiniteDifferenceImageFilter.`\
`     COMP: Doxygen warning about FloatAlmostEqual undocumented param.`\
`     COMP: Remove WrapITK include(CPack).`\
`     DOC: Add links in the doxygen footer to the tarballs.`\
`     DOC: Make diagram for PhasedArray3DSpecialCoordinatesImage verbatim.`

Michael Jeulin-L (1):

`     BUG: Add the const correctness to SpatialObject::GetMaximumDepth`

Michael Stauffer (24):

`     BUG: disable computation of fixed image gradients in ANTS metric`\
`     PERF: CompositeTransform - use raw pointers for efficiency`\
`     PERF: Remove pre-warp in ImageToImageMetricv4.`\
`     BUG: Add check for sampling in ANTS metric`\
`     ENH: Metricv4 floating point compensation and summed compensation`\
`     ENH: Change ANTS metricv4 default radius`\
`     ENH: Add multi-metric registration test for ImageToImageMetrics`\
`     BUG: Avoid EXC_BAD_ACCESS access when resizing array`\
`     ENH: Add a proper Demons metric in metricv4 format.`\
`     BUG: Fix bug in CentralDiffernceImageFunction regarding boundaries`\
`     ENH: Update v4 PointSet metrics to work with image metrics`\
`     ENH: Add IndexInBounds method in ConstNeighborhoodIterator`\
`     ENH: PointSetMetric overhaul, common virtual domain, estimators`\
`     ENH: Add ObjectToObjectMultiMetricv4`\
`     COMP: Fix compilation errors from recent patch merges`\
`     COMP: Fix some compiler warnings`\
`     BUG: Implement itkObjectToObjectMetricBase::GetCurrentValue()`\
`     PERF: Optimze GetValue in MattesMutual..ImageMetricv4`\
`     COMP: Fix compiler warning in Jensen PointSet Metricv4`\
`     STYLE: Rename ObjectToObjectOptimizerBase::m_Value`\
`     COMP: Fix compiler warning in LinearInterpolateImageFunction.`\
`     COMP: JointHistorgram Metricv4 - fix warning`\
`     COMP: Fix some Doxygen warnings`\
`     PERF: Change 1st parameter of UpdateTransformParameters to const`

Nick Tustison (15):

`     ENH: Fixing registration methods pipelining.`\
`     ENH:  Adding B-spline SyN registration method.`\
`     PERF:  B-spline cache thrashing. h/t Brad L.`\
`     BUG:  Fix valgrind errors.`\
`     ENH:  Exposing window sizes in registration methods.`\
`     COMP:  Address comp. warnings (int <-> double)`\
`     COMP:  Remove small warning.`\
`     ENH:  Adding vars and removing couts`\
`     BUG:  Iterate over virtual image (not fixed image).`\
`     ENH: Improving event reporting for registration methods.`\
`     STYLE:  Remove reporters from time-varying methods.`\
`     STYLE:  More unnecessary variables removal.`\
`     DOC:  Adding citation for method.`\
`     BUG: Unnecessary tautology.`\
`     ENH:  Adding option to specify sampling percentages per level.`

Paul Novotny (3):

`     COMP: Build fix for non-apple big-endian`\
`     COMP: Fix Spatial Object Test Segfaults`\
`     BUG: Fix test failures due to NrrdIO on i386`

Ren-Hui Gong (3):

`     ENH: XML DOM for ITK preview 5.`\
`     BUG: XML DOM memory leakage fix and minor revisions`\
`     BUG: XML DOM Bug-Fix and Improvements (revised 2012-06-06 5:25PM).`

Sean McBride (3):

`     COMP: valgrind suppression for system zlib`\
`     COMP: Removed undefined use of std::complex with integer types`\
`     COMP: removed invalid use of noreturn attribute`

T.R Shashwath (1):

`     COMP: Define feenableexcept and fedisableexcept on iOS`

Vivien Delmon (1):

`     COMP: fix compilation errors with gcc 4.7`

Xiaoxiao Liu (8):

`     BUG: Missing vxl header in BridgeVXL header test.`\
`     BUG: Missing raw file next to mhd file.`\
`     BUG:  Fix OpenCVVideoIO warnings and testing bugs.`\
`     BUG: Fix itkVideoStream test failure.`\
`     ENH: Enable component-based packaging.`\
`     ENH: Disable system installed OpenCV and VXL warnings.`\
`     BUG: ITK-2930 Fix OpenCVBridge memory copy errors.`\
`     BUG: Fix itkOpenCVVideoIOTest test failure.`
