(*
    HLins: insert http-links into HTML documents.
    See http://www.lri.fr/~treinen/hlins

    Copyright (C) 1999 Ralf Treinen <treinen@lri.fr>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

(**************************************************************************)
(* fixed-length cyclic character buffer.                                  *)
(**************************************************************************)

(* abstract type of a buffer *)
type buffer;;

(* test whether the buffer is empty *)
val is_empty: buffer -> bool;;

(* (fresh n) returns a buffer with n-1 positions *)
val fresh: int -> buffer;;

(* append a character *)
val addc: buffer -> char -> unit;;

(* put a string in front of the buffer *)
val push: buffer -> string -> unit;;

(* take a character *)
val getc: buffer -> char;;

(* take a string of length n *)
val gets: buffer -> int -> string;;

(* take all the contents from the buffer *)
val getall: buffer -> string;;

