/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ContiguousSetTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAsList() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testAsList();
}

public void testContains() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testContains();
}

public void testContainsAll() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testContainsAll();
}

public void testCreate_empty() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testCreate_empty();
}

public void testCreate_noMax() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testCreate_noMax();
}

public void testCreate_noMin() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testCreate_noMin();
}

public void testEquals() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testEquals();
}

public void testFirst() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testFirst();
}

public void testHeadSet() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testHeadSet();
}

public void testHeadSet_tooSmall() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testHeadSet_tooSmall();
}

public void testIntersection() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testIntersection();
}

public void testIntersection_empty() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testIntersection_empty();
}

public void testInvalidIntRange() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testInvalidIntRange();
}

public void testInvalidLongRange() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testInvalidLongRange();
}

public void testLast() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testLast();
}

public void testRange() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testRange();
}

public void testRange_unboundedRange() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testRange_unboundedRange();
}

public void testSubSet() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testSubSet();
}

public void testSubSet_outOfOrder() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testSubSet_outOfOrder();
}

public void testSubSet_tooLarge() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testSubSet_tooLarge();
}

public void testSubSet_tooSmall() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testSubSet_tooSmall();
}

public void testTailSet() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testTailSet();
}

public void testTailSet_tooLarge() throws Exception {
  com.google.common.collect.ContiguousSetTest testCase = new com.google.common.collect.ContiguousSetTest();
  testCase.testTailSet_tooLarge();
}
}
