/* gmpc-metadata-text-label.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-metadata-text-label.vala, do not modify */

/* Gnome Music Player Client 
 * Copyright (C) 2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <libmpd/libmpdclient.h>
#include <libmpd/libmpd.h>
#include <misc.h>
#include <metadata.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <main.h>
#include <gmpc-meta-watcher.h>

#define _mpd_freeSong0(var) ((var == NULL) ? NULL : (var = (mpd_freeSong (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _meta_data_free0(var) ((var == NULL) ? NULL : (var = (meta_data_free (var), NULL)))

struct _GmpcMetaDataWidgetsTextLabelPrivate {
	mpd_Song* cur_song;
	gchar* song_checksum;
	MetaDataType cur_type;
};

struct _Block5Data {
	int _ref_count_;
	GmpcMetaDataWidgetsTextLabel * self;
	MetaData* item;
	mpd_Song* song;
	MetaDataType type;
};


static gpointer gmpc_meta_data_widgets_text_label_parent_class = NULL;

#define use_transition_mdtl TRUE
#define some_unique_name_mdtl VERSION
#define GMPC_META_DATA_WIDGETS_TEXT_LABEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_META_DATA_WIDGETS_TYPE_TEXT_LABEL, GmpcMetaDataWidgetsTextLabelPrivate))
enum  {
	GMPC_META_DATA_WIDGETS_TEXT_LABEL_DUMMY_PROPERTY
};
static void gmpc_meta_data_widgets_text_label_set_from_item (GmpcMetaDataWidgetsTextLabel* self, const MetaData* item);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda31_ (const mpd_Song* csong, MetaDataType type, MetaDataResult _result_, const MetaData* met, GmpcMetaDataWidgetsTextLabel* self);
static void __lambda31__gmpc_meta_watcher_data_changed (GmpcMetaWatcher* _sender, const mpd_Song* song, MetaDataType type, MetaDataResult _result_, const MetaData* met, gpointer self);
static void _lambda32_ (GtkLabel* source, GtkMenu* menu, Block5Data* _data5_);
static void _lambda33_ (GtkMenuItem* source, Block5Data* _data5_);
static void __lambda33__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda34_ (GtkMenuItem* source, GmpcMetaDataWidgetsTextLabel* self);
static void __lambda34__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda32__gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self);
static void gmpc_meta_data_widgets_text_label_finalize (GObject* obj);


static void gmpc_meta_data_widgets_text_label_set_from_item (GmpcMetaDataWidgetsTextLabel* self, const MetaData* item) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (item != NULL) {
		if (item->content_type == META_DATA_CONTENT_TEXT) {
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			gchar* res;
			_tmp0_ = meta_data_get_text (item);
			_tmp1_ = g_strdup (_tmp0_);
			res = _tmp1_;
			gtk_label_set_text ((GtkLabel*) self, res);
			_g_free0 (res);
		} else {
			if (item->content_type == META_DATA_CONTENT_HTML) {
				gchar* _tmp2_ = NULL;
				gchar* res;
				_tmp2_ = meta_data_get_text_from_html (item);
				res = _tmp2_;
				gtk_label_set_text ((GtkLabel*) self, res);
				_g_free0 (res);
			} else {
				if (item->content_type == META_DATA_CONTENT_URI) {
					const gchar* _tmp3_ = NULL;
					gchar* _tmp4_;
					gchar* path;
					gchar* res;
					gchar* _tmp5_ = NULL;
					_tmp3_ = meta_data_get_uri (item);
					_tmp4_ = g_strdup (_tmp3_);
					path = _tmp4_;
					res = NULL;
					g_file_get_contents (path, &_tmp5_, NULL, &_inner_error_);
					_g_free0 (res);
					res = _tmp5_;
					if (_inner_error_ != NULL) {
						goto __catch9_g_error;
					}
					gtk_label_set_text ((GtkLabel*) self, res);
					goto __finally9;
					__catch9_g_error:
					{
						GError * e;
						const gchar* _tmp6_ = NULL;
						gchar* _tmp7_ = NULL;
						gchar* _tmp8_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp6_ = _ ("Error reading file: %s");
						_tmp7_ = g_strdup_printf (_tmp6_, e->message);
						_tmp8_ = _tmp7_;
						gtk_label_set_text ((GtkLabel*) self, _tmp8_);
						_g_free0 (_tmp8_);
						_g_error_free0 (e);
					}
					__finally9:
					if (_inner_error_ != NULL) {
						_g_free0 (res);
						_g_free0 (path);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_free0 (res);
					_g_free0 (path);
				} else {
					const gchar* _tmp9_ = NULL;
					_tmp9_ = _ ("Not available");
					gtk_label_set_text ((GtkLabel*) self, _tmp9_);
				}
			}
		}
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = _ ("Not available");
		gtk_label_set_text ((GtkLabel*) self, _tmp10_);
	}
}


/**
         * @param song The #MPD.Song to display the text for.
         * @param type The #Gmpc.MetaData.Type of metadata to display. 
         * Create a text label for Song, that displays 
         * Text metadata
         * @return a #TextLabel or type #Gtk.Label
         */
static gpointer _mpd_songDup0 (gpointer self) {
	return self ? mpd_songDup (self) : NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_meta_data_free0 (_data5_->item);
		_mpd_freeSong0 (_data5_->song);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda31_ (const mpd_Song* csong, MetaDataType type, MetaDataResult _result_, const MetaData* met, GmpcMetaDataWidgetsTextLabel* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (csong != NULL);
	if (type == self->priv->cur_type) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = mpd_song_checksum (csong);
		_tmp2_ = _tmp1_;
		_tmp0_ = g_strcmp0 (self->priv->song_checksum, _tmp2_) == 0;
		_g_free0 (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (_result_ == META_DATA_AVAILABLE) {
			gmpc_meta_data_widgets_text_label_set_from_item (self, met);
		} else {
			if (_result_ == META_DATA_FETCHING) {
				const gchar* _tmp3_ = NULL;
				_tmp3_ = _ ("Fetching...");
				gtk_label_set_text ((GtkLabel*) self, _tmp3_);
			} else {
				gmpc_meta_data_widgets_text_label_set_from_item (self, NULL);
			}
		}
	}
}


static void __lambda31__gmpc_meta_watcher_data_changed (GmpcMetaWatcher* _sender, const mpd_Song* song, MetaDataType type, MetaDataResult _result_, const MetaData* met, gpointer self) {
	_lambda31_ (song, type, _result_, met, self);
}


static void _lambda33_ (GtkMenuItem* source, Block5Data* _data5_) {
	GmpcMetaDataWidgetsTextLabel * self;
	MetaData* _tmp0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (source != NULL);
	gmpc_meta_watcher_get_meta_path (gmw, _data5_->song, _data5_->type | META_QUERY_NO_CACHE, &_tmp0_);
	_meta_data_free0 (_data5_->item);
	_data5_->item = _tmp0_;
}


static void __lambda33__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda33_ (_sender, self);
}


static void _lambda34_ (GtkMenuItem* source, GmpcMetaDataWidgetsTextLabel* self) {
	GmpcMetaDataEditWindow* _tmp0_ = NULL;
	GmpcMetaDataEditWindow* _tmp1_;
	g_return_if_fail (source != NULL);
	_tmp0_ = gmpc_meta_data_edit_window_new (self->priv->cur_song, self->priv->cur_type);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (_tmp1_);
}


static void __lambda34__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda34_ (_sender, self);
}


static void _lambda32_ (GtkLabel* source, GtkMenu* menu, Block5Data* _data5_) {
	GmpcMetaDataWidgetsTextLabel * self;
	const gchar* _tmp0_ = NULL;
	GtkImageMenuItem* _tmp1_ = NULL;
	GtkImageMenuItem* mitem;
	GtkImage* _tmp2_ = NULL;
	GtkImage* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkImageMenuItem* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_;
	self = _data5_->self;
	g_return_if_fail (source != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = _ ("Refetch");
	_tmp1_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp0_);
	mitem = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkImage*) gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_MENU);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	gtk_image_menu_item_set_image (mitem, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_signal_connect_data ((GtkMenuItem*) mitem, "activate", (GCallback) __lambda33__gtk_menu_item_activate, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) mitem));
	gtk_widget_show ((GtkWidget*) mitem);
	_tmp4_ = _ ("Metadata selector");
	_tmp5_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp4_);
	_g_object_unref0 (mitem);
	mitem = g_object_ref_sink (_tmp5_);
	_tmp6_ = (GtkImage*) gtk_image_new_from_stock ("gtk-edit", GTK_ICON_SIZE_MENU);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	gtk_image_menu_item_set_image (mitem, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	g_signal_connect_object ((GtkMenuItem*) mitem, "activate", (GCallback) __lambda34__gtk_menu_item_activate, self, 0);
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) ((GtkMenuItem*) mitem));
	gtk_widget_show ((GtkWidget*) mitem);
	_g_object_unref0 (mitem);
}


static void __lambda32__gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self) {
	_lambda32_ (_sender, menu, self);
}


GmpcMetaDataWidgetsTextLabel* gmpc_meta_data_widgets_text_label_construct (GType object_type, const mpd_Song* song, MetaDataType type) {
	GmpcMetaDataWidgetsTextLabel * self = NULL;
	Block5Data* _data5_;
	mpd_Song* _tmp0_;
	gchar* _tmp1_ = NULL;
	MetaData* _tmp2_ = NULL;
	MetaDataResult _tmp3_;
	MetaDataResult a;
	g_return_val_if_fail (song != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->song = _mpd_songDup0 (song);
	_data5_->type = type;
	self = (GmpcMetaDataWidgetsTextLabel*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	gtk_label_set_line_wrap ((GtkLabel*) self, TRUE);
	gtk_label_set_text ((GtkLabel*) self, "Not available");
	gtk_misc_set_alignment ((GtkMisc*) self, 0.0f, 0.0f);
	gtk_misc_set_padding ((GtkMisc*) self, 4, 4);
	gtk_label_set_selectable ((GtkLabel*) self, TRUE);
	self->priv->cur_type = _data5_->type;
	_tmp0_ = _mpd_songDup0 (_data5_->song);
	_mpd_freeSong0 (self->priv->cur_song);
	self->priv->cur_song = _tmp0_;
	_tmp1_ = mpd_song_checksum (_data5_->song);
	_g_free0 (self->priv->song_checksum);
	self->priv->song_checksum = _tmp1_;
	g_signal_connect_object (gmw, "data-changed", (GCallback) __lambda31__gmpc_meta_watcher_data_changed, self, 0);
	_data5_->item = NULL;
	_tmp3_ = gmpc_meta_watcher_get_meta_path (gmw, _data5_->song, _data5_->type, &_tmp2_);
	_meta_data_free0 (_data5_->item);
	_data5_->item = _tmp2_;
	a = _tmp3_;
	if (a == META_DATA_AVAILABLE) {
		gmpc_meta_data_widgets_text_label_set_from_item (self, _data5_->item);
	} else {
		if (a == META_DATA_FETCHING) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = _ ("Fetching...");
			gtk_label_set_text ((GtkLabel*) self, _tmp4_);
		} else {
			gmpc_meta_data_widgets_text_label_set_from_item (self, NULL);
		}
	}
	g_signal_connect_data ((GtkLabel*) self, "populate-popup", (GCallback) __lambda32__gtk_label_populate_popup, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}


GmpcMetaDataWidgetsTextLabel* gmpc_meta_data_widgets_text_label_new (const mpd_Song* song, MetaDataType type) {
	return gmpc_meta_data_widgets_text_label_construct (GMPC_META_DATA_WIDGETS_TYPE_TEXT_LABEL, song, type);
}


static void gmpc_meta_data_widgets_text_label_class_init (GmpcMetaDataWidgetsTextLabelClass * klass) {
	gmpc_meta_data_widgets_text_label_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcMetaDataWidgetsTextLabelPrivate));
	G_OBJECT_CLASS (klass)->finalize = gmpc_meta_data_widgets_text_label_finalize;
}


static void gmpc_meta_data_widgets_text_label_instance_init (GmpcMetaDataWidgetsTextLabel * self) {
	self->priv = GMPC_META_DATA_WIDGETS_TEXT_LABEL_GET_PRIVATE (self);
	self->priv->cur_song = NULL;
	self->priv->song_checksum = NULL;
	self->priv->cur_type = META_ALBUM_TXT;
}


static void gmpc_meta_data_widgets_text_label_finalize (GObject* obj) {
	GmpcMetaDataWidgetsTextLabel * self;
	self = GMPC_META_DATA_WIDGETS_TEXT_LABEL (obj);
	_mpd_freeSong0 (self->priv->cur_song);
	_g_free0 (self->priv->song_checksum);
	G_OBJECT_CLASS (gmpc_meta_data_widgets_text_label_parent_class)->finalize (obj);
}


GType gmpc_meta_data_widgets_text_label_get_type (void) {
	static volatile gsize gmpc_meta_data_widgets_text_label_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_meta_data_widgets_text_label_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcMetaDataWidgetsTextLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_meta_data_widgets_text_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcMetaDataWidgetsTextLabel), 0, (GInstanceInitFunc) gmpc_meta_data_widgets_text_label_instance_init, NULL };
		GType gmpc_meta_data_widgets_text_label_type_id;
		gmpc_meta_data_widgets_text_label_type_id = g_type_register_static (GTK_TYPE_LABEL, "GmpcMetaDataWidgetsTextLabel", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_meta_data_widgets_text_label_type_id__volatile, gmpc_meta_data_widgets_text_label_type_id);
	}
	return gmpc_meta_data_widgets_text_label_type_id__volatile;
}



