/*
 * Copyright 1999-2014 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#ifndef GLOBUS_IO_ERROR_HIERARCHY_H
#define GLOBUS_IO_ERROR_HIERARCHY_H


#include "globus_common.h"

#include "globus_object.h"
#include "globus_error.h"
#include "globus_io.h"

#define GLOBUS_IO_ERROR_TYPE_BASE_DEFINITION GLOBUS_ERROR_TYPE_BASE_DEFINITION
#define globus_io_error_initialize_base globus_error_initialize_base

#ifdef __cplusplus
extern "C" {
#endif
 
/* the following code all generated by running the script
 * ./globus_io_error_hierarchy.h.sh declarations < globus_io_error_hierarchy.idl
 */

extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED \
        (&GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern globus_object_t *
globus_io_error_construct_security_failed (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern globus_object_t *
globus_io_error_initialize_security_failed (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* return the handle instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern globus_io_handle_t *
globus_io_error_security_failed_get_handle (globus_object_t * error)
;

/* set the handle instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern void
globus_io_error_security_failed_set_handle (
    globus_object_t * error,
    globus_io_handle_t * value)
;

/* return the maj_stat instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern int
globus_io_error_security_failed_get_maj_stat (globus_object_t * error)
;

/* set the maj_stat instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern void
globus_io_error_security_failed_set_maj_stat (
    globus_object_t * error,
    int value)
;

/* return the min_stat instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern int
globus_io_error_security_failed_get_min_stat (globus_object_t * error)
;

/* set the min_stat instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern void
globus_io_error_security_failed_set_min_stat (
    globus_object_t * error,
    int value)
;

/* return the token_stat instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern int
globus_io_error_security_failed_get_token_stat (globus_object_t * error)
;

/* set the token_stat instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SECURITY_FAILED   */
extern void
globus_io_error_security_failed_set_token_stat (
    globus_object_t * error,
    int value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_AUTHENTICATION_FAILED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_AUTHENTICATION_FAILED \
        (&GLOBUS_IO_ERROR_TYPE_AUTHENTICATION_FAILED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_AUTHENTICATION_FAILED   */
extern globus_object_t *
globus_io_error_construct_authentication_failed (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_AUTHENTICATION_FAILED   */
extern globus_object_t *
globus_io_error_initialize_authentication_failed (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_AUTHORIZATION_FAILED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_AUTHORIZATION_FAILED \
        (&GLOBUS_IO_ERROR_TYPE_AUTHORIZATION_FAILED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_AUTHORIZATION_FAILED   */
extern globus_object_t *
globus_io_error_construct_authorization_failed (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_AUTHORIZATION_FAILED   */
extern globus_object_t *
globus_io_error_initialize_authorization_failed (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_UNAUTHORIZED_IDENTITY_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_UNAUTHORIZED_IDENTITY \
        (&GLOBUS_IO_ERROR_TYPE_UNAUTHORIZED_IDENTITY_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_UNAUTHORIZED_IDENTITY   */
extern globus_object_t *
globus_io_error_construct_unauthorized_identity (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat,
    char * identity);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_UNAUTHORIZED_IDENTITY   */
extern globus_object_t *
globus_io_error_initialize_unauthorized_identity (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat,
    char * identity);

/* return the identity instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_UNAUTHORIZED_IDENTITY   */
extern char *
globus_io_error_unauthorized_identity_get_identity (globus_object_t * error)
;

/* set the identity instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_UNAUTHORIZED_IDENTITY   */
extern void
globus_io_error_unauthorized_identity_set_identity (
    globus_object_t * error,
    char * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_BAD_PROTECTION_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_BAD_PROTECTION \
        (&GLOBUS_IO_ERROR_TYPE_BAD_PROTECTION_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_BAD_PROTECTION   */
extern globus_object_t *
globus_io_error_construct_bad_protection (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_BAD_PROTECTION   */
extern globus_object_t *
globus_io_error_initialize_bad_protection (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_NO_SEC_CONTEXT_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_NO_SEC_CONTEXT \
        (&GLOBUS_IO_ERROR_TYPE_NO_SEC_CONTEXT_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_NO_SEC_CONTEXT   */
extern globus_object_t *
globus_io_error_construct_no_sec_context (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_NO_SEC_CONTEXT   */
extern globus_object_t *
globus_io_error_initialize_no_sec_context (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_CONTEXT_EXPIRED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_CONTEXT_EXPIRED \
        (&GLOBUS_IO_ERROR_TYPE_CONTEXT_EXPIRED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_CONTEXT_EXPIRED   */
extern globus_object_t *
globus_io_error_construct_context_expired (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_CONTEXT_EXPIRED   */
extern globus_object_t *
globus_io_error_initialize_context_expired (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_CREDENTIALS_EXPIRED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_CREDENTIALS_EXPIRED \
        (&GLOBUS_IO_ERROR_TYPE_CREDENTIALS_EXPIRED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_CREDENTIALS_EXPIRED   */
extern globus_object_t *
globus_io_error_construct_credentials_expired (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_CREDENTIALS_EXPIRED   */
extern globus_object_t *
globus_io_error_initialize_credentials_expired (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_NO_CREDENTIALS_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_NO_CREDENTIALS \
        (&GLOBUS_IO_ERROR_TYPE_NO_CREDENTIALS_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_NO_CREDENTIALS   */
extern globus_object_t *
globus_io_error_construct_no_credentials (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_NO_CREDENTIALS   */
extern globus_object_t *
globus_io_error_initialize_no_credentials (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_INVALID_CREDENTIALS_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_INVALID_CREDENTIALS \
        (&GLOBUS_IO_ERROR_TYPE_INVALID_CREDENTIALS_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_CREDENTIALS   */
extern globus_object_t *
globus_io_error_construct_invalid_credentials (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_CREDENTIALS   */
extern globus_object_t *
globus_io_error_initialize_invalid_credentials (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int maj_stat,
    int min_stat,
    int token_stat);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_IO_FAILED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_IO_FAILED \
        (&GLOBUS_IO_ERROR_TYPE_IO_FAILED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_IO_FAILED   */
extern globus_object_t *
globus_io_error_construct_io_failed (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_IO_FAILED   */
extern globus_object_t *
globus_io_error_initialize_io_failed (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* return the handle instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_IO_FAILED   */
extern globus_io_handle_t *
globus_io_error_io_failed_get_handle (globus_object_t * error)
;

/* set the handle instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_IO_FAILED   */
extern void
globus_io_error_io_failed_set_handle (
    globus_object_t * error,
    globus_io_handle_t * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_SYSTEM_FAILURE_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_SYSTEM_FAILURE \
        (&GLOBUS_IO_ERROR_TYPE_SYSTEM_FAILURE_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_SYSTEM_FAILURE   */
extern globus_object_t *
globus_io_error_construct_system_failure (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int save_errno);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_SYSTEM_FAILURE   */
extern globus_object_t *
globus_io_error_initialize_system_failure (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle,
    int save_errno);

/* return the save_errno instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SYSTEM_FAILURE   */
extern int
globus_io_error_system_failure_get_save_errno (globus_object_t * error)
;

/* set the save_errno instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_SYSTEM_FAILURE   */
extern void
globus_io_error_system_failure_set_save_errno (
    globus_object_t * error,
    int value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_EOF_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_EOF \
        (&GLOBUS_IO_ERROR_TYPE_EOF_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_EOF   */
extern globus_object_t *
globus_io_error_construct_eof (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_EOF   */
extern globus_object_t *
globus_io_error_initialize_eof (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_IO_CANCELLED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_IO_CANCELLED \
        (&GLOBUS_IO_ERROR_TYPE_IO_CANCELLED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_IO_CANCELLED   */
extern globus_object_t *
globus_io_error_construct_io_cancelled (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_IO_CANCELLED   */
extern globus_object_t *
globus_io_error_initialize_io_cancelled (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER \
        (&GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern globus_object_t *
globus_io_error_construct_bad_parameter (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern globus_object_t *
globus_io_error_initialize_bad_parameter (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* return the name instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern char *
globus_io_error_bad_parameter_get_name (globus_object_t * error)
;

/* set the name instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern void
globus_io_error_bad_parameter_set_name (
    globus_object_t * error,
    char * value)
;

/* return the position instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern int
globus_io_error_bad_parameter_get_position (globus_object_t * error)
;

/* set the position instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern void
globus_io_error_bad_parameter_set_position (
    globus_object_t * error,
    int value)
;

/* return the function instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern char *
globus_io_error_bad_parameter_get_function (globus_object_t * error)
;

/* set the function instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_BAD_PARAMETER   */
extern void
globus_io_error_bad_parameter_set_function (
    globus_object_t * error,
    char * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_BAD_POINTER_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_BAD_POINTER \
        (&GLOBUS_IO_ERROR_TYPE_BAD_POINTER_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_BAD_POINTER   */
extern globus_object_t *
globus_io_error_construct_bad_pointer (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_BAD_POINTER   */
extern globus_object_t *
globus_io_error_initialize_bad_pointer (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_NULL_PARAMETER_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_NULL_PARAMETER \
        (&GLOBUS_IO_ERROR_TYPE_NULL_PARAMETER_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_NULL_PARAMETER   */
extern globus_object_t *
globus_io_error_construct_null_parameter (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_NULL_PARAMETER   */
extern globus_object_t *
globus_io_error_initialize_null_parameter (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_INVALID_TYPE_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_INVALID_TYPE \
        (&GLOBUS_IO_ERROR_TYPE_INVALID_TYPE_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_TYPE   */
extern globus_object_t *
globus_io_error_construct_invalid_type (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * required_type_string);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_TYPE   */
extern globus_object_t *
globus_io_error_initialize_invalid_type (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * required_type_string);

/* return the required_type_string instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_INVALID_TYPE   */
extern char *
globus_io_error_invalid_type_get_required_type_string (globus_object_t * error)
;

/* set the required_type_string instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_INVALID_TYPE   */
extern void
globus_io_error_invalid_type_set_required_type_string (
    globus_object_t * error,
    char * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_IMMUTABLE_ATTRIBUTE_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_IMMUTABLE_ATTRIBUTE \
        (&GLOBUS_IO_ERROR_TYPE_IMMUTABLE_ATTRIBUTE_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_IMMUTABLE_ATTRIBUTE   */
extern globus_object_t *
globus_io_error_construct_immutable_attribute (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * attribute_name);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_IMMUTABLE_ATTRIBUTE   */
extern globus_object_t *
globus_io_error_initialize_immutable_attribute (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * attribute_name);

/* return the attribute_name instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_IMMUTABLE_ATTRIBUTE   */
extern char *
globus_io_error_immutable_attribute_get_attribute_name (globus_object_t * error)
;

/* set the attribute_name instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_IMMUTABLE_ATTRIBUTE   */
extern void
globus_io_error_immutable_attribute_set_attribute_name (
    globus_object_t * error,
    char * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH \
        (&GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH   */
extern globus_object_t *
globus_io_error_construct_attribute_mismatch (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * attr1,
    char * attr2);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH   */
extern globus_object_t *
globus_io_error_initialize_attribute_mismatch (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * attr1,
    char * attr2);

/* return the attr1 instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH   */
extern char *
globus_io_error_attribute_mismatch_get_attr1 (globus_object_t * error)
;

/* set the attr1 instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH   */
extern void
globus_io_error_attribute_mismatch_set_attr1 (
    globus_object_t * error,
    char * value)
;

/* return the attr2 instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH   */
extern char *
globus_io_error_attribute_mismatch_get_attr2 (globus_object_t * error)
;

/* set the attr2 instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_ATTRIBUTE_MISMATCH   */
extern void
globus_io_error_attribute_mismatch_set_attr2 (
    globus_object_t * error,
    char * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_INVALID_NAME_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_INVALID_NAME \
        (&GLOBUS_IO_ERROR_TYPE_INVALID_NAME_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_NAME   */
extern globus_object_t *
globus_io_error_construct_invalid_name (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * unresolvable_name);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_NAME   */
extern globus_object_t *
globus_io_error_initialize_invalid_name (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * unresolvable_name);

/* return the unresolvable_name instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_INVALID_NAME   */
extern char *
globus_io_error_invalid_name_get_unresolvable_name (globus_object_t * error)
;

/* set the unresolvable_name instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_INVALID_NAME   */
extern void
globus_io_error_invalid_name_set_unresolvable_name (
    globus_object_t * error,
    char * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_HOST_NOT_FOUND_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_HOST_NOT_FOUND \
        (&GLOBUS_IO_ERROR_TYPE_HOST_NOT_FOUND_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_HOST_NOT_FOUND   */
extern globus_object_t *
globus_io_error_construct_host_not_found (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * unresolvable_name);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_HOST_NOT_FOUND   */
extern globus_object_t *
globus_io_error_initialize_host_not_found (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function,
    char * unresolvable_name);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_INVALID_PORT_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_INVALID_PORT \
        (&GLOBUS_IO_ERROR_TYPE_INVALID_PORT_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_PORT   */
extern globus_object_t *
globus_io_error_construct_invalid_port (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_INVALID_PORT   */
extern globus_object_t *
globus_io_error_initialize_invalid_port (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_RESTRICTED_PORT_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_RESTRICTED_PORT \
        (&GLOBUS_IO_ERROR_TYPE_RESTRICTED_PORT_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_RESTRICTED_PORT   */
extern globus_object_t *
globus_io_error_construct_restricted_port (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_RESTRICTED_PORT   */
extern globus_object_t *
globus_io_error_initialize_restricted_port (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_PORT_IN_USE_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_PORT_IN_USE \
        (&GLOBUS_IO_ERROR_TYPE_PORT_IN_USE_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_PORT_IN_USE   */
extern globus_object_t *
globus_io_error_construct_port_in_use (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_PORT_IN_USE   */
extern globus_object_t *
globus_io_error_initialize_port_in_use (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_NOT_INITIALIZED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_NOT_INITIALIZED \
        (&GLOBUS_IO_ERROR_TYPE_NOT_INITIALIZED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_NOT_INITIALIZED   */
extern globus_object_t *
globus_io_error_construct_not_initialized (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_NOT_INITIALIZED   */
extern globus_object_t *
globus_io_error_initialize_not_initialized (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * name,
    int position,
    char * function);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_REGISTRATION_ERROR_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_REGISTRATION_ERROR \
        (&GLOBUS_IO_ERROR_TYPE_REGISTRATION_ERROR_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_REGISTRATION_ERROR   */
extern globus_object_t *
globus_io_error_construct_registration_error (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_REGISTRATION_ERROR   */
extern globus_object_t *
globus_io_error_initialize_registration_error (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* return the handle instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_REGISTRATION_ERROR   */
extern globus_io_handle_t *
globus_io_error_registration_error_get_handle (globus_object_t * error)
;

/* set the handle instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_REGISTRATION_ERROR   */
extern void
globus_io_error_registration_error_set_handle (
    globus_object_t * error,
    globus_io_handle_t * value)
;


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_READ_ALREADY_REGISTERED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_READ_ALREADY_REGISTERED \
        (&GLOBUS_IO_ERROR_TYPE_READ_ALREADY_REGISTERED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_READ_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_construct_read_already_registered (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_READ_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_initialize_read_already_registered (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_WRITE_ALREADY_REGISTERED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_WRITE_ALREADY_REGISTERED \
        (&GLOBUS_IO_ERROR_TYPE_WRITE_ALREADY_REGISTERED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_WRITE_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_construct_write_already_registered (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_WRITE_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_initialize_write_already_registered (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_EXCEPT_ALREADY_REGISTERED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_EXCEPT_ALREADY_REGISTERED \
        (&GLOBUS_IO_ERROR_TYPE_EXCEPT_ALREADY_REGISTERED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_EXCEPT_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_construct_except_already_registered (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_EXCEPT_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_initialize_except_already_registered (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_CLOSE_ALREADY_REGISTERED_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_CLOSE_ALREADY_REGISTERED \
        (&GLOBUS_IO_ERROR_TYPE_CLOSE_ALREADY_REGISTERED_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_CLOSE_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_construct_close_already_registered (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_CLOSE_ALREADY_REGISTERED   */
extern globus_object_t *
globus_io_error_initialize_close_already_registered (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    globus_io_handle_t * handle);


extern const globus_object_type_t
             GLOBUS_IO_ERROR_TYPE_INTERNAL_ERROR_DEFINITION;

#define GLOBUS_IO_ERROR_TYPE_INTERNAL_ERROR \
        (&GLOBUS_IO_ERROR_TYPE_INTERNAL_ERROR_DEFINITION)

/* allocate and initialize an error of type
 * GLOBUS_IO_ERROR_TYPE_INTERNAL_ERROR   */
extern globus_object_t *
globus_io_error_construct_internal_error (
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * function);

/* initialize and return an error of type
 * GLOBUS_IO_ERROR_TYPE_INTERNAL_ERROR   */
extern globus_object_t *
globus_io_error_initialize_internal_error (
    globus_object_t * error,
    globus_module_descriptor_t * source,
    globus_object_t * cause,
    char * function);

/* return the function instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_INTERNAL_ERROR   */
extern char *
globus_io_error_internal_error_get_function (globus_object_t * error)
;

/* set the function instance data of an error
 * derived from GLOBUS_IO_ERROR_TYPE_INTERNAL_ERROR   */
extern void
globus_io_error_internal_error_set_function (
    globus_object_t * error,
    char * value)
;



#ifdef __cplusplus
}
#endif

#endif /* GLOBUS_IO_ERROR_HIERARCHY_H */

