// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides a list of custom vocabulary filters that match the specified criteria.
// If no criteria are specified, all custom vocabularies are returned.
//
// To get detailed information about a specific custom vocabulary filter, use the
// operation.
func (c *Client) ListVocabularyFilters(ctx context.Context, params *ListVocabularyFiltersInput, optFns ...func(*Options)) (*ListVocabularyFiltersOutput, error) {
	if params == nil {
		params = &ListVocabularyFiltersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVocabularyFilters", params, optFns, c.addOperationListVocabularyFiltersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVocabularyFiltersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVocabularyFiltersInput struct {

	// The maximum number of custom vocabulary filters to return in each page of
	// results. If there are fewer results than the value that you specify, only the
	// actual results are returned. If you do not specify a value, a default of 5 is
	// used.
	MaxResults *int32

	// Returns only the custom vocabulary filters that contain the specified string.
	// The search is not case sensitive.
	NameContains *string

	// If your ListVocabularyFilters request returns more results than can be
	// displayed, NextToken is displayed in the response with an associated string. To
	// get the next page of results, copy this string and repeat your request,
	// including NextToken with the value of the copied string. Repeat as needed to
	// view all your results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListVocabularyFiltersOutput struct {

	// If NextToken is present in your response, it indicates that not all results are
	// displayed. To view the next set of results, copy the string associated with the
	// NextToken parameter in your results output, then run your request again
	// including NextToken with the value of the copied string. Repeat as needed to
	// view all your results.
	NextToken *string

	// Provides information about the custom vocabulary filters that match the
	// criteria specified in your request.
	VocabularyFilters []types.VocabularyFilterInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVocabularyFiltersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListVocabularyFilters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListVocabularyFilters{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListVocabularyFilters"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVocabularyFilters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVocabularyFiltersAPIClient is a client that implements the
// ListVocabularyFilters operation.
type ListVocabularyFiltersAPIClient interface {
	ListVocabularyFilters(context.Context, *ListVocabularyFiltersInput, ...func(*Options)) (*ListVocabularyFiltersOutput, error)
}

var _ ListVocabularyFiltersAPIClient = (*Client)(nil)

// ListVocabularyFiltersPaginatorOptions is the paginator options for
// ListVocabularyFilters
type ListVocabularyFiltersPaginatorOptions struct {
	// The maximum number of custom vocabulary filters to return in each page of
	// results. If there are fewer results than the value that you specify, only the
	// actual results are returned. If you do not specify a value, a default of 5 is
	// used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVocabularyFiltersPaginator is a paginator for ListVocabularyFilters
type ListVocabularyFiltersPaginator struct {
	options   ListVocabularyFiltersPaginatorOptions
	client    ListVocabularyFiltersAPIClient
	params    *ListVocabularyFiltersInput
	nextToken *string
	firstPage bool
}

// NewListVocabularyFiltersPaginator returns a new ListVocabularyFiltersPaginator
func NewListVocabularyFiltersPaginator(client ListVocabularyFiltersAPIClient, params *ListVocabularyFiltersInput, optFns ...func(*ListVocabularyFiltersPaginatorOptions)) *ListVocabularyFiltersPaginator {
	if params == nil {
		params = &ListVocabularyFiltersInput{}
	}

	options := ListVocabularyFiltersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVocabularyFiltersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVocabularyFiltersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListVocabularyFilters page.
func (p *ListVocabularyFiltersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVocabularyFiltersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListVocabularyFilters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListVocabularyFilters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListVocabularyFilters",
	}
}
