// Code generated by smithy-go-codegen DO NOT EDIT.

package signer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds cross-account permissions to a signing profile.
func (c *Client) AddProfilePermission(ctx context.Context, params *AddProfilePermissionInput, optFns ...func(*Options)) (*AddProfilePermissionOutput, error) {
	if params == nil {
		params = &AddProfilePermissionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AddProfilePermission", params, optFns, c.addOperationAddProfilePermissionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AddProfilePermissionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AddProfilePermissionInput struct {

	// For cross-account signing. Grant a designated account permission to perform one
	// or more of the following actions. Each action is associated with a specific
	// API's operations. For more information about cross-account signing, see [Using cross-account signing with signing profiles]in the
	// AWS Signer Developer Guide.
	//
	// You can designate the following actions to an account.
	//
	//   - signer:StartSigningJob . This action isn't supported for container image
	//   workflows. For details, see StartSigningJob.
	//
	//   - signer:SignPayload . This action isn't supported for AWS Lambda workflows.
	//   For details, see SignPayload
	//
	//   - signer:GetSigningProfile . For details, see GetSigningProfile.
	//
	//   - signer:RevokeSignature . For details, see RevokeSignature.
	//
	// [Using cross-account signing with signing profiles]: https://docs.aws.amazon.com/signer/latest/developerguide/signing-profile-cross-account.html
	//
	// This member is required.
	Action *string

	// The AWS principal receiving cross-account permissions. This may be an IAM role
	// or another AWS account ID.
	//
	// This member is required.
	Principal *string

	// The human-readable name of the signing profile.
	//
	// This member is required.
	ProfileName *string

	// A unique identifier for the cross-account permission statement.
	//
	// This member is required.
	StatementId *string

	// The version of the signing profile.
	ProfileVersion *string

	// A unique identifier for the current profile revision.
	RevisionId *string

	noSmithyDocumentSerde
}

type AddProfilePermissionOutput struct {

	// A unique identifier for the current profile revision.
	RevisionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAddProfilePermissionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAddProfilePermission{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAddProfilePermission{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AddProfilePermission"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAddProfilePermissionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAddProfilePermission(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opAddProfilePermission(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AddProfilePermission",
	}
}
