// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakergeospatial

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of vector enrichment jobs.
func (c *Client) ListVectorEnrichmentJobs(ctx context.Context, params *ListVectorEnrichmentJobsInput, optFns ...func(*Options)) (*ListVectorEnrichmentJobsOutput, error) {
	if params == nil {
		params = &ListVectorEnrichmentJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVectorEnrichmentJobs", params, optFns, c.addOperationListVectorEnrichmentJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVectorEnrichmentJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVectorEnrichmentJobsInput struct {

	// The maximum number of items to return.
	MaxResults *int32

	// If the previous response was truncated, you receive this token. Use it in your
	// next request to receive the next set of results.
	NextToken *string

	// The parameter by which to sort the results.
	SortBy *string

	// An optional value that specifies whether you want the results sorted in
	// Ascending or Descending order.
	SortOrder types.SortOrder

	// A filter that retrieves only jobs with a specific status.
	StatusEquals *string

	noSmithyDocumentSerde
}

type ListVectorEnrichmentJobsOutput struct {

	// Contains summary information about the Vector Enrichment jobs.
	//
	// This member is required.
	VectorEnrichmentJobSummaries []types.ListVectorEnrichmentJobOutputConfig

	// If the previous response was truncated, you receive this token. Use it in your
	// next request to receive the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVectorEnrichmentJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListVectorEnrichmentJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListVectorEnrichmentJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListVectorEnrichmentJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVectorEnrichmentJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVectorEnrichmentJobsAPIClient is a client that implements the
// ListVectorEnrichmentJobs operation.
type ListVectorEnrichmentJobsAPIClient interface {
	ListVectorEnrichmentJobs(context.Context, *ListVectorEnrichmentJobsInput, ...func(*Options)) (*ListVectorEnrichmentJobsOutput, error)
}

var _ ListVectorEnrichmentJobsAPIClient = (*Client)(nil)

// ListVectorEnrichmentJobsPaginatorOptions is the paginator options for
// ListVectorEnrichmentJobs
type ListVectorEnrichmentJobsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVectorEnrichmentJobsPaginator is a paginator for ListVectorEnrichmentJobs
type ListVectorEnrichmentJobsPaginator struct {
	options   ListVectorEnrichmentJobsPaginatorOptions
	client    ListVectorEnrichmentJobsAPIClient
	params    *ListVectorEnrichmentJobsInput
	nextToken *string
	firstPage bool
}

// NewListVectorEnrichmentJobsPaginator returns a new
// ListVectorEnrichmentJobsPaginator
func NewListVectorEnrichmentJobsPaginator(client ListVectorEnrichmentJobsAPIClient, params *ListVectorEnrichmentJobsInput, optFns ...func(*ListVectorEnrichmentJobsPaginatorOptions)) *ListVectorEnrichmentJobsPaginator {
	if params == nil {
		params = &ListVectorEnrichmentJobsInput{}
	}

	options := ListVectorEnrichmentJobsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVectorEnrichmentJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVectorEnrichmentJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListVectorEnrichmentJobs page.
func (p *ListVectorEnrichmentJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVectorEnrichmentJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.ListVectorEnrichmentJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListVectorEnrichmentJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListVectorEnrichmentJobs",
	}
}
