// Code generated by smithy-go-codegen DO NOT EDIT.

package pcaconnectorad

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pcaconnectorad/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the service principal names that the connector uses to authenticate with
// Active Directory.
func (c *Client) ListServicePrincipalNames(ctx context.Context, params *ListServicePrincipalNamesInput, optFns ...func(*Options)) (*ListServicePrincipalNamesOutput, error) {
	if params == nil {
		params = &ListServicePrincipalNamesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServicePrincipalNames", params, optFns, c.addOperationListServicePrincipalNamesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServicePrincipalNamesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServicePrincipalNamesInput struct {

	// The Amazon Resource Name (ARN) that was returned when you called [CreateDirectoryRegistration].
	//
	// [CreateDirectoryRegistration]: https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html
	//
	// This member is required.
	DirectoryRegistrationArn *string

	// Use this parameter when paginating results to specify the maximum number of
	// items to return in the response on each page. If additional items exist beyond
	// the number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int32

	// Use this parameter when paginating results in a subsequent request after you
	// receive a response with truncated results. Set it to the value of the NextToken
	// parameter from the response you just received.
	NextToken *string

	noSmithyDocumentSerde
}

type ListServicePrincipalNamesOutput struct {

	// Use this parameter when paginating results in a subsequent request after you
	// receive a response with truncated results. Set it to the value of the NextToken
	// parameter from the response you just received.
	NextToken *string

	// The service principal name, if any, that the connector uses to authenticate
	// with Active Directory.
	ServicePrincipalNames []types.ServicePrincipalNameSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServicePrincipalNamesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServicePrincipalNames{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServicePrincipalNames{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServicePrincipalNames"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListServicePrincipalNamesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServicePrincipalNames(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServicePrincipalNamesAPIClient is a client that implements the
// ListServicePrincipalNames operation.
type ListServicePrincipalNamesAPIClient interface {
	ListServicePrincipalNames(context.Context, *ListServicePrincipalNamesInput, ...func(*Options)) (*ListServicePrincipalNamesOutput, error)
}

var _ ListServicePrincipalNamesAPIClient = (*Client)(nil)

// ListServicePrincipalNamesPaginatorOptions is the paginator options for
// ListServicePrincipalNames
type ListServicePrincipalNamesPaginatorOptions struct {
	// Use this parameter when paginating results to specify the maximum number of
	// items to return in the response on each page. If additional items exist beyond
	// the number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServicePrincipalNamesPaginator is a paginator for ListServicePrincipalNames
type ListServicePrincipalNamesPaginator struct {
	options   ListServicePrincipalNamesPaginatorOptions
	client    ListServicePrincipalNamesAPIClient
	params    *ListServicePrincipalNamesInput
	nextToken *string
	firstPage bool
}

// NewListServicePrincipalNamesPaginator returns a new
// ListServicePrincipalNamesPaginator
func NewListServicePrincipalNamesPaginator(client ListServicePrincipalNamesAPIClient, params *ListServicePrincipalNamesInput, optFns ...func(*ListServicePrincipalNamesPaginatorOptions)) *ListServicePrincipalNamesPaginator {
	if params == nil {
		params = &ListServicePrincipalNamesInput{}
	}

	options := ListServicePrincipalNamesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServicePrincipalNamesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServicePrincipalNamesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServicePrincipalNames page.
func (p *ListServicePrincipalNamesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServicePrincipalNamesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListServicePrincipalNames(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListServicePrincipalNames(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServicePrincipalNames",
	}
}
