// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Use this structure to optionally create filters that specify that only some
// metric namespaces or log groups are to be shared from the source account to the
// monitoring account.
type LinkConfiguration struct {

	// Use this structure to filter which log groups are to send log events from the
	// source account to the monitoring account.
	LogGroupConfiguration *LogGroupConfiguration

	// Use this structure to filter which metric namespaces are to be shared from the
	// source account to the monitoring account.
	MetricConfiguration *MetricConfiguration

	noSmithyDocumentSerde
}

// A structure that contains information about one link attached to this
// monitoring account sink.
type ListAttachedLinksItem struct {

	// The label that was assigned to this link at creation, with the variables
	// resolved to their actual values.
	Label *string

	// The ARN of the link.
	LinkArn *string

	// The resource types supported by this link.
	ResourceTypes []string

	noSmithyDocumentSerde
}

// A structure that contains information about one of this source account's links
// to a monitoring account.
type ListLinksItem struct {

	// The ARN of the link.
	Arn *string

	// The random ID string that Amazon Web Services generated as part of the link ARN.
	Id *string

	// The label that was assigned to this link at creation, with the variables
	// resolved to their actual values.
	Label *string

	// The resource types supported by this link.
	ResourceTypes []string

	// The ARN of the sink that this link is attached to.
	SinkArn *string

	noSmithyDocumentSerde
}

// A structure that contains information about one of this monitoring account's
// sinks.
type ListSinksItem struct {

	// The ARN of the sink.
	Arn *string

	// The random ID string that Amazon Web Services generated as part of the sink ARN.
	Id *string

	// The name of the sink.
	Name *string

	noSmithyDocumentSerde
}

// This structure contains the Filter parameter which you can use to specify which
// log groups are to share log events from this source account to the monitoring
// account.
type LogGroupConfiguration struct {

	// Use this field to specify which log groups are to share their log events with
	// the monitoring account. Use the term LogGroupName and one or more of the
	// following operands. Use single quotation marks (') around log group names. The
	// matching of log group names is case sensitive. Each filter has a limit of five
	// conditional operands. Conditional operands are AND and OR .
	//
	//   - = and !=
	//
	//   - AND
	//
	//   - OR
	//
	//   - LIKE and NOT LIKE . These can be used only as prefix searches. Include a %
	//   at the end of the string that you want to search for and include.
	//
	//   - IN and NOT IN , using parentheses ( )
	//
	// Examples:
	//
	//   - LogGroupName IN ('This-Log-Group', 'Other-Log-Group') includes only the log
	//   groups with names This-Log-Group and Other-Log-Group .
	//
	//   - LogGroupName NOT IN ('Private-Log-Group', 'Private-Log-Group-2') includes
	//   all log groups except the log groups with names Private-Log-Group and
	//   Private-Log-Group-2 .
	//
	//   - LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%' includes
	//   all log groups that have names that start with aws/lambda/ or AWSLogs .
	//
	// If you are updating a link that uses filters, you can specify * as the only
	// value for the filter parameter to delete the filter and share all log groups
	// with the monitoring account.
	//
	// This member is required.
	Filter *string

	noSmithyDocumentSerde
}

// This structure contains the Filter parameter which you can use to specify which
// metric namespaces are to be shared from this source account to the monitoring
// account.
type MetricConfiguration struct {

	// Use this field to specify which metrics are to be shared with the monitoring
	// account. Use the term Namespace and one or more of the following operands. Use
	// single quotation marks (') around namespace names. The matching of namespace
	// names is case sensitive. Each filter has a limit of five conditional operands.
	// Conditional operands are AND and OR .
	//
	//   - = and !=
	//
	//   - AND
	//
	//   - OR
	//
	//   - LIKE and NOT LIKE . These can be used only as prefix searches. Include a %
	//   at the end of the string that you want to search for and include.
	//
	//   - IN and NOT IN , using parentheses ( )
	//
	// Examples:
	//
	//   - Namespace NOT LIKE 'AWS/%' includes only namespaces that don't start with
	//   AWS/ , such as custom namespaces.
	//
	//   - Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3') includes only the metrics in
	//   the EC2, Elastic Load Balancing, and Amazon S3 namespaces.
	//
	//   - Namespace = 'AWS/EC2' OR Namespace NOT LIKE 'AWS/%' includes only the EC2
	//   namespace and your custom namespaces.
	//
	// If you are updating a link that uses filters, you can specify * as the only
	// value for the filter parameter to delete the filter and share all metric
	// namespaces with the monitoring account.
	//
	// This member is required.
	Filter *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
