// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplaceentitlementservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/marketplaceentitlementservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// GetEntitlements retrieves entitlement values for a given product. The results
// can be filtered based on customer identifier or product dimensions.
func (c *Client) GetEntitlements(ctx context.Context, params *GetEntitlementsInput, optFns ...func(*Options)) (*GetEntitlementsOutput, error) {
	if params == nil {
		params = &GetEntitlementsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEntitlements", params, optFns, c.addOperationGetEntitlementsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEntitlementsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The GetEntitlementsRequest contains parameters for the GetEntitlements
// operation.
type GetEntitlementsInput struct {

	// Product code is used to uniquely identify a product in AWS Marketplace. The
	// product code will be provided by AWS Marketplace when the product listing is
	// created.
	//
	// This member is required.
	ProductCode *string

	// Filter is used to return entitlements for a specific customer or for a specific
	// dimension. Filters are described as keys mapped to a lists of values. Filtered
	// requests are unioned for each value in the value list, and then intersected for
	// each filter key.
	Filter map[string][]string

	// The maximum number of items to retrieve from the GetEntitlements operation. For
	// pagination, use the NextToken field in subsequent calls to GetEntitlements.
	MaxResults *int32

	// For paginated calls to GetEntitlements, pass the NextToken from the previous
	// GetEntitlementsResult.
	NextToken *string

	noSmithyDocumentSerde
}

// The GetEntitlementsRequest contains results from the GetEntitlements operation.
type GetEntitlementsOutput struct {

	// The set of entitlements found through the GetEntitlements operation. If the
	// result contains an empty set of entitlements, NextToken might still be present
	// and should be used.
	Entitlements []types.Entitlement

	// For paginated results, use NextToken in subsequent calls to GetEntitlements. If
	// the result contains an empty set of entitlements, NextToken might still be
	// present and should be used.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEntitlementsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetEntitlements{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetEntitlements{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEntitlements"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetEntitlementsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEntitlements(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetEntitlementsAPIClient is a client that implements the GetEntitlements
// operation.
type GetEntitlementsAPIClient interface {
	GetEntitlements(context.Context, *GetEntitlementsInput, ...func(*Options)) (*GetEntitlementsOutput, error)
}

var _ GetEntitlementsAPIClient = (*Client)(nil)

// GetEntitlementsPaginatorOptions is the paginator options for GetEntitlements
type GetEntitlementsPaginatorOptions struct {
	// The maximum number of items to retrieve from the GetEntitlements operation. For
	// pagination, use the NextToken field in subsequent calls to GetEntitlements.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetEntitlementsPaginator is a paginator for GetEntitlements
type GetEntitlementsPaginator struct {
	options   GetEntitlementsPaginatorOptions
	client    GetEntitlementsAPIClient
	params    *GetEntitlementsInput
	nextToken *string
	firstPage bool
}

// NewGetEntitlementsPaginator returns a new GetEntitlementsPaginator
func NewGetEntitlementsPaginator(client GetEntitlementsAPIClient, params *GetEntitlementsInput, optFns ...func(*GetEntitlementsPaginatorOptions)) *GetEntitlementsPaginator {
	if params == nil {
		params = &GetEntitlementsInput{}
	}

	options := GetEntitlementsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetEntitlementsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetEntitlementsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetEntitlements page.
func (p *GetEntitlementsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetEntitlementsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetEntitlements(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetEntitlements(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEntitlements",
	}
}
